/*
 * Decompiled with CFR 0.152.
 */
package kafka.examples;

import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;

public class Utils {
    private Utils() {
    }

    public static void printHelp(String message, Object ... args) {
        System.out.println(String.format(message, args));
    }

    public static void printOut(String message, Object ... args) {
        System.out.printf("%s - %s%n", Thread.currentThread().getName(), String.format(message, args));
    }

    public static void printErr(String message, Object ... args) {
        System.err.printf("%s - %s%n", Thread.currentThread().getName(), String.format(message, args));
    }

    public static void maybePrintRecord(long numRecords, ConsumerRecord<Integer, String> record) {
        Utils.maybePrintRecord(numRecords, (Integer)record.key(), (String)record.value(), record.topic(), record.partition(), record.offset());
    }

    public static void maybePrintRecord(long numRecords, int key, String value, RecordMetadata metadata) {
        Utils.maybePrintRecord(numRecords, key, value, metadata.topic(), metadata.partition(), metadata.offset());
    }

    private static void maybePrintRecord(long numRecords, int key, String value, String topic, int partition, long offset) {
        if ((long)key % Math.max(1L, numRecords / 10L) == 0L) {
            Utils.printOut("Sample: record(%d, %s), partition(%s-%d), offset(%d)", key, value, topic, partition, offset);
        }
    }

    public static void recreateTopics(String bootstrapServers, int numPartitions, String ... topicNames) {
        Properties props = new Properties();
        props.put("bootstrap.servers", bootstrapServers);
        props.put("client.id", "client-" + UUID.randomUUID());
        try (Admin admin = Admin.create((Properties)props);){
            try {
                admin.deleteTopics(Arrays.asList(topicNames)).all().get();
            }
            catch (ExecutionException e) {
                if (!(e.getCause() instanceof UnknownTopicOrPartitionException)) {
                    throw e;
                }
                Utils.printErr("Topics deletion error: %s", e.getCause());
            }
            Utils.printOut("Deleted topics: %s", Arrays.toString(topicNames));
            while (true) {
                short replicationFactor = -1;
                List newTopics = Arrays.stream(topicNames).map(name -> new NewTopic(name, numPartitions, replicationFactor)).collect(Collectors.toList());
                try {
                    admin.createTopics(newTopics).all().get();
                    Utils.printOut("Created topics: %s", Arrays.toString(topicNames));
                }
                catch (ExecutionException e) {
                    if (!(e.getCause() instanceof TopicExistsException)) {
                        throw e;
                    }
                    Utils.printOut("Waiting for topics metadata cleanup", new Object[0]);
                    TimeUnit.MILLISECONDS.sleep(1000L);
                    continue;
                }
                break;
            }
        }
        catch (Throwable e) {
            throw new RuntimeException("Topics creation error", e);
        }
    }
}

