/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.kafka.eventstreams.kwps;

import com.mapr.kafka.eventstreams.kwps.KafkaTopic;
import lombok.NonNull;

@Deprecated
public class KTopicDescriptor {
    @NonNull
    private final String topic;
    private int partitions = -1;
    private long ttl = -1L;
    private long size = -1L;
    private String owner = null;
    private boolean ownVolume = false;
    private CompressionType compression = null;
    private String adminPerms = null;
    private String producePerms = null;
    private String consumePerms = null;

    public KTopicDescriptor(String topicName) {
        this.topic = KafkaTopic.validate(topicName);
    }

    public String getCompressionString() {
        return String.valueOf((Object)this.compression);
    }

    public KTopicDescriptor setCompression(@NonNull CompressionType compression) {
        if (compression == null) {
            throw new NullPointerException("compression is marked non-null but is null");
        }
        this.compression = compression;
        return this;
    }

    public KTopicDescriptor setCompression(@NonNull String compression) {
        if (compression == null) {
            throw new NullPointerException("compression is marked non-null but is null");
        }
        try {
            this.compression = CompressionType.valueOf(compression.toLowerCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("'" + compression + "' is not a supported compression scheme for topics.", e);
        }
        return this;
    }

    public boolean hasPartitions() {
        return this.partitions != -1;
    }

    public boolean hasCompression() {
        return this.compression != null;
    }

    public boolean hasAdminPerms() {
        return this.adminPerms != null;
    }

    public boolean hasProducePerms() {
        return this.producePerms != null;
    }

    public boolean hasConsumePerms() {
        return this.consumePerms != null;
    }

    public boolean hasOwner() {
        return this.owner != null;
    }

    public boolean hasTtl() {
        return this.ttl != -1L;
    }

    public boolean hasSize() {
        return this.size != -1L;
    }

    @NonNull
    public String getTopic() {
        return this.topic;
    }

    public int getPartitions() {
        return this.partitions;
    }

    public KTopicDescriptor setPartitions(int partitions) {
        this.partitions = partitions;
        return this;
    }

    public long getTtl() {
        return this.ttl;
    }

    public KTopicDescriptor setTtl(long ttl) {
        this.ttl = ttl;
        return this;
    }

    public long getSize() {
        return this.size;
    }

    public KTopicDescriptor setSize(long size) {
        this.size = size;
        return this;
    }

    public String getOwner() {
        return this.owner;
    }

    public KTopicDescriptor setOwner(String owner) {
        this.owner = owner;
        return this;
    }

    public boolean isOwnVolume() {
        return this.ownVolume;
    }

    public KTopicDescriptor setOwnVolume(boolean ownVolume) {
        this.ownVolume = ownVolume;
        return this;
    }

    public CompressionType getCompression() {
        return this.compression;
    }

    public String getAdminPerms() {
        return this.adminPerms;
    }

    public KTopicDescriptor setAdminPerms(String adminPerms) {
        this.adminPerms = adminPerms;
        return this;
    }

    public String getProducePerms() {
        return this.producePerms;
    }

    public KTopicDescriptor setProducePerms(String producePerms) {
        this.producePerms = producePerms;
        return this;
    }

    public String getConsumePerms() {
        return this.consumePerms;
    }

    public KTopicDescriptor setConsumePerms(String consumePerms) {
        this.consumePerms = consumePerms;
        return this;
    }

    public static enum CompressionType {
        off,
        lzf,
        lz4,
        zlib;

    }
}

