/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.kafka.eventstreams.impl.listener;

import com.mapr.fs.jni.NativeData;
import com.mapr.kafka.eventstreams.impl.listener.NativeDataParser;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.junit.Assert;
import org.junit.Test;

public class NativeDataParserTest {
    @Test
    public void testNextTopicPartition() {
        NativeData nativeData = new NativeData();
        nativeData.long_data = new long[]{2L, 0L, 2L, 2L, 0L};
        nativeData.byte_data = new byte[]{47, 115, 116, 49};
        nativeData.err = 0;
        nativeData.longArrIndex = 0;
        nativeData.byteArrIndex = 0;
        NativeDataParser nativeDataParser = new NativeDataParser(nativeData);
        TopicPartition tp = nativeDataParser.getNextTopicPartition();
        Assert.assertEquals((Object)"/s:t1", (Object)tp.topic());
        Assert.assertEquals((long)0L, (long)tp.partition());
    }

    @Test
    public void testParseListenerRecords() {
        NativeData nativeData = new NativeData();
        nativeData.long_data = new long[]{2L, 22L, 2L, 24L, 0L, 0L, 1L, 0L, 1624557529564L, 2L, 1L, 0L, 4L, 1L, 16L, 5L, 0L};
        nativeData.byte_data = new byte[]{50, 116, 101, 115, 116, 99, 111, 110, 115, 111, 108, 101, 45, 112, 114, 111, 100, 117, 99, 101, 114, 0, 47, 115, 116, 50};
        nativeData.err = 0;
        nativeData.longArrIndex = 0;
        nativeData.byteArrIndex = 0;
        NativeDataParser nativeDataParser = new NativeDataParser(nativeData);
        Map records = nativeDataParser.parseListenerRecords(false);
        Iterator iter = records.entrySet().iterator();
        Assert.assertEquals((Object)true, (Object)iter.hasNext());
        Map.Entry entry = iter.next();
        Assert.assertEquals((Object)"/s:t2", (Object)((TopicPartition)entry.getKey()).topic());
        Assert.assertEquals((long)0L, (long)((TopicPartition)entry.getKey()).partition());
        Assert.assertEquals((long)1L, (long)((List)entry.getValue()).size());
        Assert.assertEquals((Object)false, (Object)iter.hasNext());
    }
}

