/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.kafka.eventstreams.impl.listener;

import com.mapr.kafka.eventstreams.impl.listener.ListenerRecord;
import com.mapr.kafka.eventstreams.impl.listener.MarlinListener;
import com.mapr.kafka.eventstreams.impl.listener.MarlinListenerImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Optional;
import java.util.Properties;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.IntegerDeserializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.easymock.EasyMock;
import org.easymock.EasyMockRunner;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=EasyMockRunner.class)
public class MarlinListenerTest {
    @Test
    public void testPoll() {
        byte[] key = new byte[]{0, 0, 0, -56};
        byte[] next = new byte[]{110, 101, 120, 116};
        ArrayList<ListenerRecord> listenerRecords = new ArrayList<ListenerRecord>();
        listenerRecords.add(new ListenerRecord("/s:t", 1, 0L, 0L, 0, key, next, null, "producer"));
        listenerRecords.add(new ListenerRecord("/s:t", 1, 1L, 0L, 0, key, next, null, "producer"));
        listenerRecords.add(new ListenerRecord("/s:t", 1, 2L, 0L, 0, key, next, null, "producer"));
        TopicPartition topicPartition = new TopicPartition("/s:t", 0);
        HashMap<TopicPartition, ArrayList<ListenerRecord>> marlinRecMap = new HashMap<TopicPartition, ArrayList<ListenerRecord>>();
        marlinRecMap.put(topicPartition, listenerRecords);
        IntegerDeserializer intDeserializer = new IntegerDeserializer();
        StringDeserializer stringDeserializer = new StringDeserializer();
        MarlinListenerImpl listenerImpl = (MarlinListenerImpl)EasyMock.createNiceMock(MarlinListenerImpl.class);
        MarlinListener marlinListener = new MarlinListener(this.getConsumerConfig((Deserializer)intDeserializer, (Deserializer)stringDeserializer), (Deserializer)intDeserializer, (Deserializer)stringDeserializer, listenerImpl);
        EasyMock.expect((Object)listenerImpl.poll(100L)).andReturn(marlinRecMap).once();
        EasyMock.replay((Object[])new Object[]{listenerImpl});
        ConsumerRecords records = marlinListener.poll(100L);
        Iterator iter = records.iterator();
        int c = 0;
        while (iter.hasNext()) {
            ConsumerRecord record = (ConsumerRecord)iter.next();
            Assert.assertEquals((long)1L, (long)record.partition());
            Assert.assertEquals((Object)"/s:t", (Object)record.topic());
            Assert.assertEquals(Optional.of(200), Optional.of((Integer)record.key()));
            Assert.assertEquals((Object)"next", (Object)record.value());
            Assert.assertEquals((long)c, (long)record.offset());
            ++c;
        }
        Assert.assertEquals((long)3L, (long)c);
        EasyMock.verify((Object[])new Object[]{listenerImpl});
    }

    @Test
    public void testToKafkaConsumerRecordWithIntegerAndStringDeserializer() {
        IntegerDeserializer intDeserializer = new IntegerDeserializer();
        StringDeserializer stringDeserializer = new StringDeserializer();
        MarlinListenerImpl listenerImpl = (MarlinListenerImpl)EasyMock.createNiceMock(MarlinListenerImpl.class);
        MarlinListener marlinListener = new MarlinListener(this.getConsumerConfig((Deserializer)intDeserializer, (Deserializer)stringDeserializer), (Deserializer)intDeserializer, (Deserializer)stringDeserializer, listenerImpl);
        byte[] key1 = new byte[]{0, 0, 0, -56};
        byte[] second = new byte[]{115, 101, 99, 111, 110, 100};
        ListenerRecord record2 = new ListenerRecord("/s:t1", 0, 1L, 0L, 0, key1, second, null, "producer");
        ConsumerRecord consumerRecord = marlinListener.toKafkaConsumerRecord(record2, (Deserializer)intDeserializer, (Deserializer)stringDeserializer);
        Assert.assertEquals((Object)200, (Object)consumerRecord.key());
        Assert.assertEquals((Object)"second", (Object)consumerRecord.value());
    }

    private ConsumerConfig getConsumerConfig(Deserializer keyDeserializer, Deserializer valueDeserializer) {
        String keyDeserializerClassName = keyDeserializer.getClass().getName();
        String valueDeserializerClassName = valueDeserializer.getClass().getName();
        Properties props = new Properties();
        props.setProperty("key.deserializer", keyDeserializerClassName);
        props.setProperty("value.deserializer", valueDeserializerClassName);
        return new ConsumerConfig(props);
    }
}

