/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.kafka.eventstreams.impl.producer;

import com.mapr.fs.jni.MarlinJniListener;
import com.mapr.kafka.eventstreams.impl.producer.MarlinProducer;
import com.mapr.kafka.eventstreams.impl.producer.MarlinProducerImpl;
import java.util.Properties;
import org.apache.kafka.clients.producer.ProducerConfig;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.easymock.EasyMock;
import org.easymock.EasyMockRunner;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=EasyMockRunner.class)
public class MarlinProducerTest {
    private String topic = "/s:t";
    private ProducerRecord<String, String> stringStringRecord = new ProducerRecord(this.topic, Integer.valueOf(0), (Object)"key", (Object)"value");
    private ProducerRecord<Integer, String> intStringRecord = new ProducerRecord(this.topic, Integer.valueOf(1), (Object)12, (Object)"value");
    private ProducerRecord<String, Integer> stringIntRecord = new ProducerRecord(this.topic, Integer.valueOf(2), (Object)"key", (Object)12);

    @BeforeClass
    public static void staticSetUp() {
        MarlinJniListener.class.getDeclaredMethods();
    }

    @Test
    public void testSendThrowsExceptions() {
        StringSerializer stringSerializer = new StringSerializer();
        MarlinProducerImpl producerImpl = (MarlinProducerImpl)EasyMock.createNiceMock(MarlinProducerImpl.class);
        MarlinProducer marlinProducer = new MarlinProducer(this.getProducerConfig((Serializer)stringSerializer, (Serializer)stringSerializer), (Serializer)stringSerializer, (Serializer)stringSerializer, producerImpl);
        try {
            marlinProducer.send(this.intStringRecord);
        }
        catch (Exception e) {
            Assert.assertEquals(SerializationException.class, e.getClass());
            Assert.assertEquals((Object)"Can't convert key of class java.lang.Integer to class class org.apache.kafka.common.serialization.StringSerializer specified in key.serializer", (Object)e.getMessage());
        }
        try {
            marlinProducer.send(this.stringIntRecord);
        }
        catch (Exception e) {
            Assert.assertEquals(SerializationException.class, e.getClass());
            Assert.assertEquals((Object)"Can't convert value of class java.lang.Integer to class class org.apache.kafka.common.serialization.StringSerializer specified in value.serializer", (Object)e.getMessage());
        }
    }

    @Test
    public void testIfJniMethodCalledWithParameters() {
        StringSerializer stringSerializer = new StringSerializer();
        byte[] serializedKey = stringSerializer.serialize("/s:t", "key");
        byte[] serializedValue = stringSerializer.serialize("/s:t", "value");
        MarlinProducerImpl producerImpl = (MarlinProducerImpl)EasyMock.mock(MarlinProducerImpl.class);
        MarlinProducer marlinProducer = new MarlinProducer(this.getProducerConfig((Serializer)stringSerializer, (Serializer)stringSerializer), (Serializer)stringSerializer, (Serializer)stringSerializer, producerImpl);
        EasyMock.expect((Object)producerImpl.send(this.stringStringRecord, 0, serializedKey, serializedValue, null)).andReturn(null).once();
        EasyMock.replay((Object[])new Object[]{producerImpl});
        marlinProducer.send(this.stringStringRecord);
        EasyMock.verify((Object[])new Object[]{producerImpl});
    }

    private ProducerConfig getProducerConfig(Serializer keySerializer, Serializer valueSerializer) {
        String keySerializerClassName = keySerializer.getClass().getName();
        String valueSerializerClassName = valueSerializer.getClass().getName();
        Properties props = new Properties();
        props.setProperty("key.serializer", keySerializerClassName);
        props.setProperty("value.serializer", valueSerializerClassName);
        return new ProducerConfig(props);
    }
}

