/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.kafka.eventstreams.impl;

import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.fs.proto.Marlinserver;
import org.ojai.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarlinRowKeyDecoder {
    static final Logger LOG = LoggerFactory.getLogger(MarlinRowKeyDecoder.class);
    public static String TOPIC = "topic";
    public static String PARTITION = "partition";
    public static String TOPIC_UNIQ = "topicUniq";
    public static String OFFSET = "offset";
    public static String CONSUMER_GROUP = "consumerGroup";
    private static final Marlinserver.MarlinInternalDefaults mdef = Marlinserver.MarlinInternalDefaults.getDefaultInstance();

    public static Document decodeMsgKey(String key) throws IllegalArgumentException {
        DBDocumentImpl doc = new DBDocumentImpl();
        int offset = 0;
        offset = MarlinRowKeyDecoder.decodePartition(key, offset, (Document)doc);
        offset = MarlinRowKeyDecoder.decodeTopic(key, offset, (Document)doc);
        offset = MarlinRowKeyDecoder.decodeTopicUniq(key, offset, (Document)doc);
        offset = MarlinRowKeyDecoder.decodeSeq(key, offset, (Document)doc);
        return doc;
    }

    public static Document decodeTopicFeedKey(String key) throws IllegalArgumentException {
        DBDocumentImpl doc = new DBDocumentImpl();
        int offset = 0;
        offset = MarlinRowKeyDecoder.decodePartition(key, offset, (Document)doc);
        offset = MarlinRowKeyDecoder.decodeTopic(key, offset, (Document)doc);
        offset = MarlinRowKeyDecoder.decodeTopicUniq(key, offset, (Document)doc);
        return doc;
    }

    public static Document decodeCursorKey(String key) throws IllegalArgumentException {
        DBDocumentImpl doc = new DBDocumentImpl();
        int offset = 0;
        offset += MarlinRowKeyDecoder.matchCursorPrefix(key, offset);
        offset = MarlinRowKeyDecoder.decodeTopic(key, offset, (Document)doc);
        offset = MarlinRowKeyDecoder.decodeTopicUniq(key, offset, (Document)doc);
        offset = MarlinRowKeyDecoder.decodePartition(key, offset, (Document)doc);
        offset = MarlinRowKeyDecoder.decodeGroup(key, offset, (Document)doc);
        return doc;
    }

    public static Document decodeAssignKey(String key) throws IllegalArgumentException {
        DBDocumentImpl doc = new DBDocumentImpl();
        int offset = 0;
        offset = MarlinRowKeyDecoder.matchAssignPrefix(key, offset);
        offset = MarlinRowKeyDecoder.decodeTopic(key, offset, (Document)doc);
        offset = MarlinRowKeyDecoder.decodeTopicUniq(key, offset, (Document)doc);
        offset = MarlinRowKeyDecoder.decodeGroup(key, offset, (Document)doc);
        return doc;
    }

    private static int decodePartition(String key, int offset, Document doc) throws IllegalArgumentException {
        String prefix = mdef.getKeyPrefixFeedId();
        if (!MarlinRowKeyDecoder.matchPrefix(key, offset, prefix)) {
            throw new IllegalArgumentException("Invalid partition prefix at offset " + offset + " in key " + key);
        }
        long lval = MarlinRowKeyDecoder.decodeHexBytes(key, offset += prefix.length(), mdef.getKeyWidthFeedId());
        if (lval < 0L) {
            throw new IllegalArgumentException("Invalid partition id at offset " + offset + " in key " + key);
        }
        doc.set(PARTITION, (int)lval);
        return offset += mdef.getKeyWidthFeedId();
    }

    private static int decodeTopic(String key, int offset, Document doc) throws IllegalArgumentException {
        String prefix = mdef.getKeyPrefixTopicName();
        if (!MarlinRowKeyDecoder.matchPrefix(key, offset, prefix)) {
            throw new IllegalArgumentException("Invalid topic prefix at offset " + offset + " in key " + key);
        }
        int index = key.indexOf(58, offset += prefix.length());
        if (index < -1) {
            throw new IllegalArgumentException("Topic delimiter ':' missing in key " + key);
        }
        if (index - offset == 0) {
            throw new IllegalArgumentException("Empty topic in key " + key);
        }
        doc.set(TOPIC, key.substring(offset, index));
        offset = index + 1;
        return offset;
    }

    private static int decodeTopicUniq(String key, int offset, Document doc) throws IllegalArgumentException {
        long lval = MarlinRowKeyDecoder.decodeHexBytes(key, offset, mdef.getKeyWidthTopicUniq());
        if (lval < 0L) {
            throw new IllegalArgumentException("Invalid topicUniq at offset " + offset + " in key " + key);
        }
        doc.set(TOPIC_UNIQ, (int)lval);
        return offset += mdef.getKeyWidthTopicUniq();
    }

    private static int decodeSeq(String key, int offset, Document doc) throws IllegalArgumentException {
        long lval = MarlinRowKeyDecoder.decodeHexBytes(key, offset, mdef.getKeyWidthSeq());
        if (lval < 0L) {
            throw new IllegalArgumentException("Invalid seq at offset " + offset + " in key " + key);
        }
        doc.set(OFFSET, lval);
        return offset;
    }

    private static int decodeGroup(String key, int offset, Document doc) throws IllegalArgumentException {
        String prefix = mdef.getKeyPrefixGroup();
        if (!MarlinRowKeyDecoder.matchPrefix(key, offset, prefix)) {
            throw new IllegalArgumentException("Invalid group prefix at offset " + offset + " in key " + key);
        }
        if ((offset += prefix.length()) == key.length()) {
            throw new IllegalArgumentException("Empty listener group id  in key " + key);
        }
        doc.set(CONSUMER_GROUP, key.substring(offset));
        return key.length();
    }

    private static long decodeHexBytes(String key, int offset, int width) {
        long value = 0L;
        if (offset + width > key.length()) {
            return -1L;
        }
        for (int i = 0; i < width; ++i) {
            long hval = MarlinRowKeyDecoder.isHexDigit(key.charAt(offset + i));
            if (hval < 0L) {
                return -1L;
            }
            value = value * 16L + hval;
        }
        return value;
    }

    private static long isHexDigit(char c) {
        if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f') {
            return Character.digit(c, 16);
        }
        return -1L;
    }

    private static boolean matchPrefix(String key, int offset, String prefix) {
        if (offset + prefix.length() > key.length()) {
            return false;
        }
        String subStr = key.substring(offset, offset + prefix.length());
        return subStr.equals(prefix);
    }

    private static int matchCursorPrefix(String key, int offset) throws IllegalArgumentException {
        String prefix = mdef.getKeyCursorPrefix();
        if (!MarlinRowKeyDecoder.matchPrefix(key, offset, prefix)) {
            throw new IllegalArgumentException("Invalid cursor prefix at offset " + offset + " in key " + key);
        }
        return offset + prefix.length();
    }

    private static int matchAssignPrefix(String key, int offset) throws IllegalArgumentException {
        String prefix = mdef.getKeyAssignPrefix();
        if (!MarlinRowKeyDecoder.matchPrefix(key, offset, prefix)) {
            throw new IllegalArgumentException("Invalid assign prefix at offset " + offset + " in key " + key);
        }
        return offset + prefix.length();
    }
}

