/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.LeaveGroupResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.requests.LeaveGroupResponse;
import org.apache.kafka.common.utils.annotation.ApiKeyVersionsSource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;

public class LeaveGroupResponseTest {
    private final String memberIdOne = "member_1";
    private final String instanceIdOne = "instance_1";
    private final String memberIdTwo = "member_2";
    private final String instanceIdTwo = "instance_2";
    private final int throttleTimeMs = 10;
    private List<LeaveGroupResponseData.MemberResponse> memberResponses;

    @BeforeEach
    public void setUp() {
        this.memberResponses = Arrays.asList(new LeaveGroupResponseData.MemberResponse().setMemberId("member_1").setGroupInstanceId("instance_1").setErrorCode(Errors.UNKNOWN_MEMBER_ID.code()), new LeaveGroupResponseData.MemberResponse().setMemberId("member_2").setGroupInstanceId("instance_2").setErrorCode(Errors.FENCED_INSTANCE_ID.code()));
    }

    @Test
    public void testConstructorWithMemberResponses() {
        HashMap<Errors, Integer> expectedErrorCounts = new HashMap<Errors, Integer>();
        expectedErrorCounts.put(Errors.NONE, 1);
        expectedErrorCounts.put(Errors.UNKNOWN_MEMBER_ID, 1);
        expectedErrorCounts.put(Errors.FENCED_INSTANCE_ID, 1);
        Iterator iterator = ApiKeys.LEAVE_GROUP.allVersions().iterator();
        while (iterator.hasNext()) {
            short version = (Short)iterator.next();
            LeaveGroupResponse leaveGroupResponse = new LeaveGroupResponse(this.memberResponses, Errors.NONE, 10, version);
            if (version >= 3) {
                Assertions.assertEquals(expectedErrorCounts, (Object)leaveGroupResponse.errorCounts());
                Assertions.assertEquals(this.memberResponses, (Object)leaveGroupResponse.memberResponses());
            } else {
                Assertions.assertEquals(Collections.singletonMap(Errors.UNKNOWN_MEMBER_ID, 1), (Object)leaveGroupResponse.errorCounts());
                Assertions.assertEquals(Collections.emptyList(), (Object)leaveGroupResponse.memberResponses());
            }
            if (version >= 1) {
                Assertions.assertEquals((int)10, (int)leaveGroupResponse.throttleTimeMs());
            } else {
                Assertions.assertEquals((int)0, (int)leaveGroupResponse.throttleTimeMs());
            }
            Assertions.assertEquals((Object)Errors.UNKNOWN_MEMBER_ID, (Object)leaveGroupResponse.error());
        }
    }

    @Test
    public void testShouldThrottle() {
        LeaveGroupResponse response = new LeaveGroupResponse(new LeaveGroupResponseData());
        Iterator iterator = ApiKeys.LEAVE_GROUP.allVersions().iterator();
        while (iterator.hasNext()) {
            short version = (Short)iterator.next();
            if (version >= 2) {
                Assertions.assertTrue((boolean)response.shouldClientThrottle(version));
                continue;
            }
            Assertions.assertFalse((boolean)response.shouldClientThrottle(version));
        }
    }

    @Test
    public void testEqualityWithSerialization() {
        LeaveGroupResponseData responseData = new LeaveGroupResponseData().setErrorCode(Errors.NONE.code()).setThrottleTimeMs(10);
        Iterator iterator = ApiKeys.LEAVE_GROUP.allVersions().iterator();
        while (iterator.hasNext()) {
            short version = (Short)iterator.next();
            LeaveGroupResponse primaryResponse = LeaveGroupResponse.parse((ByteBuffer)MessageUtil.toByteBuffer((Message)responseData, (short)version), (short)version);
            LeaveGroupResponse secondaryResponse = LeaveGroupResponse.parse((ByteBuffer)MessageUtil.toByteBuffer((Message)responseData, (short)version), (short)version);
            Assertions.assertEquals((Object)primaryResponse, (Object)primaryResponse);
            Assertions.assertEquals((Object)primaryResponse, (Object)secondaryResponse);
            Assertions.assertEquals((int)primaryResponse.hashCode(), (int)secondaryResponse.hashCode());
        }
    }

    @Test
    public void testParse() {
        Map<Errors, Integer> expectedErrorCounts = Collections.singletonMap(Errors.NOT_COORDINATOR, 1);
        LeaveGroupResponseData data = new LeaveGroupResponseData().setErrorCode(Errors.NOT_COORDINATOR.code()).setThrottleTimeMs(10);
        Iterator iterator = ApiKeys.LEAVE_GROUP.allVersions().iterator();
        while (iterator.hasNext()) {
            short version = (Short)iterator.next();
            ByteBuffer buffer = MessageUtil.toByteBuffer((Message)data, (short)version);
            LeaveGroupResponse leaveGroupResponse = LeaveGroupResponse.parse((ByteBuffer)buffer, (short)version);
            Assertions.assertEquals(expectedErrorCounts, (Object)leaveGroupResponse.errorCounts());
            if (version >= 1) {
                Assertions.assertEquals((int)10, (int)leaveGroupResponse.throttleTimeMs());
            } else {
                Assertions.assertEquals((int)0, (int)leaveGroupResponse.throttleTimeMs());
            }
            Assertions.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)leaveGroupResponse.error());
        }
    }

    @Test
    public void testEqualityWithMemberResponses() {
        Iterator iterator = ApiKeys.LEAVE_GROUP.allVersions().iterator();
        while (iterator.hasNext()) {
            short version = (Short)iterator.next();
            List<LeaveGroupResponseData.MemberResponse> localResponses = version > 2 ? this.memberResponses : this.memberResponses.subList(0, 1);
            LeaveGroupResponse primaryResponse = new LeaveGroupResponse(localResponses, Errors.NONE, 10, version);
            Collections.reverse(localResponses);
            LeaveGroupResponse reversedResponse = new LeaveGroupResponse(localResponses, Errors.NONE, 10, version);
            Assertions.assertEquals((Object)primaryResponse, (Object)primaryResponse);
            Assertions.assertEquals((Object)primaryResponse, (Object)reversedResponse);
            Assertions.assertEquals((int)primaryResponse.hashCode(), (int)reversedResponse.hashCode());
        }
    }

    @ParameterizedTest
    @ApiKeyVersionsSource(apiKey=ApiKeys.LEAVE_GROUP)
    public void testNoErrorNoMembersResponses(short version) {
        LeaveGroupResponseData data = new LeaveGroupResponseData().setErrorCode(Errors.NONE.code()).setMembers(Collections.emptyList());
        if (version < 3) {
            Assertions.assertThrows(UnsupportedVersionException.class, () -> new LeaveGroupResponse(data, version));
        } else {
            LeaveGroupResponse response = new LeaveGroupResponse(data, version);
            Assertions.assertEquals((Object)Errors.NONE, (Object)response.topLevelError());
            Assertions.assertEquals(Collections.emptyList(), (Object)response.memberResponses());
        }
    }

    @ParameterizedTest
    @ApiKeyVersionsSource(apiKey=ApiKeys.LEAVE_GROUP)
    public void testNoErrorMultipleMembersResponses(short version) {
        LeaveGroupResponseData data = new LeaveGroupResponseData().setErrorCode(Errors.NONE.code()).setMembers(this.memberResponses);
        if (version < 3) {
            Assertions.assertThrows(UnsupportedVersionException.class, () -> new LeaveGroupResponse(data, version));
        } else {
            LeaveGroupResponse response = new LeaveGroupResponse(data, version);
            Assertions.assertEquals((Object)Errors.NONE, (Object)response.topLevelError());
            Assertions.assertEquals(this.memberResponses, (Object)response.memberResponses());
        }
    }

    @ParameterizedTest
    @ApiKeyVersionsSource(apiKey=ApiKeys.LEAVE_GROUP)
    public void testErrorResponses(short version) {
        LeaveGroupResponseData dataNoMembers = new LeaveGroupResponseData().setErrorCode(Errors.GROUP_ID_NOT_FOUND.code()).setMembers(Collections.emptyList());
        LeaveGroupResponse responseNoMembers = new LeaveGroupResponse(dataNoMembers, version);
        Assertions.assertEquals((Object)Errors.GROUP_ID_NOT_FOUND, (Object)responseNoMembers.topLevelError());
        LeaveGroupResponseData dataMembers = new LeaveGroupResponseData().setErrorCode(Errors.GROUP_ID_NOT_FOUND.code()).setMembers(this.memberResponses);
        LeaveGroupResponse responseMembers = new LeaveGroupResponse(dataMembers, version);
        Assertions.assertEquals((Object)Errors.GROUP_ID_NOT_FOUND, (Object)responseMembers.topLevelError());
    }
}

