/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.mapr.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaprKafkaUtils {
    private static final Logger LOG = LoggerFactory.getLogger(MaprKafkaUtils.class);
    private static final boolean IS_OS_WINDOWS = System.getProperty("os.name").toLowerCase().startsWith("windows");
    public static final String MAPR_HOME = MaprKafkaUtils.findMapRHome();
    public static final String MAPR_CLUSTERS_FILE = MAPR_HOME + "/conf/mapr-clusters.conf";
    private static List<String> clusterNames = null;

    public static boolean isMapr(Map<?, ?> config) {
        Object useBrokers = config.get("use.brokers");
        return !"true".equals(useBrokers) && !Boolean.TRUE.equals(useBrokers);
    }

    public static boolean isMapr(Properties properties) {
        return MaprKafkaUtils.isMapr(Utils.propsToMap(properties));
    }

    public static boolean isMapr(AbstractConfig config) {
        return MaprKafkaUtils.isMapr(config.values());
    }

    public static String maybeWrapDefaultStream(String defaultStream, String topic) {
        if (topic.contains("/") || topic.contains(":")) {
            return topic;
        }
        if (defaultStream == null || defaultStream.isEmpty()) {
            throw new KafkaException("MapR kafka clients cannot work with topics without a stream. Please either specify default stream or add a stream name to the topic name.");
        }
        return defaultStream + ":" + topic;
    }

    public static Collection<String> maybeWrapDefaultStream(String defaultStream, Collection<String> topics) {
        return topics.stream().map(t -> MaprKafkaUtils.maybeWrapDefaultStream(defaultStream, t)).collect(Collectors.toList());
    }

    public static Set<String> maybeWrapDefaultStream(String defaultStream, Set<String> topics) {
        return topics.stream().map(t -> MaprKafkaUtils.maybeWrapDefaultStream(defaultStream, t)).collect(Collectors.toSet());
    }

    public static List<String> maybeWrapDefaultStream(String defaultStream, List<String> topics) {
        return topics.stream().map(t -> MaprKafkaUtils.maybeWrapDefaultStream(defaultStream, t)).collect(Collectors.toList());
    }

    public static Collection<TopicPartition> maybeWrapDefaultStreamPartitions(String defaultStream, Collection<TopicPartition> partitions) {
        partitions.forEach(p -> p.setTopic(MaprKafkaUtils.maybeWrapDefaultStream(defaultStream, p.topic())));
        return partitions;
    }

    public static <T> Map<TopicPartition, T> maybeWrapDefaultStreamPartitions(String defaultStream, Map<TopicPartition, T> partitions) {
        partitions.keySet().forEach(p -> p.setTopic(MaprKafkaUtils.maybeWrapDefaultStream(defaultStream, p.topic())));
        return partitions;
    }

    public static String maybeTrimTopic(String topic) {
        if (topic != null && topic.contains(":")) {
            return topic.split(":")[1];
        }
        return topic;
    }

    public static Set<String> listAllTopics(Admin adminClient, String defaultStream, Collection<String> topics) {
        HashSet<String> result = new HashSet<String>();
        try {
            if (defaultStream != null && !defaultStream.isEmpty()) {
                result.addAll(MaprKafkaUtils.maybeWrapDefaultStream(defaultStream, adminClient.listTopics().names().get(60L, TimeUnit.SECONDS)));
            } else if (topics.stream().anyMatch(t -> !t.contains(":"))) {
                throw new KafkaException("Encountered short-named topic while default stream is not provided");
            }
            Set usedStreams = topics.stream().filter(t -> t.contains(":")).map(t -> t.split(":")[0]).collect(Collectors.toSet());
            for (String stream : usedStreams) {
                result.addAll(MaprKafkaUtils.maybeWrapDefaultStream(stream, adminClient.listTopics(stream).names().get(60L, TimeUnit.SECONDS)));
            }
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String findMapRHome() {
        String maprHome = System.getenv("MAPR_HOME");
        if (maprHome == null) {
            LOG.warn("Environment variable MAPR_HOME is null");
            maprHome = System.getProperty("mapr.home.dir");
            if (maprHome == null) {
                LOG.warn("System property mapr.home.dir is null");
                maprHome = IS_OS_WINDOWS ? "C:/opt/mapr" : "/opt/mapr";
                LOG.warn("Setting MapR home as {} by default", (Object)maprHome);
            }
        }
        return maprHome;
    }

    public static List<String> listClusterNames() {
        try {
            if (clusterNames == null) {
                clusterNames = Files.lines(Paths.get(MAPR_CLUSTERS_FILE, new String[0])).map(l -> l.split("\\s")[0]).collect(Collectors.toList());
            }
            return clusterNames;
        }
        catch (IOException e) {
            throw new KafkaException("Could not listClusterNames from " + MAPR_CLUSTERS_FILE, e);
        }
    }
}

