/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.producer;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.internals.ProducerInterceptors;
import org.apache.kafka.clients.producer.internals.ProducerMetadata;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.Time;

public class TestMaprProducerInitializer {
    public static <K, V> KafkaProducer<K, V> newKafkaProducer(Map<?, ?> config, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        return TestMaprProducerInitializer.newKafkaProducer(config, keySerializer, valueSerializer, null, null, null, Time.SYSTEM);
    }

    public static <K, V> KafkaProducer<K, V> newKafkaProducer(Map<?, ?> configs, Serializer<K> keySerializer, Serializer<V> valueSerializer, ProducerMetadata metadata, KafkaClient kafkaClient, ProducerInterceptors<K, V> interceptors, Time time) {
        KafkaProducer producer = new KafkaProducer(configs, keySerializer, valueSerializer, metadata, kafkaClient, interceptors, time);
        try {
            Method initializeProducer = producer.getClass().getDeclaredMethod("initializeProducer", String.class, KafkaClient.class);
            initializeProducer.setAccessible(true);
            initializeProducer.invoke((Object)producer, "topic", kafkaClient);
        }
        catch (InvocationTargetException ite) {
            throw (RuntimeException)ite.getCause();
        }
        catch (ReflectiveOperationException roe) {
            throw new RuntimeException(roe);
        }
        return producer;
    }
}

