/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.JoinGroupRequestData;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.JoinGroupRequest;
import org.apache.kafka.test.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class JoinGroupRequestTest {
    @Test
    public void shouldAcceptValidGroupInstanceIds() {
        String[] validGroupInstanceIds;
        String maxLengthString = TestUtils.randomString(249);
        for (String instanceId : validGroupInstanceIds = new String[]{"valid", "INSTANCE", "gRoUp", "ar6", "VaL1d", "_0-9_.", "...", maxLengthString}) {
            JoinGroupRequest.validateGroupInstanceId((String)instanceId);
        }
    }

    @Test
    public void shouldThrowOnInvalidGroupInstanceIds() {
        String[] invalidGroupInstanceIds;
        char[] longString = new char[250];
        Arrays.fill(longString, 'a');
        for (String instanceId : invalidGroupInstanceIds = new String[]{"", "foo bar", "..", "foo:bar", "foo=bar", ".", new String(longString)}) {
            try {
                JoinGroupRequest.validateGroupInstanceId((String)instanceId);
                Assert.fail((String)("No exception was thrown for invalid instance id: " + instanceId));
            }
            catch (InvalidConfigurationException invalidConfigurationException) {
                // empty catch block
            }
        }
    }

    @Test
    public void shouldRecognizeInvalidCharactersInGroupInstanceIds() {
        char[] invalidChars;
        for (char c : invalidChars = new char[]{'/', '\\', ',', '\u0000', ':', '\"', '\'', ';', '*', '?', ' ', '\t', '\r', '\n', '='}) {
            String instanceId = "Is " + c + "illegal";
            Assert.assertFalse((boolean)JoinGroupRequest.containsValidPattern((String)instanceId));
        }
    }

    @Test(expected=UnsupportedVersionException.class)
    public void testRequestVersionCompatibilityFailBuild() {
        new JoinGroupRequest.Builder(new JoinGroupRequestData().setGroupId("groupId").setMemberId("consumerId").setGroupInstanceId("groupInstanceId").setProtocolType("consumer")).build((short)4);
    }

    @Test
    public void testRebalanceTimeoutDefaultsToSessionTimeoutV0() {
        int sessionTimeoutMs = 30000;
        Struct struct = new JoinGroupRequestData().setGroupId("groupId").setMemberId("consumerId").setProtocolType("consumer").setSessionTimeoutMs(sessionTimeoutMs).toStruct((short)0);
        ByteBuffer buffer = ByteBuffer.allocate(struct.sizeOf());
        struct.writeTo(buffer);
        buffer.flip();
        JoinGroupRequest request = JoinGroupRequest.parse((ByteBuffer)buffer, (short)0);
        Assert.assertEquals((long)sessionTimeoutMs, (long)request.data().sessionTimeoutMs());
        Assert.assertEquals((long)sessionTimeoutMs, (long)request.data().rebalanceTimeoutMs());
    }
}

