/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.protocol.types;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.BoundField;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.SchemaException;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ProtocolSerializationTest {
    private Schema schema;
    private Struct struct;

    @Before
    public void setup() {
        this.schema = new Schema(new Field[]{new Field("boolean", (Type)Type.BOOLEAN), new Field("int8", (Type)Type.INT8), new Field("int16", (Type)Type.INT16), new Field("int32", (Type)Type.INT32), new Field("int64", (Type)Type.INT64), new Field("varint", (Type)Type.VARINT), new Field("varlong", (Type)Type.VARLONG), new Field("float64", (Type)Type.FLOAT64), new Field("string", (Type)Type.STRING), new Field("compact_string", (Type)Type.COMPACT_STRING), new Field("nullable_string", (Type)Type.NULLABLE_STRING), new Field("compact_nullable_string", (Type)Type.COMPACT_NULLABLE_STRING), new Field("bytes", (Type)Type.BYTES), new Field("compact_bytes", (Type)Type.COMPACT_BYTES), new Field("nullable_bytes", (Type)Type.NULLABLE_BYTES), new Field("compact_nullable_bytes", (Type)Type.COMPACT_NULLABLE_BYTES), new Field("array", (Type)new ArrayOf((Type)Type.INT32)), new Field("compact_array", (Type)new CompactArrayOf((Type)Type.INT32)), new Field("null_array", (Type)ArrayOf.nullable((Type)Type.INT32)), new Field("compact_null_array", (Type)CompactArrayOf.nullable((Type)Type.INT32)), new Field("struct", (Type)new Schema(new Field[]{new Field("field", (Type)new ArrayOf((Type)Type.INT32))}))});
        this.struct = new Struct(this.schema).set("boolean", (Object)true).set("int8", (Object)1).set("int16", (Object)1).set("int32", (Object)1).set("int64", (Object)1L).set("varint", (Object)300).set("varlong", (Object)500L).set("float64", (Object)0.5).set("string", (Object)"1").set("compact_string", (Object)"1").set("nullable_string", null).set("compact_nullable_string", null).set("bytes", (Object)ByteBuffer.wrap("1".getBytes())).set("compact_bytes", (Object)ByteBuffer.wrap("1".getBytes())).set("nullable_bytes", null).set("compact_nullable_bytes", null).set("array", (Object)new Object[]{1}).set("compact_array", (Object)new Object[]{1}).set("null_array", null).set("compact_null_array", null);
        this.struct.set("struct", (Object)this.struct.instance("struct").set("field", (Object)new Object[]{1, 2, 3}));
    }

    @Test
    public void testSimple() {
        this.check((Type)Type.BOOLEAN, false, "BOOLEAN");
        this.check((Type)Type.BOOLEAN, true, "BOOLEAN");
        this.check((Type)Type.INT8, (byte)-111, "INT8");
        this.check((Type)Type.INT16, (short)-11111, "INT16");
        this.check((Type)Type.INT32, -11111111, "INT32");
        this.check((Type)Type.INT64, -11111111111L, "INT64");
        this.check((Type)Type.FLOAT64, 2.5, "FLOAT64");
        this.check((Type)Type.FLOAT64, -0.5, "FLOAT64");
        this.check((Type)Type.FLOAT64, 1.0E300, "FLOAT64");
        this.check((Type)Type.FLOAT64, 0.0, "FLOAT64");
        this.check((Type)Type.FLOAT64, -0.0, "FLOAT64");
        this.check((Type)Type.FLOAT64, Double.MAX_VALUE, "FLOAT64");
        this.check((Type)Type.FLOAT64, Double.MIN_VALUE, "FLOAT64");
        this.check((Type)Type.FLOAT64, Double.NaN, "FLOAT64");
        this.check((Type)Type.FLOAT64, Double.NEGATIVE_INFINITY, "FLOAT64");
        this.check((Type)Type.FLOAT64, Double.POSITIVE_INFINITY, "FLOAT64");
        this.check((Type)Type.STRING, "", "STRING");
        this.check((Type)Type.STRING, "hello", "STRING");
        this.check((Type)Type.STRING, "A\u00ea\u00f1\u00fcC", "STRING");
        this.check((Type)Type.COMPACT_STRING, "", "COMPACT_STRING");
        this.check((Type)Type.COMPACT_STRING, "hello", "COMPACT_STRING");
        this.check((Type)Type.COMPACT_STRING, "A\u00ea\u00f1\u00fcC", "COMPACT_STRING");
        this.check((Type)Type.NULLABLE_STRING, null, "NULLABLE_STRING");
        this.check((Type)Type.NULLABLE_STRING, "", "NULLABLE_STRING");
        this.check((Type)Type.NULLABLE_STRING, "hello", "NULLABLE_STRING");
        this.check((Type)Type.COMPACT_NULLABLE_STRING, null, "COMPACT_NULLABLE_STRING");
        this.check((Type)Type.COMPACT_NULLABLE_STRING, "", "COMPACT_NULLABLE_STRING");
        this.check((Type)Type.COMPACT_NULLABLE_STRING, "hello", "COMPACT_NULLABLE_STRING");
        this.check((Type)Type.BYTES, ByteBuffer.allocate(0), "BYTES");
        this.check((Type)Type.BYTES, ByteBuffer.wrap("abcd".getBytes()), "BYTES");
        this.check((Type)Type.COMPACT_BYTES, ByteBuffer.allocate(0), "COMPACT_BYTES");
        this.check((Type)Type.COMPACT_BYTES, ByteBuffer.wrap("abcd".getBytes()), "COMPACT_BYTES");
        this.check((Type)Type.NULLABLE_BYTES, null, "NULLABLE_BYTES");
        this.check((Type)Type.NULLABLE_BYTES, ByteBuffer.allocate(0), "NULLABLE_BYTES");
        this.check((Type)Type.NULLABLE_BYTES, ByteBuffer.wrap("abcd".getBytes()), "NULLABLE_BYTES");
        this.check((Type)Type.COMPACT_NULLABLE_BYTES, null, "COMPACT_NULLABLE_BYTES");
        this.check((Type)Type.COMPACT_NULLABLE_BYTES, ByteBuffer.allocate(0), "COMPACT_NULLABLE_BYTES");
        this.check((Type)Type.COMPACT_NULLABLE_BYTES, ByteBuffer.wrap("abcd".getBytes()), "COMPACT_NULLABLE_BYTES");
        this.check((Type)Type.VARINT, Integer.MAX_VALUE, "VARINT");
        this.check((Type)Type.VARINT, Integer.MIN_VALUE, "VARINT");
        this.check((Type)Type.VARLONG, Long.MAX_VALUE, "VARLONG");
        this.check((Type)Type.VARLONG, Long.MIN_VALUE, "VARLONG");
        this.check((Type)new ArrayOf((Type)Type.INT32), new Object[]{1, 2, 3, 4}, "ARRAY(INT32)");
        this.check((Type)new ArrayOf((Type)Type.STRING), new Object[0], "ARRAY(STRING)");
        this.check((Type)new ArrayOf((Type)Type.STRING), new Object[]{"hello", "there", "beautiful"}, "ARRAY(STRING)");
        this.check((Type)new CompactArrayOf((Type)Type.INT32), new Object[]{1, 2, 3, 4}, "COMPACT_ARRAY(INT32)");
        this.check((Type)new CompactArrayOf((Type)Type.COMPACT_STRING), new Object[0], "COMPACT_ARRAY(COMPACT_STRING)");
        this.check((Type)new CompactArrayOf((Type)Type.COMPACT_STRING), new Object[]{"hello", "there", "beautiful"}, "COMPACT_ARRAY(COMPACT_STRING)");
        this.check((Type)ArrayOf.nullable((Type)Type.STRING), null, "ARRAY(STRING)");
        this.check((Type)CompactArrayOf.nullable((Type)Type.COMPACT_STRING), null, "COMPACT_ARRAY(COMPACT_STRING)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNulls() {
        for (BoundField f : this.schema.fields()) {
            Object o = this.struct.get(f);
            try {
                this.struct.set(f, null);
                this.struct.validate();
                if (f.def.type.isNullable()) continue;
                Assert.fail((String)"Should not allow serialization of null value.");
            }
            catch (SchemaException e) {
                Assert.assertFalse((String)(f.toString() + " should not be nullable"), (boolean)f.def.type.isNullable());
            }
            finally {
                this.struct.set(f, o);
            }
        }
    }

    @Test
    public void testDefault() {
        Schema schema = new Schema(new Field[]{new Field("field", (Type)Type.INT32, "doc", (Object)42)});
        Struct struct = new Struct(schema);
        Assert.assertEquals((String)"Should get the default value", (Object)42, (Object)struct.get("field"));
        struct.validate();
    }

    @Test
    public void testNullableDefault() {
        this.checkNullableDefault((Type)Type.NULLABLE_BYTES, ByteBuffer.allocate(0));
        this.checkNullableDefault((Type)Type.COMPACT_NULLABLE_BYTES, ByteBuffer.allocate(0));
        this.checkNullableDefault((Type)Type.NULLABLE_STRING, "default");
        this.checkNullableDefault((Type)Type.COMPACT_NULLABLE_STRING, "default");
    }

    private void checkNullableDefault(Type type, Object defaultValue) {
        Schema schema = new Schema(new Field[]{new Field("field", type, "doc", defaultValue)});
        Struct struct = new Struct(schema);
        Assert.assertEquals((String)"Should get the default value", (Object)defaultValue, (Object)struct.get("field"));
        struct.validate();
    }

    @Test
    public void testReadArraySizeTooLarge() {
        ArrayOf type = new ArrayOf((Type)Type.INT8);
        int size = 10;
        ByteBuffer invalidBuffer = ByteBuffer.allocate(4 + size);
        invalidBuffer.putInt(Integer.MAX_VALUE);
        for (int i = 0; i < size; ++i) {
            invalidBuffer.put((byte)i);
        }
        invalidBuffer.rewind();
        try {
            type.read(invalidBuffer);
            Assert.fail((String)"Array size not validated");
        }
        catch (SchemaException schemaException) {
            // empty catch block
        }
    }

    @Test
    public void testReadCompactArraySizeTooLarge() {
        CompactArrayOf type = new CompactArrayOf((Type)Type.INT8);
        int size = 10;
        ByteBuffer invalidBuffer = ByteBuffer.allocate(ByteUtils.sizeOfUnsignedVarint((int)Integer.MAX_VALUE) + size);
        ByteUtils.writeUnsignedVarint((int)Integer.MAX_VALUE, (ByteBuffer)invalidBuffer);
        for (int i = 0; i < size; ++i) {
            invalidBuffer.put((byte)i);
        }
        invalidBuffer.rewind();
        try {
            type.read(invalidBuffer);
            Assert.fail((String)"Array size not validated");
        }
        catch (SchemaException schemaException) {
            // empty catch block
        }
    }

    @Test
    public void testReadNegativeArraySize() {
        ArrayOf type = new ArrayOf((Type)Type.INT8);
        int size = 10;
        ByteBuffer invalidBuffer = ByteBuffer.allocate(4 + size);
        invalidBuffer.putInt(-1);
        for (int i = 0; i < size; ++i) {
            invalidBuffer.put((byte)i);
        }
        invalidBuffer.rewind();
        try {
            type.read(invalidBuffer);
            Assert.fail((String)"Array size not validated");
        }
        catch (SchemaException schemaException) {
            // empty catch block
        }
    }

    @Test
    public void testReadZeroCompactArraySize() {
        CompactArrayOf type = new CompactArrayOf((Type)Type.INT8);
        int size = 10;
        ByteBuffer invalidBuffer = ByteBuffer.allocate(ByteUtils.sizeOfUnsignedVarint((int)0) + size);
        ByteUtils.writeUnsignedVarint((int)0, (ByteBuffer)invalidBuffer);
        for (int i = 0; i < size; ++i) {
            invalidBuffer.put((byte)i);
        }
        invalidBuffer.rewind();
        try {
            type.read(invalidBuffer);
            Assert.fail((String)"Array size not validated");
        }
        catch (SchemaException schemaException) {
            // empty catch block
        }
    }

    @Test
    public void testReadStringSizeTooLarge() {
        byte[] stringBytes = "foo".getBytes();
        ByteBuffer invalidBuffer = ByteBuffer.allocate(2 + stringBytes.length);
        invalidBuffer.putShort((short)(stringBytes.length * 5));
        invalidBuffer.put(stringBytes);
        invalidBuffer.rewind();
        try {
            Type.STRING.read(invalidBuffer);
            Assert.fail((String)"String size not validated");
        }
        catch (SchemaException schemaException) {
            // empty catch block
        }
        invalidBuffer.rewind();
        try {
            Type.NULLABLE_STRING.read(invalidBuffer);
            Assert.fail((String)"String size not validated");
        }
        catch (SchemaException schemaException) {
            // empty catch block
        }
    }

    @Test
    public void testReadNegativeStringSize() {
        byte[] stringBytes = "foo".getBytes();
        ByteBuffer invalidBuffer = ByteBuffer.allocate(2 + stringBytes.length);
        invalidBuffer.putShort((short)-1);
        invalidBuffer.put(stringBytes);
        invalidBuffer.rewind();
        try {
            Type.STRING.read(invalidBuffer);
            Assert.fail((String)"String size not validated");
        }
        catch (SchemaException schemaException) {
            // empty catch block
        }
    }

    @Test
    public void testReadBytesSizeTooLarge() {
        byte[] stringBytes = "foo".getBytes();
        ByteBuffer invalidBuffer = ByteBuffer.allocate(4 + stringBytes.length);
        invalidBuffer.putInt(stringBytes.length * 5);
        invalidBuffer.put(stringBytes);
        invalidBuffer.rewind();
        try {
            Type.BYTES.read(invalidBuffer);
            Assert.fail((String)"Bytes size not validated");
        }
        catch (SchemaException schemaException) {
            // empty catch block
        }
        invalidBuffer.rewind();
        try {
            Type.NULLABLE_BYTES.read(invalidBuffer);
            Assert.fail((String)"Bytes size not validated");
        }
        catch (SchemaException schemaException) {
            // empty catch block
        }
    }

    @Test
    public void testReadNegativeBytesSize() {
        byte[] stringBytes = "foo".getBytes();
        ByteBuffer invalidBuffer = ByteBuffer.allocate(4 + stringBytes.length);
        invalidBuffer.putInt(-20);
        invalidBuffer.put(stringBytes);
        invalidBuffer.rewind();
        try {
            Type.BYTES.read(invalidBuffer);
            Assert.fail((String)"Bytes size not validated");
        }
        catch (SchemaException schemaException) {
            // empty catch block
        }
    }

    @Test
    public void testToString() {
        String structStr = this.struct.toString();
        Assert.assertNotNull((String)"Struct string should not be null.", (Object)structStr);
        Assert.assertFalse((String)"Struct string should not be empty.", (boolean)structStr.isEmpty());
    }

    private Object roundtrip(Type type, Object obj) {
        ByteBuffer buffer = ByteBuffer.allocate(type.sizeOf(obj));
        type.write(buffer, obj);
        Assert.assertFalse((String)"The buffer should now be full.", (boolean)buffer.hasRemaining());
        buffer.rewind();
        Object read = type.read(buffer);
        Assert.assertFalse((String)"All bytes should have been read.", (boolean)buffer.hasRemaining());
        return read;
    }

    private void check(Type type, Object obj, String expectedTypeName) {
        List<Object> result = this.roundtrip(type, obj);
        if (obj instanceof Object[]) {
            obj = Arrays.asList((Object[])obj);
            result = Arrays.asList((Object[])result);
        }
        Assert.assertEquals((Object)expectedTypeName, (Object)type.toString());
        Assert.assertEquals((String)"The object read back should be the same as what was written.", obj, result);
    }

    @Test
    public void testStructEquals() {
        Schema schema = new Schema(new Field[]{new Field("field1", (Type)Type.NULLABLE_STRING), new Field("field2", (Type)Type.NULLABLE_STRING)});
        Struct emptyStruct1 = new Struct(schema);
        Struct emptyStruct2 = new Struct(schema);
        Assert.assertEquals((Object)emptyStruct1, (Object)emptyStruct2);
        Struct mostlyEmptyStruct = new Struct(schema).set("field1", (Object)"foo");
        Assert.assertNotEquals((Object)emptyStruct1, (Object)mostlyEmptyStruct);
        Assert.assertNotEquals((Object)mostlyEmptyStruct, (Object)emptyStruct1);
    }

    @Test
    public void testReadIgnoringExtraDataAtTheEnd() {
        Schema oldSchema = new Schema(new Field[]{new Field("field1", (Type)Type.NULLABLE_STRING), new Field("field2", (Type)Type.NULLABLE_STRING)});
        Schema newSchema = new Schema(new Field[]{new Field("field1", (Type)Type.NULLABLE_STRING)});
        String value = "foo bar baz";
        Struct oldFormat = new Struct(oldSchema).set("field1", (Object)value).set("field2", (Object)"fine to ignore");
        ByteBuffer buffer = ByteBuffer.allocate(oldSchema.sizeOf((Object)oldFormat));
        oldFormat.writeTo(buffer);
        buffer.flip();
        Struct newFormat = newSchema.read(buffer);
        Assert.assertEquals((Object)value, (Object)newFormat.get("field1"));
    }

    @Test
    public void testReadWhenOptionalDataMissingAtTheEndIsTolerated() {
        Schema oldSchema = new Schema(new Field[]{new Field("field1", (Type)Type.NULLABLE_STRING)});
        Schema newSchema = new Schema(true, new Field[]{new Field("field1", (Type)Type.NULLABLE_STRING), new Field("field2", (Type)Type.NULLABLE_STRING, "", true, (Object)"default"), new Field("field3", (Type)Type.NULLABLE_STRING, "", true, null), new Field("field4", (Type)Type.NULLABLE_BYTES, "", true, (Object)ByteBuffer.allocate(0)), new Field("field5", (Type)Type.INT64, "doc", true, (Object)Long.MAX_VALUE)});
        String value = "foo bar baz";
        Struct oldFormat = new Struct(oldSchema).set("field1", (Object)value);
        ByteBuffer buffer = ByteBuffer.allocate(oldSchema.sizeOf((Object)oldFormat));
        oldFormat.writeTo(buffer);
        buffer.flip();
        Struct newFormat = newSchema.read(buffer);
        Assert.assertEquals((Object)value, (Object)newFormat.get("field1"));
        Assert.assertEquals((Object)"default", (Object)newFormat.get("field2"));
        Assert.assertEquals(null, (Object)newFormat.get("field3"));
        Assert.assertEquals((Object)ByteBuffer.allocate(0), (Object)newFormat.get("field4"));
        Assert.assertEquals((Object)Long.MAX_VALUE, (Object)newFormat.get("field5"));
    }

    @Test
    public void testReadWhenOptionalDataMissingAtTheEndIsNotTolerated() {
        Schema oldSchema = new Schema(new Field[]{new Field("field1", (Type)Type.NULLABLE_STRING)});
        Schema newSchema = new Schema(new Field[]{new Field("field1", (Type)Type.NULLABLE_STRING), new Field("field2", (Type)Type.NULLABLE_STRING, "", true, (Object)"default")});
        String value = "foo bar baz";
        Struct oldFormat = new Struct(oldSchema).set("field1", (Object)value);
        ByteBuffer buffer = ByteBuffer.allocate(oldSchema.sizeOf((Object)oldFormat));
        oldFormat.writeTo(buffer);
        buffer.flip();
        SchemaException e = (SchemaException)Assert.assertThrows(SchemaException.class, () -> newSchema.read(buffer));
        e.getMessage().contains("Error reading field 'field2': java.nio.BufferUnderflowException");
    }

    @Test
    public void testReadWithMissingNonOptionalExtraDataAtTheEnd() {
        Schema oldSchema = new Schema(new Field[]{new Field("field1", (Type)Type.NULLABLE_STRING)});
        Schema newSchema = new Schema(true, new Field[]{new Field("field1", (Type)Type.NULLABLE_STRING), new Field("field2", (Type)Type.NULLABLE_STRING)});
        String value = "foo bar baz";
        Struct oldFormat = new Struct(oldSchema).set("field1", (Object)value);
        ByteBuffer buffer = ByteBuffer.allocate(oldSchema.sizeOf((Object)oldFormat));
        oldFormat.writeTo(buffer);
        buffer.flip();
        SchemaException e = (SchemaException)Assert.assertThrows(SchemaException.class, () -> newSchema.read(buffer));
        e.getMessage().contains("Missing value for field 'field2' which has no default value");
    }
}

