/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.message;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.apache.kafka.message.CodeBuffer;
import org.apache.kafka.message.HeaderGenerator;
import org.apache.kafka.message.MessageGenerator;
import org.apache.kafka.message.MessageSpec;
import org.apache.kafka.message.MessageSpecType;
import org.apache.kafka.message.TypeClassGenerator;

public final class MetadataRecordTypeGenerator
implements TypeClassGenerator {
    private final HeaderGenerator headerGenerator;
    private final CodeBuffer buffer;
    private final TreeMap<Short, MessageSpec> apis;

    public MetadataRecordTypeGenerator(String packageName) {
        this.headerGenerator = new HeaderGenerator(packageName);
        this.apis = new TreeMap();
        this.buffer = new CodeBuffer();
    }

    @Override
    public String outputName() {
        return "MetadataRecordType.java";
    }

    @Override
    public void registerMessageType(MessageSpec spec) {
        short id;
        MessageSpec prevSpec;
        if (spec.type() == MessageSpecType.METADATA && (prevSpec = this.apis.put(id = spec.apiKey().get().shortValue(), spec)) != null) {
            throw new RuntimeException("Duplicate metadata record entry for type " + id + ". Original claimant: " + prevSpec.name() + ". New claimant: " + spec.name());
        }
    }

    @Override
    public void generateAndWrite(BufferedWriter writer) throws IOException {
        this.generate();
        this.write(writer);
    }

    private void generate() {
        this.buffer.printf("public enum MetadataRecordType {%n", new Object[0]);
        this.buffer.incrementIndent();
        this.generateEnumValues();
        this.buffer.printf("%n", new Object[0]);
        this.generateInstanceVariables();
        this.buffer.printf("%n", new Object[0]);
        this.generateEnumConstructor();
        this.buffer.printf("%n", new Object[0]);
        this.generateFromApiKey();
        this.buffer.printf("%n", new Object[0]);
        this.generateNewMetadataRecord();
        this.buffer.printf("%n", new Object[0]);
        this.generateAccessor("id", "short");
        this.buffer.printf("%n", new Object[0]);
        this.generateAccessor("lowestSupportedVersion", "short");
        this.buffer.printf("%n", new Object[0]);
        this.generateAccessor("highestSupportedVersion", "short");
        this.buffer.printf("%n", new Object[0]);
        this.generateToString();
        this.buffer.decrementIndent();
        this.buffer.printf("}%n", new Object[0]);
        this.headerGenerator.generate();
    }

    private void generateEnumValues() {
        int numProcessed = 0;
        for (Map.Entry<Short, MessageSpec> entry : this.apis.entrySet()) {
            MessageSpec spec = entry.getValue();
            String name = spec.name();
            this.buffer.printf("%s(\"%s\", (short) %d, (short) %d, (short) %d)%s%n", MessageGenerator.toSnakeCase(name).toUpperCase(Locale.ROOT), MessageGenerator.capitalizeFirst(name), entry.getKey(), entry.getValue().validVersions().lowest(), entry.getValue().validVersions().highest(), ++numProcessed == this.apis.size() ? ";" : ",");
        }
    }

    private void generateInstanceVariables() {
        this.buffer.printf("private final String name;%n", new Object[0]);
        this.buffer.printf("private final short id;%n", new Object[0]);
        this.buffer.printf("private final short lowestSupportedVersion;%n", new Object[0]);
        this.buffer.printf("private final short highestSupportedVersion;%n", new Object[0]);
    }

    private void generateEnumConstructor() {
        this.buffer.printf("MetadataRecordType(String name, short id, short lowestSupportedVersion, short highestSupportedVersion) {%n", new Object[0]);
        this.buffer.incrementIndent();
        this.buffer.printf("this.name = name;%n", new Object[0]);
        this.buffer.printf("this.id = id;%n", new Object[0]);
        this.buffer.printf("this.lowestSupportedVersion = lowestSupportedVersion;%n", new Object[0]);
        this.buffer.printf("this.highestSupportedVersion = highestSupportedVersion;%n", new Object[0]);
        this.buffer.decrementIndent();
        this.buffer.printf("}%n", new Object[0]);
    }

    private void generateFromApiKey() {
        this.buffer.printf("public static MetadataRecordType fromId(short id) {%n", new Object[0]);
        this.buffer.incrementIndent();
        this.buffer.printf("switch (id) {%n", new Object[0]);
        this.buffer.incrementIndent();
        for (Map.Entry<Short, MessageSpec> entry : this.apis.entrySet()) {
            this.buffer.printf("case %d:%n", entry.getKey());
            this.buffer.incrementIndent();
            this.buffer.printf("return %s;%n", MessageGenerator.toSnakeCase(entry.getValue().name()).toUpperCase(Locale.ROOT));
            this.buffer.decrementIndent();
        }
        this.buffer.printf("default:%n", new Object[0]);
        this.buffer.incrementIndent();
        this.headerGenerator.addImport("org.apache.kafka.common.errors.UnsupportedVersionException");
        this.buffer.printf("throw new UnsupportedVersionException(\"Unknown metadata id \" + id);%n", new Object[0]);
        this.buffer.decrementIndent();
        this.buffer.decrementIndent();
        this.buffer.printf("}%n", new Object[0]);
        this.buffer.decrementIndent();
        this.buffer.printf("}%n", new Object[0]);
    }

    private void generateNewMetadataRecord() {
        this.headerGenerator.addImport("org.apache.kafka.common.protocol.ApiMessage");
        this.buffer.printf("public ApiMessage newMetadataRecord() {%n", new Object[0]);
        this.buffer.incrementIndent();
        this.buffer.printf("switch (id) {%n", new Object[0]);
        this.buffer.incrementIndent();
        for (Map.Entry<Short, MessageSpec> entry : this.apis.entrySet()) {
            this.buffer.printf("case %d:%n", entry.getKey());
            this.buffer.incrementIndent();
            this.buffer.printf("return new %s();%n", MessageGenerator.capitalizeFirst(entry.getValue().name()));
            this.buffer.decrementIndent();
        }
        this.buffer.printf("default:%n", new Object[0]);
        this.buffer.incrementIndent();
        this.headerGenerator.addImport("org.apache.kafka.common.errors.UnsupportedVersionException");
        this.buffer.printf("throw new UnsupportedVersionException(\"Unknown metadata id \" + id);%n", new Object[0]);
        this.buffer.decrementIndent();
        this.buffer.decrementIndent();
        this.buffer.printf("}%n", new Object[0]);
        this.buffer.decrementIndent();
        this.buffer.printf("}%n", new Object[0]);
    }

    private void generateAccessor(String name, String type) {
        this.buffer.printf("public %s %s() {%n", type, name);
        this.buffer.incrementIndent();
        this.buffer.printf("return this.%s;%n", name);
        this.buffer.decrementIndent();
        this.buffer.printf("}%n", new Object[0]);
    }

    private void generateToString() {
        this.buffer.printf("@Override%n", new Object[0]);
        this.buffer.printf("public String toString() {%n", new Object[0]);
        this.buffer.incrementIndent();
        this.buffer.printf("return this.name();%n", new Object[0]);
        this.buffer.decrementIndent();
        this.buffer.printf("}%n", new Object[0]);
    }

    private void write(BufferedWriter writer) throws IOException {
        this.headerGenerator.buffer().write(writer);
        this.buffer.write(writer);
    }
}

