/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.message;

import org.apache.kafka.message.MessageGenerator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=120L)
public class MessageGeneratorTest {
    @Test
    public void testCapitalizeFirst() throws Exception {
        Assertions.assertEquals((Object)"", (Object)MessageGenerator.capitalizeFirst((String)""));
        Assertions.assertEquals((Object)"AbC", (Object)MessageGenerator.capitalizeFirst((String)"abC"));
    }

    @Test
    public void testLowerCaseFirst() throws Exception {
        Assertions.assertEquals((Object)"", (Object)MessageGenerator.lowerCaseFirst((String)""));
        Assertions.assertEquals((Object)"fORTRAN", (Object)MessageGenerator.lowerCaseFirst((String)"FORTRAN"));
        Assertions.assertEquals((Object)"java", (Object)MessageGenerator.lowerCaseFirst((String)"java"));
    }

    @Test
    public void testFirstIsCapitalized() throws Exception {
        Assertions.assertFalse((boolean)MessageGenerator.firstIsCapitalized((String)""));
        Assertions.assertTrue((boolean)MessageGenerator.firstIsCapitalized((String)"FORTRAN"));
        Assertions.assertFalse((boolean)MessageGenerator.firstIsCapitalized((String)"java"));
    }

    @Test
    public void testToSnakeCase() throws Exception {
        Assertions.assertEquals((Object)"", (Object)MessageGenerator.toSnakeCase((String)""));
        Assertions.assertEquals((Object)"foo_bar_baz", (Object)MessageGenerator.toSnakeCase((String)"FooBarBaz"));
        Assertions.assertEquals((Object)"foo_bar_baz", (Object)MessageGenerator.toSnakeCase((String)"fooBarBaz"));
        Assertions.assertEquals((Object)"fortran", (Object)MessageGenerator.toSnakeCase((String)"FORTRAN"));
    }

    @Test
    public void stripSuffixTest() throws Exception {
        Assertions.assertEquals((Object)"FooBa", (Object)MessageGenerator.stripSuffix((String)"FooBar", (String)"r"));
        Assertions.assertEquals((Object)"", (Object)MessageGenerator.stripSuffix((String)"FooBar", (String)"FooBar"));
        Assertions.assertEquals((Object)"Foo", (Object)MessageGenerator.stripSuffix((String)"FooBar", (String)"Bar"));
        try {
            MessageGenerator.stripSuffix((String)"FooBar", (String)"Baz");
            Assertions.fail((String)"expected exception");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testConstants() {
        Assertions.assertEquals((int)65535, (int)65535);
        Assertions.assertEquals((long)0xFFFFFFFFL, (long)0xFFFFFFFFL);
    }
}

