/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.message;

import org.apache.kafka.message.CodeBuffer;
import org.apache.kafka.message.IsNullConditional;
import org.apache.kafka.message.VersionConditionalTest;
import org.apache.kafka.message.Versions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=120L)
public class IsNullConditionalTest {
    @Test
    public void testNullCheck() throws Exception {
        CodeBuffer buffer = new CodeBuffer();
        IsNullConditional.forName((String)"foobar").nullableVersions(Versions.parse((String)"2+", null)).possibleVersions(Versions.parse((String)"0+", null)).ifNull(() -> buffer.printf("System.out.println(\"null\");%n", new Object[0])).generate(buffer);
        VersionConditionalTest.claimEquals(buffer, "if (foobar == null) {%n", "    System.out.println(\"null\");%n", "}%n");
    }

    @Test
    public void testAnotherNullCheck() throws Exception {
        CodeBuffer buffer = new CodeBuffer();
        IsNullConditional.forName((String)"foobar").nullableVersions(Versions.parse((String)"0+", null)).possibleVersions(Versions.parse((String)"2+", null)).ifNull(() -> buffer.printf("System.out.println(\"null\");%n", new Object[0])).ifShouldNotBeNull(() -> buffer.printf("System.out.println(\"not null\");%n", new Object[0])).generate(buffer);
        VersionConditionalTest.claimEquals(buffer, "if (foobar == null) {%n", "    System.out.println(\"null\");%n", "} else {%n", "    System.out.println(\"not null\");%n", "}%n");
    }

    @Test
    public void testNotNullCheck() throws Exception {
        CodeBuffer buffer = new CodeBuffer();
        IsNullConditional.forName((String)"foobar").nullableVersions(Versions.parse((String)"0+", null)).possibleVersions(Versions.parse((String)"2+", null)).ifShouldNotBeNull(() -> buffer.printf("System.out.println(\"not null\");%n", new Object[0])).generate(buffer);
        VersionConditionalTest.claimEquals(buffer, "if (foobar != null) {%n", "    System.out.println(\"not null\");%n", "}%n");
    }

    @Test
    public void testNeverNull() throws Exception {
        CodeBuffer buffer = new CodeBuffer();
        IsNullConditional.forName((String)"baz").nullableVersions(Versions.parse((String)"0-2", null)).possibleVersions(Versions.parse((String)"3+", null)).ifNull(() -> buffer.printf("System.out.println(\"null\");%n", new Object[0])).ifShouldNotBeNull(() -> buffer.printf("System.out.println(\"not null\");%n", new Object[0])).generate(buffer);
        VersionConditionalTest.claimEquals(buffer, "System.out.println(\"not null\");%n");
    }

    @Test
    public void testNeverNullWithBlockScope() throws Exception {
        CodeBuffer buffer = new CodeBuffer();
        IsNullConditional.forName((String)"baz").nullableVersions(Versions.parse((String)"0-2", null)).possibleVersions(Versions.parse((String)"3+", null)).ifNull(() -> buffer.printf("System.out.println(\"null\");%n", new Object[0])).ifShouldNotBeNull(() -> buffer.printf("System.out.println(\"not null\");%n", new Object[0])).alwaysEmitBlockScope(true).generate(buffer);
        VersionConditionalTest.claimEquals(buffer, "{%n", "    System.out.println(\"not null\");%n", "}%n");
    }
}

