/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.transforms.predicates;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigValue;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.source.SourceRecord;
import org.apache.kafka.connect.transforms.predicates.TopicNameMatches;
import org.apache.kafka.connect.transforms.util.SimpleConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TopicNameMatchesTest {
    @Test
    public void testPatternRequiredInConfig() {
        HashMap props = new HashMap();
        ConfigException e = (ConfigException)Assertions.assertThrows(ConfigException.class, () -> this.config(props));
        Assertions.assertTrue((boolean)e.getMessage().contains("Missing required configuration \"pattern\""));
    }

    @Test
    public void testPatternMayNotBeEmptyInConfig() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("pattern", "");
        ConfigException e = (ConfigException)Assertions.assertThrows(ConfigException.class, () -> this.config(props));
        Assertions.assertTrue((boolean)e.getMessage().contains("String must be non-empty"));
    }

    @Test
    public void testPatternIsValidRegexInConfig() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("pattern", "[");
        ConfigException e = (ConfigException)Assertions.assertThrows(ConfigException.class, () -> this.config(props));
        Assertions.assertTrue((boolean)e.getMessage().contains("Invalid regex"));
    }

    @Test
    public void testConfig() {
        TopicNameMatches predicate = new TopicNameMatches();
        predicate.config().validate(Collections.singletonMap("pattern", "my-prefix-.*"));
        List configs = predicate.config().validate(Collections.singletonMap("pattern", "*"));
        List errorMsgs = ((ConfigValue)configs.get(0)).errorMessages();
        Assertions.assertEquals((int)1, (int)errorMsgs.size());
        Assertions.assertTrue((boolean)((String)errorMsgs.get(0)).contains("Invalid regex"));
    }

    @Test
    public void testTest() {
        TopicNameMatches predicate = new TopicNameMatches();
        predicate.configure(Collections.singletonMap("pattern", "my-prefix-.*"));
        Assertions.assertTrue((boolean)predicate.test((ConnectRecord)this.recordWithTopicName("my-prefix-")));
        Assertions.assertTrue((boolean)predicate.test((ConnectRecord)this.recordWithTopicName("my-prefix-foo")));
        Assertions.assertFalse((boolean)predicate.test((ConnectRecord)this.recordWithTopicName("x-my-prefix-")));
        Assertions.assertFalse((boolean)predicate.test((ConnectRecord)this.recordWithTopicName("x-my-prefix-foo")));
        Assertions.assertFalse((boolean)predicate.test((ConnectRecord)this.recordWithTopicName("your-prefix-")));
        Assertions.assertFalse((boolean)predicate.test((ConnectRecord)this.recordWithTopicName("your-prefix-foo")));
        Assertions.assertFalse((boolean)predicate.test((ConnectRecord)new SourceRecord(null, null, null, null, null)));
    }

    private SimpleConfig config(Map<String, String> props) {
        return new SimpleConfig(TopicNameMatches.CONFIG_DEF, props);
    }

    private SourceRecord recordWithTopicName(String topicName) {
        return new SourceRecord(null, null, topicName, null, null);
    }
}

