/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.rest.util;

import com.mapr.web.security.SslConfig;
import com.mapr.web.security.WebSecurityManager;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.SslConfigs;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.utils.Utils;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jsse.provider.BouncyCastleJsseProvider;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class SSLUtils {
    private static SslConfig sslConfig = null;
    private static final Pattern COMMA_WITH_WHITESPACE = Pattern.compile("\\s*,\\s*");

    private static SslConfig getSslConfig() {
        if (sslConfig == null) {
            sslConfig = WebSecurityManager.getSslConfig();
        }
        return sslConfig;
    }

    private static void putIfBlank(Map<String, Object> map, String key, Supplier<Object> supplier) {
        Object value = map.get(key);
        if (value == null || value instanceof String && Utils.isBlank((String)((String)value)) || value instanceof Password && Utils.isBlank((String)((Password)value).value())) {
            map.put(key, supplier.get());
        }
    }

    private static void setMaprSslConfigsIfNeeded(Map<String, Object> sslConfigs) {
        SSLUtils.putIfBlank(sslConfigs, "ssl.keystore.type", () -> SSLUtils.getSslConfig().getServerKeystoreType());
        SSLUtils.putIfBlank(sslConfigs, "ssl.keystore.location", () -> SSLUtils.getSslConfig().getServerKeystoreLocation());
        SSLUtils.putIfBlank(sslConfigs, "ssl.keystore.password", () -> new Password(new String(SSLUtils.getSslConfig().getServerKeystorePassword())));
        SSLUtils.putIfBlank(sslConfigs, "ssl.key.password", () -> new Password(new String(SSLUtils.getSslConfig().getServerKeyPassword())));
        SSLUtils.putIfBlank(sslConfigs, "ssl.truststore.type", () -> SSLUtils.getSslConfig().getServerTruststoreType());
        SSLUtils.putIfBlank(sslConfigs, "ssl.truststore.location", () -> SSLUtils.getSslConfig().getServerTruststoreLocation());
        SSLUtils.putIfBlank(sslConfigs, "ssl.truststore.password", () -> new Password(new String(SSLUtils.getSslConfig().getServerTruststorePassword())));
    }

    public static SslContextFactory createServerSideSslContextFactory(AbstractConfig config, String prefix) {
        Map sslConfigValues = config.valuesWithPrefixAllOrNothing(prefix);
        SSLUtils.setMaprSslConfigsIfNeeded(sslConfigValues);
        SslContextFactory.Server ssl = new SslContextFactory.Server();
        SSLUtils.configureSslContextFactoryKeyStore((SslContextFactory)ssl, sslConfigValues);
        SSLUtils.configureSslContextFactoryTrustStore((SslContextFactory)ssl, sslConfigValues);
        SSLUtils.configureSslContextFactoryAlgorithms((SslContextFactory)ssl, sslConfigValues);
        SSLUtils.configureSslContextFactoryAuthentication(ssl, sslConfigValues);
        return ssl;
    }

    public static SslContextFactory createServerSideSslContextFactory(AbstractConfig config) {
        return SSLUtils.createServerSideSslContextFactory(config, "listeners.https.");
    }

    public static SslContextFactory createClientSideSslContextFactory(AbstractConfig config) {
        Map sslConfigValues = config.valuesWithPrefixAllOrNothing("listeners.https.");
        SSLUtils.setMaprSslConfigsIfNeeded(sslConfigValues);
        SslContextFactory.Client ssl = new SslContextFactory.Client();
        SSLUtils.configureSslContextFactoryKeyStore((SslContextFactory)ssl, sslConfigValues);
        SSLUtils.configureSslContextFactoryTrustStore((SslContextFactory)ssl, sslConfigValues);
        SSLUtils.configureSslContextFactoryAlgorithms((SslContextFactory)ssl, sslConfigValues);
        SSLUtils.configureSslContextFactoryEndpointIdentification((SslContextFactory)ssl, sslConfigValues);
        return ssl;
    }

    private static void maybeEnableFips(SslContextFactory ssl, Map<String, Object> sslConfigValues) {
        String keyStoreType = (String)SSLUtils.getOrDefault(sslConfigValues, "ssl.keystore.type", "JKS");
        if ("BCFKS".equals(keyStoreType)) {
            Security.addProvider((Provider)new BouncyCastleFipsProvider());
            Security.addProvider((Provider)new BouncyCastleJsseProvider());
            ssl.setProvider("BCJSSE");
        }
    }

    protected static void configureSslContextFactoryKeyStore(SslContextFactory ssl, Map<String, Object> sslConfigValues) {
        Password sslKeyPassword;
        Password sslKeystorePassword;
        SSLUtils.maybeEnableFips(ssl, sslConfigValues);
        ssl.setKeyStoreType((String)SSLUtils.getOrDefault(sslConfigValues, "ssl.keystore.type", "JKS"));
        String sslKeystoreLocation = (String)sslConfigValues.get("ssl.keystore.location");
        if (sslKeystoreLocation != null) {
            ssl.setKeyStorePath(sslKeystoreLocation);
        }
        if ((sslKeystorePassword = (Password)sslConfigValues.get("ssl.keystore.password")) != null) {
            ssl.setKeyStorePassword(sslKeystorePassword.value());
        }
        if ((sslKeyPassword = (Password)sslConfigValues.get("ssl.key.password")) != null) {
            ssl.setKeyManagerPassword(sslKeyPassword.value());
        }
    }

    protected static Object getOrDefault(Map<String, Object> configMap, String key, Object defaultValue) {
        if (configMap.containsKey(key)) {
            return configMap.get(key);
        }
        return defaultValue;
    }

    protected static void configureSslContextFactoryTrustStore(SslContextFactory ssl, Map<String, Object> sslConfigValues) {
        Password sslTruststorePassword;
        ssl.setTrustStoreType((String)SSLUtils.getOrDefault(sslConfigValues, "ssl.truststore.type", "JKS"));
        String sslTruststoreLocation = (String)sslConfigValues.get("ssl.truststore.location");
        if (sslTruststoreLocation != null) {
            ssl.setTrustStorePath(sslTruststoreLocation);
        }
        if ((sslTruststorePassword = (Password)sslConfigValues.get("ssl.truststore.password")) != null) {
            ssl.setTrustStorePassword(sslTruststorePassword.value());
        }
    }

    protected static void configureSslContextFactoryAlgorithms(SslContextFactory ssl, Map<String, Object> sslConfigValues) {
        List sslEnabledProtocols = (List)SSLUtils.getOrDefault(sslConfigValues, "ssl.enabled.protocols", Arrays.asList(COMMA_WITH_WHITESPACE.split(SslConfigs.DEFAULT_SSL_ENABLED_PROTOCOLS)));
        ssl.setIncludeProtocols(sslEnabledProtocols.toArray(new String[0]));
        List sslDisabledProtocols = (List)SSLUtils.getOrDefault(sslConfigValues, "ssl.disabled.protocols", Arrays.asList(COMMA_WITH_WHITESPACE.split("SSLv3, TLSv1.0")));
        ssl.setExcludeProtocols(sslDisabledProtocols.toArray(new String[sslDisabledProtocols.size()]));
        String sslProvider = (String)sslConfigValues.get("ssl.provider");
        if (sslProvider != null) {
            ssl.setProvider(sslProvider);
        }
        ssl.setProtocol((String)SSLUtils.getOrDefault(sslConfigValues, "ssl.protocol", SslConfigs.DEFAULT_SSL_PROTOCOL));
        List sslCipherSuites = (List)sslConfigValues.get("ssl.cipher.suites");
        if (sslCipherSuites != null) {
            ssl.setIncludeCipherSuites(sslCipherSuites.toArray(new String[0]));
        }
        List sslCipherSuitesExclude = (List)SSLUtils.getOrDefault(sslConfigValues, "ssl.cipher.suites.exclude", Arrays.asList(COMMA_WITH_WHITESPACE.split("TLS_DHE.*, TLS_EDH.*, .*RC4.*, .*MD5.*, .*DES.*")));
        ssl.setExcludeCipherSuites(sslCipherSuitesExclude.toArray(new String[sslCipherSuitesExclude.size()]));
        ssl.setKeyManagerFactoryAlgorithm((String)SSLUtils.getOrDefault(sslConfigValues, "ssl.keymanager.algorithm", SslConfigs.DEFAULT_SSL_KEYMANGER_ALGORITHM));
        String sslSecureRandomImpl = (String)sslConfigValues.get("ssl.secure.random.implementation");
        if (sslSecureRandomImpl != null) {
            ssl.setSecureRandomAlgorithm(sslSecureRandomImpl);
        }
        ssl.setTrustManagerFactoryAlgorithm((String)SSLUtils.getOrDefault(sslConfigValues, "ssl.trustmanager.algorithm", SslConfigs.DEFAULT_SSL_TRUSTMANAGER_ALGORITHM));
    }

    protected static void configureSslContextFactoryEndpointIdentification(SslContextFactory ssl, Map<String, Object> sslConfigValues) {
        String sslEndpointIdentificationAlg = (String)sslConfigValues.get("ssl.endpoint.identification.algorithm");
        if (sslEndpointIdentificationAlg != null) {
            ssl.setEndpointIdentificationAlgorithm(sslEndpointIdentificationAlg);
        }
    }

    protected static void configureSslContextFactoryAuthentication(SslContextFactory.Server ssl, Map<String, Object> sslConfigValues) {
        String sslClientAuth;
        switch (sslClientAuth = (String)SSLUtils.getOrDefault(sslConfigValues, "ssl.client.auth", "none")) {
            case "requested": {
                ssl.setWantClientAuth(true);
                break;
            }
            case "required": {
                ssl.setNeedClientAuth(true);
                break;
            }
            default: {
                ssl.setNeedClientAuth(false);
                ssl.setWantClientAuth(false);
            }
        }
    }
}

