/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.rest.util;

import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.net.ssl.X509ExtendedKeyManager;
import org.apache.kafka.common.config.SslConfigs;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.connect.runtime.WorkerConfig;
import org.apache.kafka.connect.runtime.rest.errors.SSLConfigException;
import org.apache.kafka.connect.tools.KafkaSSLPropertiesReader;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jsse.provider.BouncyCastleJsseProvider;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class SSLUtils {
    private static final Pattern COMMA_WITH_WHITESPACE = Pattern.compile("\\s*,\\s*");

    public static SslContextFactory createServerSideSslContextFactory(WorkerConfig config, String prefix) {
        Map sslConfigValues = config.valuesWithPrefixAllOrNothing(prefix);
        SslContextFactory.Server ssl = new SslContextFactory.Server();
        SSLUtils.configureSslContextFactoryKeyStore((SslContextFactory)ssl, sslConfigValues);
        SSLUtils.configureSslContextFactoryTrustStore((SslContextFactory)ssl, sslConfigValues);
        SSLUtils.configureSslContextFactoryAlgorithms((SslContextFactory)ssl, sslConfigValues);
        SSLUtils.configureSslContextFactoryAuthentication(ssl, sslConfigValues);
        return ssl;
    }

    public static SslContextFactory createServerSideSslContextFactory(WorkerConfig config) {
        return SSLUtils.createServerSideSslContextFactory(config, "listeners.https.");
    }

    public static SslContextFactory createClientSideSslContextFactory(WorkerConfig config) {
        Map sslConfigValues = config.valuesWithPrefixAllOrNothing("listeners.https.");
        SslContextFactory.Client ssl = new SslContextFactory.Client(){

            protected X509ExtendedKeyManager newSniX509ExtendedKeyManager(X509ExtendedKeyManager keyManager) {
                return keyManager;
            }
        };
        SSLUtils.configureSslContextFactoryKeyStore((SslContextFactory)ssl, sslConfigValues);
        SSLUtils.configureSslContextFactoryTrustStore((SslContextFactory)ssl, sslConfigValues);
        SSLUtils.configureSslContextFactoryAlgorithms((SslContextFactory)ssl, sslConfigValues);
        SSLUtils.configureSslContextFactoryEndpointIdentification((SslContextFactory)ssl, sslConfigValues);
        return ssl;
    }

    private static void configureSslContextFactoryKeyStore(SslContextFactory ssl, Map<String, Object> sslConfigValues) {
        String sslKeystoreType = (String)sslConfigValues.get("ssl.keystore.type");
        if (sslKeystoreType != null && !sslKeystoreType.isEmpty()) {
            ssl.setKeyStoreType(sslKeystoreType);
        } else {
            sslKeystoreType = KafkaSSLPropertiesReader.getServerKeystoreType();
            if (sslKeystoreType == null) {
                throw new SSLConfigException("ssl.keystore.type");
            }
            ssl.setKeyStoreType(sslKeystoreType);
            if (sslKeystoreType.equalsIgnoreCase("BCFKS")) {
                Security.addProvider((Provider)new BouncyCastleFipsProvider());
                Security.addProvider((Provider)new BouncyCastleJsseProvider());
                ssl.setProvider("BCJSSE");
            }
        }
        String sslKeystoreLocation = (String)sslConfigValues.get("ssl.keystore.location");
        if (sslKeystoreLocation != null) {
            ssl.setKeyStorePath(sslKeystoreLocation);
        } else {
            sslKeystoreLocation = KafkaSSLPropertiesReader.getServerKeystoreLocation();
            if (sslKeystoreLocation == null) {
                throw new SSLConfigException("ssl.keystore.location");
            }
            ssl.setKeyStorePath(sslKeystoreLocation);
        }
        Password sslKeystorePassword = (Password)sslConfigValues.get("ssl.keystore.password");
        if (sslKeystorePassword != null && !Objects.equals(sslKeystorePassword.value(), "")) {
            ssl.setKeyStorePassword(sslKeystorePassword.value());
        } else {
            String tmpSslKeystorePassword = KafkaSSLPropertiesReader.getServerKeystorePassword();
            if (Objects.equals(tmpSslKeystorePassword, "")) {
                throw new SSLConfigException("ssl.keystore.password");
            }
            ssl.setKeyStorePassword(tmpSslKeystorePassword);
        }
        Password sslKeyPassword = (Password)sslConfigValues.get("ssl.key.password");
        if (sslKeyPassword != null && !Objects.equals(sslKeyPassword.value(), "")) {
            ssl.setKeyManagerPassword(sslKeyPassword.value());
        } else {
            String tmpSslKeyPassword = KafkaSSLPropertiesReader.getServerKeyPassword();
            if (Objects.equals(tmpSslKeyPassword, "")) {
                throw new SSLConfigException("ssl.key.password");
            }
            ssl.setKeyManagerPassword(tmpSslKeyPassword);
        }
    }

    protected static Object getOrDefault(Map<String, Object> configMap, String key, Object defaultValue) {
        if (configMap.containsKey(key)) {
            return configMap.get(key);
        }
        return defaultValue;
    }

    protected static void configureSslContextFactoryTrustStore(SslContextFactory ssl, Map<String, Object> sslConfigValues) {
        Password sslTruststorePassword;
        String sslTruststoreType = (String)sslConfigValues.get("ssl.truststore.type");
        if (sslTruststoreType != null && !sslTruststoreType.isEmpty()) {
            ssl.setTrustStoreType(sslTruststoreType);
        } else {
            sslTruststoreType = KafkaSSLPropertiesReader.getServerTruststoreType();
            if (sslTruststoreType == null) {
                throw new SSLConfigException("ssl.truststore.type");
            }
            ssl.setTrustStoreType(sslTruststoreType);
        }
        String sslTruststoreLocation = (String)sslConfigValues.get("ssl.truststore.location");
        if (sslTruststoreLocation != null) {
            ssl.setTrustStorePath(sslTruststoreLocation);
        }
        if ((sslTruststorePassword = (Password)sslConfigValues.get("ssl.truststore.password")) != null) {
            ssl.setTrustStorePassword(sslTruststorePassword.value());
        }
    }

    protected static void configureSslContextFactoryAlgorithms(SslContextFactory ssl, Map<String, Object> sslConfigValues) {
        List sslCipherSuitesExclude;
        List sslEnabledProtocols = (List)SSLUtils.getOrDefault(sslConfigValues, "ssl.enabled.protocols", Arrays.asList(COMMA_WITH_WHITESPACE.split(SslConfigs.DEFAULT_SSL_ENABLED_PROTOCOLS)));
        ssl.setIncludeProtocols(sslEnabledProtocols.toArray(new String[sslEnabledProtocols.size()]));
        List sslDisabledProtocols = (List)SSLUtils.getOrDefault(sslConfigValues, "ssl.disabled.protocols", Arrays.asList(COMMA_WITH_WHITESPACE.split("SSLv3, TLSv1.0")));
        ssl.setExcludeProtocols(sslDisabledProtocols.toArray(new String[sslDisabledProtocols.size()]));
        String sslProvider = (String)sslConfigValues.get("ssl.provider");
        if (sslProvider != null) {
            ssl.setProvider(sslProvider);
        }
        ssl.setProtocol((String)SSLUtils.getOrDefault(sslConfigValues, "ssl.protocol", SslConfigs.DEFAULT_SSL_PROTOCOL));
        List sslCipherSuites = (List)sslConfigValues.get("ssl.cipher.suites");
        if (sslCipherSuites != null) {
            ssl.setIncludeCipherSuites(sslCipherSuites.toArray(new String[sslCipherSuites.size()]));
        }
        if ((sslCipherSuitesExclude = (List)sslConfigValues.get("ssl.cipher.suites.exclude")) != null) {
            ssl.setExcludeCipherSuites(sslCipherSuitesExclude.toArray(new String[sslCipherSuitesExclude.size()]));
        }
        ssl.setKeyManagerFactoryAlgorithm((String)SSLUtils.getOrDefault(sslConfigValues, "ssl.keymanager.algorithm", SslConfigs.DEFAULT_SSL_KEYMANGER_ALGORITHM));
        String sslSecureRandomImpl = (String)sslConfigValues.get("ssl.secure.random.implementation");
        if (sslSecureRandomImpl != null) {
            ssl.setSecureRandomAlgorithm(sslSecureRandomImpl);
        }
        ssl.setTrustManagerFactoryAlgorithm((String)SSLUtils.getOrDefault(sslConfigValues, "ssl.trustmanager.algorithm", SslConfigs.DEFAULT_SSL_TRUSTMANAGER_ALGORITHM));
    }

    protected static void configureSslContextFactoryEndpointIdentification(SslContextFactory ssl, Map<String, Object> sslConfigValues) {
        String sslEndpointIdentificationAlg = (String)sslConfigValues.get("ssl.endpoint.identification.algorithm");
        if (sslEndpointIdentificationAlg != null) {
            ssl.setEndpointIdentificationAlgorithm(sslEndpointIdentificationAlg);
        }
    }

    protected static void configureSslContextFactoryAuthentication(SslContextFactory.Server ssl, Map<String, Object> sslConfigValues) {
        String sslClientAuth;
        switch (sslClientAuth = (String)SSLUtils.getOrDefault(sslConfigValues, "ssl.client.auth", "none")) {
            case "requested": {
                ssl.setWantClientAuth(true);
                break;
            }
            case "required": {
                ssl.setNeedClientAuth(true);
                break;
            }
            default: {
                ssl.setNeedClientAuth(false);
                ssl.setWantClientAuth(false);
            }
        }
    }
}

