/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.rest.util;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.function.BiConsumer;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;

public class HeadersFilter
implements Filter {
    private Properties headerProperties = new Properties();

    public void init(FilterConfig filterConfig) throws ServletException {
        String headersFilename = filterConfig.getInitParameter("headers.file");
        File headerFile = new File(headersFilename);
        try {
            this.headerProperties.loadFromXML(FileUtils.openInputStream((File)headerFile));
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        this.headerProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> httpServletResponse.addHeader((String)k, v.toString())));
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void destroy() {
    }
}

