/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.mirror;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.connect.mirror.MirrorConnectorConfig;
import org.apache.kafka.connect.mirror.TestUtils;
import org.apache.kafka.test.MockMetricsReporter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MirrorConnectorConfigTest {
    @Test
    public void testSourceConsumerConfig() {
        Map<String, String> connectorProps = TestUtils.makeProps("consumer.max.poll.interval.ms", "120000", "source.cluster.bootstrap.servers", "localhost:2345");
        TestMirrorConnectorConfig config = new TestMirrorConnectorConfig(connectorProps);
        Map connectorConsumerProps = config.sourceConsumerConfig("test");
        HashMap<String, String> expectedConsumerProps = new HashMap<String, String>();
        expectedConsumerProps.put("enable.auto.commit", "false");
        expectedConsumerProps.put("auto.offset.reset", "earliest");
        expectedConsumerProps.put("max.poll.interval.ms", "120000");
        expectedConsumerProps.put("client.id", "source1->target2|ConnectorName|test");
        expectedConsumerProps.put("bootstrap.servers", "localhost:2345");
        Assertions.assertEquals(expectedConsumerProps, (Object)connectorConsumerProps);
        connectorProps = TestUtils.makeProps("consumer.auto.offset.reset", "latest", "source.cluster.bootstrap.servers", "localhost:2345");
        config = new TestMirrorConnectorConfig(connectorProps);
        connectorConsumerProps = config.sourceConsumerConfig("test");
        expectedConsumerProps.put("auto.offset.reset", "latest");
        expectedConsumerProps.remove("max.poll.interval.ms");
        Assertions.assertEquals(expectedConsumerProps, (Object)connectorConsumerProps, (String)"consumer. source consumer config not matching");
    }

    @Test
    public void testSourceConsumerConfigWithSourcePrefix() {
        String prefix = "source.consumer.";
        Map<String, String> connectorProps = TestUtils.makeProps(prefix + "auto.offset.reset", "latest", prefix + "max.poll.interval.ms", "100");
        TestMirrorConnectorConfig config = new TestMirrorConnectorConfig(connectorProps);
        Map connectorConsumerProps = config.sourceConsumerConfig("test");
        HashMap<String, String> expectedConsumerProps = new HashMap<String, String>();
        expectedConsumerProps.put("enable.auto.commit", "false");
        expectedConsumerProps.put("auto.offset.reset", "latest");
        expectedConsumerProps.put("max.poll.interval.ms", "100");
        expectedConsumerProps.put("client.id", "source1->target2|ConnectorName|test");
        Assertions.assertEquals(expectedConsumerProps, (Object)connectorConsumerProps, (String)(prefix + " source consumer config not matching"));
    }

    @Test
    public void testSourceProducerConfig() {
        Map<String, String> connectorProps = TestUtils.makeProps("producer.acks", "1");
        TestMirrorConnectorConfig config = new TestMirrorConnectorConfig(connectorProps);
        Map connectorProducerProps = config.sourceProducerConfig("test");
        HashMap<String, String> expectedProducerProps = new HashMap<String, String>();
        expectedProducerProps.put("acks", "1");
        expectedProducerProps.put("client.id", "source1->target2|ConnectorName|test");
        Assertions.assertEquals(expectedProducerProps, (Object)connectorProducerProps, (String)"producer. source product config not matching");
    }

    @Test
    public void testSourceProducerConfigWithSourcePrefix() {
        String prefix = "source.producer.";
        Map<String, String> connectorProps = TestUtils.makeProps(prefix + "acks", "1");
        TestMirrorConnectorConfig config = new TestMirrorConnectorConfig(connectorProps);
        Map connectorProducerProps = config.sourceProducerConfig("test");
        HashMap<String, String> expectedProducerProps = new HashMap<String, String>();
        expectedProducerProps.put("acks", "1");
        expectedProducerProps.put("client.id", "source1->target2|ConnectorName|test");
        Assertions.assertEquals(expectedProducerProps, (Object)connectorProducerProps, (String)(prefix + " source producer config not matching"));
    }

    @Test
    public void testSourceAdminConfig() {
        Map<String, String> connectorProps = TestUtils.makeProps("admin.connections.max.idle.ms", "10000");
        TestMirrorConnectorConfig config = new TestMirrorConnectorConfig(connectorProps);
        Map connectorAdminProps = config.sourceAdminConfig("test");
        HashMap<String, String> expectedAdminProps = new HashMap<String, String>();
        expectedAdminProps.put("connections.max.idle.ms", "10000");
        expectedAdminProps.put("client.id", "source1->target2|ConnectorName|test");
        Assertions.assertEquals(expectedAdminProps, (Object)connectorAdminProps, (String)"admin. source connector admin props not matching");
    }

    @Test
    public void testSourceAdminConfigWithSourcePrefix() {
        String prefix = "source.admin.";
        Map<String, String> connectorProps = TestUtils.makeProps(prefix + "connections.max.idle.ms", "10000");
        TestMirrorConnectorConfig config = new TestMirrorConnectorConfig(connectorProps);
        Map connectorAdminProps = config.sourceAdminConfig("test");
        HashMap<String, String> expectedAdminProps = new HashMap<String, String>();
        expectedAdminProps.put("connections.max.idle.ms", "10000");
        expectedAdminProps.put("client.id", "source1->target2|ConnectorName|test");
        Assertions.assertEquals(expectedAdminProps, (Object)connectorAdminProps, (String)(prefix + " source connector admin props not matching"));
    }

    @Test
    public void testTargetAdminConfig() {
        Map<String, String> connectorProps = TestUtils.makeProps("admin.connections.max.idle.ms", "10000");
        TestMirrorConnectorConfig config = new TestMirrorConnectorConfig(connectorProps);
        Map connectorAdminProps = config.targetAdminConfig("test");
        HashMap<String, String> expectedAdminProps = new HashMap<String, String>();
        expectedAdminProps.put("connections.max.idle.ms", "10000");
        expectedAdminProps.put("client.id", "source1->target2|ConnectorName|test");
        Assertions.assertEquals(expectedAdminProps, (Object)connectorAdminProps, (String)"admin. target connector admin props not matching");
    }

    @Test
    public void testTargetAdminConfigWithSourcePrefix() {
        String prefix = "target.admin.";
        Map<String, String> connectorProps = TestUtils.makeProps(prefix + "connections.max.idle.ms", "10000");
        TestMirrorConnectorConfig config = new TestMirrorConnectorConfig(connectorProps);
        Map connectorAdminProps = config.targetAdminConfig("test");
        HashMap<String, String> expectedAdminProps = new HashMap<String, String>();
        expectedAdminProps.put("connections.max.idle.ms", "10000");
        expectedAdminProps.put("client.id", "source1->target2|ConnectorName|test");
        Assertions.assertEquals(expectedAdminProps, (Object)connectorAdminProps, (String)(prefix + " source connector admin props not matching"));
    }

    @Test
    public void testInvalidSecurityProtocol() {
        ConfigException ce = (ConfigException)Assertions.assertThrows(ConfigException.class, () -> new TestMirrorConnectorConfig(TestUtils.makeProps("security.protocol", "abc")));
        Assertions.assertTrue((boolean)ce.getMessage().contains("security.protocol"));
    }

    @Test
    public void testCaseInsensitiveSecurityProtocol() {
        String saslSslLowerCase = SecurityProtocol.SASL_SSL.name.toLowerCase(Locale.ROOT);
        TestMirrorConnectorConfig config = new TestMirrorConnectorConfig(TestUtils.makeProps("security.protocol", saslSslLowerCase));
        Assertions.assertEquals((Object)saslSslLowerCase, config.originalsStrings().get("security.protocol"));
    }

    @Test
    public void testMetricsReporters() {
        Map<String, String> connectorProps = TestUtils.makeProps("metric.reporters", MockMetricsReporter.class.getName());
        TestMirrorConnectorConfig config = new TestMirrorConnectorConfig(connectorProps);
        Assertions.assertEquals((int)2, (int)config.metricsReporters().size());
        connectorProps.put("auto.include.jmx.reporter", "false");
        config = new TestMirrorConnectorConfig(connectorProps);
        Assertions.assertEquals((int)1, (int)config.metricsReporters().size());
    }

    @Test
    public void testExplicitlyEnableJmxReporter() {
        String reporters = MockMetricsReporter.class.getName() + "," + JmxReporter.class.getName();
        Map<String, String> connectorProps = TestUtils.makeProps("metric.reporters", reporters);
        TestMirrorConnectorConfig config = new TestMirrorConnectorConfig(connectorProps);
        Assertions.assertEquals((int)2, (int)config.metricsReporters().size());
    }

    @Test
    public void testReplicationPolicy() {
        TestMirrorConnectorConfig config = new TestMirrorConnectorConfig(TestUtils.makeProps(new String[0]));
        Assertions.assertSame((Object)config.replicationPolicy(), (Object)config.replicationPolicy());
    }

    static class TestMirrorConnectorConfig
    extends MirrorConnectorConfig {
        protected TestMirrorConnectorConfig(Map<String, String> props) {
            super(BASE_CONNECTOR_CONFIG_DEF, props);
        }
    }
}

