/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.mirror.integration;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import kafka.server.KafkaConfig;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.network.Mode;
import org.apache.kafka.connect.mirror.integration.MirrorConnectorsIntegrationBaseTest;
import org.apache.kafka.test.TestSslUtils;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;

@Tag(value="integration")
public class MirrorConnectorsIntegrationSSLTest
extends MirrorConnectorsIntegrationBaseTest {
    @Override
    @BeforeEach
    public void startClusters() throws Exception {
        Map sslConfig = TestSslUtils.createSslConfig((boolean)false, (boolean)true, (Mode)Mode.SERVER, (File)TestUtils.tempFile(), (String)"testCert");
        this.backupBrokerProps.put(KafkaConfig.ListenersProp(), "SSL://localhost:0");
        this.backupBrokerProps.put(KafkaConfig.InterBrokerListenerNameProp(), "SSL");
        this.backupBrokerProps.putAll((Map<?, ?>)sslConfig);
        Properties sslProps = new Properties();
        sslProps.put("ssl.truststore.location", sslConfig.get("ssl.truststore.location"));
        sslProps.put("ssl.truststore.password", ((Password)sslConfig.get("ssl.truststore.password")).value());
        sslProps.put("security.protocol", "SSL");
        this.backupWorkerProps.putAll(sslProps.entrySet().stream().collect(Collectors.toMap(e -> String.valueOf(e.getKey()), e -> String.valueOf(e.getValue()))));
        this.mm2Props.putAll(sslProps.entrySet().stream().collect(Collectors.toMap(e -> "backup." + e.getKey(), e -> String.valueOf(e.getValue()))));
        this.mm2Props.putAll(sslProps.entrySet().stream().collect(Collectors.toMap(e -> "backup.producer." + e.getKey(), e -> String.valueOf(e.getValue()))));
        super.startClusters();
    }
}

