/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.mirror;

import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.connect.mirror.OffsetSync;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OffsetSyncTest {
    @Test
    public void testSerde() {
        OffsetSync offsetSync = new OffsetSync(new TopicPartition("topic-1", 2), 3L, 4L);
        byte[] key = offsetSync.recordKey();
        byte[] value = offsetSync.recordValue();
        ConsumerRecord record = new ConsumerRecord("any-topic", 6, 7L, (Object)key, (Object)value);
        OffsetSync deserialized = OffsetSync.deserializeRecord((ConsumerRecord)record);
        Assertions.assertEquals((Object)offsetSync.topicPartition(), (Object)deserialized.topicPartition(), (String)"Failure on offset sync topic partition serde");
        Assertions.assertEquals((long)offsetSync.upstreamOffset(), (long)deserialized.upstreamOffset(), (String)"Failure on upstream offset serde");
        Assertions.assertEquals((long)offsetSync.downstreamOffset(), (long)deserialized.downstreamOffset(), (String)"Failure on downstream offset serde");
    }
}

