/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.mirror;

import java.util.List;
import java.util.Map;
import org.apache.kafka.connect.mirror.MirrorHeartbeatTask;
import org.apache.kafka.connect.mirror.TestUtils;
import org.apache.kafka.connect.source.SourceRecord;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MirrorHeartbeatTaskTest {
    @Test
    public void testPollCreatesRecords() throws InterruptedException {
        MirrorHeartbeatTask heartbeatTask = new MirrorHeartbeatTask();
        heartbeatTask.start(TestUtils.makeProps("source.cluster.alias", "testSource", "target.cluster.alias", "testTarget"));
        List records = heartbeatTask.poll();
        Assertions.assertEquals((int)1, (int)records.size());
        Map sourcePartition = ((SourceRecord)records.iterator().next()).sourcePartition();
        Assertions.assertEquals(sourcePartition.get("sourceClusterAlias"), (Object)"testSource", (String)"sourcePartition's sourceClusterAlias record was not created");
        Assertions.assertEquals(sourcePartition.get("targetClusterAlias"), (Object)"testTarget", (String)"sourcePartition's targetClusterAlias record was not created");
    }
}

