/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.mirror;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.mirror.MirrorCheckpointConfig;
import org.apache.kafka.connect.mirror.MirrorCheckpointTaskConfig;
import org.apache.kafka.connect.mirror.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MirrorCheckpointConfigTest {
    @Test
    public void testTaskConfigConsumerGroups() {
        List<String> groups = Arrays.asList("consumer-1", "consumer-2", "consumer-3");
        MirrorCheckpointConfig config = new MirrorCheckpointConfig(TestUtils.makeProps(new String[0]));
        Map props = config.taskConfigForConsumerGroups(groups, 1);
        MirrorCheckpointTaskConfig taskConfig = new MirrorCheckpointTaskConfig(props);
        Assertions.assertEquals((Object)taskConfig.taskConsumerGroups(), new HashSet<String>(groups), (String)"Setting consumer groups property configuration failed");
    }

    @Test
    public void testGroupMatching() {
        MirrorCheckpointConfig config = new MirrorCheckpointConfig(TestUtils.makeProps("groups", "group1"));
        Assertions.assertTrue((boolean)config.groupFilter().shouldReplicateGroup("group1"), (String)"topic1 group matching property configuration failed");
        Assertions.assertFalse((boolean)config.groupFilter().shouldReplicateGroup("group2"), (String)"topic2 group matching property configuration failed");
    }

    @Test
    public void testNonMutationOfConfigDef() {
        ConfigDef taskConfigDef = MirrorCheckpointTaskConfig.TASK_CONFIG_DEF;
        Assertions.assertTrue((boolean)taskConfigDef.names().contains("task.assigned.groups"), (String)"task.assigned.groups should be defined for task ConfigDef");
        Assertions.assertFalse((boolean)MirrorCheckpointConfig.CONNECTOR_CONFIG_DEF.names().contains("task.assigned.groups"), (String)"task.assigned.groups should not be defined for connector ConfigDef");
    }

    @Test
    public void testConsumerConfigsForOffsetSyncsTopic() {
        Map<String, String> connectorProps = TestUtils.makeProps("source.consumer.max.partition.fetch.bytes", "1", "target.consumer.heartbeat.interval.ms", "1", "consumer.max.poll.interval.ms", "1", "fetch.min.bytes", "1");
        MirrorCheckpointConfig config = new MirrorCheckpointConfig(connectorProps);
        Map sourceConsumerConfig = config.sourceConsumerConfig("test");
        Map offsetSyncsTopicSourceConsumerConfig = config.offsetSyncsTopicConsumerConfig();
        TestUtils.assertEqualsExceptClientId(sourceConsumerConfig, offsetSyncsTopicSourceConsumerConfig);
        Assertions.assertEquals((Object)"source1->target2|ConnectorName|test", sourceConsumerConfig.get("client.id"));
        Assertions.assertEquals((Object)"source1->target2|ConnectorName|offset-syncs-source-consumer", offsetSyncsTopicSourceConsumerConfig.get("client.id"));
        connectorProps.put("offset-syncs.topic.location", "target");
        config = new MirrorCheckpointConfig(connectorProps);
        Map targetConsumerConfig = config.targetConsumerConfig("test");
        Map offsetSyncsTopicTargetConsumerConfig = config.offsetSyncsTopicConsumerConfig();
        TestUtils.assertEqualsExceptClientId(targetConsumerConfig, offsetSyncsTopicTargetConsumerConfig);
        Assertions.assertEquals((Object)"source1->target2|ConnectorName|test", targetConsumerConfig.get("client.id"));
        Assertions.assertEquals((Object)"source1->target2|ConnectorName|offset-syncs-target-consumer", offsetSyncsTopicTargetConsumerConfig.get("client.id"));
    }
}

