/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.mirror;

import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.connect.mirror.Checkpoint;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CheckpointTest {
    @Test
    public void testSerde() {
        Checkpoint checkpoint = new Checkpoint("group-1", new TopicPartition("topic-2", 3), 4L, 5L, "metadata-6");
        byte[] key = checkpoint.recordKey();
        byte[] value = checkpoint.recordValue();
        ConsumerRecord record = new ConsumerRecord("any-topic", 7, 8L, (Object)key, (Object)value);
        Checkpoint deserialized = Checkpoint.deserializeRecord((ConsumerRecord)record);
        Assertions.assertEquals((Object)checkpoint.consumerGroupId(), (Object)deserialized.consumerGroupId(), (String)"Failure on checkpoint consumerGroupId serde");
        Assertions.assertEquals((Object)checkpoint.topicPartition(), (Object)deserialized.topicPartition(), (String)"Failure on checkpoint topicPartition serde");
        Assertions.assertEquals((long)checkpoint.upstreamOffset(), (long)deserialized.upstreamOffset(), (String)"Failure on checkpoint upstreamOffset serde");
        Assertions.assertEquals((long)checkpoint.downstreamOffset(), (long)deserialized.downstreamOffset(), (String)"Failure on checkpoint downstreamOffset serde");
    }
}

