/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.mirror.clients.admin;

import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.acl.AclBinding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FakeLocalMetadataStore {
    private static final Logger log = LoggerFactory.getLogger(FakeLocalMetadataStore.class);
    private static ConcurrentHashMap<String, ConcurrentHashMap<String, String>> allTopics = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, Vector<AclBinding>> allAcls = new ConcurrentHashMap();

    public static void addTopicToLocalMetadataStore(NewTopic newTopic) {
        ConcurrentHashMap<String, String> configs = new ConcurrentHashMap<String, String>(newTopic.configs());
        configs.putIfAbsent("partitions", String.valueOf(newTopic.numPartitions()));
        allTopics.putIfAbsent(newTopic.name(), configs);
    }

    public static void updatePartitionCount(String topic, int newPartitionCount) {
        ConcurrentHashMap<String, String> configs = allTopics.getOrDefault(topic, new ConcurrentHashMap());
        configs.compute("partitions", (key, value) -> String.valueOf(newPartitionCount));
        allTopics.putIfAbsent(topic, configs);
    }

    public static void updateTopicConfig(String topic, Config newConfig) {
        ConcurrentHashMap topicConfigs = allTopics.getOrDefault(topic, new ConcurrentHashMap());
        newConfig.entries().stream().forEach(configEntry -> {
            if (configEntry.name() != null) {
                if (configEntry.value() != null) {
                    log.debug("Topic '{}' update config '{}' to '{}'", new Object[]{topic, configEntry.name(), configEntry.value()});
                    topicConfigs.compute(configEntry.name(), (key, value) -> configEntry.value());
                } else {
                    log.warn("Topic '{}' has config '{}' set to null", (Object)topic, (Object)configEntry.name());
                }
            }
        });
        allTopics.putIfAbsent(topic, topicConfigs);
    }

    public static Boolean containsTopic(String topic) {
        return allTopics.containsKey(topic);
    }

    public static Map<String, String> topicConfig(String topic) {
        return allTopics.getOrDefault(topic, new ConcurrentHashMap());
    }

    public static List<AclBinding> aclBindings(String aclPrinciple) {
        return allAcls.getOrDefault("User:" + aclPrinciple, new Vector());
    }

    public static void addACLs(String principal, AclBinding aclBinding) {
        Vector<AclBinding> aclBindings = allAcls.getOrDefault(principal, new Vector());
        aclBindings.add(aclBinding);
        allAcls.putIfAbsent(principal, aclBindings);
    }

    public static void clear() {
        allTopics.clear();
        allAcls.clear();
    }
}

