/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.mirror;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.CreateTopicsOptions;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.mirror.MirrorUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class MirrorUtilsTest {
    private static final String TOPIC = "topic";
    private final Admin admin = (Admin)Mockito.mock(Admin.class);
    private final CreateTopicsResult ctr = (CreateTopicsResult)Mockito.mock(CreateTopicsResult.class);
    private final KafkaFuture<Void> future = (KafkaFuture)Mockito.mock(KafkaFuture.class);

    @Test
    public void testCreateCompactedTopic() throws Exception {
        Map<String, KafkaFuture<Void>> values = Collections.singletonMap(TOPIC, this.future);
        Mockito.when((Object)((Void)this.future.get())).thenReturn(null);
        Mockito.when((Object)this.ctr.values()).thenReturn(values);
        Mockito.when((Object)this.admin.createTopics((Collection)ArgumentMatchers.any(), (CreateTopicsOptions)ArgumentMatchers.any())).thenReturn((Object)this.ctr);
        MirrorUtils.createCompactedTopic((String)TOPIC, (short)1, (short)1, (Admin)this.admin);
        ((KafkaFuture)Mockito.verify(this.future)).get();
        ((CreateTopicsResult)Mockito.verify((Object)this.ctr)).values();
        ((Admin)Mockito.verify((Object)this.admin)).createTopics((Collection)ArgumentMatchers.any(), (CreateTopicsOptions)ArgumentMatchers.any());
    }

    @Test
    public void testCreateCompactedTopicAlreadyExists() throws Exception {
        Map<String, KafkaFuture<Void>> values = Collections.singletonMap(TOPIC, this.future);
        Mockito.when((Object)((Void)this.future.get())).thenThrow(new Throwable[]{new ExecutionException((Throwable)new TopicExistsException("topic exists"))});
        Mockito.when((Object)this.ctr.values()).thenReturn(values);
        Mockito.when((Object)this.admin.createTopics((Collection)ArgumentMatchers.any(), (CreateTopicsOptions)ArgumentMatchers.any())).thenReturn((Object)this.ctr);
        MirrorUtils.createCompactedTopic((String)TOPIC, (short)1, (short)1, (Admin)this.admin);
        ((KafkaFuture)Mockito.verify(this.future)).get();
        ((CreateTopicsResult)Mockito.verify((Object)this.ctr)).values();
        ((Admin)Mockito.verify((Object)this.admin)).createTopics((Collection)ArgumentMatchers.any(), (CreateTopicsOptions)ArgumentMatchers.any());
    }

    @Test
    public void testCreateCompactedTopicFails() throws Exception {
        Map<String, KafkaFuture<Void>> values = Collections.singletonMap(TOPIC, this.future);
        Mockito.when((Object)((Void)this.future.get())).thenThrow(new Throwable[]{new ExecutionException((Throwable)new ClusterAuthorizationException("not authorized"))});
        Mockito.when((Object)this.ctr.values()).thenReturn(values);
        Mockito.when((Object)this.admin.createTopics((Collection)ArgumentMatchers.any(), (CreateTopicsOptions)ArgumentMatchers.any())).thenReturn((Object)this.ctr);
        Throwable ce = Assertions.assertThrows(ConnectException.class, () -> MirrorUtils.createCompactedTopic((String)TOPIC, (short)1, (short)1, (Admin)this.admin), (String)"Should have exception thrown");
        Assertions.assertTrue((boolean)(ce.getCause() instanceof ExecutionException));
        Assertions.assertTrue((boolean)(ce.getCause().getCause() instanceof ClusterAuthorizationException));
        ((KafkaFuture)Mockito.verify(this.future)).get();
        ((CreateTopicsResult)Mockito.verify((Object)this.ctr)).values();
        ((Admin)Mockito.verify((Object)this.admin)).createTopics((Collection)ArgumentMatchers.any(), (CreateTopicsOptions)ArgumentMatchers.any());
    }
}

