/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.client;

import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hadoop.hive.metastore.annotation.MetastoreCheckinTest;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.Catalog;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.FunctionType;
import org.apache.hadoop.hive.metastore.api.GetAllFunctionsResponse;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.ResourceType;
import org.apache.hadoop.hive.metastore.api.ResourceUri;
import org.apache.hadoop.hive.metastore.client.MetaStoreClientTest;
import org.apache.hadoop.hive.metastore.client.builder.CatalogBuilder;
import org.apache.hadoop.hive.metastore.client.builder.DatabaseBuilder;
import org.apache.hadoop.hive.metastore.client.builder.FunctionBuilder;
import org.apache.hadoop.hive.metastore.minihms.AbstractMetaStoreService;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TException;
import org.apache.thrift.transport.TTransportException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={MetastoreCheckinTest.class})
public class TestFunctions
extends MetaStoreClientTest {
    private static final String DEFAULT_DATABASE = "default";
    private static final String OTHER_DATABASE = "dummy";
    private static final String TEST_FUNCTION_CLASS = "org.apache.hadoop.hive.ql.udf.generic.GenericUDFUpper";
    private final AbstractMetaStoreService metaStore;
    private IMetaStoreClient client;
    private Function[] testFunctions = new Function[4];

    public TestFunctions(String name, AbstractMetaStoreService metaStore) {
        this.metaStore = metaStore;
    }

    @Before
    public void setUp() throws Exception {
        this.client = this.metaStore.getClient();
        this.client.dropDatabase(OTHER_DATABASE, true, true, true);
        for (Function function : this.client.getAllFunctions().getFunctions()) {
            this.client.dropFunction(function.getDbName(), function.getFunctionName());
        }
        this.testFunctions[0] = new FunctionBuilder().setDbName(DEFAULT_DATABASE).setName("test_function_to_find_1").setClass(TEST_FUNCTION_CLASS).addResourceUri(new ResourceUri(ResourceType.JAR, "hdfs:///tmp/jar1.jar")).addResourceUri(new ResourceUri(ResourceType.FILE, "hdfs:///tmp/file1.txt")).addResourceUri(new ResourceUri(ResourceType.ARCHIVE, "hdfs:///tmp/archive1.tgz")).build(this.metaStore.getConf());
        this.testFunctions[1] = new FunctionBuilder().setDbName(DEFAULT_DATABASE).setName("test_function_to_find_2").setClass(TEST_FUNCTION_CLASS).build(this.metaStore.getConf());
        this.testFunctions[2] = new FunctionBuilder().setDbName(DEFAULT_DATABASE).setName("test_function_hidden_1").setClass(TEST_FUNCTION_CLASS).build(this.metaStore.getConf());
        new DatabaseBuilder().setName(OTHER_DATABASE).create(this.client, this.metaStore.getConf());
        this.testFunctions[3] = new FunctionBuilder().setDbName(OTHER_DATABASE).setName("test_function_to_find_1").setClass(TEST_FUNCTION_CLASS).build(this.metaStore.getConf());
        for (int i = 0; i < this.testFunctions.length; ++i) {
            this.client.createFunction(this.testFunctions[i]);
            this.testFunctions[i] = this.client.getFunction(this.testFunctions[i].getDbName(), this.testFunctions[i].getFunctionName());
        }
    }

    @After
    public void tearDown() throws Exception {
        try {
            if (this.client != null) {
                this.client.close();
            }
        }
        finally {
            this.client = null;
        }
    }

    @Test
    public void testCreateGetDeleteFunction() throws Exception {
        Function function = new FunctionBuilder().setDbName(OTHER_DATABASE).setName("test_function").setClass(TEST_FUNCTION_CLASS).setFunctionType(FunctionType.JAVA).setOwnerType(PrincipalType.ROLE).setOwner("owner").setCreateTime(100).addResourceUri(new ResourceUri(ResourceType.JAR, "hdfs:///tmp/jar1.jar")).addResourceUri(new ResourceUri(ResourceType.FILE, "hdfs:///tmp/file1.txt")).addResourceUri(new ResourceUri(ResourceType.ARCHIVE, "hdfs:///tmp/archive1.tgz")).create(this.client, this.metaStore.getConf());
        Function createdFunction = this.client.getFunction(function.getDbName(), function.getFunctionName());
        function.setCreateTime(createdFunction.getCreateTime());
        Assert.assertEquals((String)"Comparing functions", (Object)function, (Object)createdFunction);
        this.client.dropFunction(function.getDbName(), function.getFunctionName());
        try {
            this.client.getFunction(function.getDbName(), function.getFunctionName());
            Assert.fail((String)"Expected a NoSuchObjectException to be thrown");
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
    }

    @Test
    public void testCreateFunctionDefaultValues() throws Exception {
        Function function = new Function();
        function.setDbName(OTHER_DATABASE);
        function.setFunctionName("test_function");
        function.setClassName(TEST_FUNCTION_CLASS);
        function.setOwnerName("owner3");
        function.setOwnerType(PrincipalType.USER);
        function.setFunctionType(FunctionType.JAVA);
        this.client.createFunction(function);
        Function createdFunction = this.client.getFunction(function.getDbName(), function.getFunctionName());
        Assert.assertEquals((String)"Comparing OwnerName", (Object)createdFunction.getOwnerName(), (Object)"owner3");
        Assert.assertEquals((String)"Comparing ResourceUris", (long)0L, (long)createdFunction.getResourceUris().size());
        Assert.assertNotEquals((String)"Comparing CreateTime", (long)0L, (long)createdFunction.getCreateTime());
    }

    @Test(expected=InvalidObjectException.class)
    public void testCreateFunctionNullClass() throws Exception {
        Function function = this.testFunctions[0];
        function.setClassName(null);
        this.client.createFunction(function);
    }

    @Test(expected=InvalidObjectException.class)
    public void testCreateFunctionInvalidName() throws Exception {
        Function function = this.testFunctions[0];
        function.setFunctionName("test_function_2;");
        this.client.createFunction(function);
    }

    @Test(expected=InvalidObjectException.class)
    public void testCreateFunctionEmptyName() throws Exception {
        Function function = this.testFunctions[0];
        function.setFunctionName("");
        this.client.createFunction(function);
    }

    @Test
    public void testCreateFunctionNullFunctionName() throws Exception {
        Function function = this.testFunctions[0];
        function.setFunctionName(null);
        try {
            this.client.createFunction(function);
            Assert.fail((String)"Expected an NullPointerException or TTransportException to be thrown");
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (TTransportException tTransportException) {
            // empty catch block
        }
    }

    @Test
    public void testCreateFunctionNullDatabaseName() throws Exception {
        Function function = this.testFunctions[0];
        function.setDbName(null);
        try {
            this.client.createFunction(function);
            Assert.fail((String)"Expected a NoSuchObjectException to be thrown");
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
    }

    @Test
    public void testCreateFunctionNullOwnerType() throws Exception {
        Function function = this.testFunctions[0];
        function.setFunctionName("test_function_2");
        function.setOwnerType(null);
        try {
            this.client.createFunction(function);
            Assert.fail((String)"Expected an NullPointerException or TTransportException to be thrown");
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (TTransportException tTransportException) {
            // empty catch block
        }
    }

    @Test
    public void testCreateFunctionNullFunctionType() throws Exception {
        Function function = this.testFunctions[0];
        function.setFunctionName("test_function_2");
        function.setFunctionType(null);
        try {
            this.client.createFunction(function);
            Assert.fail((String)"Expected an NullPointerException or TTransportException to be thrown");
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (TTransportException tTransportException) {
            // empty catch block
        }
    }

    @Test(expected=NoSuchObjectException.class)
    public void testCreateFunctionNoSuchDatabase() throws Exception {
        Function function = this.testFunctions[0];
        function.setDbName("no_such_database");
        this.client.createFunction(function);
    }

    @Test(expected=AlreadyExistsException.class)
    public void testCreateFunctionAlreadyExists() throws Exception {
        Function function = this.testFunctions[0];
        this.client.createFunction(function);
    }

    @Test
    public void testGetFunctionCaseInsensitive() throws Exception {
        Function function = this.testFunctions[0];
        Function resultUpper = this.client.getFunction(function.getDbName().toUpperCase(), function.getFunctionName().toUpperCase());
        Assert.assertEquals((String)"Comparing functions", (Object)function, (Object)resultUpper);
        Function resultMix = this.client.getFunction("DeFaUlt", "tEsT_FuncTION_tO_FinD_1");
        Assert.assertEquals((String)"Comparing functions", (Object)function, (Object)resultMix);
    }

    @Test(expected=NoSuchObjectException.class)
    public void testGetFunctionNoSuchDatabase() throws Exception {
        Function function = this.testFunctions[1];
        this.client.getFunction("no_such_database", function.getFunctionName());
    }

    @Test(expected=NoSuchObjectException.class)
    public void testGetFunctionNoSuchFunction() throws Exception {
        Function function = this.testFunctions[1];
        this.client.getFunction(function.getDbName(), "no_such_function");
    }

    @Test(expected=NoSuchObjectException.class)
    public void testGetFunctionNoSuchFunctionInThisDatabase() throws Exception {
        Function function = this.testFunctions[1];
        this.client.getFunction(OTHER_DATABASE, function.getFunctionName());
    }

    @Test
    public void testGetFunctionNullDatabase() throws Exception {
        try {
            this.client.getFunction(null, OTHER_DATABASE);
            Assert.fail((String)"Expected an NullPointerException or MetaException to be thrown");
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (MetaException metaException) {
            // empty catch block
        }
    }

    @Test(expected=MetaException.class)
    public void testGetFunctionNullFunctionName() throws Exception {
        this.client.getFunction(DEFAULT_DATABASE, null);
    }

    @Test(expected=NoSuchObjectException.class)
    public void testDropFunctionNoSuchDatabase() throws Exception {
        Function function = this.testFunctions[1];
        this.client.dropFunction("no_such_database", function.getFunctionName());
    }

    @Test(expected=NoSuchObjectException.class)
    public void testDropFunctionNoSuchFunction() throws Exception {
        this.client.dropFunction(DEFAULT_DATABASE, "no_such_function");
    }

    @Test(expected=NoSuchObjectException.class)
    public void testDropFunctionNoSuchFunctionInThisDatabase() throws Exception {
        Function function = this.testFunctions[1];
        this.client.dropFunction(OTHER_DATABASE, function.getFunctionName());
    }

    @Test
    public void testDropFunctionNullDatabase() throws Exception {
        try {
            this.client.dropFunction(null, "no_such_function");
            Assert.fail((String)"Expected an NullPointerException or TTransportException to be thrown");
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (TTransportException tTransportException) {
            // empty catch block
        }
    }

    @Test
    public void testDropFunctionNullFunctionName() throws Exception {
        try {
            this.client.dropFunction(DEFAULT_DATABASE, null);
            Assert.fail((String)"Expected an NullPointerException or TTransportException to be thrown");
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (TTransportException tTransportException) {
            // empty catch block
        }
    }

    @Test
    public void testDropFunctionCaseInsensitive() throws Exception {
        Function function = this.testFunctions[0];
        this.client.dropFunction(function.getDbName().toUpperCase(), function.getFunctionName().toUpperCase());
        try {
            this.client.getFunction(function.getDbName(), function.getFunctionName());
            Assert.fail((String)"Expected a NoSuchObjectException to be thrown");
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
        this.client.createFunction(function);
        this.client.dropFunction("DeFaUlt", "tEsT_FuncTION_tO_FinD_1");
        try {
            this.client.getFunction(function.getDbName(), function.getFunctionName());
            Assert.fail((String)"Expected a NoSuchObjectException to be thrown");
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
    }

    @Test
    public void testGetAllFunctions() throws Exception {
        GetAllFunctionsResponse response = this.client.getAllFunctions();
        List allFunctions = response.getFunctions();
        Assert.assertEquals((String)"All functions size", (long)4L, (long)allFunctions.size());
        for (Function function : allFunctions) {
            if (function.getDbName().equals(OTHER_DATABASE)) {
                Assert.assertEquals((String)"Comparing functions", (Object)this.testFunctions[3], (Object)function);
                continue;
            }
            if (function.getFunctionName().equals("test_function_hidden_1")) {
                Assert.assertEquals((String)"Comparing functions", (Object)this.testFunctions[2], (Object)function);
                continue;
            }
            if (function.getFunctionName().equals("test_function_to_find_2")) {
                Assert.assertEquals((String)"Comparing functions", (Object)this.testFunctions[1], (Object)function);
                continue;
            }
            Assert.assertEquals((String)"Comparing functions", (Object)this.testFunctions[0], (Object)function);
        }
        this.client.dropFunction(this.testFunctions[1].getDbName(), this.testFunctions[1].getFunctionName());
        response = this.client.getAllFunctions();
        allFunctions = response.getFunctions();
        Assert.assertEquals((String)"All functions size", (long)3L, (long)allFunctions.size());
        for (Function function : allFunctions) {
            if (function.getDbName().equals(OTHER_DATABASE)) {
                Assert.assertEquals((String)"Comparing functions", (Object)this.testFunctions[3], (Object)function);
                continue;
            }
            if (function.getFunctionName().equals("test_function_hidden_1")) {
                Assert.assertEquals((String)"Comparing functions", (Object)this.testFunctions[2], (Object)function);
                continue;
            }
            Assert.assertEquals((String)"Comparing functions", (Object)this.testFunctions[0], (Object)function);
        }
    }

    @Test
    public void testGetFunctions() throws Exception {
        List functions = this.client.getFunctions(DEFAULT_DATABASE, "*_to_find_*");
        Assert.assertEquals((String)"Found functions size", (long)2L, (long)functions.size());
        Assert.assertTrue((String)"Should contain", (boolean)functions.contains("test_function_to_find_1"));
        Assert.assertTrue((String)"Should contain", (boolean)functions.contains("test_function_to_find_2"));
        functions = this.client.getFunctions(DEFAULT_DATABASE, "*_to_find_*|*_hidden_*");
        Assert.assertEquals((String)"Found functions size", (long)3L, (long)functions.size());
        Assert.assertTrue((String)"Should contain", (boolean)functions.contains("test_function_to_find_1"));
        Assert.assertTrue((String)"Should contain", (boolean)functions.contains("test_function_to_find_2"));
        Assert.assertTrue((String)"Should contain", (boolean)functions.contains("test_function_hidden_1"));
        functions = this.client.getFunctions(OTHER_DATABASE, "*_to_find_*");
        Assert.assertEquals((String)"Found functions size", (long)1L, (long)functions.size());
        Assert.assertTrue((String)"Should contain", (boolean)functions.contains("test_function_to_find_1"));
        functions = this.client.getFunctions(DEFAULT_DATABASE, "*_not_such_function_*");
        Assert.assertEquals((String)"No such functions size", (long)0L, (long)functions.size());
        functions = this.client.getFunctions(DEFAULT_DATABASE, null);
        Assert.assertEquals((String)"Search functions without pattern size", (long)3L, (long)functions.size());
        functions = this.client.getFunctions(DEFAULT_DATABASE, "");
        Assert.assertEquals((String)"Search functions with empty pattern", (long)0L, (long)functions.size());
        functions = this.client.getFunctions("no_such_database", "*_to_find_*");
        Assert.assertEquals((String)"No such functions size", (long)0L, (long)functions.size());
    }

    @Test
    public void testGetFunctionsCaseInsensitive() throws Exception {
        List functions = this.client.getFunctions("deFAulT", "*_tO_FiND*");
        Assert.assertEquals((String)"Found functions size", (long)2L, (long)functions.size());
        Assert.assertTrue((String)"Should contain", (boolean)functions.contains("test_function_to_find_1"));
        Assert.assertTrue((String)"Should contain", (boolean)functions.contains("test_function_to_find_2"));
    }

    @Test(expected=MetaException.class)
    public void testGetFunctionsNullDatabase() throws Exception {
        this.client.getFunctions(null, OTHER_DATABASE);
    }

    @Test
    public void testAlterFunction() throws Exception {
        Function newFunction = new FunctionBuilder().setDbName(OTHER_DATABASE).setName("test_function_2").setOwner("Owner2").setOwnerType(PrincipalType.GROUP).setClass("org.apache.hadoop.hive.ql.udf.generic.GenericUDFUpper2").setFunctionType(FunctionType.JAVA).build(this.metaStore.getConf());
        this.client.alterFunction(this.testFunctions[0].getDbName(), this.testFunctions[0].getFunctionName(), newFunction);
        Function alteredFunction = this.client.getFunction(newFunction.getDbName(), newFunction.getFunctionName());
        Assert.assertEquals((String)"Comparing Database", (Object)newFunction.getDbName(), (Object)alteredFunction.getDbName());
        Assert.assertEquals((String)"Comparing FunctionName", (Object)newFunction.getFunctionName(), (Object)alteredFunction.getFunctionName());
        Assert.assertEquals((String)"Comparing OwnerName", (Object)newFunction.getOwnerName(), (Object)alteredFunction.getOwnerName());
        Assert.assertEquals((String)"Comparing OwnerType", (Object)newFunction.getOwnerType(), (Object)alteredFunction.getOwnerType());
        Assert.assertEquals((String)"Comparing ClassName", (Object)newFunction.getClassName(), (Object)alteredFunction.getClassName());
        Assert.assertEquals((String)"Comparing FunctionType", (Object)newFunction.getFunctionType(), (Object)alteredFunction.getFunctionType());
        try {
            this.client.getFunction(this.testFunctions[0].getDbName(), this.testFunctions[0].getDbName());
            Assert.fail((String)"Expected a NoSuchObjectException to be thrown");
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
        newFunction = this.testFunctions[1].deepCopy();
        newFunction.setClassName("NewClassName");
        this.client.alterFunction(this.testFunctions[1].getDbName(), this.testFunctions[1].getFunctionName(), newFunction);
        alteredFunction = this.client.getFunction(newFunction.getDbName(), newFunction.getFunctionName());
        Assert.assertEquals((String)"Comparing functions", (Object)newFunction, (Object)alteredFunction);
    }

    private Function getNewFunction() throws MetaException {
        return new FunctionBuilder().setName("test_function_2").setClass(TEST_FUNCTION_CLASS).build(this.metaStore.getConf());
    }

    @Test(expected=MetaException.class)
    public void testAlterFunctionNoSuchDatabase() throws Exception {
        Function originalFunction = this.testFunctions[1];
        Function newFunction = this.getNewFunction();
        this.client.alterFunction("no_such_database", originalFunction.getFunctionName(), newFunction);
    }

    @Test(expected=MetaException.class)
    public void testAlterFunctionNoSuchFunction() throws Exception {
        Function originalFunction = this.testFunctions[1];
        Function newFunction = this.getNewFunction();
        this.client.alterFunction(originalFunction.getDbName(), "no_such_function", newFunction);
    }

    @Test(expected=MetaException.class)
    public void testAlterFunctionNoSuchFunctionInThisDatabase() throws Exception {
        Function originalFunction = this.testFunctions[1];
        Function newFunction = this.getNewFunction();
        this.client.alterFunction(OTHER_DATABASE, originalFunction.getFunctionName(), newFunction);
    }

    @Test
    public void testAlterFunctionNullDatabase() throws Exception {
        Function newFunction = this.getNewFunction();
        try {
            this.client.alterFunction(null, OTHER_DATABASE, newFunction);
            Assert.fail((String)"Expected an NullPointerException or TTransportException to be thrown");
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (TTransportException tTransportException) {
            // empty catch block
        }
    }

    @Test
    public void testAlterFunctionNullFunctionName() throws Exception {
        Function newFunction = this.getNewFunction();
        try {
            this.client.alterFunction(DEFAULT_DATABASE, null, newFunction);
            Assert.fail((String)"Expected an NullPointerException or TTransportException to be thrown");
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (TTransportException tTransportException) {
            // empty catch block
        }
    }

    @Test
    public void testAlterFunctionNullFunction() throws Exception {
        Function originalFunction = this.testFunctions[1];
        try {
            this.client.alterFunction(DEFAULT_DATABASE, originalFunction.getFunctionName(), null);
            Assert.fail((String)"Expected an NullPointerException or TTransportException to be thrown");
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (TTransportException tTransportException) {
            // empty catch block
        }
    }

    @Test
    public void testAlterFunctionInvalidNameInNew() throws Exception {
        Function newFunction = this.getNewFunction();
        newFunction.setFunctionName("test_function_2;");
        try {
            this.client.alterFunction(DEFAULT_DATABASE, "test_function_to_find_2", newFunction);
            Assert.fail((String)"Expected an InvalidObjectException or TApplicationException to be thrown");
        }
        catch (InvalidObjectException invalidObjectException) {
        }
        catch (TApplicationException tApplicationException) {
            // empty catch block
        }
    }

    @Test
    public void testAlterFunctionEmptyNameInNew() throws Exception {
        Function newFunction = this.getNewFunction();
        newFunction.setFunctionName("");
        try {
            this.client.alterFunction(DEFAULT_DATABASE, "test_function_to_find_2", newFunction);
            Assert.fail((String)"Expected an InvalidObjectException or TApplicationException to be thrown");
        }
        catch (InvalidObjectException invalidObjectException) {
        }
        catch (TApplicationException tApplicationException) {
            // empty catch block
        }
    }

    @Test
    public void testAlterFunctionNullClassInNew() throws Exception {
        Function newFunction = this.getNewFunction();
        newFunction.setClassName(null);
        try {
            this.client.alterFunction(DEFAULT_DATABASE, "test_function_to_find_2", newFunction);
            Assert.fail((String)"Expected an InvalidObjectException or TApplicationException to be thrown");
        }
        catch (InvalidObjectException invalidObjectException) {
        }
        catch (TApplicationException tApplicationException) {
            // empty catch block
        }
    }

    @Test
    public void testAlterFunctionNullFunctionNameInNew() throws Exception {
        Function newFunction = this.getNewFunction();
        newFunction.setFunctionName(null);
        try {
            this.client.alterFunction(DEFAULT_DATABASE, "test_function_to_find_2", newFunction);
            Assert.fail((String)"Expected an NullPointerException or TTransportException to be thrown");
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (TTransportException tTransportException) {
            // empty catch block
        }
    }

    @Test
    public void testAlterFunctionNullDatabaseNameInNew() throws Exception {
        Function newFunction = this.getNewFunction();
        newFunction.setDbName(null);
        try {
            this.client.alterFunction(DEFAULT_DATABASE, "test_function_to_find_2", newFunction);
            Assert.fail((String)"Expected an NullPointerException or TTransportException to be thrown");
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (TTransportException tTransportException) {
            // empty catch block
        }
    }

    @Test
    public void testAlterFunctionNullOwnerTypeInNew() throws Exception {
        Function newFunction = this.getNewFunction();
        newFunction.setOwnerType(null);
        try {
            this.client.alterFunction(DEFAULT_DATABASE, "test_function_to_find_2", newFunction);
            Assert.fail((String)"Expected an NullPointerException or TTransportException to be thrown");
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (TTransportException tTransportException) {
            // empty catch block
        }
    }

    @Test
    public void testAlterFunctionNullFunctionTypeInNew() throws Exception {
        Function newFunction = this.getNewFunction();
        newFunction.setFunctionType(null);
        try {
            this.client.alterFunction(DEFAULT_DATABASE, "test_function_to_find_2", newFunction);
            Assert.fail((String)"Expected an NullPointerException or TTransportException to be thrown");
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (TTransportException tTransportException) {
            // empty catch block
        }
    }

    @Test
    public void testAlterFunctionNoSuchDatabaseInNew() throws Exception {
        Function newFunction = this.getNewFunction();
        newFunction.setDbName("no_such_database");
        try {
            this.client.alterFunction(DEFAULT_DATABASE, "test_function_to_find_2", newFunction);
            Assert.fail((String)"Expected an InvalidObjectException or TApplicationException to be thrown");
        }
        catch (InvalidObjectException exception) {
            exception.printStackTrace();
        }
        catch (TApplicationException exception) {
            exception.printStackTrace();
        }
    }

    @Test(expected=MetaException.class)
    public void testAlterFunctionAlreadyExists() throws Exception {
        Function originalFunction = this.testFunctions[0];
        Function newFunction = this.testFunctions[1];
        this.client.alterFunction(originalFunction.getDbName(), originalFunction.getFunctionName(), newFunction);
    }

    @Test
    public void testAlterFunctionCaseInsensitive() throws Exception {
        Function newFunction = new FunctionBuilder().setDbName(OTHER_DATABASE).setName("test_function_2").setClass(TEST_FUNCTION_CLASS).build(this.metaStore.getConf());
        Function originalFunction = this.testFunctions[1];
        this.client.alterFunction(originalFunction.getDbName().toUpperCase(), originalFunction.getFunctionName().toUpperCase(), newFunction);
        Function alteredFunction = this.client.getFunction(newFunction.getDbName(), newFunction.getFunctionName());
        newFunction.setCreateTime(alteredFunction.getCreateTime());
        Assert.assertEquals((String)"Comparing functions", (Object)newFunction, (Object)alteredFunction);
        try {
            this.client.getFunction(originalFunction.getDbName(), originalFunction.getDbName());
            Assert.fail((String)"Expected a NoSuchObjectException to be thrown");
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
        originalFunction = this.testFunctions[2];
        newFunction.setFunctionName("test_function_3");
        this.client.alterFunction("DeFaUlt", "tEsT_FuncTION_HiDDEn_1", newFunction);
        alteredFunction = this.client.getFunction(newFunction.getDbName(), newFunction.getFunctionName());
        newFunction.setCreateTime(alteredFunction.getCreateTime());
        Assert.assertEquals((String)"Comparing functions", (Object)newFunction, (Object)alteredFunction);
        try {
            this.client.getFunction(originalFunction.getDbName(), originalFunction.getDbName());
            Assert.fail((String)"Expected a NoSuchObjectException to be thrown");
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
    }

    @Test
    public void otherCatalog() throws TException {
        String catName = "functions_catalog";
        Catalog cat = new CatalogBuilder().setName(catName).setLocation(MetaStoreTestUtils.getTestWarehouseDir(catName)).build();
        this.client.createCatalog(cat);
        String dbName = "functions_other_catalog_db";
        Database db = new DatabaseBuilder().setCatalogName(catName).setName(dbName).create(this.client, this.metaStore.getConf());
        String functionName = "test_function";
        Function function = new FunctionBuilder().inDb(db).setName(functionName).setClass(TEST_FUNCTION_CLASS).setFunctionType(FunctionType.JAVA).setOwnerType(PrincipalType.ROLE).setOwner("owner").setCreateTime(100).addResourceUri(new ResourceUri(ResourceType.JAR, "hdfs:///tmp/jar1.jar")).addResourceUri(new ResourceUri(ResourceType.FILE, "hdfs:///tmp/file1.txt")).addResourceUri(new ResourceUri(ResourceType.ARCHIVE, "hdfs:///tmp/archive1.tgz")).create(this.client, this.metaStore.getConf());
        Function createdFunction = this.client.getFunction(catName, dbName, functionName);
        function.setCreateTime(createdFunction.getCreateTime());
        Assert.assertEquals((String)"Comparing functions", (Object)function, (Object)createdFunction);
        String f2Name = "testy_function2";
        Function f2 = new FunctionBuilder().inDb(db).setName(f2Name).setClass(TEST_FUNCTION_CLASS).create(this.client, this.metaStore.getConf());
        HashSet functions = new HashSet(this.client.getFunctions(catName, dbName, "test*"));
        Assert.assertEquals((long)2L, (long)functions.size());
        Assert.assertTrue((boolean)functions.contains(functionName));
        Assert.assertTrue((boolean)functions.contains(f2Name));
        functions = new HashSet(this.client.getFunctions(catName, dbName, "test_*"));
        Assert.assertEquals((long)1L, (long)functions.size());
        Assert.assertTrue((boolean)functions.contains(functionName));
        Assert.assertFalse((boolean)functions.contains(f2Name));
        this.client.dropFunction(function.getCatName(), function.getDbName(), function.getFunctionName());
        try {
            this.client.getFunction(function.getCatName(), function.getDbName(), function.getFunctionName());
            Assert.fail((String)"Expected a NoSuchObjectException to be thrown");
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
    }

    @Test(expected=NoSuchObjectException.class)
    public void addNoSuchCatalog() throws TException {
        String functionName = "test_function";
        new FunctionBuilder().setName(functionName).setCatName("nosuch").setDbName(DEFAULT_DATABASE).setClass(TEST_FUNCTION_CLASS).setFunctionType(FunctionType.JAVA).setOwnerType(PrincipalType.ROLE).setOwner("owner").setCreateTime(100).addResourceUri(new ResourceUri(ResourceType.JAR, "hdfs:///tmp/jar1.jar")).addResourceUri(new ResourceUri(ResourceType.FILE, "hdfs:///tmp/file1.txt")).addResourceUri(new ResourceUri(ResourceType.ARCHIVE, "hdfs:///tmp/archive1.tgz")).create(this.client, this.metaStore.getConf());
    }

    @Test(expected=NoSuchObjectException.class)
    public void getNoSuchCatalog() throws TException {
        this.client.getFunction("nosuch", DEFAULT_DATABASE, this.testFunctions[0].getFunctionName());
    }

    @Test(expected=NoSuchObjectException.class)
    public void dropNoSuchCatalog() throws TException {
        this.client.dropFunction("nosuch", DEFAULT_DATABASE, this.testFunctions[0].getFunctionName());
    }

    @Test
    public void getFunctionsNoSuchCatalog() throws TException {
        List functionNames = this.client.getFunctions("nosuch", DEFAULT_DATABASE, "*");
        Assert.assertEquals((long)0L, (long)functionNames.size());
    }
}

