/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.DummyMetaStoreInitListener;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hadoop.hive.metastore.annotation.MetastoreCheckinTest;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.security.HadoopThriftAuthBridge;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MetastoreCheckinTest.class})
public class TestMetaStoreInitListener {
    private Configuration conf;

    @Before
    public void setUp() throws Exception {
        System.setProperty("hive.metastore.init.hooks", DummyMetaStoreInitListener.class.getName());
        this.conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setLongVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.THRIFT_CONNECTION_RETRIES, (long)3L);
        MetastoreConf.setBoolVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_SUPPORT_CONCURRENCY, (boolean)false);
        MetaStoreTestUtils.setConfForStandloneMode(this.conf);
        MetaStoreTestUtils.startMetaStoreWithRetry(HadoopThriftAuthBridge.getBridge(), this.conf);
    }

    @Test
    public void testMetaStoreInitListener() throws Exception {
        Assert.assertTrue((boolean)DummyMetaStoreInitListener.wasCalled);
    }
}

