/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.DummyEndFunctionListener;
import org.apache.hadoop.hive.metastore.DummyListener;
import org.apache.hadoop.hive.metastore.DummyPreListener;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreEndFunctionContext;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.client.builder.DatabaseBuilder;
import org.apache.hadoop.hive.metastore.client.builder.TableBuilder;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.security.HadoopThriftAuthBridge;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MetastoreUnitTest.class})
public class TestMetaStoreEndFunctionListener {
    private Configuration conf;
    private HiveMetaStoreClient msc;

    @Before
    public void setUp() throws Exception {
        System.setProperty("hive.metastore.event.listeners", DummyListener.class.getName());
        System.setProperty("hive.metastore.pre.event.listeners", DummyPreListener.class.getName());
        System.setProperty("hive.metastore.end.function.listeners", DummyEndFunctionListener.class.getName());
        this.conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setLongVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.THRIFT_CONNECTION_RETRIES, (long)3L);
        MetastoreConf.setBoolVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_SUPPORT_CONCURRENCY, (boolean)false);
        MetaStoreTestUtils.setConfForStandloneMode(this.conf);
        MetaStoreTestUtils.startMetaStoreWithRetry(HadoopThriftAuthBridge.getBridge(), this.conf);
        this.msc = new HiveMetaStoreClient(this.conf);
    }

    @Test
    public void testEndFunctionListener() throws Exception {
        String dbName = "hive3524";
        String tblName = "tmptbl";
        Database db = new DatabaseBuilder().setName(dbName).setCatalogName("hive").create((IMetaStoreClient)this.msc, this.conf);
        try {
            this.msc.getDatabase("UnknownDB");
        }
        catch (Exception exception) {
            // empty catch block
        }
        int listSize = DummyEndFunctionListener.funcNameList.size();
        String func_name = DummyEndFunctionListener.funcNameList.get(listSize - 1);
        MetaStoreEndFunctionContext context = DummyEndFunctionListener.contextList.get(listSize - 1);
        Assert.assertEquals((Object)func_name, (Object)"get_database");
        Assert.assertFalse((boolean)context.isSuccess());
        Exception e = context.getException();
        Assert.assertTrue((e != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(e instanceof NoSuchObjectException));
        Assert.assertEquals((Object)context.getInputTableName(), null);
        String unknownTable = "UnknownTable";
        ((TableBuilder)new TableBuilder().inDb(db).setTableName(tblName).addCol("a", "string")).addPartCol("b", "string").create((IMetaStoreClient)this.msc, this.conf);
        try {
            this.msc.getTable(dbName, unknownTable);
        }
        catch (Exception exception) {
            // empty catch block
        }
        listSize = DummyEndFunctionListener.funcNameList.size();
        func_name = DummyEndFunctionListener.funcNameList.get(listSize - 1);
        context = DummyEndFunctionListener.contextList.get(listSize - 1);
        Assert.assertEquals((Object)func_name, (Object)"get_table");
        Assert.assertFalse((boolean)context.isSuccess());
        e = context.getException();
        Assert.assertTrue((e != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(e instanceof NoSuchObjectException));
        Assert.assertEquals((Object)context.getInputTableName(), (Object)unknownTable);
        try {
            this.msc.getPartition("hive3524", tblName, "b=2012");
        }
        catch (Exception exception) {
            // empty catch block
        }
        listSize = DummyEndFunctionListener.funcNameList.size();
        func_name = DummyEndFunctionListener.funcNameList.get(listSize - 1);
        context = DummyEndFunctionListener.contextList.get(listSize - 1);
        Assert.assertEquals((Object)func_name, (Object)"get_partition_by_name");
        Assert.assertFalse((boolean)context.isSuccess());
        e = context.getException();
        Assert.assertTrue((e != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(e instanceof NoSuchObjectException));
        Assert.assertEquals((Object)context.getInputTableName(), (Object)tblName);
        try {
            this.msc.dropTable(dbName, unknownTable);
        }
        catch (Exception exception) {
            // empty catch block
        }
        listSize = DummyEndFunctionListener.funcNameList.size();
        func_name = DummyEndFunctionListener.funcNameList.get(listSize - 1);
        context = DummyEndFunctionListener.contextList.get(listSize - 1);
        Assert.assertEquals((Object)func_name, (Object)"get_table");
        Assert.assertFalse((boolean)context.isSuccess());
        e = context.getException();
        Assert.assertTrue((e != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(e instanceof NoSuchObjectException));
        Assert.assertEquals((Object)context.getInputTableName(), (Object)"UnknownTable");
    }
}

