/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.net.InetAddress;
import java.util.List;
import org.apache.hadoop.hive.metastore.LockRequestBuilder;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.apache.hadoop.hive.metastore.api.LockComponent;
import org.apache.hadoop.hive.metastore.api.LockLevel;
import org.apache.hadoop.hive.metastore.api.LockRequest;
import org.apache.hadoop.hive.metastore.api.LockType;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MetastoreUnitTest.class})
public class TestLockRequestBuilder {
    @Test
    public void noUser() {
        LockRequestBuilder bldr = new LockRequestBuilder();
        LockComponent comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        bldr.addLockComponent(comp);
        comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        bldr.addLockComponent(comp);
        boolean caughtException = false;
        try {
            LockRequest lockRequest = bldr.build();
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)"Cannot build a lock without giving a user", (Object)e.getMessage());
            caughtException = true;
        }
        Assert.assertTrue((boolean)caughtException);
    }

    @Test
    public void testDbTable() throws Exception {
        LockRequestBuilder bldr = new LockRequestBuilder();
        LockComponent comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        bldr.addLockComponent(comp).setUser("fred");
        comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        bldr.addLockComponent(comp);
        LockRequest req = bldr.build();
        List locks = req.getComponent();
        Assert.assertEquals((long)2L, (long)locks.size());
        Assert.assertEquals((Object)"fred", (Object)req.getUser());
        Assert.assertEquals((Object)InetAddress.getLocalHost().getHostName(), (Object)req.getHostname());
    }

    @Test
    public void testTablePartition() {
        LockRequestBuilder bldr = new LockRequestBuilder();
        LockComponent comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        bldr.addLockComponent(comp).setUser(null);
        comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypartition");
        bldr.addLockComponent(comp);
        LockRequest req = bldr.build();
        List locks = req.getComponent();
        Assert.assertEquals((long)2L, (long)locks.size());
        Assert.assertEquals((Object)"unknown", (Object)req.getUser());
    }

    @Test
    public void testTwoSeparateDbs() {
        LockRequestBuilder bldr = new LockRequestBuilder();
        LockComponent comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        bldr.addLockComponent(comp).setUser("fred");
        comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "yourdb");
        bldr.addLockComponent(comp);
        LockRequest req = bldr.build();
        List locks = req.getComponent();
        Assert.assertEquals((long)2L, (long)locks.size());
    }

    @Test
    public void testExExDb() {
        LockRequestBuilder bldr = new LockRequestBuilder();
        LockComponent comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        bldr.addLockComponent(comp);
        comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        bldr.addLockComponent(comp).setUser("fred");
        LockRequest req = bldr.build();
        List locks = req.getComponent();
        Assert.assertEquals((long)1L, (long)locks.size());
    }

    @Test
    public void testExSWDb() {
        LockRequestBuilder bldr = new LockRequestBuilder();
        LockComponent comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        bldr.addLockComponent(comp).setUser("fred");
        comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.DB, "mydb");
        bldr.addLockComponent(comp);
        LockRequest req = bldr.build();
        List locks = req.getComponent();
        Assert.assertEquals((long)1L, (long)locks.size());
        Assert.assertEquals((Object)LockType.EXCLUSIVE, (Object)((LockComponent)locks.get(0)).getType());
    }

    @Test
    public void testExSRDb() {
        LockRequestBuilder bldr = new LockRequestBuilder();
        LockComponent comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        bldr.addLockComponent(comp).setUser("fred");
        comp = new LockComponent(LockType.SHARED_READ, LockLevel.DB, "mydb");
        bldr.addLockComponent(comp);
        LockRequest req = bldr.build();
        List locks = req.getComponent();
        Assert.assertEquals((long)1L, (long)locks.size());
        Assert.assertEquals((Object)LockType.EXCLUSIVE, (Object)((LockComponent)locks.get(0)).getType());
    }

    @Test
    public void testSWExDb() {
        LockRequestBuilder bldr = new LockRequestBuilder();
        LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.DB, "mydb");
        bldr.addLockComponent(comp);
        comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        bldr.addLockComponent(comp).setUser("fred");
        LockRequest req = bldr.build();
        List locks = req.getComponent();
        Assert.assertEquals((long)1L, (long)locks.size());
        Assert.assertEquals((Object)LockType.EXCLUSIVE, (Object)((LockComponent)locks.get(0)).getType());
    }

    @Test
    public void testSWSWDb() {
        LockRequestBuilder bldr = new LockRequestBuilder();
        LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.DB, "mydb");
        bldr.addLockComponent(comp);
        comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.DB, "mydb");
        bldr.addLockComponent(comp).setUser("fred");
        LockRequest req = bldr.build();
        List locks = req.getComponent();
        Assert.assertEquals((long)1L, (long)locks.size());
        Assert.assertEquals((Object)LockType.SHARED_WRITE, (Object)((LockComponent)locks.get(0)).getType());
    }

    @Test
    public void testSWSRDb() {
        LockRequestBuilder bldr = new LockRequestBuilder();
        LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.DB, "mydb");
        bldr.addLockComponent(comp);
        comp = new LockComponent(LockType.SHARED_READ, LockLevel.DB, "mydb");
        bldr.addLockComponent(comp).setUser("fred");
        LockRequest req = bldr.build();
        List locks = req.getComponent();
        Assert.assertEquals((long)1L, (long)locks.size());
        Assert.assertEquals((Object)LockType.SHARED_WRITE, (Object)((LockComponent)locks.get(0)).getType());
    }

    @Test
    public void testSRExDb() {
        LockRequestBuilder bldr = new LockRequestBuilder();
        LockComponent comp = new LockComponent(LockType.SHARED_READ, LockLevel.DB, "mydb");
        bldr.addLockComponent(comp);
        comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        bldr.addLockComponent(comp).setUser("fred");
        LockRequest req = bldr.build();
        List locks = req.getComponent();
        Assert.assertEquals((long)1L, (long)locks.size());
        Assert.assertEquals((Object)LockType.EXCLUSIVE, (Object)((LockComponent)locks.get(0)).getType());
    }

    @Test
    public void testSRSWDb() {
        LockRequestBuilder bldr = new LockRequestBuilder();
        LockComponent comp = new LockComponent(LockType.SHARED_READ, LockLevel.DB, "mydb");
        bldr.addLockComponent(comp);
        comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.DB, "mydb");
        bldr.addLockComponent(comp).setUser("fred");
        LockRequest req = bldr.build();
        List locks = req.getComponent();
        Assert.assertEquals((long)1L, (long)locks.size());
        Assert.assertEquals((Object)LockType.SHARED_WRITE, (Object)((LockComponent)locks.get(0)).getType());
    }

    @Test
    public void testSRSRDb() {
        LockRequestBuilder bldr = new LockRequestBuilder();
        LockComponent comp = new LockComponent(LockType.SHARED_READ, LockLevel.DB, "mydb");
        bldr.addLockComponent(comp);
        comp = new LockComponent(LockType.SHARED_READ, LockLevel.DB, "mydb");
        bldr.addLockComponent(comp).setUser("fred");
        LockRequest req = bldr.build();
        List locks = req.getComponent();
        Assert.assertEquals((long)1L, (long)locks.size());
        Assert.assertEquals((Object)LockType.SHARED_READ, (Object)((LockComponent)locks.get(0)).getType());
    }

    @Test
    public void testTwoSeparateTables() {
        LockRequestBuilder bldr = new LockRequestBuilder();
        LockComponent comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        bldr.addLockComponent(comp);
        comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setTablename("yourtable");
        bldr.addLockComponent(comp).setUser("fred");
        LockRequest req = bldr.build();
        List locks = req.getComponent();
        Assert.assertEquals((long)2L, (long)locks.size());
    }

    @Test
    public void testExExTable() {
        LockRequestBuilder bldr = new LockRequestBuilder();
        LockComponent comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        bldr.addLockComponent(comp);
        comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        bldr.addLockComponent(comp).setUser("fred");
        LockRequest req = bldr.build();
        List locks = req.getComponent();
        Assert.assertEquals((long)1L, (long)locks.size());
    }

    @Test
    public void testExSWTable() {
        LockRequestBuilder bldr = new LockRequestBuilder();
        LockComponent comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        bldr.addLockComponent(comp);
        comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        bldr.addLockComponent(comp).setUser("fred");
        LockRequest req = bldr.build();
        List locks = req.getComponent();
        Assert.assertEquals((long)1L, (long)locks.size());
        Assert.assertEquals((Object)LockType.EXCLUSIVE, (Object)((LockComponent)locks.get(0)).getType());
    }

    @Test
    public void testExSRTable() {
        LockRequestBuilder bldr = new LockRequestBuilder();
        LockComponent comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        bldr.addLockComponent(comp);
        comp = new LockComponent(LockType.SHARED_READ, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        bldr.addLockComponent(comp).setUser("fred");
        LockRequest req = bldr.build();
        List locks = req.getComponent();
        Assert.assertEquals((long)1L, (long)locks.size());
        Assert.assertEquals((Object)LockType.EXCLUSIVE, (Object)((LockComponent)locks.get(0)).getType());
    }

    @Test
    public void testSWExTable() {
        LockRequestBuilder bldr = new LockRequestBuilder();
        LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        bldr.addLockComponent(comp);
        comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        bldr.addLockComponent(comp).setUser("fred");
        LockRequest req = bldr.build();
        List locks = req.getComponent();
        Assert.assertEquals((long)1L, (long)locks.size());
        Assert.assertEquals((Object)LockType.EXCLUSIVE, (Object)((LockComponent)locks.get(0)).getType());
    }

    @Test
    public void testSWSWTable() {
        LockRequestBuilder bldr = new LockRequestBuilder();
        LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        bldr.addLockComponent(comp);
        comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        bldr.addLockComponent(comp).setUser("fred");
        LockRequest req = bldr.build();
        List locks = req.getComponent();
        Assert.assertEquals((long)1L, (long)locks.size());
        Assert.assertEquals((Object)LockType.SHARED_WRITE, (Object)((LockComponent)locks.get(0)).getType());
    }

    @Test
    public void testSWSRTable() {
        LockRequestBuilder bldr = new LockRequestBuilder();
        LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        bldr.addLockComponent(comp);
        comp = new LockComponent(LockType.SHARED_READ, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        bldr.addLockComponent(comp).setUser("fred");
        LockRequest req = bldr.build();
        List locks = req.getComponent();
        Assert.assertEquals((long)1L, (long)locks.size());
        Assert.assertEquals((Object)LockType.SHARED_WRITE, (Object)((LockComponent)locks.get(0)).getType());
    }

    @Test
    public void testSRExTable() {
        LockRequestBuilder bldr = new LockRequestBuilder();
        LockComponent comp = new LockComponent(LockType.SHARED_READ, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        bldr.addLockComponent(comp);
        comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        bldr.addLockComponent(comp).setUser("fred");
        LockRequest req = bldr.build();
        List locks = req.getComponent();
        Assert.assertEquals((long)1L, (long)locks.size());
        Assert.assertEquals((Object)LockType.EXCLUSIVE, (Object)((LockComponent)locks.get(0)).getType());
    }

    @Test
    public void testSRSWTable() {
        LockRequestBuilder bldr = new LockRequestBuilder();
        LockComponent comp = new LockComponent(LockType.SHARED_READ, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        bldr.addLockComponent(comp);
        comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        bldr.addLockComponent(comp).setUser("fred");
        LockRequest req = bldr.build();
        List locks = req.getComponent();
        Assert.assertEquals((long)1L, (long)locks.size());
        Assert.assertEquals((Object)LockType.SHARED_WRITE, (Object)((LockComponent)locks.get(0)).getType());
    }

    @Test
    public void testSRSRTable() {
        LockRequestBuilder bldr = new LockRequestBuilder();
        LockComponent comp = new LockComponent(LockType.SHARED_READ, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        bldr.addLockComponent(comp);
        comp = new LockComponent(LockType.SHARED_READ, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        bldr.addLockComponent(comp).setUser("fred");
        LockRequest req = bldr.build();
        List locks = req.getComponent();
        Assert.assertEquals((long)1L, (long)locks.size());
        Assert.assertEquals((Object)LockType.SHARED_READ, (Object)((LockComponent)locks.get(0)).getType());
    }

    @Test
    public void testTwoSeparatePartitions() {
        LockRequestBuilder bldr = new LockRequestBuilder();
        LockComponent comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypart");
        bldr.addLockComponent(comp);
        comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("yourpart");
        bldr.addLockComponent(comp).setUser("fred");
        LockRequest req = bldr.build();
        List locks = req.getComponent();
        Assert.assertEquals((long)2L, (long)locks.size());
    }

    @Test
    public void testExExPart() {
        LockRequestBuilder bldr = new LockRequestBuilder();
        LockComponent comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypart");
        bldr.addLockComponent(comp);
        comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypart");
        bldr.addLockComponent(comp).setUser("fred");
        LockRequest req = bldr.build();
        List locks = req.getComponent();
        Assert.assertEquals((long)1L, (long)locks.size());
    }

    @Test
    public void testExSWPart() {
        LockRequestBuilder bldr = new LockRequestBuilder();
        LockComponent comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypart");
        bldr.addLockComponent(comp);
        comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypart");
        bldr.addLockComponent(comp).setUser("fred");
        LockRequest req = bldr.build();
        List locks = req.getComponent();
        Assert.assertEquals((long)1L, (long)locks.size());
        Assert.assertEquals((Object)LockType.EXCLUSIVE, (Object)((LockComponent)locks.get(0)).getType());
    }

    @Test
    public void testExSRPart() {
        LockRequestBuilder bldr = new LockRequestBuilder();
        LockComponent comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypart");
        bldr.addLockComponent(comp);
        comp = new LockComponent(LockType.SHARED_READ, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypart");
        bldr.addLockComponent(comp).setUser("fred");
        LockRequest req = bldr.build();
        List locks = req.getComponent();
        Assert.assertEquals((long)1L, (long)locks.size());
        Assert.assertEquals((Object)LockType.EXCLUSIVE, (Object)((LockComponent)locks.get(0)).getType());
    }

    @Test
    public void testSWExPart() {
        LockRequestBuilder bldr = new LockRequestBuilder();
        LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypart");
        bldr.addLockComponent(comp);
        comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypart");
        bldr.addLockComponent(comp).setUser("fred");
        LockRequest req = bldr.build();
        List locks = req.getComponent();
        Assert.assertEquals((long)1L, (long)locks.size());
        Assert.assertEquals((Object)LockType.EXCLUSIVE, (Object)((LockComponent)locks.get(0)).getType());
    }

    @Test
    public void testSWSWPart() {
        LockRequestBuilder bldr = new LockRequestBuilder();
        LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypart");
        bldr.addLockComponent(comp);
        comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypart");
        bldr.addLockComponent(comp).setUser("fred");
        LockRequest req = bldr.build();
        List locks = req.getComponent();
        Assert.assertEquals((long)1L, (long)locks.size());
        Assert.assertEquals((Object)LockType.SHARED_WRITE, (Object)((LockComponent)locks.get(0)).getType());
    }

    @Test
    public void testSWSRPart() {
        LockRequestBuilder bldr = new LockRequestBuilder();
        LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypart");
        bldr.addLockComponent(comp);
        comp = new LockComponent(LockType.SHARED_READ, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypart");
        bldr.addLockComponent(comp).setUser("fred");
        LockRequest req = bldr.build();
        List locks = req.getComponent();
        Assert.assertEquals((long)1L, (long)locks.size());
        Assert.assertEquals((Object)LockType.SHARED_WRITE, (Object)((LockComponent)locks.get(0)).getType());
    }

    @Test
    public void testSRExPart() {
        LockRequestBuilder bldr = new LockRequestBuilder();
        LockComponent comp = new LockComponent(LockType.SHARED_READ, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypart");
        bldr.addLockComponent(comp);
        comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypart");
        bldr.addLockComponent(comp).setUser("fred");
        LockRequest req = bldr.build();
        List locks = req.getComponent();
        Assert.assertEquals((long)1L, (long)locks.size());
        Assert.assertEquals((Object)LockType.EXCLUSIVE, (Object)((LockComponent)locks.get(0)).getType());
    }

    @Test
    public void testSRSWPart() {
        LockRequestBuilder bldr = new LockRequestBuilder();
        LockComponent comp = new LockComponent(LockType.SHARED_READ, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypart");
        bldr.addLockComponent(comp);
        comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypart");
        bldr.addLockComponent(comp).setUser("fred");
        LockRequest req = bldr.build();
        List locks = req.getComponent();
        Assert.assertEquals((long)1L, (long)locks.size());
        Assert.assertEquals((Object)LockType.SHARED_WRITE, (Object)((LockComponent)locks.get(0)).getType());
    }

    @Test
    public void testSRSRPart() {
        LockRequestBuilder bldr = new LockRequestBuilder();
        LockComponent comp = new LockComponent(LockType.SHARED_READ, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypart");
        bldr.addLockComponent(comp);
        comp = new LockComponent(LockType.SHARED_READ, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setPartitionname("mypart");
        bldr.addLockComponent(comp).setUser("fred");
        LockRequest req = bldr.build();
        List locks = req.getComponent();
        Assert.assertEquals((long)1L, (long)locks.size());
        Assert.assertEquals((Object)LockType.SHARED_READ, (Object)((LockComponent)locks.get(0)).getType());
    }
}

