/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.converters;

import java.time.DateTimeException;
import java.time.ZoneOffset;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.util.Localiser;

public class ZoneOffsetStringConverter
implements TypeConverter<ZoneOffset, String> {
    private static final long serialVersionUID = -6314756576149793428L;

    @Override
    public ZoneOffset toMemberType(String str) {
        if (str == null) {
            return null;
        }
        try {
            return ZoneOffset.of(str);
        }
        catch (DateTimeException dte) {
            throw new NucleusDataStoreException(Localiser.msg("016002", str, ZoneOffset.class.getName()), dte);
        }
    }

    @Override
    public String toDatastoreType(ZoneOffset offset) {
        return offset != null ? offset.toString() : null;
    }
}

