/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.enhancer;

import org.datanucleus.ClassConstants;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.enhancer.asm.MethodVisitor;
import org.datanucleus.enhancer.asm.Type;

public final class EnhanceUtils {
    public static final String ACN_boolean = ClassNameConstants.BOOLEAN;
    public static final String ACN_byte = ClassNameConstants.BYTE;
    public static final String ACN_char = ClassNameConstants.CHAR;
    public static final String ACN_double = ClassNameConstants.DOUBLE;
    public static final String ACN_float = ClassNameConstants.FLOAT;
    public static final String ACN_int = ClassNameConstants.INT;
    public static final String ACN_long = ClassNameConstants.LONG;
    public static final String ACN_short = ClassNameConstants.SHORT;
    public static final String ACN_Boolean = ClassNameConstants.JAVA_LANG_BOOLEAN.replace('.', '/');
    public static final String ACN_Byte = ClassNameConstants.JAVA_LANG_BYTE.replace('.', '/');
    public static final String ACN_Character = ClassNameConstants.JAVA_LANG_CHARACTER.replace('.', '/');
    public static final String ACN_Double = ClassNameConstants.JAVA_LANG_DOUBLE.replace('.', '/');
    public static final String ACN_Float = ClassNameConstants.JAVA_LANG_FLOAT.replace('.', '/');
    public static final String ACN_Integer = ClassNameConstants.JAVA_LANG_INTEGER.replace('.', '/');
    public static final String ACN_Long = ClassNameConstants.JAVA_LANG_LONG.replace('.', '/');
    public static final String ACN_Short = ClassNameConstants.JAVA_LANG_SHORT.replace('.', '/');
    public static final String ACN_String = ClassNameConstants.JAVA_LANG_STRING.replace('.', '/');
    public static final String ACN_Object = Object.class.getName().replace('.', '/');
    public static final String CD_String = Type.getDescriptor(String.class);
    public static final String CD_Object = Type.getDescriptor(Object.class);

    private EnhanceUtils() {
    }

    public static void addBIPUSHToMethod(MethodVisitor visitor, int i) {
        if (i < 6) {
            switch (i) {
                case 0: {
                    visitor.visitInsn(3);
                    break;
                }
                case 1: {
                    visitor.visitInsn(4);
                    break;
                }
                case 2: {
                    visitor.visitInsn(5);
                    break;
                }
                case 3: {
                    visitor.visitInsn(6);
                    break;
                }
                case 4: {
                    visitor.visitInsn(7);
                    break;
                }
                case 5: {
                    visitor.visitInsn(8);
                }
            }
        } else if (i < 127) {
            visitor.visitIntInsn(16, i);
        } else if (i < Short.MAX_VALUE) {
            visitor.visitIntInsn(17, i);
        }
    }

    public static void addReturnForType(MethodVisitor visitor, Class type) {
        if (type == Integer.TYPE || type == Boolean.TYPE || type == Byte.TYPE || type == Character.TYPE || type == Short.TYPE) {
            visitor.visitInsn(172);
        } else if (type == Double.TYPE) {
            visitor.visitInsn(175);
        } else if (type == Float.TYPE) {
            visitor.visitInsn(174);
        } else if (type == Long.TYPE) {
            visitor.visitInsn(173);
        } else {
            visitor.visitInsn(176);
        }
    }

    public static void addLoadForType(MethodVisitor visitor, Class type, int number) {
        if (type == Integer.TYPE || type == Boolean.TYPE || type == Byte.TYPE || type == Character.TYPE || type == Short.TYPE) {
            visitor.visitVarInsn(21, number);
        } else if (type == Double.TYPE) {
            visitor.visitVarInsn(24, number);
        } else if (type == Float.TYPE) {
            visitor.visitVarInsn(23, number);
        } else if (type == Long.TYPE) {
            visitor.visitVarInsn(22, number);
        } else {
            visitor.visitVarInsn(25, number);
        }
    }

    public static String getTypeNameForPersistableMethod(Class cls) {
        if (cls == null) {
            return null;
        }
        if (cls == ClassConstants.BOOLEAN) {
            return "Boolean";
        }
        if (cls == ClassConstants.BYTE) {
            return "Byte";
        }
        if (cls == ClassConstants.CHAR) {
            return "Char";
        }
        if (cls == ClassConstants.DOUBLE) {
            return "Double";
        }
        if (cls == ClassConstants.FLOAT) {
            return "Float";
        }
        if (cls == ClassConstants.INT) {
            return "Int";
        }
        if (cls == ClassConstants.LONG) {
            return "Long";
        }
        if (cls == ClassConstants.SHORT) {
            return "Short";
        }
        if (cls == ClassConstants.JAVA_LANG_STRING) {
            return "String";
        }
        return "Object";
    }

    public static String getTypeDescriptorForType(String clsName) {
        if (clsName == null) {
            return null;
        }
        if (clsName.equals(ClassNameConstants.BOOLEAN)) {
            return Type.BOOLEAN_TYPE.getDescriptor();
        }
        if (clsName.equals(ClassNameConstants.BYTE)) {
            return Type.BYTE_TYPE.getDescriptor();
        }
        if (clsName.equals(ClassNameConstants.CHAR)) {
            return Type.CHAR_TYPE.getDescriptor();
        }
        if (clsName.equals(ClassNameConstants.DOUBLE)) {
            return Type.DOUBLE_TYPE.getDescriptor();
        }
        if (clsName.equals(ClassNameConstants.FLOAT)) {
            return Type.FLOAT_TYPE.getDescriptor();
        }
        if (clsName.equals(ClassNameConstants.INT)) {
            return Type.INT_TYPE.getDescriptor();
        }
        if (clsName.equals(ClassNameConstants.LONG)) {
            return Type.LONG_TYPE.getDescriptor();
        }
        if (clsName.equals(ClassNameConstants.SHORT)) {
            return Type.SHORT_TYPE.getDescriptor();
        }
        if (clsName.equals(ClassNameConstants.JAVA_LANG_STRING)) {
            return CD_String;
        }
        return "L" + clsName.replace('.', '/') + ";";
    }

    public static String getTypeDescriptorForEnhanceMethod(Class cls) {
        if (cls == null) {
            return null;
        }
        if (cls == ClassConstants.BOOLEAN) {
            return Type.BOOLEAN_TYPE.getDescriptor();
        }
        if (cls == ClassConstants.BYTE) {
            return Type.BYTE_TYPE.getDescriptor();
        }
        if (cls == ClassConstants.CHAR) {
            return Type.CHAR_TYPE.getDescriptor();
        }
        if (cls == ClassConstants.DOUBLE) {
            return Type.DOUBLE_TYPE.getDescriptor();
        }
        if (cls == ClassConstants.FLOAT) {
            return Type.FLOAT_TYPE.getDescriptor();
        }
        if (cls == ClassConstants.INT) {
            return Type.INT_TYPE.getDescriptor();
        }
        if (cls == ClassConstants.LONG) {
            return Type.LONG_TYPE.getDescriptor();
        }
        if (cls == ClassConstants.SHORT) {
            return Type.SHORT_TYPE.getDescriptor();
        }
        if (cls == ClassConstants.JAVA_LANG_STRING) {
            return CD_String;
        }
        return CD_Object;
    }

    public static String getASMClassNameForSingleFieldIdentityConstructor(Class fieldType) {
        if (fieldType == null) {
            return null;
        }
        if (fieldType == ClassConstants.BYTE || fieldType == ClassConstants.JAVA_LANG_BYTE) {
            return ACN_Byte;
        }
        if (fieldType == ClassConstants.CHAR || fieldType == ClassConstants.JAVA_LANG_CHARACTER) {
            return ACN_Character;
        }
        if (fieldType == ClassConstants.INT || fieldType == ClassConstants.JAVA_LANG_INTEGER) {
            return ACN_Integer;
        }
        if (fieldType == ClassConstants.LONG || fieldType == ClassConstants.JAVA_LANG_LONG) {
            return ACN_Long;
        }
        if (fieldType == ClassConstants.SHORT || fieldType == ClassConstants.JAVA_LANG_SHORT) {
            return ACN_Short;
        }
        if (fieldType == ClassConstants.JAVA_LANG_STRING) {
            return ACN_String;
        }
        return ACN_Object;
    }

    public static int getAsmVersionForJRE() {
        return 51;
    }
}

