/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.scram;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.scram.CredentialCache;
import org.apache.hadoop.security.scram.ScramCredential;
import org.apache.hadoop.security.scram.ScramFormatter;
import org.apache.hadoop.security.scram.ScramMechanism;
import org.apache.hive.scram.NoScramAlgorithmException;
import org.apache.hive.scram.ScramPasswordException;
import org.apache.hive.scram.ScramUtil;

public final class CredentialCacheHelper {
    private static final Log LOG = LogFactory.getLog(CredentialCacheHelper.class);
    private static final char[] PASSWORD = CredentialCacheHelper.readPassword();
    private static final ScramFormatter SCRAM_FORMATTER = CredentialCacheHelper.createScramFormatter();
    private static final ScramCredential SCRAM_CREDENTIAL = CredentialCacheHelper.createScramCredential();
    private static final CredentialCache.Cache<ScramCredential> SCRAM_CACHE = CredentialCacheHelper.createScramCache();

    private CredentialCacheHelper() {
    }

    public static CredentialCache.Cache<ScramCredential> getScramCache() {
        return SCRAM_CACHE;
    }

    public static char[] getScramPassword() {
        return PASSWORD;
    }

    private static char[] readPassword() {
        try {
            Configuration conf = new Configuration();
            conf.addResource("scram/scram-site.xml");
            char[] password = conf.getPassword("scram.password");
            if (password == null) {
                throw new ScramPasswordException("Scram password is null. Check that scram credentials exist and configured");
            }
            return password;
        }
        catch (IOException e) {
            LOG.error((Object)"Error reading scram.password property");
            throw new ScramPasswordException(e);
        }
    }

    private static CredentialCache.Cache<ScramCredential> createScramCache() {
        LOG.info((Object)"Creating SCRAM-SHA-256 cache");
        CredentialCache credentialCache = new CredentialCache();
        credentialCache.createCache(ScramUtil.getScramMechanismName(), ScramCredential.class);
        return credentialCache.cache(ScramUtil.getScramMechanismName(), ScramCredential.class);
    }

    private static ScramCredential createScramCredential() {
        return SCRAM_FORMATTER.generateCredential(new String(CredentialCacheHelper.getScramPassword()), 4096);
    }

    public static void addUserToScramCache(String userName) {
        CredentialCacheHelper.getScramCache().put(userName, (Object)SCRAM_CREDENTIAL);
    }

    public static void removeUserFromScramCache(String userName) {
        CredentialCacheHelper.getScramCache().remove(userName);
    }

    private static ScramFormatter createScramFormatter() {
        try {
            return new ScramFormatter(ScramMechanism.SCRAM_SHA_256);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error((Object)String.format("Can't find %s algorithm.", ScramUtil.getScramMechanismName()));
            throw new NoScramAlgorithmException(e);
        }
    }
}

