/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.ndv.hll.HyperLogLog;
import org.apache.hadoop.hive.metastore.Deadline;
import org.apache.hadoop.hive.metastore.FileFormatProxy;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hadoop.hive.metastore.ObjectStore;
import org.apache.hadoop.hive.metastore.PartitionExpressionProxy;
import org.apache.hadoop.hive.metastore.RawStore;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.apache.hadoop.hive.metastore.api.AggrStats;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsDesc;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.FileMetadataExprType;
import org.apache.hadoop.hive.metastore.api.InvalidInputException;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.LongColumnStatsData;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.client.builder.DatabaseBuilder;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MetastoreUnitTest.class})
public class TestOldSchema {
    private ObjectStore store = null;
    private Configuration conf;
    private static final Logger LOG = LoggerFactory.getLogger((String)TestOldSchema.class.getName());
    private byte[][] bitVectors = new byte[2][];

    @Before
    public void setUp() throws Exception {
        this.conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setBoolVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.STATS_FETCH_BITVECTOR, (boolean)false);
        MetastoreConf.setBoolVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_IN_TEST, (boolean)true);
        MetaStoreTestUtils.setConfForStandloneMode(this.conf);
        this.store = new ObjectStore();
        this.store.setConf(this.conf);
        TestOldSchema.dropAllStoreObjects((RawStore)this.store);
        HiveMetaStore.HMSHandler.createDefaultCatalog((RawStore)this.store, (Warehouse)new Warehouse(this.conf));
        HyperLogLog hll = HyperLogLog.builder().build();
        hll.addLong(1L);
        this.bitVectors[1] = hll.serialize();
        hll = HyperLogLog.builder().build();
        hll.addLong(2L);
        hll.addLong(3L);
        hll.addLong(3L);
        hll.addLong(4L);
        this.bitVectors[0] = hll.serialize();
    }

    @After
    public void tearDown() {
    }

    @Ignore(value="HIVE-19509: Disable tests that are failing continuously")
    @Test
    public void testPartitionOps() throws Exception {
        String dbName = "default";
        String tableName = "snp";
        Database db1 = new DatabaseBuilder().setName(dbName).setDescription("description").setLocation("locationurl").build(this.conf);
        this.store.createDatabase(db1);
        long now = System.currentTimeMillis();
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
        cols.add(new FieldSchema("col1", "long", "nocomment"));
        SerDeInfo serde = new SerDeInfo("serde", "seriallib", null);
        StorageDescriptor sd = new StorageDescriptor(cols, "file:/tmp", "input", "output", false, 0, serde, null, null, Collections.emptyMap());
        ArrayList<FieldSchema> partCols = new ArrayList<FieldSchema>();
        partCols.add(new FieldSchema("ds", "string", ""));
        Table table = new Table(tableName, dbName, "me", (int)now, (int)now, 0, sd, partCols, Collections.emptyMap(), null, null, null);
        this.store.createTable(table);
        Deadline.startTimer((String)"getPartition");
        for (int i = 0; i < 10; ++i) {
            ArrayList<String> partVal = new ArrayList<String>();
            partVal.add(String.valueOf(i));
            StorageDescriptor psd = new StorageDescriptor(sd);
            psd.setLocation("file:/tmp/default/hit/ds=" + partVal);
            Partition part = new Partition(partVal, dbName, tableName, (int)now, (int)now, psd, Collections.emptyMap());
            part.setCatName("hive");
            this.store.addPartition(part);
            ColumnStatistics cs = new ColumnStatistics();
            ColumnStatisticsDesc desc = new ColumnStatisticsDesc(false, dbName, tableName);
            desc.setLastAnalyzed(now);
            desc.setPartName("ds=" + String.valueOf(i));
            cs.setStatsDesc(desc);
            ColumnStatisticsObj obj = new ColumnStatisticsObj();
            obj.setColName("col1");
            obj.setColType("bigint");
            ColumnStatisticsData data = new ColumnStatisticsData();
            LongColumnStatsData dcsd = new LongColumnStatsData();
            dcsd.setHighValue((long)(1000 + i));
            dcsd.setLowValue((long)(-1000 - i));
            dcsd.setNumNulls((long)i);
            dcsd.setNumDVs((long)(10 * i + 1));
            dcsd.setBitVectors(this.bitVectors[0]);
            data.setLongStats(dcsd);
            obj.setStatsData(data);
            cs.addToStatsObj(obj);
            this.store.updatePartitionColumnStatistics(cs, partVal);
        }
        Checker statChecker = new Checker(){

            @Override
            public void checkStats(AggrStats aggrStats) throws Exception {
                Assert.assertEquals((long)10L, (long)aggrStats.getPartsFound());
                Assert.assertEquals((long)1L, (long)aggrStats.getColStatsSize());
                ColumnStatisticsObj cso = (ColumnStatisticsObj)aggrStats.getColStats().get(0);
                Assert.assertEquals((Object)"col1", (Object)cso.getColName());
                Assert.assertEquals((Object)"bigint", (Object)cso.getColType());
                LongColumnStatsData lcsd = cso.getStatsData().getLongStats();
                Assert.assertEquals((double)1009.0, (double)lcsd.getHighValue(), (double)0.01);
                Assert.assertEquals((double)-1009.0, (double)lcsd.getLowValue(), (double)0.01);
                Assert.assertEquals((long)45L, (long)lcsd.getNumNulls());
                Assert.assertEquals((long)91L, (long)lcsd.getNumDVs());
            }
        };
        ArrayList<CallSite> partNames = new ArrayList<CallSite>();
        for (int i = 0; i < 10; ++i) {
            partNames.add((CallSite)((Object)("ds=" + i)));
        }
        AggrStats aggrStats = this.store.get_aggr_stats_for("hive", dbName, tableName, partNames, Arrays.asList("col1"));
        statChecker.checkStats(aggrStats);
    }

    private static void dropAllStoreObjects(RawStore store) throws MetaException, InvalidObjectException, InvalidInputException {
        try {
            Deadline.registerIfNot((long)100000L);
            Deadline.startTimer((String)"getPartition");
            List dbs = store.getAllDatabases("hive");
            for (int i = 0; i < dbs.size(); ++i) {
                String db = (String)dbs.get(i);
                List tbls = store.getAllTables("hive", db);
                for (String tbl : tbls) {
                    List parts = store.getPartitions("hive", db, tbl, 100);
                    for (Partition part : parts) {
                        store.dropPartition("hive", db, tbl, part.getValues());
                    }
                    store.dropTable("hive", db, tbl);
                }
                store.dropDatabase("hive", db);
            }
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
    }

    private static interface Checker {
        public void checkStats(AggrStats var1) throws Exception;
    }

    public static class MockPartitionExpressionProxy
    implements PartitionExpressionProxy {
        public String convertExprToFilter(byte[] expr) throws MetaException {
            return null;
        }

        public boolean filterPartitionsByExpr(List<FieldSchema> partColumns, byte[] expr, String defaultPartitionName, List<String> partitionNames) throws MetaException {
            return false;
        }

        public FileMetadataExprType getMetadataType(String inputFormat) {
            return null;
        }

        public SearchArgument createSarg(byte[] expr) {
            return null;
        }

        public FileFormatProxy getFileFormatProxy(FileMetadataExprType type) {
            return null;
        }
    }
}

