/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.state;

import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusOptimisticException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.metadata.VersionStrategy;
import org.datanucleus.state.LockManager;
import org.datanucleus.state.LockMode;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class LockManagerImpl
implements LockManager {
    ExecutionContext ec;
    Map<Object, LockMode> requiredLockModesById = null;
    Map<ObjectProvider, LockMode> lockModeByObjectProvider = null;

    public LockManagerImpl(ExecutionContext ec) {
        this.ec = ec;
    }

    @Override
    public void close() {
        this.clear();
    }

    @Override
    public void clear() {
        if (this.requiredLockModesById != null) {
            this.requiredLockModesById.clear();
        }
        if (this.lockModeByObjectProvider != null) {
            this.lockModeByObjectProvider.clear();
        }
    }

    @Override
    public void lock(Object id, LockMode lockMode) {
        if (this.requiredLockModesById == null) {
            this.requiredLockModesById = new HashMap<Object, LockMode>();
        }
        this.requiredLockModesById.put(id, lockMode);
    }

    @Override
    public LockMode getLockMode(Object id) {
        LockMode lockMode;
        if (this.requiredLockModesById != null && (lockMode = this.requiredLockModesById.get(id)) != null) {
            return lockMode;
        }
        return LockMode.LOCK_NONE;
    }

    @Override
    public void lock(ObjectProvider op, LockMode lockMode) {
        if (this.lockModeByObjectProvider == null) {
            this.lockModeByObjectProvider = new HashMap<ObjectProvider, LockMode>();
        }
        this.lockModeByObjectProvider.put(op, lockMode);
        if (lockMode == LockMode.LOCK_PESSIMISTIC_READ || lockMode == LockMode.LOCK_PESSIMISTIC_WRITE) {
            op.locate();
        }
    }

    @Override
    public void unlock(ObjectProvider op) {
        if (this.lockModeByObjectProvider != null) {
            this.lockModeByObjectProvider.remove(op);
        }
    }

    @Override
    public LockMode getLockMode(ObjectProvider op) {
        if (op == null) {
            return LockMode.LOCK_NONE;
        }
        if (this.lockModeByObjectProvider != null) {
            return this.lockModeByObjectProvider.containsKey(op) ? this.lockModeByObjectProvider.get(op) : LockMode.LOCK_NONE;
        }
        return LockMode.LOCK_NONE;
    }

    @Override
    public void performOptimisticVersionCheck(ObjectProvider op, VersionStrategy versionStrategy, Object versionDatastore) {
        boolean valid;
        Object versionObject = op.getTransactionalVersion();
        if (versionObject == null) {
            return;
        }
        if (versionStrategy == null) {
            NucleusLogger.PERSISTENCE.info(op.getClassMetaData().getFullClassName() + " has no version metadata so no check of version is required, since this will not have the version flag in its table");
            return;
        }
        if (versionStrategy == VersionStrategy.DATE_TIME) {
            valid = ((Timestamp)versionObject).getTime() == ((Timestamp)versionDatastore).getTime();
        } else if (versionStrategy == VersionStrategy.VERSION_NUMBER) {
            valid = ((Number)versionObject).longValue() == ((Number)versionDatastore).longValue();
        } else {
            if (versionStrategy == VersionStrategy.STATE_IMAGE) {
                throw new NucleusUserException(Localiser.msg("032017", new Object[]{op.getClassMetaData().getFullClassName(), versionStrategy}));
            }
            throw new NucleusUserException(Localiser.msg("032017", new Object[]{op.getClassMetaData().getFullClassName(), versionStrategy}));
        }
        if (!valid) {
            throw new NucleusOptimisticException(Localiser.msg("032016", op.getObjectAsPrintable(), op.getInternalObjectId(), "" + versionDatastore, "" + versionObject), op.getObject());
        }
    }

    @Override
    public Object getNextVersion(VersionMetaData vermd, Object currentVersion) {
        if (vermd == null) {
            return null;
        }
        VersionStrategy versionStrategy = vermd.getVersionStrategy();
        if (versionStrategy == null) {
            return null;
        }
        if (versionStrategy == VersionStrategy.NONE) {
            if (currentVersion == null) {
                AbstractMemberMetaData verMmd;
                if (vermd.getFieldName() != null && ((verMmd = ((AbstractClassMetaData)vermd.getParent()).getMetaDataForMember(vermd.getFieldName())).getType() == Integer.class || verMmd.getType() == Integer.TYPE)) {
                    return 1;
                }
                return 1L;
            }
            return currentVersion;
        }
        if (versionStrategy == VersionStrategy.DATE_TIME) {
            return new Timestamp(System.currentTimeMillis());
        }
        if (versionStrategy == VersionStrategy.VERSION_NUMBER) {
            if (currentVersion == null) {
                AbstractMemberMetaData verMmd;
                Integer initValue = this.ec.getIntProperty("datanucleus.version.versionNumber.initialValue");
                if (vermd.hasExtension("version-initial-value")) {
                    initValue = Integer.valueOf(vermd.getValueForExtension("version-initial-value"));
                }
                if (vermd.getFieldName() != null && ((verMmd = ((AbstractClassMetaData)vermd.getParent()).getMetaDataForMember(vermd.getFieldName())).getType() == Integer.class || verMmd.getType() == Integer.TYPE)) {
                    return initValue;
                }
                return (long)initValue.intValue();
            }
            if (currentVersion instanceof Integer) {
                return (Integer)currentVersion + 1;
            }
            return (Long)currentVersion + 1L;
        }
        if (versionStrategy == VersionStrategy.STATE_IMAGE) {
            throw new NucleusUserException("DataNucleus doesnt currently support version strategy \"state-image\"");
        }
        throw new NucleusUserException("Unknown version strategy - not supported");
    }
}

