/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import org.apache.hadoop.hive.metastore.Deadline;
import org.apache.hadoop.hive.metastore.DeadlineException;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MetastoreUnitTest.class})
public class TestDeadline {
    private static final Logger LOG = LoggerFactory.getLogger(TestDeadline.class);
    private long timeout = 1000L;
    private long resetTimeout = 200L;
    private long duration = 500L;
    private boolean isFailed;
    private String errorMsg;

    @Test
    public void testDeadline() throws Exception {
        this.isFailed = false;
        this.errorMsg = "";
        Thread threadTimeout = new Thread(this.createRunnable());
        threadTimeout.setDaemon(true);
        threadTimeout.start();
        threadTimeout.join(60000L);
        if (this.isFailed) {
            Assert.fail((String)this.errorMsg);
        }
    }

    private Runnable createRunnable() {
        return new Runnable(){

            @Override
            public void run() {
                Deadline.registerIfNot((long)TestDeadline.this.timeout);
                try {
                    TestDeadline.this.start();
                    try {
                        Deadline.checkTimeout();
                    }
                    catch (MetaException e) {
                        TestDeadline.this.failInThread("should not timeout", (Exception)((Object)e));
                        return;
                    }
                    Deadline.stopTimer();
                    TestDeadline.this.start();
                    try {
                        Deadline.checkTimeout();
                    }
                    catch (MetaException e) {
                        TestDeadline.this.failInThread("should not timeout", (Exception)((Object)e));
                        return;
                    }
                    Deadline.stopTimer();
                    Deadline.resetTimeout((long)TestDeadline.this.resetTimeout);
                    TestDeadline.this.start();
                    try {
                        Deadline.checkTimeout();
                        TestDeadline.this.failInThread("should timeout.", null);
                        return;
                    }
                    catch (MetaException e) {
                        if (!(e.getCause() instanceof DeadlineException)) {
                            TestDeadline.this.failInThread("new MetaException failed.", (Exception)((Object)e));
                            return;
                        }
                        Deadline.clear();
                        if (Deadline.getCurrentDeadline() != null) {
                            TestDeadline.this.failInThread("the threadlocal object should be removed after timeout.", null);
                        }
                    }
                }
                catch (MetaException e) {
                    TestDeadline.this.failInThread("error happens in start, end, or reset. Check the exception.", (Exception)((Object)e));
                }
            }
        };
    }

    private void start() throws MetaException {
        Deadline.startTimer((String)"test");
        try {
            Thread.sleep(this.duration);
        }
        catch (InterruptedException e) {
            this.failInThread("Odd. Sleeping thread is interrupted.", e);
        }
    }

    private void failInThread(String msg, Exception e) {
        this.isFailed = true;
        if (e != null) {
            LOG.error(msg, (Throwable)e);
            this.errorMsg = msg + ": " + e.getMessage();
        } else {
            LOG.error(msg);
            this.errorMsg = msg;
        }
    }
}

