/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.query.inmemory.method;

import java.util.List;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.query.QueryUtils;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.query.expression.InvokeExpression;
import org.datanucleus.query.expression.Literal;
import org.datanucleus.query.expression.ParameterExpression;
import org.datanucleus.query.expression.PrimaryExpression;
import org.datanucleus.query.inmemory.InMemoryExpressionEvaluator;
import org.datanucleus.query.inmemory.InvocationEvaluator;

public class NullIfFunction
implements InvocationEvaluator {
    @Override
    public Object evaluate(InvokeExpression expr, Object ignored, InMemoryExpressionEvaluator eval) {
        Object argValue2;
        List<Expression> args = expr.getArguments();
        if (args == null || args.isEmpty()) {
            throw new NucleusException("NULLIF requires two arguments");
        }
        if (args.size() == 1) {
            return this.getValueForArgExpression(args.get(0), eval);
        }
        Expression argExpr1 = args.get(0);
        Expression argExpr2 = args.get(1);
        Object argValue1 = this.getValueForArgExpression(argExpr1, eval);
        if (argValue1 == (argValue2 = this.getValueForArgExpression(argExpr2, eval))) {
            return null;
        }
        return argValue1;
    }

    protected Object getValueForArgExpression(Expression argExpr, InMemoryExpressionEvaluator eval) {
        Object argValue = null;
        if (argExpr instanceof PrimaryExpression) {
            PrimaryExpression primExpr = (PrimaryExpression)argExpr;
            argValue = eval.getValueForPrimaryExpression(primExpr);
        } else if (argExpr instanceof ParameterExpression) {
            ParameterExpression paramExpr = (ParameterExpression)argExpr;
            argValue = QueryUtils.getValueForParameterExpression(eval.getParameterValues(), paramExpr);
        } else if (argExpr instanceof Literal) {
            argValue = ((Literal)argExpr).getLiteral();
        } else {
            throw new NucleusException("Don't support NULLIF with argument of type " + argExpr.getClass().getName());
        }
        return argValue;
    }
}

