/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.identity;

import java.io.Serializable;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.identity.DatastoreId;
import org.datanucleus.util.Localiser;

public class DatastoreIdImpl
implements Serializable,
DatastoreId,
Comparable {
    private static final long serialVersionUID = -1841930829956222995L;
    protected static final transient String STRING_DELIMITER = "[OID]";
    public final Object keyAsObject;
    public final String targetClassName;
    public final String toString;
    public final int hashCode;

    public DatastoreIdImpl(String pcClass, Object key) {
        this.targetClassName = pcClass;
        this.keyAsObject = key;
        StringBuilder s = new StringBuilder();
        s.append(this.keyAsObject.toString());
        s.append(STRING_DELIMITER);
        s.append(this.targetClassName);
        this.toString = s.toString();
        this.hashCode = this.toString.hashCode();
    }

    public DatastoreIdImpl(String str) throws IllegalArgumentException {
        if (str.length() < 2) {
            throw new IllegalArgumentException(Localiser.msg("002003", str));
        }
        if (str.indexOf(STRING_DELIMITER) < 0) {
            throw new IllegalArgumentException(Localiser.msg("002003", str));
        }
        int start = 0;
        int end = str.indexOf(STRING_DELIMITER, start);
        String oidStr = str.substring(start, end);
        Object oidValue = null;
        try {
            oidValue = Long.valueOf(oidStr);
        }
        catch (NumberFormatException nfe) {
            oidValue = oidStr;
        }
        this.keyAsObject = oidValue;
        start = end + STRING_DELIMITER.length();
        this.targetClassName = str.substring(start, str.length());
        this.toString = str;
        this.hashCode = this.toString.hashCode();
    }

    @Override
    public Object getKeyAsObject() {
        return this.keyAsObject;
    }

    @Override
    public String getTargetClassName() {
        return this.targetClassName;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!obj.getClass().getName().equals(ClassNameConstants.IDENTITY_OID_IMPL)) {
            return false;
        }
        if (this.hashCode() != obj.hashCode()) {
            return false;
        }
        return ((DatastoreId)obj).toString().equals(this.toString);
    }

    public int compareTo(Object o) {
        if (o instanceof DatastoreIdImpl) {
            DatastoreIdImpl c = (DatastoreIdImpl)o;
            return this.toString.compareTo(c.toString);
        }
        if (o == null) {
            throw new ClassCastException("object is null");
        }
        throw new ClassCastException(this.getClass().getName() + " != " + o.getClass().getName());
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public String toString() {
        return this.toString;
    }
}

