/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.client;

import com.google.common.collect.Lists;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hadoop.hive.metastore.annotation.MetastoreCheckinTest;
import org.apache.hadoop.hive.metastore.api.Catalog;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PartitionSpec;
import org.apache.hadoop.hive.metastore.api.PartitionValuesRequest;
import org.apache.hadoop.hive.metastore.api.PartitionValuesResponse;
import org.apache.hadoop.hive.metastore.api.PartitionValuesRow;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.client.MetaStoreClientTest;
import org.apache.hadoop.hive.metastore.client.builder.CatalogBuilder;
import org.apache.hadoop.hive.metastore.client.builder.DatabaseBuilder;
import org.apache.hadoop.hive.metastore.client.builder.PartitionBuilder;
import org.apache.hadoop.hive.metastore.client.builder.TableBuilder;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.minihms.AbstractMetaStoreService;
import org.apache.hadoop.hive.metastore.partition.spec.PartitionSpecProxy;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.transport.TTransportException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={MetastoreCheckinTest.class})
public class TestListPartitions
extends MetaStoreClientTest {
    private AbstractMetaStoreService metaStore;
    private IMetaStoreClient client;
    private static final String DB_NAME = "testpartdb";
    private static final String TABLE_NAME = "testparttable";

    public TestListPartitions(String name, AbstractMetaStoreService metaStore) {
        this.metaStore = metaStore;
    }

    @Before
    public void setUp() throws Exception {
        this.client = this.metaStore.getClient();
        this.client.dropDatabase(DB_NAME, true, true, true);
        this.createDB(DB_NAME);
    }

    @After
    public void tearDown() throws Exception {
        try {
            if (this.client != null) {
                this.client.close();
            }
        }
        finally {
            this.client = null;
        }
    }

    private void createDB(String dbName) throws TException {
        new DatabaseBuilder().setName(dbName).create(this.client, this.metaStore.getConf());
    }

    private Table createTestTable(IMetaStoreClient client, String dbName, String tableName, List<String> partCols) throws Exception {
        return this.createTestTable(client, dbName, tableName, partCols, false);
    }

    private Table createTestTable(IMetaStoreClient client, String dbName, String tableName, List<String> partCols, boolean setPartitionLevelPrivilages) throws TException {
        TableBuilder builder = (TableBuilder)((TableBuilder)new TableBuilder().setDbName(dbName).setTableName(tableName).addCol("id", "int")).addCol("name", "string");
        partCols.forEach(col -> builder.addPartCol(col, "string"));
        Table table = builder.build(this.metaStore.getConf());
        if (setPartitionLevelPrivilages) {
            table.putToParameters("PARTITION_LEVEL_PRIVILEGE", "true");
        }
        client.createTable(table);
        return table;
    }

    private void addPartition(IMetaStoreClient client, Table table, List<String> values) throws TException {
        PartitionBuilder partitionBuilder = new PartitionBuilder().inTable(table);
        values.forEach(val -> partitionBuilder.addValue(val));
        client.add_partition(partitionBuilder.build(this.metaStore.getConf()));
    }

    private void createTable3PartCols1PartGeneric(IMetaStoreClient client, boolean authOn) throws TException {
        Table t = this.createTestTable(client, DB_NAME, TABLE_NAME, Lists.newArrayList((Object[])new String[]{"yyyy", "mm", "dd"}), authOn);
        this.addPartition(client, t, Lists.newArrayList((Object[])new String[]{"1997", "05", "16"}));
    }

    private void createTable3PartCols1Part(IMetaStoreClient client) throws TException {
        this.createTable3PartCols1PartGeneric(client, false);
    }

    private List<List<String>> createTable4PartColsPartsGeneric(IMetaStoreClient client, boolean authOn) throws Exception {
        Table t = this.createTestTable(client, DB_NAME, TABLE_NAME, Lists.newArrayList((Object[])new String[]{"yyyy", "mm", "dd"}), authOn);
        ArrayList testValues = Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new String[]{"1999", "01", "02"}), Lists.newArrayList((Object[])new String[]{"2009", "02", "10"}), Lists.newArrayList((Object[])new String[]{"2017", "10", "26"}), Lists.newArrayList((Object[])new String[]{"2017", "11", "27"})});
        for (List vals : testValues) {
            this.addPartition(client, t, vals);
        }
        return testValues;
    }

    private List<List<String>> createTable4PartColsParts(IMetaStoreClient client) throws Exception {
        return this.createTable4PartColsPartsGeneric(client, false);
    }

    private List<List<String>> createTable4PartColsPartsAuthOn(IMetaStoreClient client) throws Exception {
        return this.createTable4PartColsPartsGeneric(client, true);
    }

    private static void assertAuthInfoReturned(String user, String group, Partition partition) {
        TestCase.assertNotNull((Object)partition.getPrivileges());
        Assert.assertEquals((Object)Lists.newArrayList(), partition.getPrivileges().getUserPrivileges().get(user));
        Assert.assertEquals((Object)Lists.newArrayList(), partition.getPrivileges().getGroupPrivileges().get(group));
        Assert.assertEquals((Object)Lists.newArrayList(), partition.getPrivileges().getRolePrivileges().get("public"));
    }

    private static void assertPartitionsHaveCorrectValues(List<Partition> partitions, List<List<String>> testValues) throws Exception {
        Assert.assertEquals((long)testValues.size(), (long)partitions.size());
        for (int i = 0; i < partitions.size(); ++i) {
            Assert.assertEquals(testValues.get(i), (Object)partitions.get(i).getValues());
        }
    }

    private static void assertCorrectPartitionNames(List<String> names, List<List<String>> testValues, List<String> partCols) throws Exception {
        Assert.assertEquals((long)testValues.size(), (long)names.size());
        for (int i = 0; i < names.size(); ++i) {
            ArrayList<CallSite> expectedKVPairs = new ArrayList<CallSite>();
            for (int j = 0; j < partCols.size(); ++j) {
                expectedKVPairs.add((CallSite)((Object)(partCols.get(j) + "=" + testValues.get(i).get(j))));
            }
            Assert.assertEquals((Object)expectedKVPairs.stream().collect(Collectors.joining("/")), (Object)names.get(i));
        }
    }

    private static void assertPartitionsSpecProxy(PartitionSpecProxy partSpecProxy, List<List<String>> testValues) throws Exception {
        Assert.assertEquals((long)testValues.size(), (long)partSpecProxy.size());
        List partitionSpecs = partSpecProxy.toPartitionSpec();
        List partitions = ((PartitionSpec)partitionSpecs.get(0)).getPartitionList().getPartitions();
        Assert.assertEquals((long)testValues.size(), (long)partitions.size());
        for (int i = 0; i < partitions.size(); ++i) {
            Assert.assertEquals(testValues.get(i), (Object)((Partition)partitions.get(i)).getValues());
        }
    }

    private static void assertCorrectPartitionValuesResponse(List<List<String>> testValues, PartitionValuesResponse resp) throws Exception {
        Assert.assertEquals((long)testValues.size(), (long)resp.getPartitionValuesSize());
        List rowList = resp.getPartitionValues();
        for (int i = 0; i < rowList.size(); ++i) {
            PartitionValuesRow pvr = (PartitionValuesRow)rowList.get(i);
            List values = pvr.getRow();
            for (int j = 0; j < values.size(); ++j) {
                Assert.assertEquals((Object)testValues.get(i).get(j), values.get(j));
            }
        }
    }

    @Test
    public void testListPartitionsAll() throws Exception {
        List<List<String>> testValues = this.createTable4PartColsParts(this.client);
        List partitions = this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1);
        TestListPartitions.assertPartitionsHaveCorrectValues(partitions, testValues);
        partitions = this.client.listPartitions(DB_NAME, TABLE_NAME, (short)1);
        TestListPartitions.assertPartitionsHaveCorrectValues(partitions, testValues.subList(0, 1));
        if (MetastoreConf.getBoolVar((Configuration)this.metaStore.getConf(), (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TRY_DIRECT_SQL)) {
            partitions = this.client.listPartitions(DB_NAME, TABLE_NAME, (short)0);
            TestCase.assertTrue((boolean)partitions.isEmpty());
        }
    }

    @Test(expected=MetaException.class)
    public void testListPartitionsAllHighMaxParts() throws Exception {
        this.createTable3PartCols1Part(this.client);
        List partitions = this.client.listPartitions(DB_NAME, TABLE_NAME, (short)101);
        TestCase.assertTrue((boolean)partitions.isEmpty());
    }

    @Test
    public void testListPartitionsAllNoParts() throws Exception {
        Table t = this.createTestTable(this.client, DB_NAME, TABLE_NAME, Lists.newArrayList((Object[])new String[]{"yyyy", "mm", "dd"}));
        List partitions = this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1);
        TestCase.assertTrue((boolean)partitions.isEmpty());
    }

    @Test(expected=NoSuchObjectException.class)
    public void testListPartitionsAllNoTable() throws Exception {
        List partitions = this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1);
    }

    @Test(expected=NoSuchObjectException.class)
    public void testListPartitionsAllNoDb() throws Exception {
        this.client.dropDatabase(DB_NAME);
        this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1);
    }

    @Test(expected=NoSuchObjectException.class)
    public void testListPartitionsAllNoDbName() throws Exception {
        this.createTable3PartCols1Part(this.client);
        this.client.listPartitions("", TABLE_NAME, (short)-1);
    }

    @Test(expected=NoSuchObjectException.class)
    public void testListPartitionsAllNoTblName() throws Exception {
        this.createTable3PartCols1Part(this.client);
        this.client.listPartitions(DB_NAME, "", (short)-1);
    }

    @Test
    public void testListPartitionsAllNullTblName() throws Exception {
        try {
            this.createTable3PartCols1Part(this.client);
            List partitions = this.client.listPartitions(DB_NAME, (String)null, (short)-1);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (NullPointerException | TTransportException throwable) {
            // empty catch block
        }
    }

    @Test
    public void testListPartitionsAllNullDbName() throws Exception {
        try {
            this.createTable3PartCols1Part(this.client);
            this.client.listPartitions(null, TABLE_NAME, (short)-1);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (NullPointerException | TTransportException throwable) {
            // empty catch block
        }
    }

    @Test
    public void testListPartitionsByValues() throws Exception {
        List<List<String>> testValues = this.createTable4PartColsParts(this.client);
        List partitions = this.client.listPartitions(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{"2017"}), (short)-1);
        Assert.assertEquals((long)2L, (long)partitions.size());
        Assert.assertEquals(testValues.get(2), (Object)((Partition)partitions.get(0)).getValues());
        Assert.assertEquals(testValues.get(3), (Object)((Partition)partitions.get(1)).getValues());
        partitions = this.client.listPartitions(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{"2017", "11"}), (short)-1);
        Assert.assertEquals((long)1L, (long)partitions.size());
        Assert.assertEquals(testValues.get(3), (Object)((Partition)partitions.get(0)).getValues());
        partitions = this.client.listPartitions(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{"20177", "11"}), (short)-1);
        Assert.assertEquals((long)0L, (long)partitions.size());
    }

    @Test(expected=MetaException.class)
    public void testListPartitionsByValuesNoVals() throws Exception {
        this.createTable3PartCols1Part(this.client);
        this.client.listPartitions(DB_NAME, TABLE_NAME, (List)Lists.newArrayList(), (short)-1);
    }

    @Test(expected=MetaException.class)
    public void testListPartitionsByValuesTooManyVals() throws Exception {
        this.createTable3PartCols1Part(this.client);
        this.client.listPartitions(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{"0", "1", "2", "3"}), (short)-1);
    }

    @Test(expected=NoSuchObjectException.class)
    public void testListPartitionsByValuesNoDbName() throws Exception {
        this.createTable3PartCols1Part(this.client);
        this.client.listPartitions("", TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{"1999"}), (short)-1);
    }

    @Test(expected=NoSuchObjectException.class)
    public void testListPartitionsByValuesNoTblName() throws Exception {
        this.createTable3PartCols1Part(this.client);
        this.client.listPartitions(DB_NAME, "", (List)Lists.newArrayList((Object[])new String[]{"1999"}), (short)-1);
    }

    @Test(expected=NoSuchObjectException.class)
    public void testListPartitionsByValuesNoTable() throws Exception {
        this.client.listPartitions(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{"1999"}), (short)-1);
    }

    @Test(expected=NoSuchObjectException.class)
    public void testListPartitionsByValuesNoDb() throws Exception {
        this.client.dropDatabase(DB_NAME);
        this.client.listPartitions(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{"1999"}), (short)-1);
    }

    @Test(expected=MetaException.class)
    public void testListPartitionsByValuesNullDbName() throws Exception {
        this.createTable3PartCols1Part(this.client);
        this.client.listPartitions(null, TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{"1999"}), (short)-1);
    }

    @Test(expected=MetaException.class)
    public void testListPartitionsByValuesNullTblName() throws Exception {
        this.createTable3PartCols1Part(this.client);
        this.client.listPartitions(DB_NAME, null, (List)Lists.newArrayList((Object[])new String[]{"1999"}), (short)-1);
    }

    @Test(expected=MetaException.class)
    public void testListPartitionsByValuesNullValues() throws Exception {
        this.createTable3PartCols1Part(this.client);
        this.client.listPartitions(DB_NAME, TABLE_NAME, (List)null, (short)-1);
    }

    @Test
    public void testListPartitionSpecs() throws Exception {
        List<List<String>> testValues = this.createTable4PartColsParts(this.client);
        PartitionSpecProxy partSpecProxy = this.client.listPartitionSpecs(DB_NAME, TABLE_NAME, -1);
        TestListPartitions.assertPartitionsSpecProxy(partSpecProxy, testValues);
        partSpecProxy = this.client.listPartitionSpecs(DB_NAME, TABLE_NAME, 2);
        TestListPartitions.assertPartitionsSpecProxy(partSpecProxy, testValues.subList(0, 2));
        if (MetastoreConf.getBoolVar((Configuration)this.metaStore.getConf(), (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TRY_DIRECT_SQL)) {
            partSpecProxy = this.client.listPartitionSpecs(DB_NAME, TABLE_NAME, 0);
            TestListPartitions.assertPartitionsSpecProxy(partSpecProxy, testValues.subList(0, 0));
        }
    }

    @Test(expected=NoSuchObjectException.class)
    public void testListPartitionSpecsNoTable() throws Exception {
        this.client.listPartitionSpecs(DB_NAME, TABLE_NAME, -1);
    }

    @Test(expected=NoSuchObjectException.class)
    public void testListPartitionSpecsNoDb() throws Exception {
        this.client.dropDatabase(DB_NAME);
        this.client.listPartitionSpecs(DB_NAME, TABLE_NAME, -1);
    }

    @Test(expected=MetaException.class)
    public void testListPartitionSpecsHighMaxParts() throws Exception {
        this.createTable4PartColsParts(this.client);
        this.client.listPartitionSpecs(DB_NAME, TABLE_NAME, 101);
    }

    @Test(expected=NoSuchObjectException.class)
    public void testListPartitionSpecsNoDbName() throws Exception {
        this.createTable4PartColsParts(this.client);
        this.client.listPartitionSpecs("", TABLE_NAME, -1);
    }

    @Test(expected=NoSuchObjectException.class)
    public void testListPartitionSpecsNoTblName() throws Exception {
        this.createTable4PartColsParts(this.client);
        this.client.listPartitionSpecs(DB_NAME, "", -1);
    }

    @Test
    public void testListPartitionSpecsNullDbName() throws Exception {
        try {
            this.createTable4PartColsParts(this.client);
            this.client.listPartitionSpecs(null, TABLE_NAME, -1);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (MetaException | TTransportException throwable) {
            // empty catch block
        }
    }

    @Test
    public void testListPartitionSpecsNullTblName() throws Exception {
        try {
            this.createTable4PartColsParts(this.client);
            this.client.listPartitionSpecs(DB_NAME, null, -1);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (NullPointerException | TTransportException throwable) {
            // empty catch block
        }
    }

    @Test
    public void testListPartitionsWithAuth() throws Exception {
        List<List<String>> partValues = this.createTable4PartColsPartsAuthOn(this.client);
        String user = "user0";
        ArrayList groups = Lists.newArrayList((Object[])new String[]{"group0"});
        List partitions = this.client.listPartitionsWithAuthInfo(DB_NAME, TABLE_NAME, (short)-1, user, (List)groups);
        Assert.assertEquals((long)4L, (long)partitions.size());
        TestListPartitions.assertPartitionsHaveCorrectValues(partitions, partValues);
        partitions.forEach(partition -> TestListPartitions.assertAuthInfoReturned(user, (String)groups.get(0), partition));
        partitions = this.client.listPartitionsWithAuthInfo(DB_NAME, TABLE_NAME, (short)2, user, (List)groups);
        Assert.assertEquals((long)2L, (long)partitions.size());
        TestListPartitions.assertPartitionsHaveCorrectValues(partitions, partValues.subList(0, 2));
        partitions.forEach(partition -> TestListPartitions.assertAuthInfoReturned(user, (String)groups.get(0), partition));
    }

    @Test(expected=MetaException.class)
    public void testListPartitionsWithAuthHighMaxParts() throws Exception {
        this.createTable4PartColsParts(this.client);
        this.client.listPartitionsWithAuthInfo(DB_NAME, TABLE_NAME, (short)101, "", (List)Lists.newArrayList());
    }

    @Test
    public void testListPartitionsWithAuthNoPrivilegesSet() throws Exception {
        List<List<String>> partValues = this.createTable4PartColsParts(this.client);
        List partitions = this.client.listPartitionsWithAuthInfo(DB_NAME, TABLE_NAME, (short)-1, "", (List)Lists.newArrayList());
        Assert.assertEquals((long)4L, (long)partitions.size());
        TestListPartitions.assertPartitionsHaveCorrectValues(partitions, partValues);
        partitions.forEach(partition -> TestCase.assertNull((Object)partition.getPrivileges()));
    }

    @Test(expected=NoSuchObjectException.class)
    public void testListPartitionsWithAuthNoDbName() throws Exception {
        this.createTable4PartColsParts(this.client);
        this.client.listPartitionsWithAuthInfo("", TABLE_NAME, (short)-1, "", (List)Lists.newArrayList());
    }

    @Test(expected=NoSuchObjectException.class)
    public void testListPartitionsWithAuthNoTblName() throws Exception {
        this.createTable4PartColsParts(this.client);
        this.client.listPartitionsWithAuthInfo(DB_NAME, "", (short)-1, "", (List)Lists.newArrayList());
    }

    @Test(expected=NoSuchObjectException.class)
    public void testListPartitionsWithAuthNoTable() throws Exception {
        this.client.listPartitionsWithAuthInfo(DB_NAME, TABLE_NAME, (short)-1, "", (List)Lists.newArrayList());
    }

    @Test(expected=NoSuchObjectException.class)
    public void testListPartitionsWithAuthNoDb() throws Exception {
        this.client.dropDatabase(DB_NAME);
        this.client.listPartitionsWithAuthInfo(DB_NAME, TABLE_NAME, (short)-1, "", (List)Lists.newArrayList());
    }

    @Test(expected=MetaException.class)
    public void testListPartitionsWithAuthNullDbName() throws Exception {
        this.createTable4PartColsParts(this.client);
        this.client.listPartitionsWithAuthInfo(null, TABLE_NAME, (short)-1, "", (List)Lists.newArrayList());
    }

    @Test
    public void testListPartitionsWithAuthNullTblName() throws Exception {
        try {
            this.createTable4PartColsParts(this.client);
            this.client.listPartitionsWithAuthInfo(DB_NAME, (String)null, (short)-1, "", (List)Lists.newArrayList());
            Assert.fail((String)"Should have thrown exception");
        }
        catch (MetaException | TTransportException throwable) {
            // empty catch block
        }
    }

    @Test
    public void testListPartitionsWithAuthNullUser() throws Exception {
        this.createTable4PartColsPartsAuthOn(this.client);
        this.client.listPartitionsWithAuthInfo(DB_NAME, TABLE_NAME, (short)-1, null, (List)Lists.newArrayList());
    }

    @Test
    public void testListPartitionsWithAuthNullGroup() throws Exception {
        this.createTable4PartColsPartsAuthOn(this.client);
        this.client.listPartitionsWithAuthInfo(DB_NAME, TABLE_NAME, (short)-1, "user0", null);
    }

    @Test
    public void testListPartitionsWithAuthByValues() throws Exception {
        List<List<String>> partValues = this.createTable4PartColsPartsAuthOn(this.client);
        String user = "user0";
        ArrayList groups = Lists.newArrayList((Object[])new String[]{"group0"});
        List partitions = this.client.listPartitionsWithAuthInfo(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{"2017", "11", "27"}), (short)-1, user, (List)groups);
        Assert.assertEquals((long)1L, (long)partitions.size());
        TestListPartitions.assertPartitionsHaveCorrectValues(partitions, partValues.subList(3, 4));
        partitions.forEach(partition -> TestListPartitions.assertAuthInfoReturned(user, (String)groups.get(0), partition));
        partitions = this.client.listPartitionsWithAuthInfo(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{"2017"}), (short)-1, user, (List)groups);
        Assert.assertEquals((long)2L, (long)partitions.size());
        TestListPartitions.assertPartitionsHaveCorrectValues(partitions, partValues.subList(2, 4));
        partitions.forEach(partition -> TestListPartitions.assertAuthInfoReturned(user, (String)groups.get(0), partition));
        partitions = this.client.listPartitionsWithAuthInfo(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{"2017"}), (short)1, user, (List)groups);
        Assert.assertEquals((long)1L, (long)partitions.size());
        TestListPartitions.assertPartitionsHaveCorrectValues(partitions, partValues.subList(2, 3));
        partitions.forEach(partition -> TestListPartitions.assertAuthInfoReturned(user, (String)groups.get(0), partition));
        partitions = this.client.listPartitionsWithAuthInfo(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{"2013"}), (short)-1, user, (List)groups);
        TestCase.assertTrue((boolean)partitions.isEmpty());
    }

    @Test(expected=MetaException.class)
    public void testListPartitionsWithAuthByValuesNoVals() throws Exception {
        this.createTable4PartColsPartsAuthOn(this.client);
        this.client.listPartitionsWithAuthInfo(DB_NAME, TABLE_NAME, (List)Lists.newArrayList(), (short)-1, "", (List)Lists.newArrayList());
    }

    @Test(expected=MetaException.class)
    public void testListPartitionsWithAuthByValuesTooManyVals() throws Exception {
        this.createTable4PartColsPartsAuthOn(this.client);
        this.client.listPartitionsWithAuthInfo(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{"0", "1", "2", "3"}), (short)-1, "", (List)Lists.newArrayList());
    }

    @Test
    public void testListPartitionsWithAuthByValuesHighMaxParts() throws Exception {
        List<List<String>> partValues = this.createTable4PartColsParts(this.client);
        List partitions = this.client.listPartitionsWithAuthInfo(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{"2017"}), (short)101, "", (List)Lists.newArrayList());
        TestListPartitions.assertPartitionsHaveCorrectValues(partitions, partValues.subList(2, 4));
    }

    @Test(expected=MetaException.class)
    public void testListPartitionsWithAuthByValuesTooManyValsHighMaxParts() throws Exception {
        this.createTable4PartColsParts(this.client);
        this.client.listPartitionsWithAuthInfo(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{"0", "1", "2", "3"}), (short)101, "", (List)Lists.newArrayList());
    }

    @Test
    public void testListPartitionsWithAuthByValuesNoPrivilegesSet() throws Exception {
        List<List<String>> partValues = this.createTable4PartColsPartsAuthOn(this.client);
        String user = "user0";
        ArrayList groups = Lists.newArrayList((Object[])new String[]{"group0"});
        List partitions = this.client.listPartitionsWithAuthInfo(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{"2017", "11", "27"}), (short)-1, user, (List)groups);
        Assert.assertEquals((long)1L, (long)partitions.size());
        TestListPartitions.assertPartitionsHaveCorrectValues(partitions, partValues.subList(3, 4));
        partitions.forEach(partition -> TestListPartitions.assertAuthInfoReturned(user, (String)groups.get(0), partition));
    }

    @Test(expected=NoSuchObjectException.class)
    public void testListPartitionsWithAuthByValuesNoDbName() throws Exception {
        this.createTable4PartColsParts(this.client);
        this.client.listPartitionsWithAuthInfo("", TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{"2017", "11", "27"}), (short)-1, "", (List)Lists.newArrayList());
    }

    @Test(expected=NoSuchObjectException.class)
    public void testListPartitionsWithAuthByValuesNoTblName() throws Exception {
        this.createTable4PartColsParts(this.client);
        this.client.listPartitionsWithAuthInfo(DB_NAME, "", (List)Lists.newArrayList((Object[])new String[]{"2017", "11", "27"}), (short)-1, "", (List)Lists.newArrayList());
    }

    @Test(expected=NoSuchObjectException.class)
    public void testListPartitionsWithAuthByValuesNoTable() throws Exception {
        this.client.listPartitionsWithAuthInfo(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{"2017", "11", "27"}), (short)-1, "", (List)Lists.newArrayList());
    }

    @Test(expected=NoSuchObjectException.class)
    public void testListPartitionsWithAuthByValuesNoDb() throws Exception {
        this.client.dropDatabase(DB_NAME);
        this.client.listPartitionsWithAuthInfo(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{"2017", "11", "27"}), (short)-1, "", (List)Lists.newArrayList());
    }

    @Test
    public void testListPartitionsWithAuthByValuesNullDbName() throws Exception {
        try {
            this.createTable4PartColsParts(this.client);
            this.client.listPartitionsWithAuthInfo(null, TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{"2017", "11", "27"}), (short)-1, "", (List)Lists.newArrayList());
            Assert.fail((String)"Should have thrown exception");
        }
        catch (NullPointerException | TTransportException throwable) {
            // empty catch block
        }
    }

    @Test
    public void testListPartitionsWithAuthByValuesNullTblName() throws Exception {
        try {
            this.createTable4PartColsParts(this.client);
            this.client.listPartitionsWithAuthInfo(DB_NAME, null, (List)Lists.newArrayList((Object[])new String[]{"2017", "11", "27"}), (short)-1, "", (List)Lists.newArrayList());
            Assert.fail((String)"Should have thrown exception");
        }
        catch (NullPointerException | TTransportException throwable) {
            // empty catch block
        }
    }

    @Test(expected=MetaException.class)
    public void testListPartitionsWithAuthByValuesNullValues() throws Exception {
        this.createTable4PartColsParts(this.client);
        this.client.listPartitionsWithAuthInfo(DB_NAME, TABLE_NAME, (List)null, (short)-1, "", (List)Lists.newArrayList());
    }

    @Test
    public void testListPartitionsWithAuthByValuesNullUser() throws Exception {
        List<List<String>> partValues = this.createTable4PartColsPartsAuthOn(this.client);
        List partitions = this.client.listPartitionsWithAuthInfo(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{"2017", "11", "27"}), (short)-1, null, (List)Lists.newArrayList());
        TestListPartitions.assertPartitionsHaveCorrectValues(partitions, partValues.subList(3, 4));
    }

    @Test
    public void testListPartitionsWithAuthByValuesNullGroup() throws Exception {
        List<List<String>> partValues = this.createTable4PartColsPartsAuthOn(this.client);
        List partitions = this.client.listPartitionsWithAuthInfo(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{"2017", "11", "27"}), (short)-1, "", null);
        TestListPartitions.assertPartitionsHaveCorrectValues(partitions, partValues.subList(3, 4));
    }

    @Test
    public void testListPartitionsByFilter() throws Exception {
        List<List<String>> partValues = this.createTable4PartColsParts(this.client);
        List partitions = this.client.listPartitionsByFilter(DB_NAME, TABLE_NAME, "yyyy=\"2017\" OR mm=\"02\"", (short)-1);
        Assert.assertEquals((long)3L, (long)partitions.size());
        TestListPartitions.assertPartitionsHaveCorrectValues(partitions, partValues.subList(1, 4));
        partitions = this.client.listPartitionsByFilter(DB_NAME, TABLE_NAME, "yyyy=\"2017\" OR mm=\"02\"", (short)2);
        Assert.assertEquals((long)2L, (long)partitions.size());
        TestListPartitions.assertPartitionsHaveCorrectValues(partitions, partValues.subList(1, 3));
        partitions = this.client.listPartitionsByFilter(DB_NAME, TABLE_NAME, "yyyy=\"2017\" OR mm=\"02\"", (short)0);
        TestCase.assertTrue((boolean)partitions.isEmpty());
        if (MetastoreConf.getBoolVar((Configuration)this.metaStore.getConf(), (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TRY_DIRECT_SQL)) {
            partitions = this.client.listPartitionsByFilter(DB_NAME, TABLE_NAME, "yYyY=\"2017\"", (short)-1);
            TestListPartitions.assertPartitionsHaveCorrectValues(partitions, partValues.subList(2, 4));
        }
        partitions = this.client.listPartitionsByFilter(DB_NAME, TABLE_NAME, "yyyy=\"2017\" AND mm=\"99\"", (short)-1);
        TestCase.assertTrue((boolean)partitions.isEmpty());
    }

    @Test(expected=MetaException.class)
    public void testListPartitionsByFilterInvalidFilter() throws Exception {
        this.createTable4PartColsParts(this.client);
        this.client.listPartitionsByFilter(DB_NAME, TABLE_NAME, "yyy=\"2017\"", (short)101);
    }

    @Test(expected=MetaException.class)
    public void testListPartitionsByFilterHighMaxParts() throws Exception {
        this.createTable4PartColsParts(this.client);
        this.client.listPartitionsByFilter(DB_NAME, TABLE_NAME, "yyyy=\"2017\"", (short)101);
    }

    @Test(expected=NoSuchObjectException.class)
    public void testListPartitionsByFilterNoTblName() throws Exception {
        this.createTable4PartColsParts(this.client);
        this.client.listPartitionsByFilter(DB_NAME, "", "yyyy=\"2017\"", (short)-1);
    }

    @Test(expected=NoSuchObjectException.class)
    public void testListPartitionsByFilterNoDbName() throws Exception {
        this.createTable4PartColsParts(this.client);
        this.client.listPartitionsByFilter("", TABLE_NAME, "yyyy=\"2017\"", (short)-1);
    }

    @Test(expected=NoSuchObjectException.class)
    public void testListPartitionsByFilterNoTable() throws Exception {
        this.client.listPartitionsByFilter(DB_NAME, TABLE_NAME, "yyyy=\"2017\"", (short)-1);
    }

    @Test(expected=NoSuchObjectException.class)
    public void testListPartitionsByFilterNoDb() throws Exception {
        this.client.dropDatabase(DB_NAME);
        this.client.listPartitionsByFilter(DB_NAME, TABLE_NAME, "yyyy=\"2017\"", (short)-1);
    }

    @Test
    public void testListPartitionsByFilterNullTblName() throws Exception {
        try {
            this.createTable4PartColsParts(this.client);
            this.client.listPartitionsByFilter(DB_NAME, null, "yyyy=\"2017\"", (short)-1);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (NullPointerException | TTransportException throwable) {
            // empty catch block
        }
    }

    @Test
    public void testListPartitionsByFilterNullDbName() throws Exception {
        try {
            this.createTable4PartColsParts(this.client);
            this.client.listPartitionsByFilter(null, TABLE_NAME, "yyyy=\"2017\"", (short)-1);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (NullPointerException | TTransportException throwable) {
            // empty catch block
        }
    }

    @Test
    public void testListPartitionsByFilterNullFilter() throws Exception {
        this.createTable4PartColsParts(this.client);
        List partitions = this.client.listPartitionsByFilter(DB_NAME, TABLE_NAME, null, (short)-1);
        Assert.assertEquals((long)4L, (long)partitions.size());
    }

    @Test
    public void testListPartitionsByFilterEmptyFilter() throws Exception {
        this.createTable4PartColsParts(this.client);
        List partitions = this.client.listPartitionsByFilter(DB_NAME, TABLE_NAME, "", (short)-1);
        Assert.assertEquals((long)4L, (long)partitions.size());
    }

    @Test
    public void testListPartitionsSpecsByFilter() throws Exception {
        List<List<String>> testValues = this.createTable4PartColsParts(this.client);
        PartitionSpecProxy partSpecProxy = this.client.listPartitionSpecsByFilter(DB_NAME, TABLE_NAME, "yyyy=\"2017\" OR mm=\"02\"", -1);
        TestListPartitions.assertPartitionsSpecProxy(partSpecProxy, testValues.subList(1, 4));
        partSpecProxy = this.client.listPartitionSpecsByFilter(DB_NAME, TABLE_NAME, "yyyy=\"2017\" OR mm=\"02\"", 2);
        TestListPartitions.assertPartitionsSpecProxy(partSpecProxy, testValues.subList(1, 3));
        partSpecProxy = this.client.listPartitionSpecsByFilter(DB_NAME, TABLE_NAME, "yyyy=\"2017\" OR mm=\"02\"", 0);
        TestListPartitions.assertPartitionsSpecProxy(partSpecProxy, Lists.newArrayList());
        partSpecProxy = this.client.listPartitionSpecsByFilter(DB_NAME, TABLE_NAME, "yyyy=\"20177\"", -1);
        TestListPartitions.assertPartitionsSpecProxy(partSpecProxy, Lists.newArrayList());
        if (MetastoreConf.getBoolVar((Configuration)this.metaStore.getConf(), (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TRY_DIRECT_SQL)) {
            partSpecProxy = this.client.listPartitionSpecsByFilter(DB_NAME, TABLE_NAME, "yYyY=\"2017\"", -1);
            TestListPartitions.assertPartitionsSpecProxy(partSpecProxy, testValues.subList(2, 4));
        }
        partSpecProxy = this.client.listPartitionSpecsByFilter(DB_NAME, TABLE_NAME, "yyyy=\"2017\" AND mm=\"99\"", -1);
        TestListPartitions.assertPartitionsSpecProxy(partSpecProxy, Lists.newArrayList());
    }

    @Test(expected=MetaException.class)
    public void testListPartitionSpecsByFilterInvalidFilter() throws Exception {
        this.createTable4PartColsParts(this.client);
        this.client.listPartitionSpecsByFilter(DB_NAME, TABLE_NAME, "yyy=\"2017\"", 101);
    }

    @Test(expected=MetaException.class)
    public void testListPartitionSpecsByFilterHighMaxParts() throws Exception {
        this.createTable4PartColsParts(this.client);
        this.client.listPartitionSpecsByFilter(DB_NAME, TABLE_NAME, "yyyy=\"2017\"", 101);
    }

    @Test(expected=NoSuchObjectException.class)
    public void testListPartitionSpecsByFilterNoTblName() throws Exception {
        this.createTable4PartColsParts(this.client);
        this.client.listPartitionSpecsByFilter(DB_NAME, "", "yyyy=\"2017\"", -1);
    }

    @Test(expected=NoSuchObjectException.class)
    public void testListPartitionSpecsByFilterNoDbName() throws Exception {
        this.createTable4PartColsParts(this.client);
        this.client.listPartitionSpecsByFilter("", TABLE_NAME, "yyyy=\"2017\"", -1);
    }

    @Test(expected=NoSuchObjectException.class)
    public void testListPartitionSpecsByFilterNoTable() throws Exception {
        this.client.listPartitionSpecsByFilter(DB_NAME, TABLE_NAME, "yyyy=\"2017\"", -1);
    }

    @Test(expected=NoSuchObjectException.class)
    public void testListPartitionSpecsByFilterNoDb() throws Exception {
        this.client.dropDatabase(DB_NAME);
        this.client.listPartitionSpecsByFilter(DB_NAME, TABLE_NAME, "yyyy=\"2017\"", -1);
    }

    @Test(expected=MetaException.class)
    public void testListPartitionSpecsByFilterNullTblName() throws Exception {
        this.createTable4PartColsParts(this.client);
        this.client.listPartitionSpecsByFilter(DB_NAME, null, "yyyy=\"2017\"", -1);
    }

    @Test(expected=MetaException.class)
    public void testListPartitionSpecsByFilterNullDbName() throws Exception {
        this.createTable4PartColsParts(this.client);
        this.client.listPartitionSpecsByFilter(null, TABLE_NAME, "yyyy=\"2017\"", -1);
    }

    @Test
    public void testListPartitionSpecsByFilterNullFilter() throws Exception {
        List<List<String>> values = this.createTable4PartColsParts(this.client);
        PartitionSpecProxy pproxy = this.client.listPartitionSpecsByFilter(DB_NAME, TABLE_NAME, null, -1);
        TestListPartitions.assertPartitionsSpecProxy(pproxy, values);
    }

    @Test
    public void testListPartitionSpecsByFilterEmptyFilter() throws Exception {
        List<List<String>> values = this.createTable4PartColsParts(this.client);
        PartitionSpecProxy pproxy = this.client.listPartitionSpecsByFilter(DB_NAME, TABLE_NAME, "", -1);
        TestListPartitions.assertPartitionsSpecProxy(pproxy, values);
    }

    @Test
    public void testGetNumPartitionsByFilter() throws Exception {
        this.createTable4PartColsParts(this.client);
        int n = this.client.getNumPartitionsByFilter(DB_NAME, TABLE_NAME, "yyyy=\"2017\" OR mm=\"02\"");
        Assert.assertEquals((long)3L, (long)n);
        n = this.client.getNumPartitionsByFilter(DB_NAME, TABLE_NAME, "");
        Assert.assertEquals((long)4L, (long)n);
        n = this.client.getNumPartitionsByFilter(DB_NAME, TABLE_NAME, "yyyy=\"20177\"");
        Assert.assertEquals((long)0L, (long)n);
        if (MetastoreConf.getBoolVar((Configuration)this.metaStore.getConf(), (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TRY_DIRECT_SQL)) {
            n = this.client.getNumPartitionsByFilter(DB_NAME, TABLE_NAME, "yYyY=\"2017\"");
            Assert.assertEquals((long)2L, (long)n);
        }
        n = this.client.getNumPartitionsByFilter(DB_NAME, TABLE_NAME, "yyyy=\"2017\" AND mm=\"99\"");
        Assert.assertEquals((long)0L, (long)n);
    }

    @Test(expected=MetaException.class)
    public void testGetNumPartitionsByFilterInvalidFilter() throws Exception {
        this.createTable4PartColsParts(this.client);
        this.client.getNumPartitionsByFilter(DB_NAME, TABLE_NAME, "yyy=\"2017\"");
    }

    @Test(expected=NoSuchObjectException.class)
    public void testGetNumPartitionsByFilterNoTblName() throws Exception {
        this.createTable4PartColsParts(this.client);
        this.client.getNumPartitionsByFilter(DB_NAME, "", "yyyy=\"2017\"");
    }

    @Test(expected=NoSuchObjectException.class)
    public void testGetNumPartitionsByFilterNoDbName() throws Exception {
        this.createTable4PartColsParts(this.client);
        this.client.getNumPartitionsByFilter("", TABLE_NAME, "yyyy=\"2017\"");
    }

    @Test(expected=NoSuchObjectException.class)
    public void testGetNumPartitionsByFilterNoTable() throws Exception {
        this.client.getNumPartitionsByFilter(DB_NAME, TABLE_NAME, "yyyy=\"2017\"");
    }

    @Test(expected=NoSuchObjectException.class)
    public void testGetNumPartitionsByFilterNoDb() throws Exception {
        this.client.dropDatabase(DB_NAME);
        this.client.getNumPartitionsByFilter(DB_NAME, TABLE_NAME, "yyyy=\"2017\"");
    }

    @Test
    public void testGetNumPartitionsByFilterNullTblName() throws Exception {
        try {
            this.createTable4PartColsParts(this.client);
            this.client.getNumPartitionsByFilter(DB_NAME, null, "yyyy=\"2017\"");
            Assert.fail((String)"Should have thrown exception");
        }
        catch (MetaException | TTransportException throwable) {
            // empty catch block
        }
    }

    @Test(expected=MetaException.class)
    public void testGetNumPartitionsByFilterNullDbName() throws Exception {
        this.createTable4PartColsParts(this.client);
        this.client.getNumPartitionsByFilter(null, TABLE_NAME, "yyyy=\"2017\"");
    }

    @Test
    public void testGetNumPartitionsByFilterNullFilter() throws Exception {
        this.createTable4PartColsParts(this.client);
        int n = this.client.getNumPartitionsByFilter(DB_NAME, TABLE_NAME, null);
        Assert.assertEquals((long)4L, (long)n);
    }

    @Test
    public void testListPartitionNames() throws Exception {
        List<List<String>> testValues = this.createTable4PartColsParts(this.client);
        List partitionNames = this.client.listPartitionNames(DB_NAME, TABLE_NAME, (short)-1);
        TestListPartitions.assertCorrectPartitionNames(partitionNames, testValues, Lists.newArrayList((Object[])new String[]{"yyyy", "mm", "dd"}));
        partitionNames = this.client.listPartitionNames(DB_NAME, TABLE_NAME, (short)2);
        TestListPartitions.assertCorrectPartitionNames(partitionNames, testValues.subList(0, 2), Lists.newArrayList((Object[])new String[]{"yyyy", "mm", "dd"}));
        partitionNames = this.client.listPartitionNames(DB_NAME, TABLE_NAME, (short)0);
        TestCase.assertTrue((boolean)partitionNames.isEmpty());
        partitionNames = this.client.listPartitionNames(DB_NAME, TABLE_NAME, (short)101);
        TestListPartitions.assertCorrectPartitionNames(partitionNames, testValues, Lists.newArrayList((Object[])new String[]{"yyyy", "mm", "dd"}));
    }

    @Test(expected=NoSuchObjectException.class)
    public void testListPartitionNamesNoDbName() throws Exception {
        this.createTable4PartColsParts(this.client);
        this.client.listPartitionNames("", TABLE_NAME, (short)-1);
    }

    @Test(expected=NoSuchObjectException.class)
    public void testListPartitionNamesNoTblName() throws Exception {
        this.createTable4PartColsParts(this.client);
        this.client.listPartitionNames(DB_NAME, "", (short)-1);
    }

    @Test(expected=NoSuchObjectException.class)
    public void testListPartitionNamesNoTable() throws Exception {
        this.client.listPartitionNames(DB_NAME, TABLE_NAME, (short)-1);
    }

    @Test(expected=NoSuchObjectException.class)
    public void testListPartitionNamesNoDb() throws Exception {
        this.client.dropDatabase(DB_NAME);
        this.client.listPartitionNames(DB_NAME, TABLE_NAME, (short)-1);
    }

    @Test
    public void testListPartitionNamesNullDbName() throws Exception {
        try {
            this.createTable4PartColsParts(this.client);
            this.client.listPartitionNames(null, TABLE_NAME, (short)-1);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (NullPointerException | TTransportException throwable) {
            // empty catch block
        }
    }

    @Test
    public void testListPartitionNamesNullTblName() throws Exception {
        try {
            this.createTable4PartColsParts(this.client);
            this.client.listPartitionNames(DB_NAME, (String)null, (short)-1);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (NullPointerException | TTransportException throwable) {
            // empty catch block
        }
    }

    @Test
    public void testListPartitionNamesByValues() throws Exception {
        List<List<String>> testValues = this.createTable4PartColsParts(this.client);
        List partitionNames = this.client.listPartitionNames(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{"2017"}), (short)-1);
        TestListPartitions.assertCorrectPartitionNames(partitionNames, testValues.subList(2, 4), Lists.newArrayList((Object[])new String[]{"yyyy", "mm", "dd"}));
        partitionNames = this.client.listPartitionNames(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{"2017"}), (short)101);
        TestListPartitions.assertCorrectPartitionNames(partitionNames, testValues.subList(2, 4), Lists.newArrayList((Object[])new String[]{"yyyy", "mm", "dd"}));
        partitionNames = this.client.listPartitionNames(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{"2017"}), (short)1);
        TestListPartitions.assertCorrectPartitionNames(partitionNames, testValues.subList(2, 3), Lists.newArrayList((Object[])new String[]{"yyyy", "mm", "dd"}));
        partitionNames = this.client.listPartitionNames(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{"2017"}), (short)0);
        TestCase.assertTrue((boolean)partitionNames.isEmpty());
        partitionNames = this.client.listPartitionNames(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{"2017", "10"}), (short)-1);
        TestListPartitions.assertCorrectPartitionNames(partitionNames, testValues.subList(2, 3), Lists.newArrayList((Object[])new String[]{"yyyy", "mm", "dd"}));
    }

    @Test
    public void testListPartitionNamesByValuesMaxPartCountUnlimited() throws Exception {
        List<List<String>> testValues = this.createTable4PartColsParts(this.client);
        List partitionNames = this.client.listPartitionNames(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{"2017"}), (short)101);
        TestListPartitions.assertCorrectPartitionNames(partitionNames, testValues.subList(2, 4), Lists.newArrayList((Object[])new String[]{"yyyy", "mm", "dd"}));
    }

    @Test(expected=MetaException.class)
    public void testListPartitionNamesByValuesNoPartVals() throws Exception {
        this.createTable4PartColsParts(this.client);
        this.client.listPartitionNames(DB_NAME, TABLE_NAME, (List)Lists.newArrayList(), (short)-1);
    }

    @Test(expected=MetaException.class)
    public void testListPartitionNamesByValuesTooManyVals() throws Exception {
        this.createTable4PartColsParts(this.client);
        this.client.listPartitionNames(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{"1", "2", "3", "4"}), (short)-1);
    }

    @Test(expected=NoSuchObjectException.class)
    public void testListPartitionNamesByValuesNoDbName() throws Exception {
        this.createTable4PartColsParts(this.client);
        this.client.listPartitionNames("", TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{"2017"}), (short)-1);
    }

    @Test(expected=NoSuchObjectException.class)
    public void testListPartitionNamesByValuesNoTblName() throws Exception {
        this.createTable4PartColsParts(this.client);
        this.client.listPartitionNames(DB_NAME, "", (List)Lists.newArrayList((Object[])new String[]{"2017"}), (short)-1);
    }

    @Test(expected=NoSuchObjectException.class)
    public void testListPartitionNamesByValuesNoTable() throws Exception {
        this.client.listPartitionNames(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{"2017"}), (short)-1);
    }

    @Test(expected=NoSuchObjectException.class)
    public void testListPartitionNamesByValuesNoDb() throws Exception {
        this.client.dropDatabase(DB_NAME);
        this.client.listPartitionNames(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{"2017"}), (short)-1);
    }

    @Test
    public void testListPartitionNamesByValuesNullDbName() throws Exception {
        try {
            this.createTable4PartColsParts(this.client);
            this.client.listPartitionNames(null, TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{"2017"}), (short)-1);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (NullPointerException | TTransportException throwable) {
            // empty catch block
        }
    }

    @Test
    public void testListPartitionNamesByValuesNullTblName() throws Exception {
        try {
            this.createTable4PartColsParts(this.client);
            this.client.listPartitionNames(DB_NAME, null, (List)Lists.newArrayList((Object[])new String[]{"2017"}), (short)-1);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (NullPointerException | TTransportException throwable) {
            // empty catch block
        }
    }

    @Test(expected=MetaException.class)
    public void testListPartitionNamesByValuesNullValues() throws Exception {
        this.createTable4PartColsParts(this.client);
        this.client.listPartitionNames(DB_NAME, TABLE_NAME, (List)null, (short)-1);
    }

    @Test
    public void testListPartitionValues() throws Exception {
        List<List<String>> testValues = this.createTable4PartColsParts(this.client);
        ArrayList partitionSchema = Lists.newArrayList((Object[])new FieldSchema[]{new FieldSchema("yyyy", "string", ""), new FieldSchema("mm", "string", "")});
        PartitionValuesRequest request = new PartitionValuesRequest(DB_NAME, TABLE_NAME, (List)partitionSchema);
        PartitionValuesResponse response = this.client.listPartitionValues(request);
        TestListPartitions.assertCorrectPartitionValuesResponse(testValues, response);
    }

    @Test
    public void testListPartitionValuesEmptySchema() throws Exception {
        try {
            List<List<String>> testValues = this.createTable4PartColsParts(this.client);
            ArrayList partitionSchema = Lists.newArrayList();
            PartitionValuesRequest request = new PartitionValuesRequest(DB_NAME, TABLE_NAME, (List)partitionSchema);
            this.client.listPartitionValues(request);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (IndexOutOfBoundsException | TTransportException throwable) {
            // empty catch block
        }
    }

    @Test(expected=NoSuchObjectException.class)
    public void testListPartitionValuesNoDbName() throws Exception {
        this.createTable4PartColsParts(this.client);
        ArrayList partitionSchema = Lists.newArrayList((Object[])new FieldSchema[]{new FieldSchema("yyyy", "string", ""), new FieldSchema("mm", "string", "")});
        PartitionValuesRequest request = new PartitionValuesRequest("", TABLE_NAME, (List)partitionSchema);
        this.client.listPartitionValues(request);
    }

    @Test(expected=NoSuchObjectException.class)
    public void testListPartitionValuesNoTblName() throws Exception {
        this.createTable4PartColsParts(this.client);
        ArrayList partitionSchema = Lists.newArrayList((Object[])new FieldSchema[]{new FieldSchema("yyyy", "string", ""), new FieldSchema("mm", "string", "")});
        PartitionValuesRequest request = new PartitionValuesRequest(DB_NAME, "", (List)partitionSchema);
        this.client.listPartitionValues(request);
    }

    @Test(expected=MetaException.class)
    public void testListPartitionValuesNoTable() throws Exception {
        ArrayList partitionSchema = Lists.newArrayList((Object[])new FieldSchema[]{new FieldSchema("yyyy", "string", ""), new FieldSchema("mm", "string", "")});
        PartitionValuesRequest request = new PartitionValuesRequest(DB_NAME, TABLE_NAME, (List)partitionSchema);
        this.client.listPartitionValues(request);
    }

    @Test(expected=MetaException.class)
    public void testListPartitionValuesNoDb() throws Exception {
        this.client.dropDatabase(DB_NAME);
        ArrayList partitionSchema = Lists.newArrayList((Object[])new FieldSchema[]{new FieldSchema("yyyy", "string", ""), new FieldSchema("mm", "string", "")});
        PartitionValuesRequest request = new PartitionValuesRequest(DB_NAME, TABLE_NAME, (List)partitionSchema);
        this.client.listPartitionValues(request);
    }

    @Test
    public void testListPartitionValuesNullDbName() throws Exception {
        try {
            this.createTable4PartColsParts(this.client);
            ArrayList partitionSchema = Lists.newArrayList((Object[])new FieldSchema[]{new FieldSchema("yyyy", "string", ""), new FieldSchema("mm", "string", "")});
            PartitionValuesRequest request = new PartitionValuesRequest(null, TABLE_NAME, (List)partitionSchema);
            this.client.listPartitionValues(request);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (NullPointerException | TProtocolException throwable) {
            // empty catch block
        }
    }

    @Test
    public void testListPartitionValuesNullTblName() throws Exception {
        try {
            this.createTable4PartColsParts(this.client);
            ArrayList partitionSchema = Lists.newArrayList((Object[])new FieldSchema[]{new FieldSchema("yyyy", "string", ""), new FieldSchema("mm", "string", "")});
            PartitionValuesRequest request = new PartitionValuesRequest(DB_NAME, null, (List)partitionSchema);
            this.client.listPartitionValues(request);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (NullPointerException | TProtocolException throwable) {
            // empty catch block
        }
    }

    @Test
    public void testListPartitionValuesNullSchema() throws Exception {
        try {
            this.createTable4PartColsParts(this.client);
            PartitionValuesRequest request = new PartitionValuesRequest(DB_NAME, TABLE_NAME, null);
            this.client.listPartitionValues(request);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (NullPointerException | TProtocolException throwable) {
            // empty catch block
        }
    }

    @Test
    public void testListPartitionValuesNullRequest() throws Exception {
        try {
            this.createTable4PartColsParts(this.client);
            this.client.listPartitionValues(null);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (NullPointerException | TTransportException throwable) {
            // empty catch block
        }
    }

    @Test
    public void otherCatalog() throws TException {
        String catName = "list_partition_catalog";
        Catalog cat = new CatalogBuilder().setName(catName).setLocation(MetaStoreTestUtils.getTestWarehouseDir(catName)).build();
        this.client.createCatalog(cat);
        String dbName = "list_partition_database_in_other_catalog";
        Database db = new DatabaseBuilder().setName(dbName).setCatalogName(catName).create(this.client, this.metaStore.getConf());
        String tableName = "table_in_other_catalog";
        Table table = ((TableBuilder)((TableBuilder)new TableBuilder().inDb(db).setTableName(tableName).addCol("id", "int")).addCol("name", "string")).addPartCol("partcol", "string").create(this.client, this.metaStore.getConf());
        Partition[] parts = new Partition[5];
        for (int i = 0; i < parts.length; ++i) {
            parts[i] = new PartitionBuilder().inTable(table).addValue("a" + i).build(this.metaStore.getConf());
        }
        this.client.add_partitions(Arrays.asList(parts));
        List fetched = this.client.listPartitions(catName, dbName, tableName, -1);
        Assert.assertEquals((long)parts.length, (long)fetched.size());
        Assert.assertEquals((Object)catName, (Object)((Partition)fetched.get(0)).getCatName());
        fetched = this.client.listPartitions(catName, dbName, tableName, Collections.singletonList("a0"), -1);
        Assert.assertEquals((long)1L, (long)fetched.size());
        Assert.assertEquals((Object)catName, (Object)((Partition)fetched.get(0)).getCatName());
        PartitionSpecProxy proxy = this.client.listPartitionSpecs(catName, dbName, tableName, -1);
        Assert.assertEquals((long)parts.length, (long)proxy.size());
        Assert.assertEquals((Object)catName, (Object)proxy.getCatName());
        fetched = this.client.listPartitionsByFilter(catName, dbName, tableName, "partcol=\"a0\"", -1);
        Assert.assertEquals((long)1L, (long)fetched.size());
        Assert.assertEquals((Object)catName, (Object)((Partition)fetched.get(0)).getCatName());
        proxy = this.client.listPartitionSpecsByFilter(catName, dbName, tableName, "partcol=\"a0\"", -1);
        Assert.assertEquals((long)1L, (long)proxy.size());
        Assert.assertEquals((Object)catName, (Object)proxy.getCatName());
        Assert.assertEquals((long)1L, (long)this.client.getNumPartitionsByFilter(catName, dbName, tableName, "partcol=\"a0\""));
        List names = this.client.listPartitionNames(catName, dbName, tableName, 57);
        Assert.assertEquals((long)parts.length, (long)names.size());
        names = this.client.listPartitionNames(catName, dbName, tableName, Collections.singletonList("a0"), 32768);
        Assert.assertEquals((long)1L, (long)names.size());
        PartitionValuesRequest rqst = new PartitionValuesRequest(dbName, tableName, (List)Lists.newArrayList((Object[])new FieldSchema[]{new FieldSchema("partcol", "string", "")}));
        rqst.setCatName(catName);
        PartitionValuesResponse rsp = this.client.listPartitionValues(rqst);
        Assert.assertEquals((long)5L, (long)rsp.getPartitionValuesSize());
    }

    @Test(expected=NoSuchObjectException.class)
    public void listPartitionsBogusCatalog() throws TException {
        this.createTable3PartCols1Part(this.client);
        this.client.listPartitions("bogus", DB_NAME, TABLE_NAME, -1);
    }

    @Test(expected=NoSuchObjectException.class)
    public void listPartitionsWithPartialValuesBogusCatalog() throws TException {
        this.createTable3PartCols1Part(this.client);
        this.client.listPartitions("bogus", DB_NAME, TABLE_NAME, Collections.singletonList("a0"), -1);
    }

    @Test(expected=NoSuchObjectException.class)
    public void listPartitionsSpecsBogusCatalog() throws TException {
        this.createTable3PartCols1Part(this.client);
        this.client.listPartitionSpecs("bogus", DB_NAME, TABLE_NAME, -1);
    }

    @Test(expected=NoSuchObjectException.class)
    public void listPartitionsByFilterBogusCatalog() throws TException {
        this.createTable3PartCols1Part(this.client);
        this.client.listPartitionsByFilter("bogus", DB_NAME, TABLE_NAME, "partcol=\"a0\"", -1);
    }

    @Test(expected=NoSuchObjectException.class)
    public void listPartitionSpecsByFilterBogusCatalog() throws TException {
        this.createTable3PartCols1Part(this.client);
        this.client.listPartitionSpecsByFilter("bogus", DB_NAME, TABLE_NAME, "partcol=\"a0\"", -1);
    }

    @Test(expected=NoSuchObjectException.class)
    public void getNumPartitionsByFilterBogusCatalog() throws TException {
        this.createTable3PartCols1Part(this.client);
        this.client.getNumPartitionsByFilter("bogus", DB_NAME, TABLE_NAME, "partcol=\"a0\"");
    }

    @Test(expected=NoSuchObjectException.class)
    public void listPartitionNamesBogusCatalog() throws TException {
        this.createTable3PartCols1Part(this.client);
        this.client.listPartitionNames("bogus", DB_NAME, TABLE_NAME, -1);
    }

    @Test(expected=NoSuchObjectException.class)
    public void listPartitionNamesPartialValsBogusCatalog() throws TException {
        this.createTable3PartCols1Part(this.client);
        this.client.listPartitionNames("bogus", DB_NAME, TABLE_NAME, Collections.singletonList("a0"), -1);
    }

    @Test(expected=MetaException.class)
    public void listPartitionValuesBogusCatalog() throws TException {
        this.createTable3PartCols1Part(this.client);
        PartitionValuesRequest rqst = new PartitionValuesRequest(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new FieldSchema[]{new FieldSchema("partcol", "string", "")}));
        rqst.setCatName("bogus");
        this.client.listPartitionValues(rqst);
    }
}

