/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.client.builder;

import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.ISchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.SchemaCompatibility;
import org.apache.hadoop.hive.metastore.api.SchemaType;
import org.apache.hadoop.hive.metastore.api.SchemaValidation;

public class ISchemaBuilder {
    private SchemaType schemaType;
    private String name;
    private String dbName = "default";
    private String catName = "hive";
    private SchemaCompatibility compatibility = SchemaCompatibility.BACKWARD;
    private SchemaValidation validationLevel = SchemaValidation.ALL;
    private boolean canEvolve = true;
    private String schemaGroup;
    private String description;

    public ISchemaBuilder setSchemaType(SchemaType schemaType) {
        this.schemaType = schemaType;
        return this;
    }

    public ISchemaBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public ISchemaBuilder setDbName(String dbName) {
        this.dbName = dbName;
        return this;
    }

    public ISchemaBuilder inDb(Database db) {
        this.catName = db.getCatalogName();
        this.dbName = db.getName();
        return this;
    }

    public ISchemaBuilder setCompatibility(SchemaCompatibility compatibility) {
        this.compatibility = compatibility;
        return this;
    }

    public ISchemaBuilder setValidationLevel(SchemaValidation validationLevel) {
        this.validationLevel = validationLevel;
        return this;
    }

    public ISchemaBuilder setCanEvolve(boolean canEvolve) {
        this.canEvolve = canEvolve;
        return this;
    }

    public ISchemaBuilder setSchemaGroup(String schemaGroup) {
        this.schemaGroup = schemaGroup;
        return this;
    }

    public ISchemaBuilder setDescription(String description) {
        this.description = description;
        return this;
    }

    public ISchema build() throws MetaException {
        if (this.schemaType == null || this.name == null) {
            throw new MetaException("You must provide a schemaType and name");
        }
        ISchema iSchema = new ISchema(this.schemaType, this.name, this.catName, this.dbName, this.compatibility, this.validationLevel, this.canEvolve);
        if (this.schemaGroup != null) {
            iSchema.setSchemaGroup(this.schemaGroup);
        }
        if (this.description != null) {
            iSchema.setDescription(this.description);
        }
        return iSchema;
    }
}

