/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import com.google.common.collect.Lists;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.jdo.PersistenceManager;
import javax.jdo.Query;
import javax.jdo.Transaction;
import javax.jdo.datastore.JDOConnection;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.AggregateStatsCache;
import org.apache.hadoop.hive.metastore.ColumnType;
import org.apache.hadoop.hive.metastore.DatabaseProduct;
import org.apache.hadoop.hive.metastore.Deadline;
import org.apache.hadoop.hive.metastore.IExtrapolatePartStatus;
import org.apache.hadoop.hive.metastore.LinearExtrapolatePartStatus;
import org.apache.hadoop.hive.metastore.StatObjectConverter;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.AggrStats;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsDesc;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.SQLCheckConstraint;
import org.apache.hadoop.hive.metastore.api.SQLDefaultConstraint;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLNotNullConstraint;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.metastore.api.SQLUniqueConstraint;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.SkewedInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.model.MConstraint;
import org.apache.hadoop.hive.metastore.model.MCreationMetadata;
import org.apache.hadoop.hive.metastore.model.MDatabase;
import org.apache.hadoop.hive.metastore.model.MNotificationLog;
import org.apache.hadoop.hive.metastore.model.MNotificationNextId;
import org.apache.hadoop.hive.metastore.model.MPartitionColumnStatistics;
import org.apache.hadoop.hive.metastore.model.MTableColumnStatistics;
import org.apache.hadoop.hive.metastore.model.MWMResourcePlan;
import org.apache.hadoop.hive.metastore.parser.ExpressionTree;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hive.common.util.BloomFilter;
import org.datanucleus.store.rdbms.query.ForwardQueryResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MetaStoreDirectSql {
    private static final int NO_BATCHING = -1;
    private static final int DETECT_BATCHING = 0;
    private static final Logger LOG = LoggerFactory.getLogger(MetaStoreDirectSql.class);
    private final PersistenceManager pm;
    private final String schema;
    private final DatabaseProduct dbType;
    private final int batchSize;
    private final boolean convertMapNullsToEmptyStrings;
    private final String defaultPartName;
    private final boolean isCompatibleDatastore;
    private final boolean isAggregateStatsCacheEnabled;
    private AggregateStatsCache aggrStatsCache;
    @TableName
    private String DBS;
    @TableName
    private String TBLS;
    @TableName
    private String PARTITIONS;
    @TableName
    private String DATABASE_PARAMS;
    @TableName
    private String PARTITION_PARAMS;
    @TableName
    private String SORT_COLS;
    @TableName
    private String SD_PARAMS;
    @TableName
    private String SDS;
    @TableName
    private String SERDES;
    @TableName
    private String SKEWED_STRING_LIST_VALUES;
    @TableName
    private String SKEWED_VALUES;
    @TableName
    private String BUCKETING_COLS;
    @TableName
    private String SKEWED_COL_NAMES;
    @TableName
    private String SKEWED_COL_VALUE_LOC_MAP;
    @TableName
    private String COLUMNS_V2;
    @TableName
    private String PARTITION_KEYS;
    @TableName
    private String SERDE_PARAMS;
    @TableName
    private String PART_COL_STATS;
    @TableName
    private String KEY_CONSTRAINTS;
    @TableName
    private String TAB_COL_STATS;
    @TableName
    private String PARTITION_KEY_VALS;
    public static final Object[] STATS_TABLE_TYPES = new Object[]{TableType.MANAGED_TABLE.toString(), TableType.MATERIALIZED_VIEW.toString()};

    public MetaStoreDirectSql(PersistenceManager pm, Configuration conf, String schema) {
        this.pm = pm;
        this.schema = schema;
        DatabaseProduct dbType = null;
        try {
            dbType = DatabaseProduct.determineDatabaseProduct(MetaStoreDirectSql.getProductName(pm));
        }
        catch (SQLException e) {
            LOG.warn("Cannot determine database product; assuming OTHER", (Throwable)e);
            dbType = DatabaseProduct.OTHER;
        }
        this.dbType = dbType;
        int batchSize = MetastoreConf.getIntVar(conf, MetastoreConf.ConfVars.DIRECT_SQL_PARTITION_BATCH_SIZE);
        if (batchSize == 0) {
            batchSize = DatabaseProduct.needsInBatching(dbType) ? 1000 : -1;
        }
        this.batchSize = batchSize;
        for (Field f : this.getClass().getDeclaredFields()) {
            if (f.getAnnotation(TableName.class) == null) continue;
            try {
                f.set(this, MetaStoreDirectSql.getFullyQualifiedName(schema, f.getName()));
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new RuntimeException("Internal error, cannot set " + f.getName());
            }
        }
        this.convertMapNullsToEmptyStrings = MetastoreConf.getBoolVar(conf, MetastoreConf.ConfVars.ORM_RETRIEVE_MAPNULLS_AS_EMPTY_STRINGS);
        this.defaultPartName = MetastoreConf.getVar(conf, MetastoreConf.ConfVars.DEFAULTPARTITIONNAME);
        String jdoIdFactory = MetastoreConf.getVar(conf, MetastoreConf.ConfVars.IDENTIFIER_FACTORY);
        if (!"datanucleus1".equalsIgnoreCase(jdoIdFactory)) {
            LOG.warn("Underlying metastore does not use 'datanucleus1' for its ORM naming scheme. Disabling directSQL as it uses hand-hardcoded SQL with that assumption.");
            this.isCompatibleDatastore = false;
        } else {
            boolean isInTest = MetastoreConf.getBoolVar(conf, MetastoreConf.ConfVars.HIVE_IN_TEST);
            boolean bl = this.isCompatibleDatastore = (!isInTest || this.ensureDbInit()) && this.runTestQuery();
            if (this.isCompatibleDatastore) {
                LOG.info("Using direct SQL, underlying DB is " + dbType);
            }
        }
        this.isAggregateStatsCacheEnabled = MetastoreConf.getBoolVar(conf, MetastoreConf.ConfVars.AGGREGATE_STATS_CACHE_ENABLED);
        if (this.isAggregateStatsCacheEnabled) {
            this.aggrStatsCache = AggregateStatsCache.getInstance(conf);
        }
    }

    private static String getFullyQualifiedName(String schema, String tblName) {
        return (String)(schema == null || schema.isEmpty() ? "" : "\"" + schema + "\".\"") + "\"" + tblName + "\"";
    }

    public MetaStoreDirectSql(PersistenceManager pm, Configuration conf) {
        this(pm, conf, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getProductName(PersistenceManager pm) {
        try (JDOConnection jdoConn = pm.getDataStoreConnection();){
            String string = ((Connection)jdoConn.getNativeConnection()).getMetaData().getDatabaseProductName();
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean ensureDbInit() {
        Transaction tx = this.pm.currentTransaction();
        boolean doCommit = false;
        if (!tx.isActive()) {
            tx.begin();
            doCommit = true;
        }
        LinkedList<Query> initQueries = new LinkedList<Query>();
        try {
            Query q;
            initQueries.add(this.pm.newQuery(MDatabase.class, "name == ''"));
            initQueries.add(this.pm.newQuery(MTableColumnStatistics.class, "dbName == ''"));
            initQueries.add(this.pm.newQuery(MPartitionColumnStatistics.class, "dbName == ''"));
            initQueries.add(this.pm.newQuery(MConstraint.class, "childIntegerIndex < 0"));
            initQueries.add(this.pm.newQuery(MNotificationLog.class, "dbName == ''"));
            initQueries.add(this.pm.newQuery(MNotificationNextId.class, "nextEventId < -1"));
            initQueries.add(this.pm.newQuery(MWMResourcePlan.class, "name == ''"));
            initQueries.add(this.pm.newQuery(MCreationMetadata.class, "dbName == ''"));
            while ((q = (Query)initQueries.peekFirst()) != null) {
                q.execute();
                initQueries.pollFirst();
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            doCommit = false;
            LOG.warn("Database initialization failed; direct SQL is disabled", (Throwable)ex);
            tx.rollback();
            boolean bl = false;
            return bl;
        }
        finally {
            if (doCommit) {
                tx.commit();
            }
            for (Query q : initQueries) {
                try {
                    q.closeAll();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runTestQuery() {
        Transaction tx = this.pm.currentTransaction();
        boolean doCommit = false;
        if (!tx.isActive()) {
            tx.begin();
            doCommit = true;
        }
        Query query = null;
        String selfTestQuery = "select \"DB_ID\" from " + this.DBS;
        try {
            this.prepareTxn();
            query = this.pm.newQuery("javax.jdo.query.SQL", (Object)selfTestQuery);
            query.execute();
            boolean bl = true;
            return bl;
        }
        catch (Throwable t) {
            doCommit = false;
            LOG.warn("Self-test query [" + selfTestQuery + "] failed; direct SQL is disabled", t);
            tx.rollback();
            boolean bl = false;
            return bl;
        }
        finally {
            if (doCommit) {
                tx.commit();
            }
            if (query != null) {
                query.closeAll();
            }
        }
    }

    public String getSchema() {
        return this.schema;
    }

    public boolean isCompatibleDatastore() {
        return this.isCompatibleDatastore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeNoResult(String queryText) throws SQLException {
        JDOConnection jdoConn = this.pm.getDataStoreConnection();
        Statement statement = null;
        boolean doTrace = LOG.isDebugEnabled();
        try {
            long start = doTrace ? System.nanoTime() : 0L;
            statement = ((Connection)jdoConn.getNativeConnection()).createStatement();
            statement.execute(queryText);
            this.timingTrace(doTrace, queryText, start, doTrace ? System.nanoTime() : 0L);
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            jdoConn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Database getDatabase(String catName, String dbName) throws MetaException {
        Query queryDbSelector = null;
        Query queryDbParams = null;
        try {
            List sqlResult;
            dbName = dbName.toLowerCase();
            catName = catName.toLowerCase();
            String queryTextDbSelector = "select \"DB_ID\", \"NAME\", \"DB_LOCATION_URI\", \"DESC\", \"OWNER_NAME\", \"OWNER_TYPE\", \"CTLG_NAME\" FROM " + this.DBS + " where \"NAME\" = ? and \"CTLG_NAME\" = ? ";
            Object[] params = new Object[]{dbName, catName};
            queryDbSelector = this.pm.newQuery("javax.jdo.query.SQL", (Object)queryTextDbSelector);
            if (LOG.isTraceEnabled()) {
                LOG.trace("getDatabase:query instantiated : " + queryTextDbSelector + " with param [" + params[0] + "]");
            }
            if ((sqlResult = (List)this.executeWithArray(queryDbSelector, params, queryTextDbSelector)) == null || sqlResult.isEmpty()) {
                Database database = null;
                return database;
            }
            assert (sqlResult.size() == 1);
            if (sqlResult.get(0) == null) {
                Database database = null;
                return database;
            }
            Object[] dbline = (Object[])sqlResult.get(0);
            Long dbid = MetaStoreDirectSql.extractSqlLong(dbline[0]);
            String queryTextDbParams = "select \"PARAM_KEY\", \"PARAM_VALUE\"  from " + this.DATABASE_PARAMS + "  WHERE \"DB_ID\" = ?  AND \"PARAM_KEY\" IS NOT NULL";
            params[0] = dbid;
            queryDbParams = this.pm.newQuery("javax.jdo.query.SQL", (Object)queryTextDbParams);
            if (LOG.isTraceEnabled()) {
                LOG.trace("getDatabase:query2 instantiated : " + queryTextDbParams + " with param [" + params[0] + "]");
            }
            HashMap<String, String> dbParams = new HashMap<String, String>();
            List<Object[]> sqlResult2 = this.ensureList(this.executeWithArray(queryDbParams, params, queryTextDbParams));
            if (!sqlResult2.isEmpty()) {
                for (Object[] line : sqlResult2) {
                    dbParams.put(this.extractSqlString(line[0]), this.extractSqlString(line[1]));
                }
            }
            Database db = new Database();
            db.setName(this.extractSqlString(dbline[1]));
            db.setLocationUri(this.extractSqlString(dbline[2]));
            db.setDescription(this.extractSqlString(dbline[3]));
            db.setOwnerName(this.extractSqlString(dbline[4]));
            String type = this.extractSqlString(dbline[5]);
            db.setOwnerType(null == type || type.trim().isEmpty() ? null : PrincipalType.valueOf(type));
            db.setCatalogName(this.extractSqlString(dbline[6]));
            db.setParameters(MetaStoreUtils.trimMapNulls(dbParams, this.convertMapNullsToEmptyStrings));
            if (LOG.isDebugEnabled()) {
                LOG.debug("getDatabase: directsql returning db " + db.getName() + " locn[" + db.getLocationUri() + "] desc [" + db.getDescription() + "] owner [" + db.getOwnerName() + "] ownertype [" + db.getOwnerType() + "]");
            }
            Database database = db;
            return database;
        }
        finally {
            if (queryDbSelector != null) {
                queryDbSelector.closeAll();
            }
            if (queryDbParams != null) {
                queryDbParams.closeAll();
            }
        }
    }

    public List<String> getTables(String catName, String dbName, TableType tableType) throws MetaException {
        String queryText = "SELECT " + this.TBLS + ".\"TBL_NAME\" FROM " + this.TBLS + "  INNER JOIN " + this.DBS + " ON " + this.TBLS + ".\"DB_ID\" = " + this.DBS + ".\"DB_ID\"  WHERE " + this.DBS + ".\"NAME\" = ? AND " + this.DBS + ".\"CTLG_NAME\" = ? " + (String)(tableType == null ? "" : "AND " + this.TBLS + ".\"TBL_TYPE\" = ? ");
        ArrayList<String> pms = new ArrayList<String>();
        pms.add(dbName);
        pms.add(catName);
        if (tableType != null) {
            pms.add(tableType.toString());
        }
        Query queryParams = this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText);
        return (List)this.executeWithArray(queryParams, pms.toArray(), queryText);
    }

    public List<String> getMaterializedViewsForRewriting(String dbName) throws MetaException {
        String queryText = "SELECT " + this.TBLS + ".\"TBL_NAME\" FROM " + this.TBLS + "  INNER JOIN " + this.DBS + " ON " + this.TBLS + ".\"DB_ID\" = " + this.DBS + ".\"DB_ID\"  WHERE " + this.DBS + ".\"NAME\" = ? AND " + this.TBLS + ".\"TBL_TYPE\" = ? ";
        ArrayList<String> pms = new ArrayList<String>();
        pms.add(dbName);
        pms.add(TableType.MATERIALIZED_VIEW.toString());
        Query queryParams = this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText);
        return (List)this.executeWithArray(queryParams, pms.toArray(), queryText);
    }

    public List<Partition> getPartitionsViaSqlFilter(final String catName, final String dbName, final String tblName, List<String> partNames) throws MetaException {
        if (partNames.isEmpty()) {
            return Collections.emptyList();
        }
        return this.runBatched(partNames, new Batchable<String, Partition>(){

            @Override
            public List<Partition> run(List<String> input) throws MetaException {
                String filter = MetaStoreDirectSql.this.PARTITIONS + ".\"PART_NAME\" in (" + MetaStoreDirectSql.this.makeParams(input.size()) + ")";
                return MetaStoreDirectSql.this.getPartitionsViaSqlFilterInternal(catName, dbName, tblName, null, filter, input, Collections.emptyList(), null);
            }
        });
    }

    public List<Partition> getPartitionsViaSqlFilter(SqlFilterForPushdown filter, Integer max) throws MetaException {
        Boolean isViewTable = MetaStoreDirectSql.isViewTable(filter.table);
        String catName = filter.table.isSetCatName() ? filter.table.getCatName() : "hive";
        return this.getPartitionsViaSqlFilterInternal(catName, filter.table.getDbName(), filter.table.getTableName(), isViewTable, filter.filter, filter.params, filter.joins, max);
    }

    public boolean generateSqlFilterForPushdown(Table table, ExpressionTree tree, SqlFilterForPushdown result) throws MetaException {
        boolean dbHasJoinCastBug = DatabaseProduct.hasJoinOperationOrderBug(this.dbType);
        result.table = table;
        result.filter = PartitionFilterGenerator.generateSqlFilter(table, tree, result.params, result.joins, dbHasJoinCastBug, this.defaultPartName, this.dbType, this.schema);
        return result.filter != null;
    }

    public List<Partition> getPartitions(String catName, String dbName, String tblName, Integer max) throws MetaException {
        return this.getPartitionsViaSqlFilterInternal(catName, dbName, tblName, null, null, Collections.emptyList(), Collections.emptyList(), max);
    }

    private static Boolean isViewTable(Table t) {
        return t.isSetTableType() ? Boolean.valueOf(t.getTableType().equals(TableType.VIRTUAL_VIEW.toString())) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isViewTable(String catName, String dbName, String tblName) throws MetaException {
        Query query = null;
        try {
            String queryText = "select \"TBL_TYPE\" from " + this.TBLS + " inner join " + this.DBS + " on " + this.TBLS + ".\"DB_ID\" = " + this.DBS + ".\"DB_ID\"  where " + this.TBLS + ".\"TBL_NAME\" = ? and " + this.DBS + ".\"NAME\" = ? and " + this.DBS + ".\"CTLG_NAME\" = ?";
            Object[] params = new Object[]{tblName, dbName, catName};
            query = this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText);
            query.setUnique(true);
            Object result = this.executeWithArray(query, params, queryText);
            boolean bl = result != null && result.toString().equals(TableType.VIRTUAL_VIEW.toString());
            return bl;
        }
        finally {
            if (query != null) {
                query.closeAll();
            }
        }
    }

    private List<Partition> getPartitionsViaSqlFilterInternal(String catName, String dbName, String tblName, final Boolean isView, String sqlFilter, List<? extends Object> paramsForFilter, List<String> joinsForFilter, Integer max) throws MetaException {
        boolean doTrace = LOG.isDebugEnabled();
        final String dbNameLcase = dbName.toLowerCase();
        final String tblNameLcase = tblName.toLowerCase();
        final String catNameLcase = StringUtils.normalizeSpace((String)catName);
        String orderForFilter = max != null ? " order by \"PART_NAME\" asc" : "";
        String queryText = "select " + this.PARTITIONS + ".\"PART_ID\" from " + this.PARTITIONS + "  inner join " + this.TBLS + " on " + this.PARTITIONS + ".\"TBL_ID\" = " + this.TBLS + ".\"TBL_ID\"     and " + this.TBLS + ".\"TBL_NAME\" = ?   inner join " + this.DBS + " on " + this.TBLS + ".\"DB_ID\" = " + this.DBS + ".\"DB_ID\"      and " + this.DBS + ".\"NAME\" = ? " + StringUtils.join(joinsForFilter, (char)' ') + " where " + this.DBS + ".\"CTLG_NAME\" = ? " + (String)(StringUtils.isBlank((String)sqlFilter) ? "" : " and " + sqlFilter) + orderForFilter;
        Object[] params = new Object[paramsForFilter.size() + 3];
        params[0] = tblNameLcase;
        params[1] = dbNameLcase;
        params[2] = catNameLcase;
        for (int i = 0; i < paramsForFilter.size(); ++i) {
            params[i + 3] = paramsForFilter.get(i);
        }
        long start = doTrace ? System.nanoTime() : 0L;
        Query query = this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText);
        if (max != null) {
            query.setRange(0L, (long)max.shortValue());
        }
        List sqlResult = (List)this.executeWithArray(query, params, queryText);
        long queryTime = doTrace ? System.nanoTime() : 0L;
        this.timingTrace(doTrace, queryText, start, queryTime);
        if (sqlResult.isEmpty()) {
            return Collections.emptyList();
        }
        List<Partition> result = this.runBatched(sqlResult, new Batchable<Object, Partition>(){

            @Override
            public List<Partition> run(List<Object> input) throws MetaException {
                return MetaStoreDirectSql.this.getPartitionsFromPartitionIds(catNameLcase, dbNameLcase, tblNameLcase, isView, input);
            }
        });
        query.closeAll();
        return result;
    }

    private List<Partition> getPartitionsFromPartitionIds(String catName, String dbName, String tblName, Boolean isView, List<Object> partIdList) throws MetaException {
        boolean hasSkewedColumns;
        boolean doTrace = LOG.isDebugEnabled();
        int idStringWidth = (int)Math.ceil(Math.log10(partIdList.size())) + 1;
        int sbCapacity = partIdList.size() * idStringWidth;
        StringBuilder partSb = new StringBuilder(sbCapacity);
        for (Object partitionId : partIdList) {
            partSb.append(MetaStoreDirectSql.extractSqlLong(partitionId)).append(",");
        }
        String partIds = MetaStoreDirectSql.trimCommaList(partSb);
        String queryText = "select " + this.PARTITIONS + ".\"PART_ID\", " + this.SDS + ".\"SD_ID\", " + this.SDS + ".\"CD_ID\", " + this.SERDES + ".\"SERDE_ID\", " + this.PARTITIONS + ".\"CREATE_TIME\", " + this.PARTITIONS + ".\"LAST_ACCESS_TIME\", " + this.SDS + ".\"INPUT_FORMAT\", " + this.SDS + ".\"IS_COMPRESSED\", " + this.SDS + ".\"IS_STOREDASSUBDIRECTORIES\", " + this.SDS + ".\"LOCATION\", " + this.SDS + ".\"NUM_BUCKETS\", " + this.SDS + ".\"OUTPUT_FORMAT\", " + this.SERDES + ".\"NAME\", " + this.SERDES + ".\"SLIB\" from " + this.PARTITIONS + "  left outer join " + this.SDS + " on " + this.PARTITIONS + ".\"SD_ID\" = " + this.SDS + ".\"SD_ID\"   left outer join " + this.SERDES + " on " + this.SDS + ".\"SERDE_ID\" = " + this.SERDES + ".\"SERDE_ID\" where \"PART_ID\" in (" + partIds + ") order by \"PART_NAME\" asc";
        long start = doTrace ? System.nanoTime() : 0L;
        Query query = this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText);
        List sqlResult = (List)this.executeWithArray(query, null, queryText);
        long queryTime = doTrace ? System.nanoTime() : 0L;
        Deadline.checkTimeout();
        TreeMap<Long, Partition> partitions = new TreeMap<Long, Partition>();
        TreeMap<Long, StorageDescriptor> sds = new TreeMap<Long, StorageDescriptor>();
        TreeMap<Long, SerDeInfo> serdes = new TreeMap<Long, SerDeInfo>();
        TreeMap colss = new TreeMap();
        ArrayList<Partition> orderedResult = new ArrayList<Partition>(partIdList.size());
        StringBuilder sdSb = new StringBuilder(sbCapacity);
        StringBuilder serdeSb = new StringBuilder(sbCapacity);
        StringBuilder colsSb = new StringBuilder(7);
        tblName = tblName.toLowerCase();
        dbName = dbName.toLowerCase();
        catName = catName.toLowerCase();
        for (Object[] fields : sqlResult) {
            SerDeInfo serde;
            SerDeInfo oldSerde;
            long partitionId = MetaStoreDirectSql.extractSqlLong(fields[0]);
            Long sdId = MetaStoreDirectSql.extractSqlLong(fields[1]);
            Long colId = MetaStoreDirectSql.extractSqlLong(fields[2]);
            Long serdeId = MetaStoreDirectSql.extractSqlLong(fields[3]);
            if (sdId == null || serdeId == null) {
                if (isView == null) {
                    isView = this.isViewTable(catName, dbName, tblName);
                }
                if (sdId != null || colId != null || serdeId != null || !isView.booleanValue()) {
                    throw new MetaException("Unexpected null for one of the IDs, SD " + sdId + ", serde " + serdeId + " for a " + (isView != false ? "" : "non-") + " view");
                }
            }
            Partition part = new Partition();
            orderedResult.add(part);
            part.setParameters(new HashMap<String, String>());
            part.setValues(new ArrayList<String>());
            part.setCatName(catName);
            part.setDbName(dbName);
            part.setTableName(tblName);
            if (fields[4] != null) {
                part.setCreateTime(this.extractSqlInt(fields[4]));
            }
            if (fields[5] != null) {
                part.setLastAccessTime(this.extractSqlInt(fields[5]));
            }
            partitions.put(partitionId, part);
            if (sdId == null) continue;
            assert (serdeId != null);
            StorageDescriptor sd = new StorageDescriptor();
            StorageDescriptor oldSd = sds.put(sdId, sd);
            if (oldSd != null) {
                throw new MetaException("Partitions reuse SDs; we don't expect that");
            }
            sd.setSortCols(new ArrayList<Order>());
            sd.setBucketCols(new ArrayList<String>());
            sd.setParameters(new HashMap<String, String>());
            sd.setSkewedInfo(new SkewedInfo(new ArrayList<String>(), new ArrayList<List<String>>(), new HashMap<List<String>, String>()));
            sd.setInputFormat((String)fields[6]);
            Boolean tmpBoolean = MetaStoreDirectSql.extractSqlBoolean(fields[7]);
            if (tmpBoolean != null) {
                sd.setCompressed(tmpBoolean);
            }
            if ((tmpBoolean = MetaStoreDirectSql.extractSqlBoolean(fields[8])) != null) {
                sd.setStoredAsSubDirectories(tmpBoolean);
            }
            sd.setLocation((String)fields[9]);
            if (fields[10] != null) {
                sd.setNumBuckets(this.extractSqlInt(fields[10]));
            }
            sd.setOutputFormat((String)fields[11]);
            sdSb.append(sdId).append(",");
            part.setSd(sd);
            if (colId != null) {
                ArrayList cols = (ArrayList)colss.get(colId);
                if (cols == null) {
                    cols = new ArrayList();
                    colss.put(colId, cols);
                    colsSb.append(colId).append(",");
                }
                sd.setCols(cols);
            }
            if ((oldSerde = serdes.put(serdeId, serde = new SerDeInfo())) != null) {
                throw new MetaException("SDs reuse serdes; we don't expect that");
            }
            serde.setParameters(new HashMap<String, String>());
            serde.setName((String)fields[12]);
            serde.setSerializationLib((String)fields[13]);
            serdeSb.append(serdeId).append(",");
            sd.setSerdeInfo(serde);
            Deadline.checkTimeout();
        }
        query.closeAll();
        this.timingTrace(doTrace, queryText, start, queryTime);
        queryText = "select \"PART_ID\", \"PARAM_KEY\", \"PARAM_VALUE\" from " + this.PARTITION_PARAMS + " where \"PART_ID\" in (" + partIds + ") and \"PARAM_KEY\" is not null order by \"PART_ID\" asc";
        this.loopJoinOrderedResult(partitions, queryText, 0, new ApplyFunc<Partition>(){

            @Override
            public void apply(Partition t, Object[] fields) {
                t.putToParameters((String)fields[1], (String)fields[2]);
            }
        });
        for (Partition t : partitions.values()) {
            t.setParameters(MetaStoreUtils.trimMapNulls(t.getParameters(), this.convertMapNullsToEmptyStrings));
        }
        queryText = "select \"PART_ID\", \"PART_KEY_VAL\" from " + this.PARTITION_KEY_VALS + " where \"PART_ID\" in (" + partIds + ") order by \"PART_ID\" asc, \"INTEGER_IDX\" asc";
        this.loopJoinOrderedResult(partitions, queryText, 0, new ApplyFunc<Partition>(){

            @Override
            public void apply(Partition t, Object[] fields) {
                t.addToValues((String)fields[1]);
            }
        });
        if (sdSb.length() == 0) {
            assert (serdeSb.length() == 0 && colsSb.length() == 0);
            return orderedResult;
        }
        String sdIds = MetaStoreDirectSql.trimCommaList(sdSb);
        String serdeIds = MetaStoreDirectSql.trimCommaList(serdeSb);
        String colIds = MetaStoreDirectSql.trimCommaList(colsSb);
        queryText = "select \"SD_ID\", \"PARAM_KEY\", \"PARAM_VALUE\" from " + this.SD_PARAMS + " where \"SD_ID\" in (" + sdIds + ") and \"PARAM_KEY\" is not null order by \"SD_ID\" asc";
        this.loopJoinOrderedResult(sds, queryText, 0, new ApplyFunc<StorageDescriptor>(){

            @Override
            public void apply(StorageDescriptor t, Object[] fields) {
                t.putToParameters((String)fields[1], MetaStoreDirectSql.this.extractSqlClob(fields[2]));
            }
        });
        for (StorageDescriptor t : sds.values()) {
            t.setParameters(MetaStoreUtils.trimMapNulls(t.getParameters(), this.convertMapNullsToEmptyStrings));
        }
        queryText = "select \"SD_ID\", \"COLUMN_NAME\", " + this.SORT_COLS + ".\"ORDER\" from " + this.SORT_COLS + " where \"SD_ID\" in (" + sdIds + ") order by \"SD_ID\" asc, \"INTEGER_IDX\" asc";
        this.loopJoinOrderedResult(sds, queryText, 0, new ApplyFunc<StorageDescriptor>(){

            @Override
            public void apply(StorageDescriptor t, Object[] fields) {
                if (fields[2] == null) {
                    return;
                }
                t.addToSortCols(new Order((String)fields[1], MetaStoreDirectSql.this.extractSqlInt(fields[2])));
            }
        });
        queryText = "select \"SD_ID\", \"BUCKET_COL_NAME\" from " + this.BUCKETING_COLS + " where \"SD_ID\" in (" + sdIds + ") order by \"SD_ID\" asc, \"INTEGER_IDX\" asc";
        this.loopJoinOrderedResult(sds, queryText, 0, new ApplyFunc<StorageDescriptor>(){

            @Override
            public void apply(StorageDescriptor t, Object[] fields) {
                t.addToBucketCols((String)fields[1]);
            }
        });
        queryText = "select \"SD_ID\", \"SKEWED_COL_NAME\" from " + this.SKEWED_COL_NAMES + " where \"SD_ID\" in (" + sdIds + ") order by \"SD_ID\" asc, \"INTEGER_IDX\" asc";
        boolean bl = hasSkewedColumns = this.loopJoinOrderedResult(sds, queryText, 0, new ApplyFunc<StorageDescriptor>(){

            @Override
            public void apply(StorageDescriptor t, Object[] fields) {
                if (!t.isSetSkewedInfo()) {
                    t.setSkewedInfo(new SkewedInfo());
                }
                t.getSkewedInfo().addToSkewedColNames((String)fields[1]);
            }
        }) > 0;
        if (hasSkewedColumns) {
            queryText = "select " + this.SKEWED_VALUES + ".\"SD_ID_OID\",  " + this.SKEWED_STRING_LIST_VALUES + ".\"STRING_LIST_ID\",  " + this.SKEWED_STRING_LIST_VALUES + ".\"STRING_LIST_VALUE\" from " + this.SKEWED_VALUES + "   left outer join " + this.SKEWED_STRING_LIST_VALUES + " on " + this.SKEWED_VALUES + ".\"STRING_LIST_ID_EID\" = " + this.SKEWED_STRING_LIST_VALUES + ".\"STRING_LIST_ID\" where " + this.SKEWED_VALUES + ".\"SD_ID_OID\" in (" + sdIds + ")   and " + this.SKEWED_VALUES + ".\"STRING_LIST_ID_EID\" is not null   and " + this.SKEWED_VALUES + ".\"INTEGER_IDX\" >= 0 order by " + this.SKEWED_VALUES + ".\"SD_ID_OID\" asc, " + this.SKEWED_VALUES + ".\"INTEGER_IDX\" asc,  " + this.SKEWED_STRING_LIST_VALUES + ".\"INTEGER_IDX\" asc";
            this.loopJoinOrderedResult(sds, queryText, 0, new ApplyFunc<StorageDescriptor>(){
                private Long currentListId;
                private List<String> currentList;

                @Override
                public void apply(StorageDescriptor t, Object[] fields) throws MetaException {
                    if (!t.isSetSkewedInfo()) {
                        t.setSkewedInfo(new SkewedInfo());
                    }
                    if (fields[1] == null) {
                        this.currentList = null;
                        this.currentListId = null;
                        t.getSkewedInfo().addToSkewedColValues(Collections.emptyList());
                    } else {
                        long fieldsListId = MetaStoreDirectSql.extractSqlLong(fields[1]);
                        if (this.currentListId == null || fieldsListId != this.currentListId) {
                            this.currentList = new ArrayList<String>();
                            this.currentListId = fieldsListId;
                            t.getSkewedInfo().addToSkewedColValues(this.currentList);
                        }
                        this.currentList.add((String)fields[2]);
                    }
                }
            });
            queryText = "select " + this.SKEWED_COL_VALUE_LOC_MAP + ".\"SD_ID\", " + this.SKEWED_STRING_LIST_VALUES + ".STRING_LIST_ID, " + this.SKEWED_COL_VALUE_LOC_MAP + ".\"LOCATION\", " + this.SKEWED_STRING_LIST_VALUES + ".\"STRING_LIST_VALUE\" from " + this.SKEWED_COL_VALUE_LOC_MAP + "  left outer join " + this.SKEWED_STRING_LIST_VALUES + " on " + this.SKEWED_COL_VALUE_LOC_MAP + ".\"STRING_LIST_ID_KID\" = " + this.SKEWED_STRING_LIST_VALUES + ".\"STRING_LIST_ID\" where " + this.SKEWED_COL_VALUE_LOC_MAP + ".\"SD_ID\" in (" + sdIds + ")  and " + this.SKEWED_COL_VALUE_LOC_MAP + ".\"STRING_LIST_ID_KID\" is not null order by " + this.SKEWED_COL_VALUE_LOC_MAP + ".\"SD_ID\" asc,  " + this.SKEWED_STRING_LIST_VALUES + ".\"STRING_LIST_ID\" asc,  " + this.SKEWED_STRING_LIST_VALUES + ".\"INTEGER_IDX\" asc";
            this.loopJoinOrderedResult(sds, queryText, 0, new ApplyFunc<StorageDescriptor>(){
                private Long currentListId;
                private List<String> currentList;

                @Override
                public void apply(StorageDescriptor t, Object[] fields) throws MetaException {
                    if (!t.isSetSkewedInfo()) {
                        SkewedInfo skewedInfo = new SkewedInfo();
                        skewedInfo.setSkewedColValueLocationMaps(new HashMap<List<String>, String>());
                        t.setSkewedInfo(skewedInfo);
                    }
                    Map<List<String>, String> skewMap = t.getSkewedInfo().getSkewedColValueLocationMaps();
                    if (fields[1] == null) {
                        this.currentList = new ArrayList<String>();
                        this.currentListId = null;
                    } else {
                        long fieldsListId = MetaStoreDirectSql.extractSqlLong(fields[1]);
                        if (this.currentListId == null || fieldsListId != this.currentListId) {
                            this.currentList = new ArrayList<String>();
                            this.currentListId = fieldsListId;
                        } else {
                            skewMap.remove(this.currentList);
                        }
                        this.currentList.add((String)fields[3]);
                    }
                    skewMap.put(this.currentList, (String)fields[2]);
                }
            });
        }
        if (!colss.isEmpty()) {
            queryText = "select \"CD_ID\", \"COMMENT\", \"COLUMN_NAME\", \"TYPE_NAME\" from " + this.COLUMNS_V2 + " where \"CD_ID\" in (" + colIds + ") order by \"CD_ID\" asc, \"INTEGER_IDX\" asc";
            this.loopJoinOrderedResult(colss, queryText, 0, new ApplyFunc<List<FieldSchema>>(){

                @Override
                public void apply(List<FieldSchema> t, Object[] fields) {
                    t.add(new FieldSchema((String)fields[2], MetaStoreDirectSql.this.extractSqlClob(fields[3]), (String)fields[1]));
                }
            });
        }
        queryText = "select \"SERDE_ID\", \"PARAM_KEY\", \"PARAM_VALUE\" from " + this.SERDE_PARAMS + " where \"SERDE_ID\" in (" + serdeIds + ") and \"PARAM_KEY\" is not null order by \"SERDE_ID\" asc";
        this.loopJoinOrderedResult(serdes, queryText, 0, new ApplyFunc<SerDeInfo>(){

            @Override
            public void apply(SerDeInfo t, Object[] fields) {
                t.putToParameters((String)fields[1], MetaStoreDirectSql.this.extractSqlClob(fields[2]));
            }
        });
        for (SerDeInfo t : serdes.values()) {
            t.setParameters(MetaStoreUtils.trimMapNulls(t.getParameters(), this.convertMapNullsToEmptyStrings));
        }
        return orderedResult;
    }

    public int getNumPartitionsViaSqlFilter(SqlFilterForPushdown filter) throws MetaException {
        boolean doTrace = LOG.isDebugEnabled();
        String catName = filter.table.getCatName().toLowerCase();
        String dbName = filter.table.getDbName().toLowerCase();
        String tblName = filter.table.getTableName().toLowerCase();
        String queryText = "select count(" + this.PARTITIONS + ".\"PART_ID\") from " + this.PARTITIONS + "  inner join " + this.TBLS + " on " + this.PARTITIONS + ".\"TBL_ID\" = " + this.TBLS + ".\"TBL_ID\"     and " + this.TBLS + ".\"TBL_NAME\" = ?   inner join " + this.DBS + " on " + this.TBLS + ".\"DB_ID\" = " + this.DBS + ".\"DB_ID\"      and " + this.DBS + ".\"NAME\" = ? " + StringUtils.join(filter.joins, (char)' ') + " where " + this.DBS + ".\"CTLG_NAME\" = ? " + (String)(filter.filter == null || filter.filter.trim().isEmpty() ? "" : " and " + filter.filter);
        Object[] params = new Object[filter.params.size() + 3];
        params[0] = tblName;
        params[1] = dbName;
        params[2] = catName;
        for (int i = 0; i < filter.params.size(); ++i) {
            params[i + 3] = filter.params.get(i);
        }
        long start = doTrace ? System.nanoTime() : 0L;
        Query query = this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText);
        query.setUnique(true);
        int sqlResult = this.extractSqlInt(query.executeWithArray(params));
        long queryTime = doTrace ? System.nanoTime() : 0L;
        this.timingTrace(doTrace, queryText, start, queryTime);
        return sqlResult;
    }

    private void timingTrace(boolean doTrace, String queryText, long start, long queryTime) {
        if (!doTrace) {
            return;
        }
        LOG.debug("Direct SQL query in " + (double)(queryTime - start) / 1000000.0 + "ms + " + (double)(System.nanoTime() - queryTime) / 1000000.0 + "ms, the query is [" + queryText + "]");
    }

    static Long extractSqlLong(Object obj) throws MetaException {
        if (obj == null) {
            return null;
        }
        if (!(obj instanceof Number)) {
            throw new MetaException("Expected numeric type but got " + obj.getClass().getName());
        }
        return ((Number)obj).longValue();
    }

    private static Boolean extractSqlBoolean(Object value) throws MetaException {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            try {
                return BooleanUtils.toBooleanObject((String)((String)value), (String)"Y", (String)"N", null);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        throw new MetaException("Cannot extract boolean from column value " + value);
    }

    private int extractSqlInt(Object field) {
        return ((Number)field).intValue();
    }

    private String extractSqlString(Object value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    static Double extractSqlDouble(Object obj) throws MetaException {
        if (obj == null) {
            return null;
        }
        if (!(obj instanceof Number)) {
            throw new MetaException("Expected numeric type but got " + obj.getClass().getName());
        }
        return ((Number)obj).doubleValue();
    }

    private String extractSqlClob(Object value) {
        if (value == null) {
            return null;
        }
        try {
            if (value instanceof Clob) {
                int maxLength = ((Clob)value).length() < 0x7FFFFFFDL ? (int)((Clob)value).length() : 0x7FFFFFFD;
                return ((Clob)value).getSubString(1L, maxLength);
            }
            return value.toString();
        }
        catch (SQLException sqle) {
            return null;
        }
    }

    static byte[] extractSqlBlob(Object value) throws MetaException {
        if (value == null) {
            return null;
        }
        if (value instanceof Blob) {
            try {
                return ((Blob)value).getBytes(1L, (int)((Blob)value).length());
            }
            catch (SQLException e) {
                throw new MetaException("Encounter error while processing blob.");
            }
        }
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        LOG.debug("Expected blob type but got " + value.getClass().getName());
        return null;
    }

    private static String trimCommaList(StringBuilder sb) {
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    private <T> int loopJoinOrderedResult(TreeMap<Long, T> tree, String queryText, int keyIndex, ApplyFunc<T> func) throws MetaException {
        long queryTime;
        boolean doTrace = LOG.isDebugEnabled();
        long start = doTrace ? System.nanoTime() : 0L;
        Query query = this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText);
        Object result = query.execute();
        long l = queryTime = doTrace ? System.nanoTime() : 0L;
        if (result == null) {
            query.closeAll();
            return 0;
        }
        List<Object[]> list = this.ensureList(result);
        Iterator<Object[]> iter = list.iterator();
        Object[] fields = null;
        for (Map.Entry<Long, T> entry : tree.entrySet()) {
            if (fields == null && !iter.hasNext()) break;
            long id = entry.getKey();
            while (fields != null || iter.hasNext()) {
                long nestedId;
                if (fields == null) {
                    fields = iter.next();
                }
                if ((nestedId = MetaStoreDirectSql.extractSqlLong(fields[keyIndex]).longValue()) < id) {
                    throw new MetaException("Found entries for unknown ID " + nestedId);
                }
                if (nestedId > id) break;
                func.apply(entry.getValue(), fields);
                fields = null;
            }
            Deadline.checkTimeout();
        }
        int rv = list.size();
        query.closeAll();
        this.timingTrace(doTrace, queryText, start, queryTime);
        return rv;
    }

    public ColumnStatistics getTableStats(final String catName, final String dbName, final String tableName, List<String> colNames, boolean enableBitVector) throws MetaException {
        if (colNames == null || colNames.isEmpty()) {
            return null;
        }
        final boolean doTrace = LOG.isDebugEnabled();
        final String queryText0 = "select " + this.getStatsList(enableBitVector) + " from " + this.TAB_COL_STATS + " where \"CAT_NAME\" = ? and \"DB_NAME\" = ? and \"TABLE_NAME\" = ? and \"COLUMN_NAME\" in (";
        Batchable<String, Object[]> b = new Batchable<String, Object[]>(){

            @Override
            public List<Object[]> run(List<String> input) throws MetaException {
                String queryText = queryText0 + MetaStoreDirectSql.this.makeParams(input.size()) + ")";
                Object[] params = new Object[input.size() + 3];
                params[0] = catName;
                params[1] = dbName;
                params[2] = tableName;
                for (int i = 0; i < input.size(); ++i) {
                    params[i + 3] = input.get(i);
                }
                long start = doTrace ? System.nanoTime() : 0L;
                Query query = MetaStoreDirectSql.this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText);
                Object qResult = MetaStoreDirectSql.this.executeWithArray(query, params, queryText);
                MetaStoreDirectSql.this.timingTrace(doTrace, queryText0 + "...)", start, doTrace ? System.nanoTime() : 0L);
                if (qResult == null) {
                    query.closeAll();
                    return null;
                }
                this.addQueryAfterUse(query);
                return MetaStoreDirectSql.this.ensureList(qResult);
            }
        };
        List<Object[]> list = this.runBatched(colNames, b);
        if (list.isEmpty()) {
            return null;
        }
        ColumnStatisticsDesc csd = new ColumnStatisticsDesc(true, dbName, tableName);
        csd.setCatName(catName);
        ColumnStatistics result = this.makeColumnStats(list, csd, 0);
        b.closeAllQueries();
        return result;
    }

    public AggrStats aggrColStatsForPartitions(String catName, String dbName, String tableName, List<String> partNames, List<String> colNames, boolean useDensityFunctionForNDVEstimation, double ndvTuner, boolean enableBitVector) throws MetaException {
        List<Object> colStatsList;
        if (colNames.isEmpty() || partNames.isEmpty()) {
            LOG.debug("Columns is empty or partNames is empty : Short-circuiting stats eval");
            return new AggrStats(Collections.emptyList(), 0L);
        }
        long partsFound = 0L;
        if (this.isAggregateStatsCacheEnabled && partNames.size() < this.aggrStatsCache.getMaxPartsPerCacheNode()) {
            int maxPartsPerCacheNode = this.aggrStatsCache.getMaxPartsPerCacheNode();
            double fpp = this.aggrStatsCache.getFalsePositiveProbability();
            colStatsList = new ArrayList();
            BloomFilter bloomFilter = this.createPartsBloomFilter(maxPartsPerCacheNode, fpp, partNames);
            boolean computePartsFound = true;
            for (String colName : colNames) {
                AggregateStatsCache.AggrColStats colStatsAggrCached = this.aggrStatsCache.get(catName, dbName, tableName, colName, partNames);
                if (colStatsAggrCached != null) {
                    colStatsList.add(colStatsAggrCached.getColStats());
                    partsFound = colStatsAggrCached.getNumPartsCached();
                    continue;
                }
                if (computePartsFound) {
                    partsFound = this.partsFoundForPartitions(catName, dbName, tableName, partNames, colNames);
                    computePartsFound = false;
                }
                ArrayList<String> colNamesForDB = new ArrayList<String>();
                colNamesForDB.add(colName);
                List<ColumnStatisticsObj> colStatsAggrFromDB = this.columnStatisticsObjForPartitions(catName, dbName, tableName, partNames, colNamesForDB, partsFound, useDensityFunctionForNDVEstimation, ndvTuner, enableBitVector);
                if (colStatsAggrFromDB.isEmpty()) continue;
                ColumnStatisticsObj colStatsAggr = colStatsAggrFromDB.get(0);
                colStatsList.add(colStatsAggr);
                this.aggrStatsCache.add(catName, dbName, tableName, colName, partsFound, colStatsAggr, bloomFilter);
            }
        } else {
            partsFound = this.partsFoundForPartitions(catName, dbName, tableName, partNames, colNames);
            colStatsList = this.columnStatisticsObjForPartitions(catName, dbName, tableName, partNames, colNames, partsFound, useDensityFunctionForNDVEstimation, ndvTuner, enableBitVector);
        }
        LOG.info("useDensityFunctionForNDVEstimation = " + useDensityFunctionForNDVEstimation + "\npartsFound = " + partsFound + "\nColumnStatisticsObj = " + Arrays.toString(colStatsList.toArray()));
        return new AggrStats(colStatsList, partsFound);
    }

    private BloomFilter createPartsBloomFilter(int maxPartsPerCacheNode, double fpp, List<String> partNames) {
        BloomFilter bloomFilter = new BloomFilter((long)maxPartsPerCacheNode, fpp);
        for (String partName : partNames) {
            bloomFilter.add(partName.getBytes());
        }
        return bloomFilter;
    }

    private long partsFoundForPartitions(final String catName, final String dbName, final String tableName, final List<String> partNames, List<String> colNames) throws MetaException {
        assert (!colNames.isEmpty() && !partNames.isEmpty());
        final boolean doTrace = LOG.isDebugEnabled();
        final String queryText0 = "select count(\"COLUMN_NAME\") from " + this.PART_COL_STATS + " where \"CAT_NAME\" = ? and \"DB_NAME\" = ? and \"TABLE_NAME\" = ?  and \"COLUMN_NAME\" in (%1$s) and \"PARTITION_NAME\" in (%2$s) group by \"PARTITION_NAME\"";
        List<Long> allCounts = this.runBatched(colNames, new Batchable<String, Long>(){

            @Override
            public List<Long> run(final List<String> inputColName) throws MetaException {
                return MetaStoreDirectSql.this.runBatched(partNames, new Batchable<String, Long>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public List<Long> run(List<String> inputPartNames) throws MetaException {
                        long partsFound = 0L;
                        String queryText = String.format(queryText0, MetaStoreDirectSql.this.makeParams(inputColName.size()), MetaStoreDirectSql.this.makeParams(inputPartNames.size()));
                        long start = doTrace ? System.nanoTime() : 0L;
                        Query query = MetaStoreDirectSql.this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText);
                        try {
                            Object qResult = MetaStoreDirectSql.this.executeWithArray(query, MetaStoreDirectSql.this.prepareParams(catName, dbName, tableName, inputPartNames, inputColName), queryText);
                            long end = doTrace ? System.nanoTime() : 0L;
                            MetaStoreDirectSql.this.timingTrace(doTrace, queryText, start, end);
                            ForwardQueryResult fqr = (ForwardQueryResult)qResult;
                            Iterator iter = fqr.iterator();
                            while (iter.hasNext()) {
                                if (MetaStoreDirectSql.extractSqlLong(iter.next()) != (long)inputColName.size()) continue;
                                ++partsFound;
                            }
                            ArrayList arrayList = Lists.newArrayList((Object[])new Long[]{partsFound});
                            return arrayList;
                        }
                        finally {
                            query.closeAll();
                        }
                    }
                });
            }
        });
        long partsFound = 0L;
        for (Long val : allCounts) {
            partsFound += val.longValue();
        }
        return partsFound;
    }

    private List<ColumnStatisticsObj> columnStatisticsObjForPartitions(final String catName, final String dbName, final String tableName, final List<String> partNames, List<String> colNames, long partsFound, final boolean useDensityFunctionForNDVEstimation, final double ndvTuner, final boolean enableBitVector) throws MetaException {
        final boolean areAllPartsFound = partsFound == (long)partNames.size();
        return this.runBatched(colNames, new Batchable<String, ColumnStatisticsObj>(){

            @Override
            public List<ColumnStatisticsObj> run(final List<String> inputColNames) throws MetaException {
                return MetaStoreDirectSql.this.runBatched(partNames, new Batchable<String, ColumnStatisticsObj>(){

                    @Override
                    public List<ColumnStatisticsObj> run(List<String> inputPartNames) throws MetaException {
                        return MetaStoreDirectSql.this.columnStatisticsObjForPartitionsBatch(catName, dbName, tableName, inputPartNames, inputColNames, areAllPartsFound, useDensityFunctionForNDVEstimation, ndvTuner, enableBitVector);
                    }
                });
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MetaStoreUtils.ColStatsObjWithSourceInfo> getColStatsForAllTablePartitions(String catName, String dbName, boolean enableBitVector) throws MetaException {
        String queryText = "select \"TABLE_NAME\", \"PARTITION_NAME\", " + this.getStatsList(enableBitVector) + " from  " + this.PART_COL_STATS + " where \"DB_NAME\" = ? and \"CAT_NAME\" = ?";
        long start = 0L;
        long end = 0L;
        Query query = null;
        boolean doTrace = LOG.isDebugEnabled();
        Object qResult = null;
        start = doTrace ? System.nanoTime() : 0L;
        ArrayList<MetaStoreUtils.ColStatsObjWithSourceInfo> colStatsForDB = new ArrayList<MetaStoreUtils.ColStatsObjWithSourceInfo>();
        try {
            query = this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText);
            qResult = this.executeWithArray(query, new Object[]{dbName, catName}, queryText);
            if (qResult == null) {
                query.closeAll();
                ArrayList<MetaStoreUtils.ColStatsObjWithSourceInfo> arrayList = colStatsForDB;
                return arrayList;
            }
            end = doTrace ? System.nanoTime() : 0L;
            this.timingTrace(doTrace, queryText, start, end);
            List<Object[]> list = this.ensureList(qResult);
            for (Object[] row : list) {
                String tblName = (String)row[0];
                String partName = (String)row[1];
                ColumnStatisticsObj colStatObj = this.prepareCSObj(row, 2);
                colStatsForDB.add(new MetaStoreUtils.ColStatsObjWithSourceInfo(colStatObj, catName, dbName, tblName, partName));
                Deadline.checkTimeout();
            }
        }
        finally {
            query.closeAll();
        }
        return colStatsForDB;
    }

    private List<ColumnStatisticsObj> columnStatisticsObjForPartitionsBatch(String catName, String dbName, String tableName, List<String> partNames, List<String> colNames, boolean areAllPartsFound, boolean useDensityFunctionForNDVEstimation, double ndvTuner, boolean enableBitVector) throws MetaException {
        if (enableBitVector) {
            return this.aggrStatsUseJava(catName, dbName, tableName, partNames, colNames, areAllPartsFound, useDensityFunctionForNDVEstimation, ndvTuner);
        }
        return this.aggrStatsUseDB(catName, dbName, tableName, partNames, colNames, areAllPartsFound, useDensityFunctionForNDVEstimation, ndvTuner);
    }

    private List<ColumnStatisticsObj> aggrStatsUseJava(String catName, String dbName, String tableName, List<String> partNames, List<String> colNames, boolean areAllPartsFound, boolean useDensityFunctionForNDVEstimation, double ndvTuner) throws MetaException {
        List<ColumnStatistics> partStats = this.getPartitionStats(catName, dbName, tableName, partNames, colNames, true);
        return MetaStoreUtils.aggrPartitionStats(partStats, catName, dbName, tableName, partNames, colNames, areAllPartsFound, useDensityFunctionForNDVEstimation, ndvTuner);
    }

    private List<ColumnStatisticsObj> aggrStatsUseDB(String catName, String dbName, String tableName, List<String> partNames, List<String> colNames, boolean areAllPartsFound, boolean useDensityFunctionForNDVEstimation, double ndvTuner) throws MetaException {
        String commonPrefix = "select \"COLUMN_NAME\", \"COLUMN_TYPE\", min(\"LONG_LOW_VALUE\"), max(\"LONG_HIGH_VALUE\"), min(\"DOUBLE_LOW_VALUE\"), max(\"DOUBLE_HIGH_VALUE\"), min(cast(\"BIG_DECIMAL_LOW_VALUE\" as decimal)), max(cast(\"BIG_DECIMAL_HIGH_VALUE\" as decimal)), sum(\"NUM_NULLS\"), max(\"NUM_DISTINCTS\"), max(\"AVG_COL_LEN\"), max(\"MAX_COL_LEN\"), sum(\"NUM_TRUES\"), sum(\"NUM_FALSES\"), avg((\"LONG_HIGH_VALUE\"-\"LONG_LOW_VALUE\")/cast(\"NUM_DISTINCTS\" as decimal)),avg((\"DOUBLE_HIGH_VALUE\"-\"DOUBLE_LOW_VALUE\")/\"NUM_DISTINCTS\"),avg((cast(\"BIG_DECIMAL_HIGH_VALUE\" as decimal)-cast(\"BIG_DECIMAL_LOW_VALUE\" as decimal))/\"NUM_DISTINCTS\"),sum(\"NUM_DISTINCTS\") from " + this.PART_COL_STATS + " where \"CAT_NAME\" = ? and \"DB_NAME\" = ? and \"TABLE_NAME\" = ? ";
        String queryText = null;
        long start = 0L;
        long end = 0L;
        Query query = null;
        boolean doTrace = LOG.isDebugEnabled();
        Object qResult = null;
        ForwardQueryResult fqr = null;
        if (areAllPartsFound) {
            queryText = commonPrefix + " and \"COLUMN_NAME\" in (" + this.makeParams(colNames.size()) + ") and \"PARTITION_NAME\" in (" + this.makeParams(partNames.size()) + ") group by \"COLUMN_NAME\", \"COLUMN_TYPE\"";
            start = doTrace ? System.nanoTime() : 0L;
            query = this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText);
            qResult = this.executeWithArray(query, this.prepareParams(catName, dbName, tableName, partNames, colNames), queryText);
            if (qResult == null) {
                query.closeAll();
                return Collections.emptyList();
            }
            end = doTrace ? System.nanoTime() : 0L;
            this.timingTrace(doTrace, queryText, start, end);
            List<Object[]> list = this.ensureList(qResult);
            ArrayList<ColumnStatisticsObj> colStats = new ArrayList<ColumnStatisticsObj>(list.size());
            for (Object[] row : list) {
                colStats.add(this.prepareCSObjWithAdjustedNDV(row, 0, useDensityFunctionForNDVEstimation, ndvTuner));
                Deadline.checkTimeout();
            }
            query.closeAll();
            return colStats;
        }
        ArrayList<ColumnStatisticsObj> colStats = new ArrayList<ColumnStatisticsObj>(colNames.size());
        queryText = "select \"COLUMN_NAME\", \"COLUMN_TYPE\", count(\"PARTITION_NAME\")  from " + this.PART_COL_STATS + " where \"CAT_NAME\" = ? and \"DB_NAME\" = ? and \"TABLE_NAME\" = ?  and \"COLUMN_NAME\" in (" + this.makeParams(colNames.size()) + ") and \"PARTITION_NAME\" in (" + this.makeParams(partNames.size()) + ") group by \"COLUMN_NAME\", \"COLUMN_TYPE\"";
        start = doTrace ? System.nanoTime() : 0L;
        query = this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText);
        qResult = this.executeWithArray(query, this.prepareParams(catName, dbName, tableName, partNames, colNames), queryText);
        end = doTrace ? System.nanoTime() : 0L;
        this.timingTrace(doTrace, queryText, start, end);
        if (qResult == null) {
            query.closeAll();
            return Collections.emptyList();
        }
        ArrayList<String> noExtraColumnNames = new ArrayList<String>();
        HashMap<String, String[]> extraColumnNameTypeParts = new HashMap<String, String[]>();
        List<Object[]> list = this.ensureList(qResult);
        for (Object[] row : list) {
            String colName = (String)row[0];
            String colType = (String)row[1];
            Long count = MetaStoreDirectSql.extractSqlLong(row[2]);
            if (count == (long)partNames.size() || count < 2L) {
                noExtraColumnNames.add(colName);
            } else {
                extraColumnNameTypeParts.put(colName, new String[]{colType, String.valueOf(count)});
            }
            Deadline.checkTimeout();
        }
        query.closeAll();
        if (noExtraColumnNames.size() != 0) {
            queryText = commonPrefix + " and \"COLUMN_NAME\" in (" + this.makeParams(noExtraColumnNames.size()) + ") and \"PARTITION_NAME\" in (" + this.makeParams(partNames.size()) + ") group by \"COLUMN_NAME\", \"COLUMN_TYPE\"";
            start = doTrace ? System.nanoTime() : 0L;
            query = this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText);
            qResult = this.executeWithArray(query, this.prepareParams(catName, dbName, tableName, partNames, noExtraColumnNames), queryText);
            if (qResult == null) {
                query.closeAll();
                return Collections.emptyList();
            }
            list = this.ensureList(qResult);
            for (Object[] row : list) {
                colStats.add(this.prepareCSObjWithAdjustedNDV(row, 0, useDensityFunctionForNDVEstimation, ndvTuner));
                Deadline.checkTimeout();
            }
            end = doTrace ? System.nanoTime() : 0L;
            this.timingTrace(doTrace, queryText, start, end);
            query.closeAll();
        }
        if (extraColumnNameTypeParts.size() != 0) {
            HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
            for (int index = 0; index < partNames.size(); ++index) {
                indexMap.put(partNames.get(index), index);
            }
            HashMap sumMap = new HashMap();
            queryText = "select \"COLUMN_NAME\", sum(\"NUM_NULLS\"), sum(\"NUM_TRUES\"), sum(\"NUM_FALSES\"), sum(\"NUM_DISTINCTS\") from " + this.PART_COL_STATS + " where \"CAT_NAME\" = ? and \"DB_NAME\" = ? and \"TABLE_NAME\" = ?  and \"COLUMN_NAME\" in (" + this.makeParams(extraColumnNameTypeParts.size()) + ") and \"PARTITION_NAME\" in (" + this.makeParams(partNames.size()) + ") group by \"COLUMN_NAME\"";
            start = doTrace ? System.nanoTime() : 0L;
            query = this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText);
            ArrayList<String> extraColumnNames = new ArrayList<String>();
            extraColumnNames.addAll(extraColumnNameTypeParts.keySet());
            qResult = this.executeWithArray(query, this.prepareParams(catName, dbName, tableName, partNames, extraColumnNames), queryText);
            if (qResult == null) {
                query.closeAll();
                return Collections.emptyList();
            }
            list = this.ensureList(qResult);
            Integer[] sumIndex = new Integer[]{6, 10, 11, 15};
            for (Object[] objectArray : list) {
                HashMap<Integer, Object> indexToObject = new HashMap<Integer, Object>();
                for (int ind = 1; ind < objectArray.length; ++ind) {
                    indexToObject.put(sumIndex[ind - 1], objectArray[ind]);
                }
                sumMap.put((String)objectArray[0], indexToObject);
                Deadline.checkTimeout();
            }
            end = doTrace ? System.nanoTime() : 0L;
            this.timingTrace(doTrace, queryText, start, end);
            query.closeAll();
            for (Map.Entry entry : extraColumnNameTypeParts.entrySet()) {
                Object[] row = new Object[IExtrapolatePartStatus.colStatNames.length + 2];
                String colName = (String)entry.getKey();
                String colType = ((String[])entry.getValue())[0];
                Long sumVal = Long.parseLong(((String[])entry.getValue())[1]);
                row[0] = colName;
                row[1] = colType;
                LinearExtrapolatePartStatus extrapolateMethod = new LinearExtrapolatePartStatus();
                Integer[] index = null;
                boolean decimal = false;
                if (colType.toLowerCase().startsWith("decimal")) {
                    index = IExtrapolatePartStatus.indexMaps.get("decimal");
                    decimal = true;
                } else {
                    index = IExtrapolatePartStatus.indexMaps.get(colType.toLowerCase());
                }
                if (index == null) {
                    index = IExtrapolatePartStatus.indexMaps.get("default");
                }
                Integer[] integerArray = index;
                int n = integerArray.length;
                for (int i = 0; i < n; ++i) {
                    int colStatIndex = integerArray[i];
                    String colStatName = IExtrapolatePartStatus.colStatNames[colStatIndex];
                    if (IExtrapolatePartStatus.aggrTypes[colStatIndex] == IExtrapolatePartStatus.AggrType.Sum) {
                        Object o = ((Map)sumMap.get(colName)).get(colStatIndex);
                        if (o == null) {
                            row[2 + colStatIndex] = null;
                            continue;
                        }
                        Long val = MetaStoreDirectSql.extractSqlLong(o);
                        row[2 + colStatIndex] = val / sumVal * (long)partNames.size();
                        continue;
                    }
                    if (IExtrapolatePartStatus.aggrTypes[colStatIndex] == IExtrapolatePartStatus.AggrType.Min || IExtrapolatePartStatus.aggrTypes[colStatIndex] == IExtrapolatePartStatus.AggrType.Max) {
                        queryText = !decimal ? "select \"" + colStatName + "\",\"PARTITION_NAME\" from " + this.PART_COL_STATS + " where \"CAT_NAME\" = ? and \"DB_NAME\" = ? and \"TABLE_NAME\" = ? and \"COLUMN_NAME\" = ? and \"PARTITION_NAME\" in (" + this.makeParams(partNames.size()) + ") order by \"" + colStatName + "\"" : "select \"" + colStatName + "\",\"PARTITION_NAME\" from " + this.PART_COL_STATS + " where \"CAT_NAME\" = ? and \"DB_NAME\" = ? and \"TABLE_NAME\" = ? and \"COLUMN_NAME\" = ? and \"PARTITION_NAME\" in (" + this.makeParams(partNames.size()) + ") order by cast(\"" + colStatName + "\" as decimal)";
                        start = doTrace ? System.nanoTime() : 0L;
                        query = this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText);
                        qResult = this.executeWithArray(query, this.prepareParams(catName, dbName, tableName, partNames, Arrays.asList(colName)), queryText);
                        if (qResult == null) {
                            query.closeAll();
                            return Collections.emptyList();
                        }
                        fqr = qResult;
                        Object[] min = (Object[])fqr.get(0);
                        Object[] max = (Object[])fqr.get(fqr.size() - 1);
                        end = doTrace ? System.nanoTime() : 0L;
                        this.timingTrace(doTrace, queryText, start, end);
                        query.closeAll();
                        if (min[0] == null || max[0] == null) {
                            row[2 + colStatIndex] = null;
                            continue;
                        }
                        row[2 + colStatIndex] = extrapolateMethod.extrapolate(min, max, colStatIndex, indexMap);
                        continue;
                    }
                    queryText = "select avg((\"LONG_HIGH_VALUE\"-\"LONG_LOW_VALUE\")/cast(\"NUM_DISTINCTS\" as decimal)),avg((\"DOUBLE_HIGH_VALUE\"-\"DOUBLE_LOW_VALUE\")/\"NUM_DISTINCTS\"),avg((cast(\"BIG_DECIMAL_HIGH_VALUE\" as decimal)-cast(\"BIG_DECIMAL_LOW_VALUE\" as decimal))/\"NUM_DISTINCTS\") from " + this.PART_COL_STATS + " where \"CAT_NAME\" = ? and \"DB_NAME\" = ? and \"TABLE_NAME\" = ? and \"COLUMN_NAME\" = ? and \"PARTITION_NAME\" in (" + this.makeParams(partNames.size()) + ") group by \"COLUMN_NAME\"";
                    start = doTrace ? System.nanoTime() : 0L;
                    query = this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText);
                    qResult = this.executeWithArray(query, this.prepareParams(catName, dbName, tableName, partNames, Arrays.asList(colName)), queryText);
                    if (qResult == null) {
                        query.closeAll();
                        return Collections.emptyList();
                    }
                    fqr = qResult;
                    Object[] avg = (Object[])fqr.get(0);
                    row[2 + colStatIndex] = avg[colStatIndex - 12];
                    end = doTrace ? System.nanoTime() : 0L;
                    this.timingTrace(doTrace, queryText, start, end);
                    query.closeAll();
                }
                colStats.add(this.prepareCSObjWithAdjustedNDV(row, 0, useDensityFunctionForNDVEstimation, ndvTuner));
                Deadline.checkTimeout();
            }
        }
        return colStats;
    }

    private ColumnStatisticsObj prepareCSObj(Object[] row, int i) throws MetaException {
        ColumnStatisticsData data = new ColumnStatisticsData();
        ColumnStatisticsObj cso = new ColumnStatisticsObj((String)row[i++], (String)row[i++], data);
        Object llow = row[i++];
        Object lhigh = row[i++];
        Object dlow = row[i++];
        Object dhigh = row[i++];
        Object declow = row[i++];
        Object dechigh = row[i++];
        Object nulls = row[i++];
        Object dist = row[i++];
        Object bitVector = row[i++];
        Object avglen = row[i++];
        Object maxlen = row[i++];
        Object trues = row[i++];
        Object falses = row[i++];
        StatObjectConverter.fillColumnStatisticsData(cso.getColType(), data, llow, lhigh, dlow, dhigh, declow, dechigh, nulls, dist, bitVector, avglen, maxlen, trues, falses);
        return cso;
    }

    private ColumnStatisticsObj prepareCSObjWithAdjustedNDV(Object[] row, int i, boolean useDensityFunctionForNDVEstimation, double ndvTuner) throws MetaException {
        ColumnStatisticsData data = new ColumnStatisticsData();
        ColumnStatisticsObj cso = new ColumnStatisticsObj((String)row[i++], (String)row[i++], data);
        Object llow = row[i++];
        Object lhigh = row[i++];
        Object dlow = row[i++];
        Object dhigh = row[i++];
        Object declow = row[i++];
        Object dechigh = row[i++];
        Object nulls = row[i++];
        Object dist = row[i++];
        Object avglen = row[i++];
        Object maxlen = row[i++];
        Object trues = row[i++];
        Object falses = row[i++];
        Object avgLong = row[i++];
        Object avgDouble = row[i++];
        Object avgDecimal = row[i++];
        Object sumDist = row[i++];
        StatObjectConverter.fillColumnStatisticsData(cso.getColType(), data, llow, lhigh, dlow, dhigh, declow, dechigh, nulls, dist, avglen, maxlen, trues, falses, avgLong, avgDouble, avgDecimal, sumDist, useDensityFunctionForNDVEstimation, ndvTuner);
        return cso;
    }

    private Object[] prepareParams(String catName, String dbName, String tableName, List<String> partNames, List<String> colNames) throws MetaException {
        Object[] params = new Object[colNames.size() + partNames.size() + 3];
        int paramI = 0;
        params[paramI++] = catName;
        params[paramI++] = dbName;
        params[paramI++] = tableName;
        for (String colName : colNames) {
            params[paramI++] = colName;
        }
        for (String partName : partNames) {
            params[paramI++] = partName;
        }
        return params;
    }

    public List<ColumnStatistics> getPartitionStats(final String catName, final String dbName, final String tableName, final List<String> partNames, List<String> colNames, boolean enableBitVector) throws MetaException {
        if (colNames.isEmpty() || partNames.isEmpty()) {
            return Collections.emptyList();
        }
        final boolean doTrace = LOG.isDebugEnabled();
        final String queryText0 = "select \"PARTITION_NAME\", " + this.getStatsList(enableBitVector) + " from  " + this.PART_COL_STATS + " where \"CAT_NAME\" = ? and \"DB_NAME\" = ? and \"TABLE_NAME\" = ? and \"COLUMN_NAME\"  in (%1$s) AND \"PARTITION_NAME\" in (%2$s) order by \"PARTITION_NAME\"";
        Batchable<String, Object[]> b = new Batchable<String, Object[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Object[]> run(final List<String> inputColNames) throws MetaException {
                Batchable<String, Object[]> b2 = new Batchable<String, Object[]>(){

                    @Override
                    public List<Object[]> run(List<String> inputPartNames) throws MetaException {
                        String queryText = String.format(queryText0, MetaStoreDirectSql.this.makeParams(inputColNames.size()), MetaStoreDirectSql.this.makeParams(inputPartNames.size()));
                        long start = doTrace ? System.nanoTime() : 0L;
                        Query query = MetaStoreDirectSql.this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText);
                        Object qResult = MetaStoreDirectSql.this.executeWithArray(query, MetaStoreDirectSql.this.prepareParams(catName, dbName, tableName, inputPartNames, inputColNames), queryText);
                        MetaStoreDirectSql.this.timingTrace(doTrace, queryText0, start, doTrace ? System.nanoTime() : 0L);
                        if (qResult == null) {
                            query.closeAll();
                            return Collections.emptyList();
                        }
                        this.addQueryAfterUse(query);
                        return MetaStoreDirectSql.this.ensureList(qResult);
                    }
                };
                try {
                    List<Object[]> list = MetaStoreDirectSql.this.runBatched(partNames, b2);
                    return list;
                }
                finally {
                    this.addQueryAfterUse(b2);
                }
            }
        };
        List<Object[]> list = this.runBatched(colNames, b);
        ArrayList<ColumnStatistics> result = new ArrayList<ColumnStatistics>(Math.min(list.size(), partNames.size()));
        String lastPartName = null;
        int from = 0;
        for (int i = 0; i <= list.size(); ++i) {
            String partName;
            boolean isLast = i == list.size();
            String string = partName = isLast ? null : (String)list.get(i)[0];
            if (!isLast && partName.equals(lastPartName)) continue;
            if (from != i) {
                ColumnStatisticsDesc csd = new ColumnStatisticsDesc(false, dbName, tableName);
                csd.setCatName(catName);
                csd.setPartName(lastPartName);
                result.add(this.makeColumnStats(list.subList(from, i), csd, 1));
            }
            lastPartName = partName;
            from = i;
            Deadline.checkTimeout();
        }
        b.closeAllQueries();
        return result;
    }

    private final String getStatsList(boolean enableBitVector) {
        return "\"COLUMN_NAME\", \"COLUMN_TYPE\", \"LONG_LOW_VALUE\", \"LONG_HIGH_VALUE\", \"DOUBLE_LOW_VALUE\", \"DOUBLE_HIGH_VALUE\", \"BIG_DECIMAL_LOW_VALUE\", \"BIG_DECIMAL_HIGH_VALUE\", \"NUM_NULLS\", \"NUM_DISTINCTS\", " + (enableBitVector ? "\"BIT_VECTOR\", " : "'', ") + "\"AVG_COL_LEN\", \"MAX_COL_LEN\", \"NUM_TRUES\", \"NUM_FALSES\", \"LAST_ANALYZED\" ";
    }

    private ColumnStatistics makeColumnStats(List<Object[]> list, ColumnStatisticsDesc csd, int offset) throws MetaException {
        ColumnStatistics result = new ColumnStatistics();
        result.setStatsDesc(csd);
        ArrayList<ColumnStatisticsObj> csos = new ArrayList<ColumnStatisticsObj>(list.size());
        for (Object[] row : list) {
            Object laObj = row[offset + 15];
            if (!(laObj == null || csd.isSetLastAnalyzed() && csd.getLastAnalyzed() <= MetaStoreDirectSql.extractSqlLong(laObj))) {
                csd.setLastAnalyzed(MetaStoreDirectSql.extractSqlLong(laObj));
            }
            csos.add(this.prepareCSObj(row, offset));
            Deadline.checkTimeout();
        }
        result.setStatsObj(csos);
        return result;
    }

    private List<Object[]> ensureList(Object result) throws MetaException {
        if (!(result instanceof List)) {
            throw new MetaException("Wrong result type " + result.getClass());
        }
        return (List)result;
    }

    private String makeParams(int size) {
        return size == 0 ? "" : StringUtils.repeat((String)",?", (int)size).substring(1);
    }

    private <T> T executeWithArray(Query query, Object[] params, String sql) throws MetaException {
        try {
            return (T)(params == null ? query.execute() : query.executeWithArray(params));
        }
        catch (Exception ex) {
            String error = "Failed to execute [" + sql + "] with parameters [";
            if (params != null) {
                boolean isFirst = true;
                for (Object param : params) {
                    error = error + (isFirst ? "" : ", ") + param;
                    isFirst = false;
                }
            }
            LOG.warn(error + "]", (Throwable)ex);
            throw new MetaException("See previous errors; " + ex.getMessage());
        }
    }

    public void prepareTxn() throws MetaException {
        if (this.dbType != DatabaseProduct.MYSQL) {
            return;
        }
        try {
            assert (this.pm.currentTransaction().isActive());
            this.executeNoResult("SET @@session.sql_mode=ANSI_QUOTES");
        }
        catch (SQLException sqlEx) {
            throw new MetaException("Error setting ansi quotes: " + sqlEx.getMessage());
        }
    }

    private <I, R> List<R> runBatched(List<I> input, Batchable<I, R> runnable) throws MetaException {
        if (this.batchSize == -1 || this.batchSize >= input.size()) {
            return runnable.run(input);
        }
        ArrayList<R> result = new ArrayList<R>(input.size());
        int fromIndex = 0;
        int toIndex = 0;
        while (toIndex < input.size()) {
            toIndex = Math.min(fromIndex + this.batchSize, input.size());
            List<I> batchedInput = input.subList(fromIndex, toIndex);
            List<R> batchedOutput = runnable.run(batchedInput);
            if (batchedOutput != null) {
                result.addAll(batchedOutput);
            }
            fromIndex = toIndex;
        }
        return result;
    }

    public List<SQLForeignKey> getForeignKeys(String catName, String parent_db_name, String parent_tbl_name, String foreign_db_name, String foreign_tbl_name) throws MetaException {
        Query queryParams;
        List<Object[]> sqlResult;
        ArrayList<SQLForeignKey> ret = new ArrayList<SQLForeignKey>();
        Object queryText = "SELECT  \"D2\".\"NAME\", \"T2\".\"TBL_NAME\", CASE WHEN \"C2\".\"COLUMN_NAME\" IS NOT NULL THEN \"C2\".\"COLUMN_NAME\" ELSE \"P2\".\"PKEY_NAME\" END, " + this.DBS + ".\"NAME\", " + this.TBLS + ".\"TBL_NAME\", CASE WHEN " + this.COLUMNS_V2 + ".\"COLUMN_NAME\" IS NOT NULL THEN " + this.COLUMNS_V2 + ".\"COLUMN_NAME\" ELSE " + this.PARTITION_KEYS + ".\"PKEY_NAME\" END, " + this.KEY_CONSTRAINTS + ".\"POSITION\", " + this.KEY_CONSTRAINTS + ".\"UPDATE_RULE\", " + this.KEY_CONSTRAINTS + ".\"DELETE_RULE\", " + this.KEY_CONSTRAINTS + ".\"CONSTRAINT_NAME\" , \"KEY_CONSTRAINTS2\".\"CONSTRAINT_NAME\", " + this.KEY_CONSTRAINTS + ".\"ENABLE_VALIDATE_RELY\"  from " + this.TBLS + "  INNER JOIN " + this.KEY_CONSTRAINTS + " ON " + this.TBLS + ".\"TBL_ID\" = " + this.KEY_CONSTRAINTS + ".\"CHILD_TBL_ID\"  INNER JOIN " + this.KEY_CONSTRAINTS + " \"KEY_CONSTRAINTS2\" ON \"KEY_CONSTRAINTS2\".\"PARENT_TBL_ID\"  = " + this.KEY_CONSTRAINTS + ".\"PARENT_TBL_ID\"  AND \"KEY_CONSTRAINTS2\".\"PARENT_CD_ID\"  = " + this.KEY_CONSTRAINTS + ".\"PARENT_CD_ID\" AND  \"KEY_CONSTRAINTS2\".\"PARENT_INTEGER_IDX\"  = " + this.KEY_CONSTRAINTS + ".\"PARENT_INTEGER_IDX\"  INNER JOIN " + this.DBS + " ON " + this.TBLS + ".\"DB_ID\" = " + this.DBS + ".\"DB_ID\"  INNER JOIN " + this.TBLS + " \"T2\" ON  " + this.KEY_CONSTRAINTS + ".\"PARENT_TBL_ID\" = \"T2\".\"TBL_ID\"  INNER JOIN " + this.DBS + " \"D2\" ON \"T2\".\"DB_ID\" = \"D2\".\"DB_ID\"  LEFT OUTER JOIN " + this.COLUMNS_V2 + "  ON " + this.COLUMNS_V2 + ".\"CD_ID\" = " + this.KEY_CONSTRAINTS + ".\"CHILD_CD_ID\" AND  " + this.COLUMNS_V2 + ".\"INTEGER_IDX\" = " + this.KEY_CONSTRAINTS + ".\"CHILD_INTEGER_IDX\"  LEFT OUTER JOIN " + this.PARTITION_KEYS + " ON " + this.TBLS + ".\"TBL_ID\" = " + this.PARTITION_KEYS + ".\"TBL_ID\" AND  " + this.PARTITION_KEYS + ".\"INTEGER_IDX\" = " + this.KEY_CONSTRAINTS + ".\"CHILD_INTEGER_IDX\"  LEFT OUTER JOIN " + this.COLUMNS_V2 + " \"C2\" ON \"C2\".\"CD_ID\" = " + this.KEY_CONSTRAINTS + ".\"PARENT_CD_ID\" AND  \"C2\".\"INTEGER_IDX\" = " + this.KEY_CONSTRAINTS + ".\"PARENT_INTEGER_IDX\"  LEFT OUTER JOIN " + this.PARTITION_KEYS + " \"P2\" ON \"P2\".\"TBL_ID\" = " + this.TBLS + ".\"TBL_ID\" AND  \"P2\".\"INTEGER_IDX\" = " + this.KEY_CONSTRAINTS + ".\"PARENT_INTEGER_IDX\"  WHERE " + this.KEY_CONSTRAINTS + ".\"CONSTRAINT_TYPE\" = 1 AND \"KEY_CONSTRAINTS2\".\"CONSTRAINT_TYPE\" = 0 AND " + this.DBS + ".\"CTLG_NAME\" = ? AND" + (String)(foreign_db_name == null ? "" : " " + this.DBS + ".\"NAME\" = ? AND") + (String)(foreign_tbl_name == null ? "" : " " + this.TBLS + ".\"TBL_NAME\" = ? AND") + (parent_tbl_name == null ? "" : " \"T2\".\"TBL_NAME\" = ? AND") + (parent_db_name == null ? "" : " \"D2\".\"NAME\" = ?");
        if (((String)(queryText = ((String)queryText).trim())).endsWith("AND")) {
            queryText = ((String)queryText).substring(0, ((String)queryText).length() - 3);
        }
        ArrayList<String> pms = new ArrayList<String>();
        pms.add(catName);
        if (foreign_db_name != null) {
            pms.add(foreign_db_name);
        }
        if (foreign_tbl_name != null) {
            pms.add(foreign_tbl_name);
        }
        if (parent_tbl_name != null) {
            pms.add(parent_tbl_name);
        }
        if (parent_db_name != null) {
            pms.add(parent_db_name);
        }
        if (!(sqlResult = this.ensureList(this.executeWithArray(queryParams = this.pm.newQuery("javax.jdo.query.SQL", queryText), pms.toArray(), (String)queryText))).isEmpty()) {
            for (Object[] line : sqlResult) {
                int enableValidateRely = this.extractSqlInt(line[11]);
                boolean enable = (enableValidateRely & 4) != 0;
                boolean validate = (enableValidateRely & 2) != 0;
                boolean rely = (enableValidateRely & 1) != 0;
                SQLForeignKey currKey = new SQLForeignKey(this.extractSqlString(line[0]), this.extractSqlString(line[1]), this.extractSqlString(line[2]), this.extractSqlString(line[3]), this.extractSqlString(line[4]), this.extractSqlString(line[5]), this.extractSqlInt(line[6]), this.extractSqlInt(line[7]), this.extractSqlInt(line[8]), this.extractSqlString(line[9]), this.extractSqlString(line[10]), enable, validate, rely);
                currKey.setCatName(catName);
                ret.add(currKey);
            }
        }
        return ret;
    }

    public List<SQLPrimaryKey> getPrimaryKeys(String catName, String db_name, String tbl_name) throws MetaException {
        Query queryParams;
        List<Object[]> sqlResult;
        ArrayList<SQLPrimaryKey> ret = new ArrayList<SQLPrimaryKey>();
        Object queryText = "SELECT " + this.DBS + ".\"NAME\", " + this.TBLS + ".\"TBL_NAME\", CASE WHEN " + this.COLUMNS_V2 + ".\"COLUMN_NAME\" IS NOT NULL THEN " + this.COLUMNS_V2 + ".\"COLUMN_NAME\" ELSE " + this.PARTITION_KEYS + ".\"PKEY_NAME\" END, " + this.KEY_CONSTRAINTS + ".\"POSITION\", " + this.KEY_CONSTRAINTS + ".\"CONSTRAINT_NAME\", " + this.KEY_CONSTRAINTS + ".\"ENABLE_VALIDATE_RELY\", " + this.DBS + ".\"CTLG_NAME\" from " + this.TBLS + "  INNER JOIN " + this.KEY_CONSTRAINTS + " ON " + this.TBLS + ".\"TBL_ID\" = " + this.KEY_CONSTRAINTS + ".\"PARENT_TBL_ID\"  INNER JOIN " + this.DBS + " ON " + this.TBLS + ".\"DB_ID\" = " + this.DBS + ".\"DB_ID\"  LEFT OUTER JOIN " + this.COLUMNS_V2 + " ON " + this.COLUMNS_V2 + ".\"CD_ID\" = " + this.KEY_CONSTRAINTS + ".\"PARENT_CD_ID\" AND  " + this.COLUMNS_V2 + ".\"INTEGER_IDX\" = " + this.KEY_CONSTRAINTS + ".\"PARENT_INTEGER_IDX\"  LEFT OUTER JOIN " + this.PARTITION_KEYS + " ON " + this.TBLS + ".\"TBL_ID\" = " + this.PARTITION_KEYS + ".\"TBL_ID\" AND  " + this.PARTITION_KEYS + ".\"INTEGER_IDX\" = " + this.KEY_CONSTRAINTS + ".\"PARENT_INTEGER_IDX\"  WHERE " + this.KEY_CONSTRAINTS + ".\"CONSTRAINT_TYPE\" = 0 AND " + this.DBS + ".\"CTLG_NAME\" = ? AND" + (String)(db_name == null ? "" : " " + this.DBS + ".\"NAME\" = ? AND") + (String)(tbl_name == null ? "" : " " + this.TBLS + ".\"TBL_NAME\" = ? ");
        if (((String)(queryText = ((String)queryText).trim())).endsWith("AND")) {
            queryText = ((String)queryText).substring(0, ((String)queryText).length() - 3);
        }
        ArrayList<String> pms = new ArrayList<String>();
        pms.add(catName);
        if (db_name != null) {
            pms.add(db_name);
        }
        if (tbl_name != null) {
            pms.add(tbl_name);
        }
        if (!(sqlResult = this.ensureList(this.executeWithArray(queryParams = this.pm.newQuery("javax.jdo.query.SQL", queryText), pms.toArray(), (String)queryText))).isEmpty()) {
            for (Object[] line : sqlResult) {
                int enableValidateRely = this.extractSqlInt(line[5]);
                boolean enable = (enableValidateRely & 4) != 0;
                boolean validate = (enableValidateRely & 2) != 0;
                boolean rely = (enableValidateRely & 1) != 0;
                SQLPrimaryKey currKey = new SQLPrimaryKey(this.extractSqlString(line[0]), this.extractSqlString(line[1]), this.extractSqlString(line[2]), this.extractSqlInt(line[3]), this.extractSqlString(line[4]), enable, validate, rely);
                currKey.setCatName(this.extractSqlString(line[6]));
                ret.add(currKey);
            }
        }
        return ret;
    }

    public List<SQLUniqueConstraint> getUniqueConstraints(String catName, String db_name, String tbl_name) throws MetaException {
        Query queryParams;
        List<Object[]> sqlResult;
        ArrayList<SQLUniqueConstraint> ret = new ArrayList<SQLUniqueConstraint>();
        Object queryText = "SELECT " + this.DBS + ".\"NAME\", " + this.TBLS + ".\"TBL_NAME\", CASE WHEN " + this.COLUMNS_V2 + ".\"COLUMN_NAME\" IS NOT NULL THEN " + this.COLUMNS_V2 + ".\"COLUMN_NAME\" ELSE " + this.PARTITION_KEYS + ".\"PKEY_NAME\" END, " + this.KEY_CONSTRAINTS + ".\"POSITION\", " + this.KEY_CONSTRAINTS + ".\"CONSTRAINT_NAME\", " + this.KEY_CONSTRAINTS + ".\"ENABLE_VALIDATE_RELY\"  from " + this.TBLS + "  INNER JOIN " + this.KEY_CONSTRAINTS + " ON " + this.TBLS + ".\"TBL_ID\" = " + this.KEY_CONSTRAINTS + ".\"PARENT_TBL_ID\"  INNER JOIN " + this.DBS + " ON " + this.TBLS + ".\"DB_ID\" = " + this.DBS + ".\"DB_ID\"  LEFT OUTER JOIN " + this.COLUMNS_V2 + " ON " + this.COLUMNS_V2 + ".\"CD_ID\" = " + this.KEY_CONSTRAINTS + ".\"PARENT_CD_ID\" AND  " + this.COLUMNS_V2 + ".\"INTEGER_IDX\" = " + this.KEY_CONSTRAINTS + ".\"PARENT_INTEGER_IDX\"  LEFT OUTER JOIN " + this.PARTITION_KEYS + " ON " + this.TBLS + ".\"TBL_ID\" = " + this.PARTITION_KEYS + ".\"TBL_ID\" AND  " + this.PARTITION_KEYS + ".\"INTEGER_IDX\" = " + this.KEY_CONSTRAINTS + ".\"PARENT_INTEGER_IDX\"  WHERE " + this.KEY_CONSTRAINTS + ".\"CONSTRAINT_TYPE\" = 2 AND " + this.DBS + ".\"CTLG_NAME\" = ? AND" + (String)(db_name == null ? "" : " " + this.DBS + ".\"NAME\" = ? AND") + (String)(tbl_name == null ? "" : " " + this.TBLS + ".\"TBL_NAME\" = ? ");
        if (((String)(queryText = ((String)queryText).trim())).endsWith("AND")) {
            queryText = ((String)queryText).substring(0, ((String)queryText).length() - 3);
        }
        ArrayList<String> pms = new ArrayList<String>();
        pms.add(catName);
        if (db_name != null) {
            pms.add(db_name);
        }
        if (tbl_name != null) {
            pms.add(tbl_name);
        }
        if (!(sqlResult = this.ensureList(this.executeWithArray(queryParams = this.pm.newQuery("javax.jdo.query.SQL", queryText), pms.toArray(), (String)queryText))).isEmpty()) {
            for (Object[] line : sqlResult) {
                int enableValidateRely = this.extractSqlInt(line[5]);
                boolean enable = (enableValidateRely & 4) != 0;
                boolean validate = (enableValidateRely & 2) != 0;
                boolean rely = (enableValidateRely & 1) != 0;
                ret.add(new SQLUniqueConstraint(catName, this.extractSqlString(line[0]), this.extractSqlString(line[1]), this.extractSqlString(line[2]), this.extractSqlInt(line[3]), this.extractSqlString(line[4]), enable, validate, rely));
            }
        }
        return ret;
    }

    public List<SQLNotNullConstraint> getNotNullConstraints(String catName, String db_name, String tbl_name) throws MetaException {
        Query queryParams;
        List<Object[]> sqlResult;
        ArrayList<SQLNotNullConstraint> ret = new ArrayList<SQLNotNullConstraint>();
        Object queryText = "SELECT " + this.DBS + ".\"NAME\", " + this.TBLS + ".\"TBL_NAME\",CASE WHEN " + this.COLUMNS_V2 + ".\"COLUMN_NAME\" IS NOT NULL THEN " + this.COLUMNS_V2 + ".\"COLUMN_NAME\" ELSE " + this.PARTITION_KEYS + ".\"PKEY_NAME\" END, " + this.KEY_CONSTRAINTS + ".\"CONSTRAINT_NAME\", " + this.KEY_CONSTRAINTS + ".\"ENABLE_VALIDATE_RELY\"  from " + this.TBLS + "  INNER JOIN " + this.KEY_CONSTRAINTS + " ON " + this.TBLS + ".\"TBL_ID\" = " + this.KEY_CONSTRAINTS + ".\"PARENT_TBL_ID\"  INNER JOIN " + this.DBS + " ON " + this.TBLS + ".\"DB_ID\" = " + this.DBS + ".\"DB_ID\"  LEFT OUTER JOIN " + this.COLUMNS_V2 + " ON " + this.COLUMNS_V2 + ".\"CD_ID\" = " + this.KEY_CONSTRAINTS + ".\"PARENT_CD_ID\" AND  " + this.COLUMNS_V2 + ".\"INTEGER_IDX\" = " + this.KEY_CONSTRAINTS + ".\"PARENT_INTEGER_IDX\"  LEFT OUTER JOIN " + this.PARTITION_KEYS + " ON " + this.TBLS + ".\"TBL_ID\" = " + this.PARTITION_KEYS + ".\"TBL_ID\" AND  " + this.PARTITION_KEYS + ".\"INTEGER_IDX\" = " + this.KEY_CONSTRAINTS + ".\"PARENT_INTEGER_IDX\"  WHERE " + this.KEY_CONSTRAINTS + ".\"CONSTRAINT_TYPE\" = 3 AND " + this.DBS + ".\"CTLG_NAME\" = ? AND" + (String)(db_name == null ? "" : " " + this.DBS + ".\"NAME\" = ? AND") + (String)(tbl_name == null ? "" : " " + this.TBLS + ".\"TBL_NAME\" = ? ");
        if (((String)(queryText = ((String)queryText).trim())).endsWith("AND")) {
            queryText = ((String)queryText).substring(0, ((String)queryText).length() - 3);
        }
        ArrayList<String> pms = new ArrayList<String>();
        pms.add(catName);
        if (db_name != null) {
            pms.add(db_name);
        }
        if (tbl_name != null) {
            pms.add(tbl_name);
        }
        if (!(sqlResult = this.ensureList(this.executeWithArray(queryParams = this.pm.newQuery("javax.jdo.query.SQL", queryText), pms.toArray(), (String)queryText))).isEmpty()) {
            for (Object[] line : sqlResult) {
                int enableValidateRely = this.extractSqlInt(line[4]);
                boolean enable = (enableValidateRely & 4) != 0;
                boolean validate = (enableValidateRely & 2) != 0;
                boolean rely = (enableValidateRely & 1) != 0;
                ret.add(new SQLNotNullConstraint(catName, this.extractSqlString(line[0]), this.extractSqlString(line[1]), this.extractSqlString(line[2]), this.extractSqlString(line[3]), enable, validate, rely));
            }
        }
        return ret;
    }

    public List<SQLDefaultConstraint> getDefaultConstraints(String catName, String db_name, String tbl_name) throws MetaException {
        Query queryParams;
        List<Object[]> sqlResult;
        ArrayList<SQLDefaultConstraint> ret = new ArrayList<SQLDefaultConstraint>();
        Object queryText = "SELECT " + this.DBS + ".\"NAME\", " + this.TBLS + ".\"TBL_NAME\",CASE WHEN " + this.COLUMNS_V2 + ".\"COLUMN_NAME\" IS NOT NULL THEN " + this.COLUMNS_V2 + ".\"COLUMN_NAME\" ELSE " + this.PARTITION_KEYS + ".\"PKEY_NAME\" END, " + this.KEY_CONSTRAINTS + ".\"CONSTRAINT_NAME\", " + this.KEY_CONSTRAINTS + ".\"ENABLE_VALIDATE_RELY\", " + this.KEY_CONSTRAINTS + ".\"DEFAULT_VALUE\"  from " + this.TBLS + "  INNER JOIN " + this.KEY_CONSTRAINTS + " ON " + this.TBLS + ".\"TBL_ID\" = " + this.KEY_CONSTRAINTS + ".\"PARENT_TBL_ID\"  INNER JOIN " + this.DBS + " ON " + this.TBLS + ".\"DB_ID\" = " + this.DBS + ".\"DB_ID\"  LEFT OUTER JOIN " + this.COLUMNS_V2 + " ON " + this.COLUMNS_V2 + ".\"CD_ID\" = " + this.KEY_CONSTRAINTS + ".\"PARENT_CD_ID\" AND  " + this.COLUMNS_V2 + ".\"INTEGER_IDX\" = " + this.KEY_CONSTRAINTS + ".\"PARENT_INTEGER_IDX\"  LEFT OUTER JOIN " + this.PARTITION_KEYS + " ON " + this.TBLS + ".\"TBL_ID\" = " + this.PARTITION_KEYS + ".\"TBL_ID\" AND  " + this.PARTITION_KEYS + ".\"INTEGER_IDX\" = " + this.KEY_CONSTRAINTS + ".\"PARENT_INTEGER_IDX\"  WHERE " + this.KEY_CONSTRAINTS + ".\"CONSTRAINT_TYPE\" = 4 AND " + this.DBS + ".\"CTLG_NAME\" = ? AND" + (String)(db_name == null ? "" : " " + this.DBS + ".\"NAME\" = ? AND") + (String)(tbl_name == null ? "" : " " + this.TBLS + ".\"TBL_NAME\" = ? ");
        if (((String)(queryText = ((String)queryText).trim())).endsWith("AND")) {
            queryText = ((String)queryText).substring(0, ((String)queryText).length() - 3);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("getDefaultConstraints: directsql : " + (String)queryText);
        }
        ArrayList<String> pms = new ArrayList<String>();
        pms.add(catName);
        if (db_name != null) {
            pms.add(db_name);
        }
        if (tbl_name != null) {
            pms.add(tbl_name);
        }
        if (!(sqlResult = this.ensureList(this.executeWithArray(queryParams = this.pm.newQuery("javax.jdo.query.SQL", queryText), pms.toArray(), (String)queryText))).isEmpty()) {
            for (Object[] line : sqlResult) {
                int enableValidateRely = this.extractSqlInt(line[4]);
                boolean enable = (enableValidateRely & 4) != 0;
                boolean validate = (enableValidateRely & 2) != 0;
                boolean rely = (enableValidateRely & 1) != 0;
                SQLDefaultConstraint currConstraint = new SQLDefaultConstraint(catName, this.extractSqlString(line[0]), this.extractSqlString(line[1]), this.extractSqlString(line[2]), this.extractSqlString(line[5]), this.extractSqlString(line[3]), enable, validate, rely);
                ret.add(currConstraint);
            }
        }
        return ret;
    }

    public List<SQLCheckConstraint> getCheckConstraints(String catName, String db_name, String tbl_name) throws MetaException {
        Query queryParams;
        List<Object[]> sqlResult;
        ArrayList<SQLCheckConstraint> ret = new ArrayList<SQLCheckConstraint>();
        Object queryText = "SELECT " + this.DBS + ".\"NAME\", " + this.TBLS + ".\"TBL_NAME\",CASE WHEN " + this.COLUMNS_V2 + ".\"COLUMN_NAME\" IS NOT NULL THEN " + this.COLUMNS_V2 + ".\"COLUMN_NAME\" ELSE " + this.PARTITION_KEYS + ".\"PKEY_NAME\" END, " + this.KEY_CONSTRAINTS + ".\"CONSTRAINT_NAME\", " + this.KEY_CONSTRAINTS + ".\"ENABLE_VALIDATE_RELY\", " + this.KEY_CONSTRAINTS + ".\"DEFAULT_VALUE\"  from " + this.TBLS + "  INNER JOIN " + this.KEY_CONSTRAINTS + " ON " + this.TBLS + ".\"TBL_ID\" = " + this.KEY_CONSTRAINTS + ".\"PARENT_TBL_ID\"  INNER JOIN " + this.DBS + " ON " + this.TBLS + ".\"DB_ID\" = " + this.DBS + ".\"DB_ID\"  LEFT OUTER JOIN " + this.COLUMNS_V2 + " ON " + this.COLUMNS_V2 + ".\"CD_ID\" = " + this.KEY_CONSTRAINTS + ".\"PARENT_CD_ID\" AND  " + this.COLUMNS_V2 + ".\"INTEGER_IDX\" = " + this.KEY_CONSTRAINTS + ".\"PARENT_INTEGER_IDX\"  LEFT OUTER JOIN " + this.PARTITION_KEYS + " ON " + this.TBLS + ".\"TBL_ID\" = " + this.PARTITION_KEYS + ".\"TBL_ID\" AND  " + this.PARTITION_KEYS + ".\"INTEGER_IDX\" = " + this.KEY_CONSTRAINTS + ".\"PARENT_INTEGER_IDX\"  WHERE " + this.KEY_CONSTRAINTS + ".\"CONSTRAINT_TYPE\" = 5 AND " + this.DBS + ".\"CTLG_NAME\" = ? AND" + (String)(db_name == null ? "" : " " + this.DBS + ".\"NAME\" = ? AND") + (String)(tbl_name == null ? "" : " " + this.TBLS + ".\"TBL_NAME\" = ? ");
        if (((String)(queryText = ((String)queryText).trim())).endsWith("AND")) {
            queryText = ((String)queryText).substring(0, ((String)queryText).length() - 3);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("getCheckConstraints: directsql : " + (String)queryText);
        }
        ArrayList<String> pms = new ArrayList<String>();
        pms.add(catName);
        if (db_name != null) {
            pms.add(db_name);
        }
        if (tbl_name != null) {
            pms.add(tbl_name);
        }
        if (!(sqlResult = this.ensureList(this.executeWithArray(queryParams = this.pm.newQuery("javax.jdo.query.SQL", queryText), pms.toArray(), (String)queryText))).isEmpty()) {
            for (Object[] line : sqlResult) {
                int enableValidateRely = this.extractSqlInt(line[4]);
                boolean enable = (enableValidateRely & 4) != 0;
                boolean validate = (enableValidateRely & 2) != 0;
                boolean rely = (enableValidateRely & 1) != 0;
                SQLCheckConstraint currConstraint = new SQLCheckConstraint(catName, this.extractSqlString(line[0]), this.extractSqlString(line[1]), this.extractSqlString(line[2]), this.extractSqlString(line[5]), this.extractSqlString(line[3]), enable, validate, rely);
                ret.add(currConstraint);
            }
        }
        return ret;
    }

    public List<MetaStoreUtils.FullTableName> getTableNamesWithStats() throws MetaException {
        String queryText0 = "SELECT DISTINCT " + this.TBLS + ".\"TBL_NAME\", " + this.DBS + ".\"NAME\", " + this.DBS + ".\"CTLG_NAME\" FROM " + this.TBLS + " INNER JOIN " + this.DBS + " ON " + this.TBLS + ".\"DB_ID\" = " + this.DBS + ".\"DB_ID\"";
        String queryText1 = " WHERE " + this.TBLS + ".\"TBL_TYPE\" IN (" + this.makeParams(STATS_TABLE_TYPES.length) + ")";
        ArrayList<MetaStoreUtils.FullTableName> result = new ArrayList<MetaStoreUtils.FullTableName>();
        String queryText = queryText0 + " INNER JOIN " + this.TAB_COL_STATS + " ON " + this.TBLS + ".\"TBL_ID\" = " + this.TAB_COL_STATS + ".\"TBL_ID\"" + queryText1;
        this.getStatsTableListResult(queryText, result);
        queryText = queryText0 + " INNER JOIN " + this.PARTITIONS + " ON " + this.TBLS + ".\"TBL_ID\" = " + this.PARTITIONS + ".\"TBL_ID\" INNER JOIN " + this.PART_COL_STATS + " ON " + this.PARTITIONS + ".\"PART_ID\" = " + this.PART_COL_STATS + ".\"PART_ID\"" + queryText1;
        this.getStatsTableListResult(queryText, result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<String>> getColAndPartNamesWithStats(String catName, String dbName, String tableName) throws MetaException {
        String queryText = "SELECT DISTINCT " + this.PARTITIONS + ".\"PART_NAME\", " + this.PART_COL_STATS + ".\"COLUMN_NAME\" FROM " + this.TBLS + " INNER JOIN " + this.DBS + " ON " + this.TBLS + ".\"DB_ID\" = " + this.DBS + ".\"DB_ID\" INNER JOIN " + this.PARTITIONS + " ON " + this.TBLS + ".\"TBL_ID\" = " + this.PARTITIONS + ".\"TBL_ID\"  INNER JOIN " + this.PART_COL_STATS + " ON " + this.PARTITIONS + ".\"PART_ID\" = " + this.PART_COL_STATS + ".\"PART_ID\" WHERE " + this.DBS + ".\"NAME\" = ? AND " + this.DBS + ".\"CTLG_NAME\" = ? AND " + this.TBLS + ".\"TBL_NAME\" = ? ORDER BY " + this.PARTITIONS + ".\"PART_NAME\"";
        LOG.debug("Running {}", (Object)queryText);
        Query query = this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText);
        try {
            List<Object[]> sqlResult = this.ensureList(this.executeWithArray(query, new Object[]{dbName, catName, tableName}, queryText));
            HashMap result = new HashMap();
            String lastPartName = null;
            ArrayList<String> cols = null;
            for (Object[] line : sqlResult) {
                String col = this.extractSqlString(line[1]);
                String part = this.extractSqlString(line[0]);
                if (!part.equals(lastPartName)) {
                    if (lastPartName != null) {
                        result.put(lastPartName, cols);
                    }
                    cols = cols == null ? new ArrayList<String>() : new ArrayList(cols.size());
                    lastPartName = part;
                }
                cols.add(col);
            }
            if (lastPartName != null) {
                result.put(lastPartName, cols);
            }
            HashMap hashMap = result;
            return hashMap;
        }
        finally {
            query.closeAll();
        }
    }

    public List<MetaStoreUtils.FullTableName> getAllTableNamesForStats() throws MetaException {
        String queryText = "SELECT " + this.TBLS + ".\"TBL_NAME\", " + this.DBS + ".\"NAME\", " + this.DBS + ".\"CTLG_NAME\" FROM " + this.TBLS + " INNER JOIN " + this.DBS + " ON " + this.TBLS + ".\"DB_ID\" = " + this.DBS + ".\"DB_ID\" WHERE " + this.TBLS + ".\"TBL_TYPE\" IN (" + this.makeParams(STATS_TABLE_TYPES.length) + ")";
        ArrayList<MetaStoreUtils.FullTableName> result = new ArrayList<MetaStoreUtils.FullTableName>();
        this.getStatsTableListResult(queryText, result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getStatsTableListResult(String queryText, List<MetaStoreUtils.FullTableName> result) throws MetaException {
        LOG.debug("Running {}", (Object)queryText);
        Query query = this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText);
        try {
            List<Object[]> sqlResult = this.ensureList(this.executeWithArray(query, STATS_TABLE_TYPES, queryText));
            for (Object[] line : sqlResult) {
                result.add(new MetaStoreUtils.FullTableName(this.extractSqlString(line[2]), this.extractSqlString(line[1]), this.extractSqlString(line[0])));
            }
        }
        finally {
            query.closeAll();
        }
    }

    private static abstract class Batchable<I, R> {
        private List<Query> queries = null;

        private Batchable() {
        }

        public abstract List<R> run(List<I> var1) throws MetaException;

        public void addQueryAfterUse(Query query) {
            if (this.queries == null) {
                this.queries = new ArrayList<Query>(1);
            }
            this.queries.add(query);
        }

        protected void addQueryAfterUse(Batchable<?, ?> b) {
            if (b.queries == null) {
                return;
            }
            if (this.queries == null) {
                this.queries = new ArrayList<Query>(1);
            }
            this.queries.addAll(b.queries);
        }

        public void closeAllQueries() {
            for (Query q : this.queries) {
                try {
                    q.closeAll();
                }
                catch (Throwable t) {
                    LOG.error("Failed to close a query", t);
                }
            }
        }
    }

    private static class PartitionFilterGenerator
    extends ExpressionTree.TreeVisitor {
        private final Table table;
        private final ExpressionTree.FilterBuilder filterBuffer;
        private final List<Object> params;
        private final List<String> joins;
        private final boolean dbHasJoinCastBug;
        private final String defaultPartName;
        private final DatabaseProduct dbType;
        private final String PARTITION_KEY_VALS;
        private final String PARTITIONS;
        private final String DBS;
        private final String TBLS;

        private PartitionFilterGenerator(Table table, List<Object> params, List<String> joins, boolean dbHasJoinCastBug, String defaultPartName, DatabaseProduct dbType, String schema) {
            this.table = table;
            this.params = params;
            this.joins = joins;
            this.dbHasJoinCastBug = dbHasJoinCastBug;
            this.filterBuffer = new ExpressionTree.FilterBuilder(false);
            this.defaultPartName = defaultPartName;
            this.dbType = dbType;
            this.PARTITION_KEY_VALS = MetaStoreDirectSql.getFullyQualifiedName(schema, "PARTITION_KEY_VALS");
            this.PARTITIONS = MetaStoreDirectSql.getFullyQualifiedName(schema, "PARTITIONS");
            this.DBS = MetaStoreDirectSql.getFullyQualifiedName(schema, "DBS");
            this.TBLS = MetaStoreDirectSql.getFullyQualifiedName(schema, "TBLS");
        }

        private static String generateSqlFilter(Table table, ExpressionTree tree, List<Object> params, List<String> joins, boolean dbHasJoinCastBug, String defaultPartName, DatabaseProduct dbType, String schema) throws MetaException {
            assert (table != null);
            if (tree == null) {
                return null;
            }
            if (tree.getRoot() == null) {
                return "";
            }
            PartitionFilterGenerator visitor = new PartitionFilterGenerator(table, params, joins, dbHasJoinCastBug, defaultPartName, dbType, schema);
            tree.accept(visitor);
            if (visitor.filterBuffer.hasError()) {
                LOG.info("Unable to push down SQL filter: " + visitor.filterBuffer.getErrorMessage());
                return null;
            }
            for (int i = 0; i < joins.size(); ++i) {
                if (joins.get(i) != null) continue;
                joins.remove(i--);
            }
            return "(" + visitor.filterBuffer.getFilter() + ")";
        }

        @Override
        protected void beginTreeNode(ExpressionTree.TreeNode node) throws MetaException {
            this.filterBuffer.append(" (");
        }

        @Override
        protected void midTreeNode(ExpressionTree.TreeNode node) throws MetaException {
            this.filterBuffer.append(node.getAndOr() == ExpressionTree.LogicalOperator.AND ? " and " : " or ");
        }

        @Override
        protected void endTreeNode(ExpressionTree.TreeNode node) throws MetaException {
            this.filterBuffer.append(") ");
        }

        @Override
        protected boolean shouldStop() {
            return this.filterBuffer.hasError();
        }

        @Override
        public void visit(ExpressionTree.LeafNode node) throws MetaException {
            if (node.operator == ExpressionTree.Operator.LIKE) {
                this.filterBuffer.setError("LIKE is not supported for SQL filter pushdown");
                return;
            }
            int partColCount = this.table.getPartitionKeys().size();
            int partColIndex = node.getPartColIndexForFilter(this.table, this.filterBuffer);
            if (this.filterBuffer.hasError()) {
                return;
            }
            String colTypeStr = this.table.getPartitionKeys().get(partColIndex).getType();
            FilterType colType = FilterType.fromType(colTypeStr);
            if (colType == FilterType.Invalid) {
                this.filterBuffer.setError("Filter pushdown not supported for type " + colTypeStr);
                return;
            }
            FilterType valType = FilterType.fromClass(node.value);
            Object nodeValue = node.value;
            if (valType == FilterType.Invalid) {
                this.filterBuffer.setError("Filter pushdown not supported for value " + node.value.getClass());
                return;
            }
            if (colType == FilterType.Date && valType == FilterType.String) {
                try {
                    nodeValue = MetaStoreUtils.PARTITION_DATE_FORMAT.get().parse((String)nodeValue);
                    valType = FilterType.Date;
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            if (valType == FilterType.Date) {
                nodeValue = MetaStoreUtils.PARTITION_DATE_FORMAT.get().format(nodeValue);
            }
            if (colType != valType) {
                this.filterBuffer.setError("Cannot push down filter for " + colTypeStr + " column and value " + nodeValue.getClass());
                return;
            }
            if (this.joins.isEmpty()) {
                for (int i = 0; i < partColCount; ++i) {
                    this.joins.add(null);
                }
            }
            if (this.joins.get(partColIndex) == null) {
                this.joins.set(partColIndex, "inner join " + this.PARTITION_KEY_VALS + " \"FILTER" + partColIndex + "\" on \"FILTER" + partColIndex + "\".\"PART_ID\" = " + this.PARTITIONS + ".\"PART_ID\" and \"FILTER" + partColIndex + "\".\"INTEGER_IDX\" = " + partColIndex);
            }
            String tableValue = "\"FILTER" + partColIndex + "\".\"PART_KEY_VAL\"";
            if (node.isReverseOrder) {
                this.params.add(nodeValue);
            }
            String tableColumn = tableValue;
            if (colType != FilterType.String) {
                if (colType == FilterType.Integral) {
                    tableValue = "cast(" + tableValue + " as decimal(21,0))";
                } else if (colType == FilterType.Date) {
                    tableValue = this.dbType == DatabaseProduct.ORACLE ? "TO_DATE(" + tableValue + ", 'YYYY-MM-DD')" : "cast(" + tableValue + " as date)";
                }
                String tableValue0 = tableValue;
                tableValue = "(case when " + tableColumn + " <> ?";
                this.params.add(this.defaultPartName);
                if (this.dbHasJoinCastBug) {
                    tableValue = tableValue + " and " + this.TBLS + ".\"TBL_NAME\" = ? and " + this.DBS + ".\"NAME\" = ? and " + this.DBS + ".\"CTLG_NAME\" = ? and \"FILTER" + partColIndex + "\".\"PART_ID\" = " + this.PARTITIONS + ".\"PART_ID\" and \"FILTER" + partColIndex + "\".\"INTEGER_IDX\" = " + partColIndex;
                    this.params.add(this.table.getTableName().toLowerCase());
                    this.params.add(this.table.getDbName().toLowerCase());
                    this.params.add(this.table.getCatName().toLowerCase());
                }
                tableValue = tableValue + " then " + tableValue0 + " else null end)";
            }
            if (!node.isReverseOrder) {
                this.params.add(nodeValue);
            }
            this.filterBuffer.append(node.isReverseOrder ? "(? " + node.operator.getSqlOp() + " " + tableValue + ")" : "(" + tableValue + " " + node.operator.getSqlOp() + " ?)");
        }

        private static enum FilterType {
            Integral,
            String,
            Date,
            Invalid;


            static FilterType fromType(String colTypeStr) {
                if (colTypeStr.equals("string")) {
                    return String;
                }
                if (colTypeStr.equals("date")) {
                    return Date;
                }
                if (ColumnType.IntegralTypes.contains(colTypeStr)) {
                    return Integral;
                }
                return Invalid;
            }

            public static FilterType fromClass(Object value) {
                if (value instanceof String) {
                    return String;
                }
                if (value instanceof Long) {
                    return Integral;
                }
                if (value instanceof Date) {
                    return Date;
                }
                return Invalid;
            }
        }
    }

    private abstract class ApplyFunc<Target> {
        private ApplyFunc() {
        }

        public abstract void apply(Target var1, Object[] var2) throws MetaException;
    }

    public static class SqlFilterForPushdown {
        private final List<Object> params = new ArrayList<Object>();
        private final List<String> joins = new ArrayList<String>();
        private String filter;
        private Table table;
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    private static @interface TableName {
    }
}

