/*
 * Decompiled with CFR 0.152.
 */
package com.jolbox.bonecp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.MapMaker;
import com.jolbox.bonecp.BoneCP;
import com.jolbox.bonecp.CallableStatementHandle;
import com.jolbox.bonecp.ConnectionPartition;
import com.jolbox.bonecp.IStatementCache;
import com.jolbox.bonecp.MemorizeTransactionProxy;
import com.jolbox.bonecp.PreparedStatementHandle;
import com.jolbox.bonecp.ReplayLog;
import com.jolbox.bonecp.StatementCache;
import com.jolbox.bonecp.StatementHandle;
import com.jolbox.bonecp.Statistics;
import com.jolbox.bonecp.hooks.ConnectionHook;
import com.jolbox.bonecp.hooks.ConnectionState;
import com.jolbox.bonecp.proxy.TransactionRecoveryResult;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.reflect.Proxy;
import java.net.SocketException;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionHandle
implements Connection,
Serializable {
    private static final long serialVersionUID = 5969210523116801522L;
    private static final String SET_AUTO_COMMIT_FALSE_WAS_CALLED_MESSAGE = "setAutoCommit(false) was called but transaction was not COMMITted or ROLLBACKed properly before it was closed.\n";
    private static final String STATEMENT_NOT_CLOSED = "Stack trace of location where statement was opened follows:\n%s";
    private static final String LOG_ERROR_MESSAGE = "Connection closed twice exception detected.\n%s\n%s\n";
    private static final String UNCLOSED_LOG_ERROR_MESSAGE = "Statement was not properly closed off before this connection was closed.\n%s";
    private static final String CLOSED_TWICE_EXCEPTION_MESSAGE = "Connection closed from thread [%s] was closed again.\nStack trace of location where connection was first closed follows:\n";
    protected static boolean testSupport;
    protected Connection connection = null;
    private long connectionLastUsedInMs;
    private long connectionLastResetInMs;
    protected long connectionCreationTimeInMs;
    private BoneCP pool;
    private Boolean defaultReadOnly;
    private String defaultCatalog;
    private int defaultTransactionIsolationValue = -1;
    private Boolean defaultAutoCommit;
    protected boolean resetConnectionOnClose;
    protected boolean possiblyBroken;
    protected AtomicBoolean logicallyClosed = new AtomicBoolean();
    private ConnectionPartition originatingPartition = null;
    private IStatementCache preparedStatementCache = null;
    private IStatementCache callableStatementCache = null;
    protected static Logger logger;
    private Object debugHandle;
    private ConnectionHook connectionHook;
    protected boolean doubleCloseCheck;
    protected volatile String doubleCloseException = null;
    private boolean logStatementsEnabled;
    protected boolean statementCachingEnabled;
    private List<ReplayLog> replayLog;
    private boolean inReplayMode;
    protected TransactionRecoveryResult recoveryResult;
    protected String url;
    protected Thread threadUsingConnection;
    @VisibleForTesting
    protected long maxConnectionAgeInMs;
    private boolean statisticsEnabled;
    private Statistics statistics;
    private volatile Thread threadWatch;
    protected Map<Connection, Reference<ConnectionHandle>> finalizableRefs;
    protected boolean connectionTrackingDisabled;
    @VisibleForTesting
    protected boolean txResolved = true;
    @VisibleForTesting
    protected boolean detectUnresolvedTransactions;
    protected String autoCommitStackTrace;
    protected boolean detectUnclosedStatements;
    protected boolean closeOpenStatements;
    private static final ImmutableSet<String> sqlStateDBFailureCodes;
    protected ConcurrentMap<Statement, String> trackedStatement;
    private final String noStackTrace = "";

    protected ConnectionHandle(Connection connection, ConnectionPartition partition, BoneCP pool, boolean recreating) throws SQLException {
        boolean newConnection = connection == null;
        this.originatingPartition = partition;
        this.pool = pool;
        this.connectionHook = pool.getConfig().getConnectionHook();
        if (!recreating) {
            this.connectionLastUsedInMs = System.currentTimeMillis();
            this.connectionLastResetInMs = System.currentTimeMillis();
            this.connectionCreationTimeInMs = System.currentTimeMillis();
        }
        this.url = pool.getConfig().getJdbcUrl();
        this.finalizableRefs = pool.getFinalizableRefs();
        this.defaultReadOnly = pool.getConfig().getDefaultReadOnly();
        this.defaultCatalog = pool.getConfig().getDefaultCatalog();
        this.defaultTransactionIsolationValue = pool.getConfig().getDefaultTransactionIsolationValue();
        this.defaultAutoCommit = pool.getConfig().getDefaultAutoCommit();
        this.resetConnectionOnClose = pool.getConfig().isResetConnectionOnClose();
        this.connectionTrackingDisabled = pool.getConfig().isDisableConnectionTracking();
        this.statisticsEnabled = pool.getConfig().isStatisticsEnabled();
        this.statistics = pool.getStatistics();
        this.detectUnresolvedTransactions = pool.getConfig().isDetectUnresolvedTransactions();
        this.detectUnclosedStatements = pool.getConfig().isDetectUnclosedStatements();
        this.closeOpenStatements = pool.getConfig().isCloseOpenStatements();
        if (this.closeOpenStatements) {
            this.trackedStatement = new MapMaker().makeMap();
        }
        this.threadUsingConnection = null;
        this.connectionHook = this.pool.getConfig().getConnectionHook();
        this.maxConnectionAgeInMs = pool.getConfig().getMaxConnectionAge(TimeUnit.MILLISECONDS);
        this.doubleCloseCheck = pool.getConfig().isCloseConnectionWatch();
        this.logStatementsEnabled = pool.getConfig().isLogStatementsEnabled();
        int cacheSize = pool.getConfig().getStatementsCacheSize();
        if (cacheSize > 0 && newConnection) {
            this.preparedStatementCache = new StatementCache(cacheSize, pool.getConfig().isStatisticsEnabled(), pool.getStatistics());
            this.callableStatementCache = new StatementCache(cacheSize, pool.getConfig().isStatisticsEnabled(), pool.getStatistics());
            this.statementCachingEnabled = true;
        }
        try {
            this.connection = newConnection ? pool.obtainInternalConnection(this) : connection;
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
        if (this.pool.getConfig().isTransactionRecoveryEnabled()) {
            this.replayLog = new ArrayList<ReplayLog>(30);
            this.recoveryResult = new TransactionRecoveryResult();
            if (!recreating) {
                this.connection = MemorizeTransactionProxy.memorize(this.connection, this);
            }
        }
        if (!(newConnection || connection.getAutoCommit() || connection.isClosed())) {
            connection.rollback();
        }
        if (this.defaultAutoCommit != null) {
            this.setAutoCommit(this.defaultAutoCommit);
        }
        if (this.defaultReadOnly != null) {
            this.setReadOnly(this.defaultReadOnly);
        }
        if (this.defaultCatalog != null) {
            this.setCatalog(this.defaultCatalog);
        }
        if (this.defaultTransactionIsolationValue != -1) {
            this.setTransactionIsolation(this.defaultTransactionIsolationValue);
        }
    }

    public ConnectionHandle recreateConnectionHandle() throws SQLException {
        ConnectionHandle handle = new ConnectionHandle(this.connection, this.originatingPartition, this.pool, true);
        handle.originatingPartition = this.originatingPartition;
        handle.connectionCreationTimeInMs = this.connectionCreationTimeInMs;
        handle.connectionLastResetInMs = this.connectionLastResetInMs;
        handle.connectionLastUsedInMs = this.connectionLastUsedInMs;
        handle.preparedStatementCache = this.preparedStatementCache;
        handle.callableStatementCache = this.callableStatementCache;
        handle.statementCachingEnabled = this.statementCachingEnabled;
        handle.connectionHook = this.connectionHook;
        handle.possiblyBroken = this.possiblyBroken;
        handle.debugHandle = this.debugHandle;
        this.connection = null;
        return handle;
    }

    protected static ConnectionHandle createTestConnectionHandle(Connection connection, IStatementCache preparedStatementCache, IStatementCache callableStatementCache, BoneCP pool) {
        ConnectionHandle handle = new ConnectionHandle();
        handle.connection = connection;
        handle.preparedStatementCache = preparedStatementCache;
        handle.callableStatementCache = callableStatementCache;
        handle.connectionLastUsedInMs = System.currentTimeMillis();
        handle.connectionLastResetInMs = System.currentTimeMillis();
        handle.connectionCreationTimeInMs = System.currentTimeMillis();
        handle.recoveryResult = new TransactionRecoveryResult();
        handle.trackedStatement = new MapMaker().makeMap();
        handle.url = "foo";
        handle.closeOpenStatements = true;
        handle.pool = pool;
        handle.url = null;
        int cacheSize = pool.getConfig().getStatementsCacheSize();
        if (cacheSize > 0) {
            handle.statementCachingEnabled = true;
        }
        return handle;
    }

    private ConnectionHandle() {
    }

    public void sendInitSQL() throws SQLException {
        ConnectionHandle.sendInitSQL(this.connection, this.pool.getConfig().getInitSQL());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void sendInitSQL(Connection connection, String initSQL) throws SQLException {
        if (initSQL != null) {
            Statement stmt = null;
            try {
                stmt = connection.createStatement();
                stmt.execute(initSQL);
                if (testSupport) {
                    stmt = null;
                }
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
    }

    protected SQLException markPossiblyBroken(SQLException e) {
        ConnectionState connectionState;
        String state = e.getSQLState();
        boolean alreadyDestroyed = false;
        ConnectionState connectionState2 = connectionState = this.getConnectionHook() != null ? this.getConnectionHook().onMarkPossiblyBroken(this, state, e) : ConnectionState.NOP;
        if (state == null) {
            state = "08999";
        }
        if ((sqlStateDBFailureCodes.contains((Object)state) || connectionState.equals((Object)ConnectionState.TERMINATE_ALL_CONNECTIONS)) && this.pool != null && this.pool.getDbIsDown().compareAndSet(false, true)) {
            logger.error("Database access problem. Killing off this connection and all remaining connections in the connection pool. SQL State = " + state);
            this.pool.connectionStrategy.terminateAllConnections();
            this.pool.destroyConnection(this);
            this.logicallyClosed.set(true);
            alreadyDestroyed = true;
            for (int i = 0; i < this.pool.partitionCount; ++i) {
                this.pool.partitions[i].getPoolWatchThreadSignalQueue().offer(new Object());
            }
        }
        if ((state.equals("08003") || sqlStateDBFailureCodes.contains((Object)state) || e.getCause() instanceof SocketException) && !alreadyDestroyed) {
            this.pool.destroyConnection(this);
            this.logicallyClosed.set(true);
            this.getOriginatingPartition().getPoolWatchThreadSignalQueue().offer(new Object());
        }
        char firstChar = state.charAt(0);
        if (connectionState.equals((Object)ConnectionState.CONNECTION_POSSIBLY_BROKEN) || state.equals("40001") || state.startsWith("08") || firstChar >= '5' && firstChar <= '9') {
            this.possiblyBroken = true;
        }
        if (this.possiblyBroken && this.getConnectionHook() != null) {
            this.possiblyBroken = this.getConnectionHook().onConnectionException(this, state, e);
        }
        return e;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkClosed();
        try {
            this.connection.clearWarnings();
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
    }

    private void checkClosed() throws SQLException {
        if (this.logicallyClosed.get()) {
            throw new SQLException("Connection is closed!");
        }
    }

    @Override
    public void close() throws SQLException {
        block14: {
            try {
                if (this.resetConnectionOnClose) {
                    this.rollback();
                    if (!this.getAutoCommit()) {
                        this.setAutoCommit(true);
                    }
                }
                if (this.logicallyClosed.compareAndSet(false, true)) {
                    if (this.threadWatch != null) {
                        this.threadWatch.interrupt();
                        this.threadWatch = null;
                    }
                    if (this.closeOpenStatements) {
                        for (Map.Entry statementEntry : this.trackedStatement.entrySet()) {
                            ((Statement)statementEntry.getKey()).close();
                            if (!this.detectUnclosedStatements) continue;
                            logger.warn(String.format(UNCLOSED_LOG_ERROR_MESSAGE, statementEntry.getValue()));
                        }
                        this.trackedStatement.clear();
                    }
                    if (!this.connectionTrackingDisabled) {
                        this.pool.getFinalizableRefs().remove(this.connection);
                    }
                    ConnectionHandle handle = null;
                    try {
                        handle = this.recreateConnectionHandle();
                        this.pool.connectionStrategy.cleanupConnection(this, handle);
                        this.pool.releaseConnection(handle);
                    }
                    catch (SQLException e) {
                        if (!this.isClosed()) {
                            this.pool.connectionStrategy.cleanupConnection(this, handle);
                            this.pool.releaseConnection(this);
                        }
                        throw e;
                    }
                    if (this.doubleCloseCheck) {
                        this.doubleCloseException = this.pool.captureStackTrace(CLOSED_TWICE_EXCEPTION_MESSAGE);
                    }
                    break block14;
                }
                if (this.doubleCloseCheck && this.doubleCloseException != null) {
                    String currentLocation = this.pool.captureStackTrace("Last closed trace from thread [" + Thread.currentThread().getName() + "]:\n");
                    logger.error(String.format(LOG_ERROR_MESSAGE, this.doubleCloseException, currentLocation));
                }
            }
            catch (SQLException e) {
                throw this.markPossiblyBroken(e);
            }
        }
    }

    protected void internalClose() throws SQLException {
        try {
            this.clearStatementCaches(true);
            if (this.connection != null) {
                this.connection.close();
                if (!this.connectionTrackingDisabled && this.finalizableRefs != null) {
                    this.finalizableRefs.remove(this.connection);
                }
            }
            this.logicallyClosed.set(true);
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
    }

    @Override
    public void commit() throws SQLException {
        this.checkClosed();
        try {
            this.connection.commit();
            this.txResolved = true;
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        Properties result = null;
        this.checkClosed();
        try {
            result = this.connection.getClientInfo();
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
        return result;
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        String result = null;
        this.checkClosed();
        try {
            result = this.connection.getClientInfo(name);
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
        return result;
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        boolean result = false;
        this.checkClosed();
        try {
            result = this.connection.isValid(timeout);
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
        return result;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.connection.isWrapperFor(iface);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.connection.unwrap(iface);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.connection.setClientInfo(properties);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.connection.setClientInfo(name, value);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        Struct result = null;
        this.checkClosed();
        try {
            result = this.connection.createStruct(typeName, attributes);
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
        return result;
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        Array result = null;
        this.checkClosed();
        try {
            result = this.connection.createArrayOf(typeName, elements);
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
        return result;
    }

    @Override
    public Blob createBlob() throws SQLException {
        Blob result = null;
        this.checkClosed();
        try {
            result = this.connection.createBlob();
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
        return result;
    }

    @Override
    public Clob createClob() throws SQLException {
        Clob result = null;
        this.checkClosed();
        try {
            result = this.connection.createClob();
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
        return result;
    }

    @Override
    public NClob createNClob() throws SQLException {
        NClob result = null;
        this.checkClosed();
        try {
            result = this.connection.createNClob();
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
        return result;
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        SQLXML result = null;
        this.checkClosed();
        try {
            result = this.connection.createSQLXML();
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
        return result;
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.connection.setSchema(schema);
    }

    @Override
    public String getSchema() throws SQLException {
        return this.connection.getSchema();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.connection.abort(executor);
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.connection.setNetworkTimeout(executor, milliseconds);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return this.connection.getNetworkTimeout();
    }

    @Override
    public Statement createStatement() throws SQLException {
        StatementHandle result = null;
        this.checkClosed();
        try {
            result = new StatementHandle(this.connection.createStatement(), this, this.logStatementsEnabled);
            if (this.closeOpenStatements) {
                this.trackedStatement.put(result, this.maybeCaptureStackTrace());
            }
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
        return result;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        StatementHandle result = null;
        this.checkClosed();
        try {
            result = new StatementHandle(this.connection.createStatement(resultSetType, resultSetConcurrency), this, this.logStatementsEnabled);
            if (this.closeOpenStatements) {
                this.trackedStatement.put(result, this.maybeCaptureStackTrace());
            }
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
        return result;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        StatementHandle result = null;
        this.checkClosed();
        try {
            result = new StatementHandle(this.connection.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability), this, this.logStatementsEnabled);
            if (this.closeOpenStatements) {
                this.trackedStatement.put(result, this.maybeCaptureStackTrace());
            }
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
        return result;
    }

    protected String maybeCaptureStackTrace() {
        if (this.detectUnclosedStatements) {
            return this.pool.captureStackTrace(STATEMENT_NOT_CLOSED);
        }
        return this.noStackTrace;
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        boolean result = false;
        this.checkClosed();
        try {
            result = this.connection.getAutoCommit();
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
        return result;
    }

    @Override
    public String getCatalog() throws SQLException {
        String result = null;
        this.checkClosed();
        try {
            result = this.connection.getCatalog();
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
        return result;
    }

    @Override
    public int getHoldability() throws SQLException {
        int result = 0;
        this.checkClosed();
        try {
            result = this.connection.getHoldability();
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
        return result;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        DatabaseMetaData result = null;
        this.checkClosed();
        try {
            result = this.connection.getMetaData();
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
        return result;
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        int result = 0;
        this.checkClosed();
        try {
            result = this.connection.getTransactionIsolation();
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
        return result;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        Map<String, Class<?>> result = null;
        this.checkClosed();
        try {
            result = this.connection.getTypeMap();
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
        return result;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        SQLWarning result = null;
        this.checkClosed();
        try {
            result = this.connection.getWarnings();
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
        return result;
    }

    @Override
    public boolean isClosed() {
        return this.logicallyClosed.get();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        boolean result = false;
        this.checkClosed();
        try {
            result = this.connection.isReadOnly();
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
        return result;
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        String result = null;
        this.checkClosed();
        try {
            result = this.connection.nativeSQL(sql);
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
        return result;
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        StatementHandle result = null;
        String cacheKey = null;
        this.checkClosed();
        try {
            long statStart = 0L;
            if (this.statisticsEnabled) {
                statStart = System.nanoTime();
            }
            if (this.statementCachingEnabled) {
                cacheKey = sql;
                result = this.callableStatementCache.get(cacheKey);
            }
            if (result == null) {
                result = new CallableStatementHandle(this.connection.prepareCall(sql), sql, this, cacheKey, this.callableStatementCache);
                result.setLogicallyOpen();
            }
            if (this.pool.closeConnectionWatch && this.statementCachingEnabled) {
                result.setOpenStackTrace(this.pool.captureStackTrace(STATEMENT_NOT_CLOSED));
            }
            if (this.closeOpenStatements) {
                this.trackedStatement.put(result, this.maybeCaptureStackTrace());
            }
            if (this.statisticsEnabled) {
                this.statistics.addStatementPrepareTime(System.nanoTime() - statStart);
                this.statistics.incrementStatementsPrepared();
            }
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
        return (CallableStatement)((Object)result);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        StatementHandle result = null;
        String cacheKey = null;
        this.checkClosed();
        try {
            long statStart = 0L;
            if (this.statisticsEnabled) {
                statStart = System.nanoTime();
            }
            if (this.statementCachingEnabled) {
                cacheKey = this.callableStatementCache.calculateCacheKey(sql, resultSetType, resultSetConcurrency);
                result = this.callableStatementCache.get(cacheKey);
            }
            if (result == null) {
                result = new CallableStatementHandle(this.connection.prepareCall(sql, resultSetType, resultSetConcurrency), sql, this, cacheKey, this.callableStatementCache);
                result.setLogicallyOpen();
            }
            if (this.pool.closeConnectionWatch && this.statementCachingEnabled) {
                result.setOpenStackTrace(this.pool.captureStackTrace(STATEMENT_NOT_CLOSED));
            }
            if (this.closeOpenStatements) {
                this.trackedStatement.put(result, this.maybeCaptureStackTrace());
            }
            if (this.statisticsEnabled) {
                this.statistics.addStatementPrepareTime(System.nanoTime() - statStart);
                this.statistics.incrementStatementsPrepared();
            }
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
        return (CallableStatement)((Object)result);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        StatementHandle result = null;
        String cacheKey = null;
        this.checkClosed();
        try {
            long statStart = 0L;
            if (this.statisticsEnabled) {
                statStart = System.nanoTime();
            }
            if (this.statementCachingEnabled) {
                cacheKey = this.callableStatementCache.calculateCacheKey(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
                result = this.callableStatementCache.get(cacheKey);
            }
            if (result == null) {
                result = new CallableStatementHandle(this.connection.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability), sql, this, cacheKey, this.callableStatementCache);
                result.setLogicallyOpen();
            }
            if (this.pool.closeConnectionWatch && this.statementCachingEnabled) {
                result.setOpenStackTrace(this.pool.captureStackTrace(STATEMENT_NOT_CLOSED));
            }
            if (this.closeOpenStatements) {
                this.trackedStatement.put(result, this.maybeCaptureStackTrace());
            }
            if (this.statisticsEnabled) {
                this.statistics.addStatementPrepareTime(System.nanoTime() - statStart);
                this.statistics.incrementStatementsPrepared();
            }
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
        return (CallableStatement)((Object)result);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        StatementHandle result = null;
        String cacheKey = null;
        this.checkClosed();
        try {
            long statStart = 0L;
            if (this.statisticsEnabled) {
                statStart = System.nanoTime();
            }
            if (this.statementCachingEnabled) {
                cacheKey = sql;
                result = this.preparedStatementCache.get(cacheKey);
            }
            if (result == null) {
                result = new PreparedStatementHandle(this.connection.prepareStatement(sql), sql, this, cacheKey, this.preparedStatementCache);
                result.setLogicallyOpen();
            }
            if (this.pool.closeConnectionWatch && this.statementCachingEnabled) {
                result.setOpenStackTrace(this.pool.captureStackTrace(STATEMENT_NOT_CLOSED));
            }
            if (this.closeOpenStatements) {
                this.trackedStatement.put(result, this.maybeCaptureStackTrace());
            }
            if (this.statisticsEnabled) {
                this.statistics.addStatementPrepareTime(System.nanoTime() - statStart);
                this.statistics.incrementStatementsPrepared();
            }
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
        return (PreparedStatement)((Object)result);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        StatementHandle result = null;
        String cacheKey = null;
        this.checkClosed();
        try {
            long statStart = 0L;
            if (this.statisticsEnabled) {
                statStart = System.nanoTime();
            }
            if (this.statementCachingEnabled) {
                cacheKey = this.preparedStatementCache.calculateCacheKey(sql, autoGeneratedKeys);
                result = this.preparedStatementCache.get(cacheKey);
            }
            if (result == null) {
                result = new PreparedStatementHandle(this.connection.prepareStatement(sql, autoGeneratedKeys), sql, this, cacheKey, this.preparedStatementCache);
                result.setLogicallyOpen();
            }
            if (this.pool.closeConnectionWatch && this.statementCachingEnabled) {
                result.setOpenStackTrace(this.pool.captureStackTrace(STATEMENT_NOT_CLOSED));
            }
            if (this.closeOpenStatements) {
                this.trackedStatement.put(result, this.maybeCaptureStackTrace());
            }
            if (this.statisticsEnabled) {
                this.statistics.addStatementPrepareTime(System.nanoTime() - statStart);
                this.statistics.incrementStatementsPrepared();
            }
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
        return (PreparedStatement)((Object)result);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        StatementHandle result = null;
        String cacheKey = null;
        this.checkClosed();
        try {
            long statStart = 0L;
            if (this.statisticsEnabled) {
                statStart = System.nanoTime();
            }
            if (this.statementCachingEnabled) {
                cacheKey = this.preparedStatementCache.calculateCacheKey(sql, columnIndexes);
                result = this.preparedStatementCache.get(cacheKey);
            }
            if (result == null) {
                result = new PreparedStatementHandle(this.connection.prepareStatement(sql, columnIndexes), sql, this, cacheKey, this.preparedStatementCache);
                result.setLogicallyOpen();
            }
            if (this.pool.closeConnectionWatch && this.statementCachingEnabled) {
                result.setOpenStackTrace(this.pool.captureStackTrace(STATEMENT_NOT_CLOSED));
            }
            if (this.closeOpenStatements) {
                this.trackedStatement.put(result, this.maybeCaptureStackTrace());
            }
            if (this.statisticsEnabled) {
                this.statistics.addStatementPrepareTime(System.nanoTime() - statStart);
                this.statistics.incrementStatementsPrepared();
            }
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
        return (PreparedStatement)((Object)result);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        StatementHandle result = null;
        String cacheKey = null;
        this.checkClosed();
        try {
            long statStart = 0L;
            if (this.statisticsEnabled) {
                statStart = System.nanoTime();
            }
            if (this.statementCachingEnabled) {
                cacheKey = this.preparedStatementCache.calculateCacheKey(sql, columnNames);
                result = this.preparedStatementCache.get(cacheKey);
            }
            if (result == null) {
                result = new PreparedStatementHandle(this.connection.prepareStatement(sql, columnNames), sql, this, cacheKey, this.preparedStatementCache);
                result.setLogicallyOpen();
            }
            if (this.pool.closeConnectionWatch && this.statementCachingEnabled) {
                result.setOpenStackTrace(this.pool.captureStackTrace(STATEMENT_NOT_CLOSED));
            }
            if (this.closeOpenStatements) {
                this.trackedStatement.put(result, this.maybeCaptureStackTrace());
            }
            if (this.statisticsEnabled) {
                this.statistics.addStatementPrepareTime(System.nanoTime() - statStart);
                this.statistics.incrementStatementsPrepared();
            }
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
        return (PreparedStatement)((Object)result);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        StatementHandle result = null;
        String cacheKey = null;
        this.checkClosed();
        try {
            long statStart = 0L;
            if (this.statisticsEnabled) {
                statStart = System.nanoTime();
            }
            if (this.statementCachingEnabled) {
                cacheKey = this.preparedStatementCache.calculateCacheKey(sql, resultSetType, resultSetConcurrency);
                result = this.preparedStatementCache.get(cacheKey);
            }
            if (result == null) {
                result = new PreparedStatementHandle(this.connection.prepareStatement(sql, resultSetType, resultSetConcurrency), sql, this, cacheKey, this.preparedStatementCache);
                result.setLogicallyOpen();
            }
            if (this.pool.closeConnectionWatch && this.statementCachingEnabled) {
                result.setOpenStackTrace(this.pool.captureStackTrace(STATEMENT_NOT_CLOSED));
            }
            if (this.closeOpenStatements) {
                this.trackedStatement.put(result, this.maybeCaptureStackTrace());
            }
            if (this.statisticsEnabled) {
                this.statistics.addStatementPrepareTime(System.nanoTime() - statStart);
                this.statistics.incrementStatementsPrepared();
            }
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
        return (PreparedStatement)((Object)result);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        StatementHandle result = null;
        String cacheKey = null;
        this.checkClosed();
        try {
            long statStart = 0L;
            if (this.statisticsEnabled) {
                statStart = System.nanoTime();
            }
            if (this.statementCachingEnabled) {
                cacheKey = this.preparedStatementCache.calculateCacheKey(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
                result = this.preparedStatementCache.get(cacheKey);
            }
            if (result == null) {
                result = new PreparedStatementHandle(this.connection.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability), sql, this, cacheKey, this.preparedStatementCache);
                result.setLogicallyOpen();
            }
            if (this.pool.closeConnectionWatch && this.statementCachingEnabled) {
                result.setOpenStackTrace(this.pool.captureStackTrace(STATEMENT_NOT_CLOSED));
            }
            if (this.closeOpenStatements) {
                this.trackedStatement.put(result, this.maybeCaptureStackTrace());
            }
            if (this.statisticsEnabled) {
                this.statistics.addStatementPrepareTime(System.nanoTime() - statStart);
                this.statistics.incrementStatementsPrepared();
            }
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
        return (PreparedStatement)((Object)result);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.checkClosed();
        try {
            this.connection.releaseSavepoint(savepoint);
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
    }

    @Override
    public void rollback() throws SQLException {
        this.checkClosed();
        try {
            this.connection.rollback();
            this.txResolved = true;
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.checkClosed();
        try {
            this.connection.rollback(savepoint);
            this.txResolved = true;
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkClosed();
        try {
            this.connection.setAutoCommit(autoCommit);
            this.txResolved = autoCommit;
            if (this.detectUnresolvedTransactions && !autoCommit) {
                this.autoCommitStackTrace = this.pool.captureStackTrace(SET_AUTO_COMMIT_FALSE_WAS_CALLED_MESSAGE);
            }
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.checkClosed();
        try {
            this.connection.setCatalog(catalog);
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.checkClosed();
        try {
            this.connection.setHoldability(holdability);
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.checkClosed();
        try {
            this.connection.setReadOnly(readOnly);
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.checkClosed();
        Savepoint result = null;
        try {
            result = this.connection.setSavepoint();
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
        return result;
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        this.checkClosed();
        Savepoint result = null;
        try {
            result = this.connection.setSavepoint(name);
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
        return result;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.checkClosed();
        try {
            this.connection.setTransactionIsolation(level);
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.checkClosed();
        try {
            this.connection.setTypeMap(map);
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
    }

    public long getConnectionLastUsedInMs() {
        return this.connectionLastUsedInMs;
    }

    @Deprecated
    public long getConnectionLastUsed() {
        return this.getConnectionLastUsedInMs();
    }

    protected void setConnectionLastUsedInMs(long connectionLastUsed) {
        this.connectionLastUsedInMs = connectionLastUsed;
    }

    public long getConnectionLastResetInMs() {
        return this.connectionLastResetInMs;
    }

    @Deprecated
    public long getConnectionLastReset() {
        return this.getConnectionLastResetInMs();
    }

    protected void setConnectionLastResetInMs(long connectionLastReset) {
        this.connectionLastResetInMs = connectionLastReset;
    }

    public boolean isPossiblyBroken() {
        return this.possiblyBroken;
    }

    public ConnectionPartition getOriginatingPartition() {
        return this.originatingPartition;
    }

    protected void setOriginatingPartition(ConnectionPartition originatingPartition) {
        this.originatingPartition = originatingPartition;
    }

    protected void renewConnection() {
        this.logicallyClosed.set(false);
        this.threadUsingConnection = Thread.currentThread();
        if (this.doubleCloseCheck) {
            this.doubleCloseException = null;
        }
    }

    protected void clearStatementCaches(boolean internalClose) {
        if (this.statementCachingEnabled) {
            if (internalClose) {
                this.callableStatementCache.clear();
                this.preparedStatementCache.clear();
            } else if (this.pool.closeConnectionWatch) {
                this.callableStatementCache.checkForProperClosure();
                this.preparedStatementCache.checkForProperClosure();
            }
        }
    }

    public Object getDebugHandle() {
        return this.debugHandle;
    }

    public void setDebugHandle(Object debugHandle) {
        this.debugHandle = debugHandle;
    }

    @Deprecated
    public Connection getRawConnection() {
        return this.getInternalConnection();
    }

    public Connection getInternalConnection() {
        return this.connection;
    }

    public ConnectionHook getConnectionHook() {
        return this.connectionHook;
    }

    public boolean isLogStatementsEnabled() {
        return this.logStatementsEnabled;
    }

    public void setLogStatementsEnabled(boolean logStatementsEnabled) {
        this.logStatementsEnabled = logStatementsEnabled;
    }

    protected boolean isInReplayMode() {
        return this.inReplayMode;
    }

    protected void setInReplayMode(boolean inReplayMode) {
        this.inReplayMode = inReplayMode;
    }

    public boolean isConnectionAlive() {
        return this.pool.isConnectionHandleAlive(this);
    }

    public void setInternalConnection(Connection rawConnection) {
        this.connection = rawConnection;
    }

    public BoneCP getPool() {
        return this.pool;
    }

    public List<ReplayLog> getReplayLog() {
        return this.replayLog;
    }

    protected void setReplayLog(List<ReplayLog> replayLog) {
        this.replayLog = replayLog;
    }

    public Object getProxyTarget() {
        try {
            return Proxy.getInvocationHandler(this.connection).invoke(null, this.getClass().getMethod("getProxyTarget", new Class[0]), null);
        }
        catch (Throwable t) {
            throw new RuntimeException("BoneCP: Internal error - transaction replay log is not turned on?", t);
        }
    }

    public Thread getThreadUsingConnection() {
        return this.threadUsingConnection;
    }

    @Deprecated
    public long getConnectionCreationTime() {
        return this.getConnectionCreationTimeInMs();
    }

    public long getConnectionCreationTimeInMs() {
        return this.connectionCreationTimeInMs;
    }

    public boolean isExpired() {
        return this.maxConnectionAgeInMs > 0L && this.isExpired(System.currentTimeMillis());
    }

    protected boolean isExpired(long currentTime) {
        return this.maxConnectionAgeInMs > 0L && currentTime - this.connectionCreationTimeInMs > this.maxConnectionAgeInMs;
    }

    protected void setThreadWatch(Thread threadWatch) {
        this.threadWatch = threadWatch;
    }

    public Thread getThreadWatch() {
        return this.threadWatch;
    }

    protected boolean isTxResolved() {
        return this.txResolved;
    }

    protected String getAutoCommitStackTrace() {
        return this.autoCommitStackTrace;
    }

    protected void setAutoCommitStackTrace(String autoCommitStackTrace) {
        this.autoCommitStackTrace = autoCommitStackTrace;
    }

    public void refreshConnection() throws SQLException {
        this.connection.close();
        try {
            this.connection = this.pool.obtainRawInternalConnection();
        }
        catch (SQLException e) {
            throw this.markPossiblyBroken(e);
        }
    }

    protected void untrackStatement(StatementHandle statement) {
        if (this.closeOpenStatements) {
            this.trackedStatement.remove(statement);
        }
    }

    public String getUrl() {
        return this.url;
    }

    public String toString() {
        long timeMillis = System.currentTimeMillis();
        return Objects.toStringHelper((Object)this).add("url", (Object)this.pool.getConfig().getJdbcUrl()).add("user", (Object)this.pool.getConfig().getUsername()).add("debugHandle", this.debugHandle).add("lastResetAgoInSec", TimeUnit.MILLISECONDS.toSeconds(timeMillis - this.connectionLastResetInMs)).add("lastUsedAgoInSec", TimeUnit.MILLISECONDS.toSeconds(timeMillis - this.connectionLastUsedInMs)).add("creationTimeAgoInSec", TimeUnit.MILLISECONDS.toSeconds(timeMillis - this.connectionCreationTimeInMs)).toString();
    }

    static {
        logger = LoggerFactory.getLogger(ConnectionHandle.class);
        sqlStateDBFailureCodes = ImmutableSet.of((Object)"08001", (Object)"08006", (Object)"08007", (Object)"08S01", (Object)"57P01", (Object)"HY000", (Object[])new String[0]);
    }
}

