/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.converters;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.types.converters.TypeConverter;

public class BufferedImageByteArrayConverter
implements TypeConverter<BufferedImage, byte[]> {
    private static final long serialVersionUID = 585211414298721468L;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] toDatastoreType(BufferedImage memberValue) {
        if (memberValue == null) {
            return null;
        }
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream(8192);){
            ImageIO.write((RenderedImage)memberValue, "jpg", baos);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (IOException ioe) {
            throw new NucleusDataStoreException("Error serialising object of type BufferedImage to byte array", ioe);
        }
    }

    @Override
    public BufferedImage toMemberType(byte[] datastoreValue) {
        if (datastoreValue == null || datastoreValue.length == 0) {
            return null;
        }
        try {
            return ImageIO.read(new ByteArrayInputStream(datastoreValue));
        }
        catch (IOException ioe) {
            throw new NucleusDataStoreException("Error deserialising image datastoreValue", ioe);
        }
    }
}

