/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import com.google.common.collect.Lists;
import java.io.File;
import java.lang.invoke.CallSite;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hadoop.hive.metastore.PartitionDropOptions;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.CheckConstraintsRequest;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.DefaultConstraintsRequest;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.ForeignKeysRequest;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.FunctionType;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.NotNullConstraintsRequest;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PartitionValuesRequest;
import org.apache.hadoop.hive.metastore.api.PartitionValuesResponse;
import org.apache.hadoop.hive.metastore.api.PrimaryKeysRequest;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.ResourceType;
import org.apache.hadoop.hive.metastore.api.ResourceUri;
import org.apache.hadoop.hive.metastore.api.SQLCheckConstraint;
import org.apache.hadoop.hive.metastore.api.SQLDefaultConstraint;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLNotNullConstraint;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.metastore.api.SQLUniqueConstraint;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TableMeta;
import org.apache.hadoop.hive.metastore.api.UniqueConstraintsRequest;
import org.apache.hadoop.hive.metastore.client.builder.DatabaseBuilder;
import org.apache.hadoop.hive.metastore.client.builder.FunctionBuilder;
import org.apache.hadoop.hive.metastore.client.builder.PartitionBuilder;
import org.apache.hadoop.hive.metastore.client.builder.SQLCheckConstraintBuilder;
import org.apache.hadoop.hive.metastore.client.builder.SQLDefaultConstraintBuilder;
import org.apache.hadoop.hive.metastore.client.builder.SQLForeignKeyBuilder;
import org.apache.hadoop.hive.metastore.client.builder.SQLNotNullConstraintBuilder;
import org.apache.hadoop.hive.metastore.client.builder.SQLPrimaryKeyBuilder;
import org.apache.hadoop.hive.metastore.client.builder.SQLUniqueConstraintBuilder;
import org.apache.hadoop.hive.metastore.client.builder.TableBuilder;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.partition.spec.PartitionSpecProxy;
import org.apache.thrift.TException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class NonCatCallsWithCatalog {
    private static final String OTHER_DATABASE = "non_cat_other_db";
    private Table[] testTables = new Table[6];
    private static final String TEST_FUNCTION_CLASS = "org.apache.hadoop.hive.ql.udf.generic.GenericUDFUpper";
    protected Configuration conf;
    protected IMetaStoreClient client;

    protected abstract IMetaStoreClient getClient() throws Exception;

    protected abstract String expectedCatalog();

    protected abstract String expectedBaseDir() throws MetaException;

    @Before
    public void setUp() throws Exception {
        this.conf = MetastoreConf.newMetastoreConf();
        this.conf.set("fs.defaultFS", "file:///");
        MetaStoreTestUtils.setConfForStandloneMode(this.conf);
        this.client = this.getClient();
        List databases = this.client.getAllDatabases();
        for (String db : databases) {
            if ("default".equals(db)) continue;
            this.client.dropDatabase(db, true, true, true);
        }
        for (Table[] tableName : this.client.getAllTables("default")) {
            this.client.dropTable("default", (String)tableName, true, true, true);
        }
        Database db = new DatabaseBuilder().setName(OTHER_DATABASE).build(this.conf);
        db.unsetCatalogName();
        this.client.createDatabase(db);
        this.testTables[0] = ((TableBuilder)((TableBuilder)((TableBuilder)new TableBuilder().setTableName("test_table").addCol("test_col1", "int")).addCol("test_col2", "int")).addCol("test_col3", "int")).build(this.conf);
        this.testTables[1] = ((TableBuilder)((TableBuilder)((TableBuilder)new TableBuilder().setTableName("test_view").addCol("test_col1", "int")).addCol("test_col2", "int")).addCol("test_col3", "int")).setType("VIRTUAL_VIEW").build(this.conf);
        this.testTables[2] = ((TableBuilder)((TableBuilder)((TableBuilder)new TableBuilder().setTableName("test_table_to_find_1").addCol("test_col1", "int")).addCol("test_col2", "int")).addCol("test_col3", "int")).build(this.conf);
        this.testTables[3] = ((TableBuilder)((TableBuilder)new TableBuilder().setTableName("test_partitioned_table").addCol("test_col1", "int")).addCol("test_col2", "int")).addPartCol("test_part_col", "int").build(this.conf);
        this.testTables[4] = ((TableBuilder)((TableBuilder)new TableBuilder().setTableName("external_table_for_test").addCol("test_col", "int")).setLocation(MetaStoreTestUtils.getTestWarehouseDir("/external/table_dir"))).addTableParam("EXTERNAL", "TRUE").setType("EXTERNAL_TABLE").build(this.conf);
        this.testTables[5] = ((TableBuilder)new TableBuilder().setDbName(OTHER_DATABASE).setTableName("test_table").addCol("test_col", "int")).build(this.conf);
        for (Table t : this.testTables) {
            t.unsetCatName();
            this.client.createTable(t);
        }
        for (int i = 0; i < 3; ++i) {
            Partition p = new PartitionBuilder().inTable(this.testTables[3]).addValue("a" + i).build(this.conf);
            p.unsetCatName();
            this.client.add_partition(p);
        }
    }

    @After
    public void tearDown() throws Exception {
        try {
            if (this.client != null) {
                this.client.close();
            }
        }
        finally {
            this.client = null;
        }
    }

    @Test
    public void databases() throws TException, URISyntaxException {
        String[] dbNames = new String[]{"db1", "db9"};
        Database[] dbs = new Database[2];
        dbs[0] = new DatabaseBuilder().setName(dbNames[0]).build(this.conf);
        String db1Location = MetaStoreTestUtils.getTestWarehouseDir(dbNames[1]);
        dbs[1] = new DatabaseBuilder().setName(dbNames[1]).setLocation(db1Location).build(this.conf);
        for (Database db : dbs) {
            db.unsetCatalogName();
            this.client.createDatabase(db);
        }
        Database fetched = this.client.getDatabase(dbNames[0]);
        String expectedLocation = new File(this.expectedBaseDir(), dbNames[0] + ".db").toURI().toString();
        Assert.assertEquals((Object)this.expectedCatalog(), (Object)fetched.getCatalogName());
        Assert.assertEquals((Object)expectedLocation, (Object)(fetched.getLocationUri() + "/"));
        String db0Location = new URI(fetched.getLocationUri()).getPath();
        File dir = new File(db0Location);
        Assert.assertTrue((dir.exists() && dir.isDirectory() ? 1 : 0) != 0);
        Assert.assertEquals((Object)this.expectedCatalog(), (Object)fetched.getCatalogName());
        fetched = this.client.getDatabase(dbNames[1]);
        Assert.assertEquals((Object)new File(db1Location).toURI().toString(), (Object)(fetched.getLocationUri() + "/"));
        dir = new File(new URI(fetched.getLocationUri()).getPath());
        Assert.assertTrue((dir.exists() && dir.isDirectory() ? 1 : 0) != 0);
        Assert.assertEquals((Object)this.expectedCatalog(), (Object)fetched.getCatalogName());
        HashSet fetchedDbs = new HashSet(this.client.getAllDatabases());
        for (String dbName : dbNames) {
            Assert.assertTrue((boolean)fetchedDbs.contains(dbName));
        }
        fetchedDbs = new HashSet(this.client.getDatabases("db*"));
        Assert.assertEquals((long)2L, (long)fetchedDbs.size());
        for (String dbName : dbNames) {
            Assert.assertTrue((boolean)fetchedDbs.contains(dbName));
        }
        this.client.dropDatabase(dbNames[0], true, false, false);
        dir = new File(db0Location);
        Assert.assertFalse((boolean)dir.exists());
        this.client.dropDatabase(dbNames[1], true, false, false);
        dir = new File(db1Location);
        Assert.assertFalse((boolean)dir.exists());
        fetchedDbs = new HashSet(this.client.getAllDatabases());
        for (String dbName : dbNames) {
            Assert.assertFalse((boolean)fetchedDbs.contains(dbName));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void tablesCreateDropAlterTruncate() throws TException, URISyntaxException {
        void var10_24;
        int i;
        String dbName = "db_in_other_catalog";
        Database db = new DatabaseBuilder().setName(dbName).build(this.conf);
        db.unsetCatalogName();
        this.client.createDatabase(db);
        String[] tableNames = new String[4];
        for (int i2 = 0; i2 < tableNames.length; ++i2) {
            tableNames[i2] = "table_in_other_catalog_" + i2;
            TableBuilder builder = (TableBuilder)((TableBuilder)new TableBuilder().inDb(db).setTableName(tableNames[i2]).addCol("col1_" + i2, "string")).addCol("col2_" + i2, "int");
            if (i2 == 0) {
                builder.setLocation(MetaStoreTestUtils.getTestWarehouseDir(tableNames[i2]));
            }
            if (i2 == 2) {
                builder.addPartCol("pcol1", "string");
            }
            Table t = builder.build(this.conf);
            t.unsetCatName();
            this.client.createTable(t);
        }
        String[] partVals = new String[3];
        Table partitionedTable = this.client.getTable(dbName, tableNames[2]);
        for (i = 0; i < partVals.length; ++i) {
            partVals[i] = "part" + i;
            Partition p = new PartitionBuilder().inTable(partitionedTable).addValue(partVals[i]).build(this.conf);
            p.unsetCatName();
            this.client.add_partition(p);
        }
        for (i = 0; i < tableNames.length; ++i) {
            String[] t = this.client.getTable(dbName, tableNames[i]);
            Assert.assertEquals((Object)this.expectedCatalog(), (Object)t.getCatName());
            String expectedLocation = i < 1 ? new File(MetaStoreTestUtils.getTestWarehouseDir(tableNames[i])).toURI().toString() : new File(this.expectedBaseDir() + File.separatorChar + dbName + ".db", tableNames[i]).toURI().toString();
            Assert.assertEquals((Object)expectedLocation, (Object)(t.getSd().getLocation() + "/"));
            File dir = new File(new URI(t.getSd().getLocation()).getPath());
            Assert.assertTrue((dir.exists() && dir.isDirectory() ? 1 : 0) != 0);
        }
        try {
            Table t = this.client.getTable("default", tableNames[0]);
            Assert.fail();
        }
        catch (NoSuchObjectException t) {
            // empty catch block
        }
        HashSet fetchedNames = new HashSet(this.client.getAllTables(dbName));
        Assert.assertEquals((long)tableNames.length, (long)fetchedNames.size());
        for (String string : tableNames) {
            Assert.assertTrue((boolean)fetchedNames.contains(string));
        }
        fetchedNames = new HashSet(this.client.getAllTables("default"));
        for (String string : tableNames) {
            Assert.assertFalse((boolean)fetchedNames.contains(string));
        }
        fetchedNames = new HashSet(this.client.getMaterializedViewsForRewriting("default"));
        Assert.assertFalse((boolean)fetchedNames.contains(tableNames[3]));
        List fetchedTables = this.client.getTableObjectsByName(dbName, Arrays.asList(tableNames[0], tableNames[1]));
        Assert.assertEquals((long)2L, (long)fetchedTables.size());
        Collections.sort(fetchedTables);
        Assert.assertEquals((Object)tableNames[0], (Object)((Table)fetchedTables.get(0)).getTableName());
        Assert.assertEquals((Object)tableNames[1], (Object)((Table)fetchedTables.get(1)).getTableName());
        fetchedTables = this.client.getTableObjectsByName("default", Arrays.asList(tableNames[0], tableNames[1]));
        Assert.assertEquals((long)0L, (long)fetchedTables.size());
        Table t = this.client.getTable(dbName, tableNames[0]).deepCopy();
        t.getParameters().put("test", "test");
        this.client.alter_table(dbName, tableNames[0], t);
        t = this.client.getTable(dbName, tableNames[0]).deepCopy();
        Assert.assertEquals((Object)"test", t.getParameters().get("test"));
        try {
            this.client.alter_table("default", tableNames[0], t);
            Assert.fail();
        }
        catch (InvalidOperationException dir) {
            // empty catch block
        }
        ArrayList<CallSite> partNames = new ArrayList<CallSite>();
        for (String partVal : partVals) {
            partNames.add((CallSite)((Object)("pcol1=" + partVal)));
        }
        this.client.truncateTable(dbName, tableNames[0], partNames);
        int n = tableNames.length - 1;
        while (var10_24 >= 0) {
            t = this.client.getTable(dbName, tableNames[var10_24]);
            File tableDir = new File(new URI(t.getSd().getLocation()).getPath());
            Assert.assertTrue((tableDir.exists() && tableDir.isDirectory() ? 1 : 0) != 0);
            if (tableNames[var10_24].equalsIgnoreCase(tableNames[0])) {
                this.client.dropTable(dbName, tableNames[var10_24], false, false);
                Assert.assertTrue((tableDir.exists() && tableDir.isDirectory() ? 1 : 0) != 0);
            } else {
                this.client.dropTable(dbName, tableNames[var10_24]);
                Assert.assertFalse((boolean)tableDir.exists());
            }
            --var10_24;
        }
        Assert.assertEquals((long)0L, (long)this.client.getAllTables(dbName).size());
    }

    @Test
    public void tablesGetExists() throws TException {
        String dbName = "db_in_other_catalog";
        Database db = new DatabaseBuilder().setName(dbName).build(this.conf);
        db.unsetCatalogName();
        this.client.createDatabase(db);
        Table tableNames = new String[4];
        for (int i = 0; i < ((String[])tableNames).length; ++i) {
            tableNames[i] = "table_in_other_catalog_" + i;
            Table table = ((TableBuilder)((TableBuilder)new TableBuilder().inDb(db).setTableName(tableNames[i]).addCol("col1_" + i, "string")).addCol("col2_" + i, "int")).build(this.conf);
            table.unsetCatName();
            this.client.createTable(table);
        }
        HashSet tables = new HashSet(this.client.getTables(dbName, "*e_in_other_*"));
        Assert.assertEquals((long)4L, (long)tables.size());
        for (String tableName : tableNames) {
            Assert.assertTrue((boolean)tables.contains(tableName));
        }
        List fetchedNames = this.client.getTables(dbName, "*_3");
        Assert.assertEquals((long)1L, (long)fetchedNames.size());
        Assert.assertEquals((Object)tableNames[3], fetchedNames.get(0));
        Assert.assertTrue((String)"Table exists", (boolean)this.client.tableExists(dbName, (String)tableNames[0]));
        Assert.assertFalse((String)"Table not exists", (boolean)this.client.tableExists(dbName, "non_existing_table"));
    }

    @Test
    public void tablesList() throws TException {
        String dbName = "db_in_other_catalog";
        Database db = new DatabaseBuilder().setName(dbName).build(this.conf);
        db.unsetCatalogName();
        this.client.createDatabase(db);
        String[] tableNames = new String[4];
        for (int i = 0; i < tableNames.length; ++i) {
            tableNames[i] = "table_in_other_catalog_" + i;
            TableBuilder builder = (TableBuilder)((TableBuilder)new TableBuilder().inDb(db).setTableName(tableNames[i]).addCol("col1_" + i, "string")).addCol("col2_" + i, "int");
            if (i == 0) {
                builder.addTableParam("the_key", "the_value");
            }
            Table table = builder.build(this.conf);
            table.unsetCatName();
            this.client.createTable(table);
        }
        String filter = "hive_filter_field_params__the_key=\"the_value\"";
        List fetchedNames = this.client.listTableNamesByFilter(dbName, filter, (short)-1);
        Assert.assertEquals((long)1L, (long)fetchedNames.size());
        Assert.assertEquals((Object)tableNames[0], fetchedNames.get(0));
    }

    @Test
    public void getTableMeta() throws TException {
        String dbName = "db9";
        Database db = new DatabaseBuilder().setName(dbName).build(this.conf);
        db.unsetCatalogName();
        this.client.createDatabase(db);
        String[] tableNames = new String[]{"table_in_other_catalog_1", "table_in_other_catalog_2", "random_name"};
        ArrayList<TableMeta> expected = new ArrayList<TableMeta>(tableNames.length);
        for (int i = 0; i < tableNames.length; ++i) {
            Table table = ((TableBuilder)((TableBuilder)new TableBuilder().inDb(db).setTableName(tableNames[i]).addCol("id", "int")).addCol("name", "string")).build(this.conf);
            table.unsetCatName();
            this.client.createTable(table);
            expected.add(new TableMeta(dbName, tableNames[i], TableType.MANAGED_TABLE.name()));
        }
        List<String> types = Collections.singletonList(TableType.MANAGED_TABLE.name());
        List actual = this.client.getTableMeta(dbName, "*", types);
        Assert.assertEquals(new TreeSet(expected), new TreeSet(actual));
        actual = this.client.getTableMeta("*", "table_*", types);
        Assert.assertEquals(expected.subList(0, 2), actual.subList(0, 2));
    }

    @Test
    public void addPartitions() throws TException {
        int i;
        String dbName = "add_partition_database_in_other_catalog";
        Database db = new DatabaseBuilder().setName(dbName).build(this.conf);
        db.unsetCatalogName();
        this.client.createDatabase(db);
        String tableName = "table_in_other_catalog";
        Table table = ((TableBuilder)((TableBuilder)new TableBuilder().inDb(db).setTableName(tableName).addCol("id", "int")).addCol("name", "string")).addPartCol("partcol", "string").build(this.conf);
        table.unsetCatName();
        this.client.createTable(table);
        Partition[] parts = new Partition[5];
        for (i = 0; i < parts.length; ++i) {
            parts[i] = new PartitionBuilder().inTable(table).addValue("a" + i).build(this.conf);
            parts[i].unsetCatName();
        }
        this.client.add_partition(parts[0]);
        Assert.assertEquals((long)2L, (long)this.client.add_partitions(Arrays.asList(parts[1], parts[2])));
        this.client.add_partitions(Arrays.asList(parts[3], parts[4]), true, false);
        for (i = 0; i < parts.length; ++i) {
            Partition fetched = this.client.getPartition(dbName, tableName, Collections.singletonList("a" + i));
            Assert.assertEquals((Object)dbName, (Object)fetched.getDbName());
            Assert.assertEquals((Object)tableName, (Object)fetched.getTableName());
            Assert.assertEquals((Object)this.expectedCatalog(), (Object)fetched.getCatName());
        }
        this.client.dropDatabase(dbName, true, true, true);
    }

    @Test
    public void getPartitions() throws TException {
        String dbName = "get_partition_database_in_other_catalog";
        Database db = new DatabaseBuilder().setName(dbName).build(this.conf);
        db.unsetCatalogName();
        this.client.createDatabase(db);
        String tableName = "table_in_other_catalog";
        Table table = ((TableBuilder)((TableBuilder)new TableBuilder().inDb(db).setTableName(tableName).addCol("id", "int")).addCol("name", "string")).addPartCol("partcol", "string").addTableParam("PARTITION_LEVEL_PRIVILEGE", "true").build(this.conf);
        table.unsetCatName();
        this.client.createTable(table);
        Partition[] parts = new Partition[5];
        for (int i = 0; i < parts.length; ++i) {
            parts[i] = new PartitionBuilder().inTable(table).addValue("a" + i).build(this.conf);
            parts[i].unsetCatName();
        }
        this.client.add_partitions(Arrays.asList(parts));
        Partition fetched = this.client.getPartition(dbName, tableName, Collections.singletonList("a0"));
        Assert.assertEquals((Object)this.expectedCatalog(), (Object)fetched.getCatName());
        Assert.assertEquals((Object)"a0", fetched.getValues().get(0));
        fetched = this.client.getPartition(dbName, tableName, "partcol=a0");
        Assert.assertEquals((Object)this.expectedCatalog(), (Object)fetched.getCatName());
        Assert.assertEquals((Object)"a0", fetched.getValues().get(0));
        List fetchedParts = this.client.getPartitionsByNames(dbName, tableName, Arrays.asList("partcol=a0", "partcol=a1"));
        Assert.assertEquals((long)2L, (long)fetchedParts.size());
        HashSet<String> vals = new HashSet<String>(fetchedParts.size());
        for (Partition part : fetchedParts) {
            vals.add((String)part.getValues().get(0));
        }
        Assert.assertTrue((boolean)vals.contains("a0"));
        Assert.assertTrue((boolean)vals.contains("a1"));
    }

    @Test
    public void listPartitions() throws TException {
        String dbName = "list_partition_database_in_other_catalog";
        Database db = new DatabaseBuilder().setName(dbName).build(this.conf);
        db.unsetCatalogName();
        this.client.createDatabase(db);
        String tableName = "table_in_other_catalog";
        Table table = ((TableBuilder)((TableBuilder)new TableBuilder().inDb(db).setTableName(tableName).addCol("id", "int")).addCol("name", "string")).addPartCol("partcol", "string").build(this.conf);
        table.unsetCatName();
        this.client.createTable(table);
        Partition[] parts = new Partition[5];
        for (int i = 0; i < parts.length; ++i) {
            parts[i] = new PartitionBuilder().inTable(table).addValue("a" + i).build(this.conf);
            parts[i].unsetCatName();
        }
        this.client.add_partitions(Arrays.asList(parts));
        List fetched = this.client.listPartitions(dbName, tableName, (short)-1);
        Assert.assertEquals((long)parts.length, (long)fetched.size());
        Assert.assertEquals((Object)this.expectedCatalog(), (Object)((Partition)fetched.get(0)).getCatName());
        fetched = this.client.listPartitions(dbName, tableName, Collections.singletonList("a0"), (short)-1);
        Assert.assertEquals((long)1L, (long)fetched.size());
        Assert.assertEquals((Object)this.expectedCatalog(), (Object)((Partition)fetched.get(0)).getCatName());
        PartitionSpecProxy proxy = this.client.listPartitionSpecs(dbName, tableName, -1);
        Assert.assertEquals((long)parts.length, (long)proxy.size());
        Assert.assertEquals((Object)this.expectedCatalog(), (Object)proxy.getCatName());
        fetched = this.client.listPartitionsByFilter(dbName, tableName, "partcol=\"a0\"", (short)-1);
        Assert.assertEquals((long)1L, (long)fetched.size());
        Assert.assertEquals((Object)this.expectedCatalog(), (Object)((Partition)fetched.get(0)).getCatName());
        proxy = this.client.listPartitionSpecsByFilter(dbName, tableName, "partcol=\"a0\"", -1);
        Assert.assertEquals((long)1L, (long)proxy.size());
        Assert.assertEquals((Object)this.expectedCatalog(), (Object)proxy.getCatName());
        Assert.assertEquals((long)1L, (long)this.client.getNumPartitionsByFilter(dbName, tableName, "partcol=\"a0\""));
        List names = this.client.listPartitionNames(dbName, tableName, (short)57);
        Assert.assertEquals((long)parts.length, (long)names.size());
        names = this.client.listPartitionNames(dbName, tableName, Collections.singletonList("a0"), (short)Short.MAX_VALUE);
        Assert.assertEquals((long)1L, (long)names.size());
        PartitionValuesRequest rqst = new PartitionValuesRequest(dbName, tableName, (List)Lists.newArrayList((Object[])new FieldSchema[]{new FieldSchema("partcol", "string", "")}));
        PartitionValuesResponse rsp = this.client.listPartitionValues(rqst);
        Assert.assertEquals((long)5L, (long)rsp.getPartitionValuesSize());
    }

    @Test
    public void alterPartitions() throws TException {
        String dbName = "alter_partition_database_in_other_catalog";
        Database db = new DatabaseBuilder().setName(dbName).build(this.conf);
        db.unsetCatalogName();
        this.client.createDatabase(db);
        String tableName = "table_in_other_catalog";
        Table table = ((TableBuilder)((TableBuilder)new TableBuilder().inDb(db).setTableName(tableName).addCol("id", "int")).addCol("name", "string")).addPartCol("partcol", "string").build(this.conf);
        table.unsetCatName();
        this.client.createTable(table);
        Partition[] parts = new Partition[5];
        for (int i = 0; i < 5; ++i) {
            parts[i] = ((PartitionBuilder)new PartitionBuilder().inTable(table).addValue("a" + i).setLocation(MetaStoreTestUtils.getTestWarehouseDir("b" + i))).build(this.conf);
            parts[i].unsetCatName();
        }
        this.client.add_partitions(Arrays.asList(parts));
        Partition newPart = this.client.getPartition(dbName, tableName, Collections.singletonList("a0"));
        newPart.getParameters().put("test_key", "test_value");
        this.client.alter_partition(dbName, tableName, newPart);
        Partition fetched = this.client.getPartition(dbName, tableName, Collections.singletonList("a0"));
        Assert.assertEquals((Object)"test_value", fetched.getParameters().get("test_key"));
        newPart = this.client.getPartition(dbName, tableName, Collections.singletonList("a1"));
        newPart.setLastAccessTime(3);
        Partition newPart1 = this.client.getPartition(dbName, tableName, Collections.singletonList("a2"));
        newPart1.getSd().setLocation(MetaStoreTestUtils.getTestWarehouseDir("somewhere"));
        this.client.alter_partitions(dbName, tableName, Arrays.asList(newPart, newPart1));
        fetched = this.client.getPartition(dbName, tableName, Collections.singletonList("a1"));
        Assert.assertEquals((long)3L, (long)fetched.getLastAccessTime());
        fetched = this.client.getPartition(dbName, tableName, Collections.singletonList("a2"));
        Assert.assertTrue((boolean)fetched.getSd().getLocation().contains("somewhere"));
        newPart = this.client.getPartition(dbName, tableName, Collections.singletonList("a4"));
        newPart.getParameters().put("test_key", "test_value");
        EnvironmentContext ec = new EnvironmentContext();
        ec.setProperties(Collections.singletonMap("a", "b"));
        this.client.alter_partition(dbName, tableName, newPart, ec);
        fetched = this.client.getPartition(dbName, tableName, Collections.singletonList("a4"));
        Assert.assertEquals((Object)"test_value", fetched.getParameters().get("test_key"));
        this.client.dropDatabase(dbName, true, true, true);
    }

    @Test
    public void dropPartitions() throws TException {
        String dbName = "drop_partition_database_in_other_catalog";
        Database db = new DatabaseBuilder().setName(dbName).build(this.conf);
        db.unsetCatalogName();
        this.client.createDatabase(db);
        String tableName = "table_in_other_catalog";
        Table table = ((TableBuilder)((TableBuilder)new TableBuilder().inDb(db).setTableName(tableName).addCol("id", "int")).addCol("name", "string")).addPartCol("partcol", "string").build(this.conf);
        table.unsetCatName();
        this.client.createTable(table);
        Partition[] parts = new Partition[2];
        for (int i = 0; i < parts.length; ++i) {
            parts[i] = new PartitionBuilder().inTable(table).addValue("a" + i).build(this.conf);
            parts[i].unsetCatName();
        }
        this.client.add_partitions(Arrays.asList(parts));
        List fetched = this.client.listPartitions(dbName, tableName, (short)-1);
        Assert.assertEquals((long)parts.length, (long)fetched.size());
        Assert.assertTrue((boolean)this.client.dropPartition(dbName, tableName, Collections.singletonList("a0"), PartitionDropOptions.instance().ifExists(false)));
        try {
            this.client.getPartition(dbName, tableName, Collections.singletonList("a0"));
            Assert.fail();
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)this.client.dropPartition(dbName, tableName, "partcol=a1", true));
        try {
            this.client.getPartition(dbName, tableName, Collections.singletonList("a1"));
            Assert.fail();
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
    }

    @Test
    public void primaryKeyAndForeignKey() throws TException {
        Table parentTable = this.testTables[2];
        Table table = this.testTables[3];
        String constraintName = "othercatfk";
        List pk = ((SQLPrimaryKeyBuilder)((SQLPrimaryKeyBuilder)new SQLPrimaryKeyBuilder().onTable(parentTable)).addColumn("test_col1")).build(this.conf);
        this.client.addPrimaryKey(pk);
        List fk = ((SQLForeignKeyBuilder)((SQLForeignKeyBuilder)((SQLForeignKeyBuilder)new SQLForeignKeyBuilder().fromPrimaryKey(pk).onTable(table)).addColumn("test_col1")).setConstraintName(constraintName)).build(this.conf);
        this.client.addForeignKey(fk);
        PrimaryKeysRequest pkRqst = new PrimaryKeysRequest(parentTable.getDbName(), parentTable.getTableName());
        pkRqst.setCatName(parentTable.getCatName());
        List pkFetched = this.client.getPrimaryKeys(pkRqst);
        Assert.assertEquals((long)1L, (long)pkFetched.size());
        Assert.assertEquals((Object)this.expectedCatalog(), (Object)((SQLPrimaryKey)pkFetched.get(0)).getCatName());
        Assert.assertEquals((Object)parentTable.getDbName(), (Object)((SQLPrimaryKey)pkFetched.get(0)).getTable_db());
        Assert.assertEquals((Object)parentTable.getTableName(), (Object)((SQLPrimaryKey)pkFetched.get(0)).getTable_name());
        Assert.assertEquals((Object)"test_col1", (Object)((SQLPrimaryKey)pkFetched.get(0)).getColumn_name());
        Assert.assertEquals((long)1L, (long)((SQLPrimaryKey)pkFetched.get(0)).getKey_seq());
        Assert.assertTrue((boolean)((SQLPrimaryKey)pkFetched.get(0)).isEnable_cstr());
        Assert.assertFalse((boolean)((SQLPrimaryKey)pkFetched.get(0)).isValidate_cstr());
        Assert.assertFalse((boolean)((SQLPrimaryKey)pkFetched.get(0)).isRely_cstr());
        Assert.assertEquals((Object)parentTable.getCatName(), (Object)((SQLPrimaryKey)pkFetched.get(0)).getCatName());
        ForeignKeysRequest rqst = new ForeignKeysRequest(parentTable.getDbName(), parentTable.getTableName(), table.getDbName(), table.getTableName());
        rqst.setCatName(table.getCatName());
        List fetched = this.client.getForeignKeys(rqst);
        Assert.assertEquals((long)1L, (long)fetched.size());
        Assert.assertEquals((Object)table.getDbName(), (Object)((SQLForeignKey)fetched.get(0)).getFktable_db());
        Assert.assertEquals((Object)table.getTableName(), (Object)((SQLForeignKey)fetched.get(0)).getFktable_name());
        Assert.assertEquals((Object)this.expectedCatalog(), (Object)((SQLForeignKey)fetched.get(0)).getCatName());
        Assert.assertEquals((Object)"test_col1", (Object)((SQLForeignKey)fetched.get(0)).getFkcolumn_name());
        Assert.assertEquals((Object)parentTable.getDbName(), (Object)((SQLForeignKey)fetched.get(0)).getPktable_db());
        Assert.assertEquals((Object)parentTable.getTableName(), (Object)((SQLForeignKey)fetched.get(0)).getPktable_name());
        Assert.assertEquals((Object)"test_col1", (Object)((SQLForeignKey)fetched.get(0)).getFkcolumn_name());
        Assert.assertEquals((long)1L, (long)((SQLForeignKey)fetched.get(0)).getKey_seq());
        Assert.assertEquals((Object)(parentTable.getTableName() + "_primary_key"), (Object)((SQLForeignKey)fetched.get(0)).getPk_name());
        Assert.assertEquals((Object)constraintName, (Object)((SQLForeignKey)fetched.get(0)).getFk_name());
        String table0FkName = ((SQLForeignKey)fetched.get(0)).getFk_name();
        Assert.assertTrue((boolean)((SQLForeignKey)fetched.get(0)).isEnable_cstr());
        Assert.assertFalse((boolean)((SQLForeignKey)fetched.get(0)).isValidate_cstr());
        Assert.assertFalse((boolean)((SQLForeignKey)fetched.get(0)).isRely_cstr());
        Assert.assertEquals((Object)table.getCatName(), (Object)((SQLForeignKey)fetched.get(0)).getCatName());
        this.client.dropConstraint(table.getDbName(), table.getTableName(), table0FkName);
        rqst = new ForeignKeysRequest(parentTable.getDbName(), parentTable.getTableName(), table.getDbName(), table.getTableName());
        rqst.setCatName(table.getCatName());
        fetched = this.client.getForeignKeys(rqst);
        Assert.assertTrue((boolean)fetched.isEmpty());
    }

    @Test
    public void notNullConstraint() throws TException {
        String constraintName = "ocuc";
        List nn = ((SQLNotNullConstraintBuilder)((SQLNotNullConstraintBuilder)((SQLNotNullConstraintBuilder)new SQLNotNullConstraintBuilder().onTable(this.testTables[2])).addColumn("test_col1")).setConstraintName(constraintName)).build(this.conf);
        this.client.addNotNullConstraint(nn);
        NotNullConstraintsRequest rqst = new NotNullConstraintsRequest(this.testTables[2].getCatName(), this.testTables[2].getDbName(), this.testTables[2].getTableName());
        List fetched = this.client.getNotNullConstraints(rqst);
        Assert.assertEquals((long)1L, (long)fetched.size());
        Assert.assertEquals((Object)this.testTables[2].getDbName(), (Object)((SQLNotNullConstraint)fetched.get(0)).getTable_db());
        Assert.assertEquals((Object)this.testTables[2].getTableName(), (Object)((SQLNotNullConstraint)fetched.get(0)).getTable_name());
        Assert.assertEquals((Object)"test_col1", (Object)((SQLNotNullConstraint)fetched.get(0)).getColumn_name());
        Assert.assertEquals((Object)constraintName, (Object)((SQLNotNullConstraint)fetched.get(0)).getNn_name());
        Assert.assertTrue((boolean)((SQLNotNullConstraint)fetched.get(0)).isEnable_cstr());
        Assert.assertFalse((boolean)((SQLNotNullConstraint)fetched.get(0)).isValidate_cstr());
        Assert.assertFalse((boolean)((SQLNotNullConstraint)fetched.get(0)).isRely_cstr());
        Assert.assertEquals((Object)this.testTables[2].getCatName(), (Object)((SQLNotNullConstraint)fetched.get(0)).getCatName());
        this.client.dropConstraint(this.testTables[2].getDbName(), this.testTables[2].getTableName(), constraintName);
        rqst = new NotNullConstraintsRequest(this.testTables[2].getCatName(), this.testTables[2].getDbName(), this.testTables[2].getTableName());
        fetched = this.client.getNotNullConstraints(rqst);
        Assert.assertTrue((boolean)fetched.isEmpty());
    }

    @Test
    public void uniqueConstraint() throws TException {
        String constraintName = "ocuc";
        List uc = ((SQLUniqueConstraintBuilder)((SQLUniqueConstraintBuilder)((SQLUniqueConstraintBuilder)new SQLUniqueConstraintBuilder().onTable(this.testTables[2])).addColumn("test_col1")).setConstraintName(constraintName)).build(this.conf);
        this.client.addUniqueConstraint(uc);
        UniqueConstraintsRequest rqst = new UniqueConstraintsRequest(this.testTables[2].getCatName(), this.testTables[2].getDbName(), this.testTables[2].getTableName());
        List fetched = this.client.getUniqueConstraints(rqst);
        Assert.assertEquals((long)1L, (long)fetched.size());
        Assert.assertEquals((Object)this.testTables[2].getDbName(), (Object)((SQLUniqueConstraint)fetched.get(0)).getTable_db());
        Assert.assertEquals((Object)this.testTables[2].getTableName(), (Object)((SQLUniqueConstraint)fetched.get(0)).getTable_name());
        Assert.assertEquals((Object)"test_col1", (Object)((SQLUniqueConstraint)fetched.get(0)).getColumn_name());
        Assert.assertEquals((long)1L, (long)((SQLUniqueConstraint)fetched.get(0)).getKey_seq());
        Assert.assertEquals((Object)constraintName, (Object)((SQLUniqueConstraint)fetched.get(0)).getUk_name());
        Assert.assertTrue((boolean)((SQLUniqueConstraint)fetched.get(0)).isEnable_cstr());
        Assert.assertFalse((boolean)((SQLUniqueConstraint)fetched.get(0)).isValidate_cstr());
        Assert.assertFalse((boolean)((SQLUniqueConstraint)fetched.get(0)).isRely_cstr());
        Assert.assertEquals((Object)this.testTables[2].getCatName(), (Object)((SQLUniqueConstraint)fetched.get(0)).getCatName());
        Assert.assertEquals((Object)this.expectedCatalog(), (Object)((SQLUniqueConstraint)fetched.get(0)).getCatName());
        this.client.dropConstraint(this.testTables[2].getDbName(), this.testTables[2].getTableName(), constraintName);
        rqst = new UniqueConstraintsRequest(this.testTables[2].getCatName(), this.testTables[2].getDbName(), this.testTables[2].getTableName());
        fetched = this.client.getUniqueConstraints(rqst);
        Assert.assertTrue((boolean)fetched.isEmpty());
    }

    @Test
    public void defaultConstraints() throws TException {
        String constraintName = "ocdv";
        List dv = ((SQLDefaultConstraintBuilder)((SQLDefaultConstraintBuilder)((SQLDefaultConstraintBuilder)new SQLDefaultConstraintBuilder().onTable(this.testTables[2])).addColumn("test_col1")).setConstraintName(constraintName)).setDefaultVal((Object)"empty").build(this.conf);
        this.client.addDefaultConstraint(dv);
        DefaultConstraintsRequest rqst = new DefaultConstraintsRequest(this.testTables[2].getCatName(), this.testTables[2].getDbName(), this.testTables[2].getTableName());
        List fetched = this.client.getDefaultConstraints(rqst);
        Assert.assertEquals((long)1L, (long)fetched.size());
        Assert.assertEquals((Object)this.expectedCatalog(), (Object)((SQLDefaultConstraint)fetched.get(0)).getCatName());
        Assert.assertEquals((Object)this.testTables[2].getDbName(), (Object)((SQLDefaultConstraint)fetched.get(0)).getTable_db());
        Assert.assertEquals((Object)this.testTables[2].getTableName(), (Object)((SQLDefaultConstraint)fetched.get(0)).getTable_name());
        Assert.assertEquals((Object)"test_col1", (Object)((SQLDefaultConstraint)fetched.get(0)).getColumn_name());
        Assert.assertEquals((Object)"empty", (Object)((SQLDefaultConstraint)fetched.get(0)).getDefault_value());
        Assert.assertEquals((Object)constraintName, (Object)((SQLDefaultConstraint)fetched.get(0)).getDc_name());
        Assert.assertTrue((boolean)((SQLDefaultConstraint)fetched.get(0)).isEnable_cstr());
        Assert.assertFalse((boolean)((SQLDefaultConstraint)fetched.get(0)).isValidate_cstr());
        Assert.assertFalse((boolean)((SQLDefaultConstraint)fetched.get(0)).isRely_cstr());
        Assert.assertEquals((Object)this.testTables[2].getCatName(), (Object)((SQLDefaultConstraint)fetched.get(0)).getCatName());
        this.client.dropConstraint(this.testTables[2].getDbName(), this.testTables[2].getTableName(), constraintName);
        rqst = new DefaultConstraintsRequest(this.testTables[2].getCatName(), this.testTables[2].getDbName(), this.testTables[2].getTableName());
        fetched = this.client.getDefaultConstraints(rqst);
        Assert.assertTrue((boolean)fetched.isEmpty());
    }

    @Test
    public void createTableWithConstraints() throws TException {
        Table parentTable = this.testTables[2];
        Table table = ((TableBuilder)((TableBuilder)((TableBuilder)((TableBuilder)((TableBuilder)((TableBuilder)new TableBuilder().setTableName("table_in_other_catalog_with_constraints").addCol("col1", "int")).addCol("col2", "varchar(32)")).addCol("col3", "int")).addCol("col4", "int")).addCol("col5", "int")).addCol("col6", "int")).build(this.conf);
        table.unsetCatName();
        List parentPk = ((SQLPrimaryKeyBuilder)((SQLPrimaryKeyBuilder)new SQLPrimaryKeyBuilder().onTable(parentTable)).addColumn("test_col1")).build(this.conf);
        for (Object pkcol : parentPk) {
            pkcol.unsetCatName();
        }
        this.client.addPrimaryKey(parentPk);
        List pk = ((SQLPrimaryKeyBuilder)((SQLPrimaryKeyBuilder)new SQLPrimaryKeyBuilder().onTable(table)).addColumn("col2")).build(this.conf);
        for (Object pkcol : pk) {
            pkcol.unsetCatName();
        }
        List fk = ((SQLForeignKeyBuilder)((SQLForeignKeyBuilder)new SQLForeignKeyBuilder().fromPrimaryKey(parentPk).onTable(table)).addColumn("col1")).build(this.conf);
        for (Object fkcol : fk) {
            fkcol.unsetCatName();
        }
        List dv = ((SQLDefaultConstraintBuilder)((SQLDefaultConstraintBuilder)new SQLDefaultConstraintBuilder().onTable(table)).addColumn("col3")).setDefaultVal((Object)0).build(this.conf);
        for (Object dccol : dv) {
            dccol.unsetCatName();
        }
        List nn = ((SQLNotNullConstraintBuilder)((SQLNotNullConstraintBuilder)new SQLNotNullConstraintBuilder().onTable(table)).addColumn("col4")).build(this.conf);
        for (Object nncol : nn) {
            nncol.unsetCatName();
        }
        List uc = ((SQLUniqueConstraintBuilder)((SQLUniqueConstraintBuilder)new SQLUniqueConstraintBuilder().onTable(table)).addColumn("col5")).build(this.conf);
        for (Object uccol : uc) {
            uccol.unsetCatName();
        }
        List cc = ((SQLCheckConstraintBuilder)((SQLCheckConstraintBuilder)new SQLCheckConstraintBuilder().onTable(table)).addColumn("col6")).setCheckExpression("> 0").build(this.conf);
        for (SQLCheckConstraint cccol : cc) {
            cccol.unsetCatName();
        }
        this.client.createTableWithConstraints(table, pk, fk, uc, nn, dv, cc);
        PrimaryKeysRequest pkRqst = new PrimaryKeysRequest(parentTable.getDbName(), parentTable.getTableName());
        pkRqst.setCatName(parentTable.getCatName());
        List pkFetched = this.client.getPrimaryKeys(pkRqst);
        Assert.assertEquals((long)1L, (long)pkFetched.size());
        Assert.assertEquals((Object)this.expectedCatalog(), (Object)((SQLPrimaryKey)pkFetched.get(0)).getCatName());
        Assert.assertEquals((Object)parentTable.getDbName(), (Object)((SQLPrimaryKey)pkFetched.get(0)).getTable_db());
        Assert.assertEquals((Object)parentTable.getTableName(), (Object)((SQLPrimaryKey)pkFetched.get(0)).getTable_name());
        Assert.assertEquals((Object)"test_col1", (Object)((SQLPrimaryKey)pkFetched.get(0)).getColumn_name());
        Assert.assertEquals((long)1L, (long)((SQLPrimaryKey)pkFetched.get(0)).getKey_seq());
        Assert.assertTrue((boolean)((SQLPrimaryKey)pkFetched.get(0)).isEnable_cstr());
        Assert.assertFalse((boolean)((SQLPrimaryKey)pkFetched.get(0)).isValidate_cstr());
        Assert.assertFalse((boolean)((SQLPrimaryKey)pkFetched.get(0)).isRely_cstr());
        Assert.assertEquals((Object)parentTable.getCatName(), (Object)((SQLPrimaryKey)pkFetched.get(0)).getCatName());
        ForeignKeysRequest fkRqst = new ForeignKeysRequest(parentTable.getDbName(), parentTable.getTableName(), table.getDbName(), table.getTableName());
        fkRqst.setCatName(table.getCatName());
        List fkFetched = this.client.getForeignKeys(fkRqst);
        Assert.assertEquals((long)1L, (long)fkFetched.size());
        Assert.assertEquals((Object)this.expectedCatalog(), (Object)((SQLForeignKey)fkFetched.get(0)).getCatName());
        Assert.assertEquals((Object)table.getDbName(), (Object)((SQLForeignKey)fkFetched.get(0)).getFktable_db());
        Assert.assertEquals((Object)table.getTableName(), (Object)((SQLForeignKey)fkFetched.get(0)).getFktable_name());
        Assert.assertEquals((Object)"col1", (Object)((SQLForeignKey)fkFetched.get(0)).getFkcolumn_name());
        Assert.assertEquals((Object)parentTable.getDbName(), (Object)((SQLForeignKey)fkFetched.get(0)).getPktable_db());
        Assert.assertEquals((Object)parentTable.getTableName(), (Object)((SQLForeignKey)fkFetched.get(0)).getPktable_name());
        Assert.assertEquals((long)1L, (long)((SQLForeignKey)fkFetched.get(0)).getKey_seq());
        Assert.assertEquals((Object)(parentTable.getTableName() + "_primary_key"), (Object)((SQLForeignKey)fkFetched.get(0)).getPk_name());
        Assert.assertTrue((boolean)((SQLForeignKey)fkFetched.get(0)).isEnable_cstr());
        Assert.assertFalse((boolean)((SQLForeignKey)fkFetched.get(0)).isValidate_cstr());
        Assert.assertFalse((boolean)((SQLForeignKey)fkFetched.get(0)).isRely_cstr());
        Assert.assertEquals((Object)table.getCatName(), (Object)((SQLForeignKey)fkFetched.get(0)).getCatName());
        NotNullConstraintsRequest nnRqst = new NotNullConstraintsRequest(table.getCatName(), table.getDbName(), table.getTableName());
        List nnFetched = this.client.getNotNullConstraints(nnRqst);
        Assert.assertEquals((long)1L, (long)nnFetched.size());
        Assert.assertEquals((Object)table.getDbName(), (Object)((SQLNotNullConstraint)nnFetched.get(0)).getTable_db());
        Assert.assertEquals((Object)table.getTableName(), (Object)((SQLNotNullConstraint)nnFetched.get(0)).getTable_name());
        Assert.assertEquals((Object)"col4", (Object)((SQLNotNullConstraint)nnFetched.get(0)).getColumn_name());
        Assert.assertEquals((Object)(table.getTableName() + "_not_null_constraint"), (Object)((SQLNotNullConstraint)nnFetched.get(0)).getNn_name());
        Assert.assertTrue((boolean)((SQLNotNullConstraint)nnFetched.get(0)).isEnable_cstr());
        Assert.assertFalse((boolean)((SQLNotNullConstraint)nnFetched.get(0)).isValidate_cstr());
        Assert.assertFalse((boolean)((SQLNotNullConstraint)nnFetched.get(0)).isRely_cstr());
        Assert.assertEquals((Object)table.getCatName(), (Object)((SQLNotNullConstraint)nnFetched.get(0)).getCatName());
        UniqueConstraintsRequest ucRqst = new UniqueConstraintsRequest(table.getCatName(), table.getDbName(), table.getTableName());
        List ucFetched = this.client.getUniqueConstraints(ucRqst);
        Assert.assertEquals((long)1L, (long)ucFetched.size());
        Assert.assertEquals((Object)table.getDbName(), (Object)((SQLUniqueConstraint)ucFetched.get(0)).getTable_db());
        Assert.assertEquals((Object)table.getTableName(), (Object)((SQLUniqueConstraint)ucFetched.get(0)).getTable_name());
        Assert.assertEquals((Object)"col5", (Object)((SQLUniqueConstraint)ucFetched.get(0)).getColumn_name());
        Assert.assertEquals((long)1L, (long)((SQLUniqueConstraint)ucFetched.get(0)).getKey_seq());
        Assert.assertEquals((Object)(table.getTableName() + "_unique_constraint"), (Object)((SQLUniqueConstraint)ucFetched.get(0)).getUk_name());
        Assert.assertTrue((boolean)((SQLUniqueConstraint)ucFetched.get(0)).isEnable_cstr());
        Assert.assertFalse((boolean)((SQLUniqueConstraint)ucFetched.get(0)).isValidate_cstr());
        Assert.assertFalse((boolean)((SQLUniqueConstraint)ucFetched.get(0)).isRely_cstr());
        Assert.assertEquals((Object)table.getCatName(), (Object)((SQLUniqueConstraint)ucFetched.get(0)).getCatName());
        DefaultConstraintsRequest dcRqst = new DefaultConstraintsRequest(table.getCatName(), table.getDbName(), table.getTableName());
        List dcFetched = this.client.getDefaultConstraints(dcRqst);
        Assert.assertEquals((long)1L, (long)dcFetched.size());
        Assert.assertEquals((Object)this.expectedCatalog(), (Object)((SQLDefaultConstraint)dcFetched.get(0)).getCatName());
        Assert.assertEquals((Object)table.getDbName(), (Object)((SQLDefaultConstraint)dcFetched.get(0)).getTable_db());
        Assert.assertEquals((Object)table.getTableName(), (Object)((SQLDefaultConstraint)dcFetched.get(0)).getTable_name());
        Assert.assertEquals((Object)"col3", (Object)((SQLDefaultConstraint)dcFetched.get(0)).getColumn_name());
        Assert.assertEquals((Object)"0", (Object)((SQLDefaultConstraint)dcFetched.get(0)).getDefault_value());
        Assert.assertEquals((Object)(table.getTableName() + "_default_value"), (Object)((SQLDefaultConstraint)dcFetched.get(0)).getDc_name());
        Assert.assertTrue((boolean)((SQLDefaultConstraint)dcFetched.get(0)).isEnable_cstr());
        Assert.assertFalse((boolean)((SQLDefaultConstraint)dcFetched.get(0)).isValidate_cstr());
        Assert.assertFalse((boolean)((SQLDefaultConstraint)dcFetched.get(0)).isRely_cstr());
        Assert.assertEquals((Object)table.getCatName(), (Object)((SQLDefaultConstraint)dcFetched.get(0)).getCatName());
        CheckConstraintsRequest ccRqst = new CheckConstraintsRequest(table.getCatName(), table.getDbName(), table.getTableName());
        List ccFetched = this.client.getCheckConstraints(ccRqst);
        Assert.assertEquals((long)1L, (long)ccFetched.size());
        Assert.assertEquals((Object)this.expectedCatalog(), (Object)((SQLCheckConstraint)ccFetched.get(0)).getCatName());
        Assert.assertEquals((Object)table.getDbName(), (Object)((SQLCheckConstraint)ccFetched.get(0)).getTable_db());
        Assert.assertEquals((Object)table.getTableName(), (Object)((SQLCheckConstraint)ccFetched.get(0)).getTable_name());
        Assert.assertEquals((Object)"col6", (Object)((SQLCheckConstraint)ccFetched.get(0)).getColumn_name());
        Assert.assertEquals((Object)"> 0", (Object)((SQLCheckConstraint)ccFetched.get(0)).getCheck_expression());
        Assert.assertEquals((Object)(table.getTableName() + "_check_constraint"), (Object)((SQLCheckConstraint)ccFetched.get(0)).getDc_name());
        Assert.assertTrue((boolean)((SQLCheckConstraint)ccFetched.get(0)).isEnable_cstr());
        Assert.assertFalse((boolean)((SQLCheckConstraint)ccFetched.get(0)).isValidate_cstr());
        Assert.assertFalse((boolean)((SQLCheckConstraint)ccFetched.get(0)).isRely_cstr());
        Assert.assertEquals((Object)table.getCatName(), (Object)((SQLCheckConstraint)ccFetched.get(0)).getCatName());
    }

    @Test
    public void functions() throws TException {
        String dbName = "functions_other_catalog_db";
        Database db = new DatabaseBuilder().setName(dbName).build(this.conf);
        db.unsetCatalogName();
        this.client.createDatabase(db);
        String functionName = "test_function";
        Function function = new FunctionBuilder().inDb(db).setName(functionName).setClass(TEST_FUNCTION_CLASS).setFunctionType(FunctionType.JAVA).setOwnerType(PrincipalType.ROLE).setOwner("owner").addResourceUri(new ResourceUri(ResourceType.JAR, "hdfs:///tmp/jar1.jar")).addResourceUri(new ResourceUri(ResourceType.FILE, "hdfs:///tmp/file1.txt")).addResourceUri(new ResourceUri(ResourceType.ARCHIVE, "hdfs:///tmp/archive1.tgz")).build(this.conf);
        function.unsetCatName();
        this.client.createFunction(function);
        Function createdFunction = this.client.getFunction(dbName, functionName);
        Assert.assertEquals((Object)function.getFunctionName(), (Object)createdFunction.getFunctionName());
        Assert.assertEquals((Object)function.getDbName(), (Object)createdFunction.getDbName());
        Assert.assertEquals((Object)this.expectedCatalog(), (Object)createdFunction.getCatName());
        Assert.assertEquals((Object)function.getClassName(), (Object)createdFunction.getClassName());
        Assert.assertEquals((Object)function.getOwnerName(), (Object)createdFunction.getOwnerName());
        Assert.assertEquals((Object)function.getOwnerType(), (Object)createdFunction.getOwnerType());
        Assert.assertEquals((Object)function.getFunctionType(), (Object)createdFunction.getFunctionType());
        Assert.assertEquals((Object)function.getResourceUris(), (Object)createdFunction.getResourceUris());
        String f2Name = "testy_function2";
        Function f2 = new FunctionBuilder().inDb(db).setName(f2Name).setClass(TEST_FUNCTION_CLASS).build(this.conf);
        f2.unsetCatName();
        this.client.createFunction(f2);
        HashSet functions = new HashSet(this.client.getFunctions(dbName, "test*"));
        Assert.assertEquals((long)2L, (long)functions.size());
        Assert.assertTrue((boolean)functions.contains(functionName));
        Assert.assertTrue((boolean)functions.contains(f2Name));
        functions = new HashSet(this.client.getFunctions(dbName, "test_*"));
        Assert.assertEquals((long)1L, (long)functions.size());
        Assert.assertTrue((boolean)functions.contains(functionName));
        Assert.assertFalse((boolean)functions.contains(f2Name));
        this.client.dropFunction(function.getDbName(), function.getFunctionName());
        try {
            this.client.getFunction(function.getDbName(), function.getFunctionName());
            Assert.fail((String)"Expected a NoSuchObjectException to be thrown");
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
    }
}

