/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.auth;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import org.apache.hive.service.auth.PlainClient;

public final class SaslPlainClientFactory
implements SaslClientFactory {
    public static final String PLAIN_METHOD = "PLAIN";

    @Override
    public SaslClient createSaslClient(String[] mechanisms, String authorizationId, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        for (String mechanism : mechanisms) {
            if (!PLAIN_METHOD.equals(mechanism)) continue;
            Object[] userInfo = this.getUserInfo(authorizationId, cbh);
            return new PlainClient(authorizationId, (String)userInfo[0], (byte[])userInfo[1]);
        }
        return null;
    }

    @Override
    public String[] getMechanismNames(Map<String, ?> props) {
        return new String[]{PLAIN_METHOD};
    }

    private Object[] getUserInfo(String authorizationId, CallbackHandler cbh) throws SaslException {
        if (cbh == null) {
            throw new SaslException("Callback handler to get username/password required");
        }
        try {
            byte[] bytepw;
            String userPrompt = "PLAIN authentication id: ";
            String passwdPrompt = "PLAIN password: ";
            NameCallback ncb = authorizationId == null ? new NameCallback(userPrompt) : new NameCallback(userPrompt, authorizationId);
            PasswordCallback pcb = new PasswordCallback(passwdPrompt, false);
            cbh.handle(new Callback[]{ncb, pcb});
            char[] pw = pcb.getPassword();
            if (pw != null) {
                bytepw = new String(pw).getBytes(StandardCharsets.UTF_8);
                pcb.clearPassword();
            } else {
                bytepw = null;
            }
            String authId = ncb.getName();
            return new Object[]{authId, bytepw};
        }
        catch (IOException ioException) {
            throw new SaslException("Cannot get password", ioException);
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
            throw new SaslException("Cannot get userid/password", unsupportedCallbackException);
        }
    }
}

