/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.server;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hive.service.server.HiveServer2;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestHS2HttpServer {
    private static HiveServer2 hiveServer2 = null;
    private static HiveConf hiveConf = null;
    private static String metastorePasswd = "61ecbc41cdae3e6b32712a06c73606fa";
    private static Integer webUIPort = null;

    @BeforeClass
    public static void beforeTests() throws Exception {
        webUIPort = MetaStoreTestUtils.findFreePortExcepting((int)Integer.valueOf(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_PORT.getDefaultValue()));
        hiveConf = new HiveConf();
        hiveConf.set("fs.defaultFS", "file:///");
        hiveConf.set(HiveConf.ConfVars.METASTOREPWD.varname, metastorePasswd);
        hiveConf.set(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_PORT.varname, webUIPort.toString());
        hiveConf.setVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER, "org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdHiveAuthorizerFactory");
        Object hs2Exception = null;
        boolean hs2Started = false;
        for (int tryCount = 0; tryCount < 10; ++tryCount) {
            try {
                hiveServer2 = new HiveServer2();
                hiveServer2.init(hiveConf);
                hiveServer2.start();
                Thread.sleep(5000L);
                hs2Started = true;
                break;
            }
            catch (Exception t) {
                HiveConf.setIntVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SERVER2_THRIFT_PORT, (int)MetaStoreTestUtils.findFreePort());
                HiveConf.setIntVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SERVER2_THRIFT_HTTP_PORT, (int)MetaStoreTestUtils.findFreePort());
                HiveConf.setIntVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SERVER2_WEBUI_PORT, (int)MetaStoreTestUtils.findFreePort());
                webUIPort = hiveConf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_PORT);
                continue;
            }
        }
        if (!hs2Started) {
            throw hs2Exception;
        }
    }

    @Test
    public void testStackServlet() throws Exception {
        String line;
        String baseURL = "http://localhost:" + webUIPort + "/stacks";
        URL url = new URL(baseURL);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        Assert.assertEquals((long)200L, (long)conn.getResponseCode());
        BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        boolean contents = false;
        while ((line = reader.readLine()) != null) {
            if (!line.contains("Process Thread Dump:")) continue;
            contents = true;
        }
        Assert.assertTrue((boolean)contents);
    }

    @Test
    public void testContextRootUrlRewrite() throws Exception {
        String datePattern = "[a-zA-Z]{3} [a-zA-Z]{3} [0-9]{2} [0-9]{2}:[0-9]{2}:[0-9]{2}";
        String dateMask = "xxxMasked_DateTime_xxx";
        String baseURL = "http://localhost:" + webUIPort + "/";
        String contextRootContent = this.getURLResponseAsString(baseURL);
        String jspUrl = "http://localhost:" + webUIPort + "/hiveserver2.jsp";
        String jspContent = this.getURLResponseAsString(jspUrl);
        String expected = contextRootContent.replaceAll(datePattern, dateMask);
        String actual = jspContent.replaceAll(datePattern, dateMask);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConfStrippedFromWebUI() throws Exception {
        String pwdValFound = null;
        String pwdKeyFound = null;
        try (CloseableHttpClient httpclient = null;){
            httpclient = HttpClients.createDefault();
            HttpGet httpGet = new HttpGet("http://localhost:" + webUIPort + "/conf");
            try (CloseableHttpResponse response1 = httpclient.execute((HttpUriRequest)httpGet);){
                String line;
                HttpEntity entity1 = response1.getEntity();
                BufferedReader br = new BufferedReader(new InputStreamReader(entity1.getContent()));
                while ((line = br.readLine()) != null) {
                    if (line.contains(metastorePasswd)) {
                        pwdValFound = line;
                    }
                    if (!line.contains(HiveConf.ConfVars.METASTOREPWD.varname)) continue;
                    pwdKeyFound = line;
                }
                EntityUtils.consume((HttpEntity)entity1);
            }
        }
        Assert.assertNotNull(pwdKeyFound);
        Assert.assertNull((Object)pwdValFound);
    }

    private String getURLResponseAsString(String baseURL) throws IOException {
        URL url = new URL(baseURL);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        Assert.assertEquals((String)"Got an HTTP response code other thank OK.", (long)200L, (long)conn.getResponseCode());
        StringWriter writer = new StringWriter();
        IOUtils.copy((InputStream)conn.getInputStream(), (Writer)writer, (String)"UTF-8");
        return writer.toString();
    }

    @AfterClass
    public static void afterTests() throws Exception {
        hiveServer2.stop();
    }
}

