/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli;

import java.util.List;
import junit.framework.Assert;
import org.apache.commons.lang.StringUtils;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.rpc.thrift.TStatus;
import org.apache.hive.service.rpc.thrift.TStatusCode;
import org.junit.Test;

public class TestHiveSQLException {
    @Test
    public void testExceptionToTStatus() {
        Exception ex1 = TestHiveSQLException.createException();
        ex1.initCause(TestHiveSQLException.createSimpleCause());
        TStatus status = HiveSQLException.toTStatus((Exception)ex1);
        Assert.assertEquals((Object)TStatusCode.ERROR_STATUS, (Object)status.getStatusCode());
        Assert.assertEquals((String)ex1.getMessage(), (String)status.getErrorMessage());
        Assert.assertEquals((Object)HiveSQLException.toString((Throwable)ex1), (Object)status.getInfoMessages());
    }

    @Test
    public void testHiveSQLExceptionToTStatus() {
        String expectedMessage = "reason";
        String expectedSqlState = "sqlState";
        int expectedVendorCode = 10;
        HiveSQLException ex1 = new HiveSQLException(expectedMessage, expectedSqlState, expectedVendorCode, (Throwable)TestHiveSQLException.createSimpleCause());
        TStatus status = HiveSQLException.toTStatus((Exception)((Object)ex1));
        Assert.assertEquals((Object)TStatusCode.ERROR_STATUS, (Object)status.getStatusCode());
        Assert.assertEquals((String)expectedSqlState, (String)status.getSqlState());
        Assert.assertEquals((String)expectedMessage, (String)status.getErrorMessage());
        Assert.assertEquals((Object)HiveSQLException.toString((Throwable)ex1), (Object)status.getInfoMessages());
    }

    @Test
    public void testExceptionMarshalling() throws Exception {
        Exception ex1 = TestHiveSQLException.createException();
        ex1.initCause(TestHiveSQLException.createSimpleCause());
        Throwable ex = HiveSQLException.toCause((List)HiveSQLException.toString((Throwable)ex1));
        Assert.assertSame(RuntimeException.class, ex.getClass());
        Assert.assertEquals((String)"exception1", (String)ex.getMessage());
        Assert.assertSame(UnsupportedOperationException.class, ex.getCause().getClass());
        Assert.assertEquals((String)"exception2", (String)ex.getCause().getMessage());
    }

    @Test
    public void testNestedException() {
        Exception ex1 = TestHiveSQLException.createException();
        ex1.initCause(TestHiveSQLException.createNestedCause());
        Throwable ex = HiveSQLException.toCause((List)HiveSQLException.toString((Throwable)ex1));
        Assert.assertSame(RuntimeException.class, ex.getClass());
        Assert.assertEquals((String)"exception1", (String)ex.getMessage());
        Assert.assertSame(UnsupportedOperationException.class, ex.getCause().getClass());
        Assert.assertEquals((String)"exception2", (String)ex.getCause().getMessage());
        Assert.assertSame(Exception.class, ex.getCause().getCause().getClass());
        Assert.assertEquals((String)"exception3", (String)ex.getCause().getCause().getMessage());
    }

    @Test
    public void testExceptionWithUnknownSource() {
        Exception ex1 = TestHiveSQLException.createException();
        ex1.initCause(TestHiveSQLException.createSimpleCause());
        List details = HiveSQLException.toString((Throwable)ex1);
        Object[] tokens = ((String)details.get(1)).split(":");
        tokens[2] = null;
        tokens[3] = "-1";
        details.set(1, StringUtils.join((Object[])tokens, (String)":"));
        Throwable ex = HiveSQLException.toCause((List)details);
        Assert.assertSame(RuntimeException.class, ex.getClass());
        Assert.assertEquals((String)"exception1", (String)ex.getMessage());
        Assert.assertSame(UnsupportedOperationException.class, ex.getCause().getClass());
        Assert.assertEquals((String)"exception2", (String)ex.getCause().getMessage());
    }

    @Test
    public void testExceptionWithMissingTypeOnClient() {
        UnsupportedOperationException ex1 = new UnsupportedOperationException();
        ex1.initCause(TestHiveSQLException.createSimpleCause());
        List details = HiveSQLException.toString((Throwable)ex1);
        Object[] tokens = ((String)details.get(0)).split(":");
        tokens[0] = "*DummyException";
        details.set(0, StringUtils.join((Object[])tokens, (String)":"));
        Throwable ex = HiveSQLException.toCause((List)details);
        Assert.assertEquals(RuntimeException.class, ex.getClass());
    }

    @Test
    public void testExceptionFromAnonymousClass() {
        Dummy d = new Dummy(){

            @Override
            public void testExceptionConversion() {
                Exception ex1 = TestHiveSQLException.createException();
                ex1.initCause(TestHiveSQLException.createSimpleCause());
                Throwable ex = HiveSQLException.toCause((List)HiveSQLException.toString((Throwable)ex1));
                Assert.assertSame(RuntimeException.class, ex.getClass());
                Assert.assertEquals((String)"exception1", (String)ex.getMessage());
                Assert.assertSame(UnsupportedOperationException.class, ex.getCause().getClass());
                Assert.assertEquals((String)"exception2", (String)ex.getCause().getMessage());
            }
        };
        d.testExceptionConversion();
    }

    private static Exception createException() {
        return new RuntimeException("exception1");
    }

    private static Exception createSimpleCause() {
        return new UnsupportedOperationException("exception2");
    }

    private static Exception createNestedCause() {
        return new UnsupportedOperationException("exception2", new Exception("exception3"));
    }

    static interface Dummy {
        public void testExceptionConversion();
    }
}

