/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.auth.ldap;

import java.io.IOException;
import java.util.Arrays;
import javax.naming.NamingException;
import javax.security.sasl.AuthenticationException;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.service.auth.ldap.CustomQueryFilterFactory;
import org.apache.hive.service.auth.ldap.DirSearch;
import org.apache.hive.service.auth.ldap.Filter;
import org.apache.hive.service.auth.ldap.FilterFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TestCustomQueryFilter {
    private static final String USER2_DN = "uid=user2,ou=People,dc=example,dc=com";
    private static final String USER1_DN = "uid=user1,ou=People,dc=example,dc=com";
    private static final String CUSTOM_QUERY = "(&(objectClass=person)(|(uid=user1)(uid=user2)))";
    private FilterFactory factory;
    private HiveConf conf;
    @Mock
    private DirSearch search;

    @Before
    public void setup() {
        this.conf = new HiveConf();
        this.conf.set("hive.root.logger", "DEBUG,console");
        this.factory = new CustomQueryFilterFactory();
    }

    @Test
    public void testFactory() {
        this.conf.unset(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_CUSTOMLDAPQUERY.varname);
        Assert.assertNull((Object)this.factory.getInstance(this.conf));
        this.conf.setVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_CUSTOMLDAPQUERY, CUSTOM_QUERY);
        Assert.assertNotNull((Object)this.factory.getInstance(this.conf));
    }

    @Test
    public void testApplyPositive() throws AuthenticationException, NamingException, IOException {
        this.conf.setVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_CUSTOMLDAPQUERY, CUSTOM_QUERY);
        Mockito.when((Object)this.search.executeCustomQuery((String)Mockito.eq((Object)CUSTOM_QUERY))).thenReturn(Arrays.asList(USER1_DN, USER2_DN));
        Filter filter = this.factory.getInstance(this.conf);
        filter.apply(this.search, "user1");
        filter.apply(this.search, "user2");
    }

    @Test(expected=AuthenticationException.class)
    public void testApplyNegative() throws AuthenticationException, NamingException, IOException {
        this.conf.setVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_CUSTOMLDAPQUERY, CUSTOM_QUERY);
        Mockito.when((Object)this.search.executeCustomQuery((String)Mockito.eq((Object)CUSTOM_QUERY))).thenReturn(Arrays.asList(USER1_DN, USER2_DN));
        Filter filter = this.factory.getInstance(this.conf);
        filter.apply(this.search, "user3");
    }
}

