/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.server;

import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hive.http.security.PamAuthenticator;
import org.apache.hive.http.security.PamUserIdentity;
import org.apache.hive.service.server.HiveServer2;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.B64Code;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestHS2HttpServerPam {
    private static HiveServer2 hiveServer2 = null;
    private static HiveConf hiveConf = null;
    private static String metastorePasswd = "693efe9fa425ad21886d73a0fa3fbc70";
    private static Integer webUIPort = null;
    private static String host = "localhost";

    @BeforeClass
    public static void beforeTests() throws Exception {
        webUIPort = MetaStoreUtils.findFreePortExcepting((int)Integer.valueOf(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_PORT.getDefaultValue()));
        hiveConf = new HiveConf();
        hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_IN_TEST, true);
        hiveConf.set("fs.default.name", "file:///");
        hiveConf.set(HiveConf.ConfVars.METASTOREPWD.varname, metastorePasswd);
        hiveConf.set(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_PORT.varname, webUIPort.toString());
        hiveConf.setVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER, "org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdHiveAuthorizerFactory");
        hiveConf.setVar(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_PAM_AUTHENTICATOR, TestPamAuthenticator.class.getName());
        hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_USE_PAM, true);
        hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_USE_SSL, false);
        hiveServer2 = new HiveServer2((PamAuthenticator)new TestPamAuthenticator());
        hiveServer2.init(hiveConf);
        hiveServer2.start();
        Thread.sleep(5000L);
    }

    @Test
    public void testUnauthorizedConnection() throws Exception {
        String baseURL = "http://" + host + ":" + webUIPort + "/stacks";
        URL url = new URL(baseURL);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        Assert.assertEquals((long)401L, (long)conn.getResponseCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAuthorizedConnection() throws Exception {
        try (CloseableHttpClient httpclient = null;){
            String username = "user1";
            String password = "1";
            httpclient = HttpClients.createDefault();
            HttpGet httpGet = new HttpGet("http://" + host + ":" + webUIPort);
            String authB64Code = B64Code.encode((String)(username + ":" + password), (String)"iso-8859-1");
            httpGet.setHeader(HttpHeader.AUTHORIZATION.asString(), "Basic " + authB64Code);
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpGet);
            Assert.assertTrue((boolean)response.toString().contains(Integer.toString(200)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIncorrectUser() throws Exception {
        try (CloseableHttpClient httpclient = null;){
            String username = "nouser";
            String password = "aaaa";
            httpclient = HttpClients.createDefault();
            HttpGet httpGet = new HttpGet("http://" + host + ":" + webUIPort);
            String authB64Code = B64Code.encode((String)(username + ":" + password), (String)"iso-8859-1");
            httpGet.setHeader(HttpHeader.AUTHORIZATION.asString(), "Basic " + authB64Code);
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpGet);
            Assert.assertTrue((boolean)response.toString().contains(Integer.toString(401)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIncorrectPassword() throws Exception {
        try (CloseableHttpClient httpclient = null;){
            String username = "user1";
            String password = "aaaa";
            httpclient = HttpClients.createDefault();
            HttpGet httpGet = new HttpGet("http://" + host + ":" + webUIPort);
            String authB64Code = B64Code.encode((String)(username + ":" + password), (String)"iso-8859-1");
            httpGet.setHeader(HttpHeader.AUTHORIZATION.asString(), "Basic " + authB64Code);
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpGet);
            Assert.assertTrue((boolean)response.toString().contains(Integer.toString(401)));
        }
    }

    @AfterClass
    public static void afterTests() {
        hiveServer2.stop();
    }

    public static class TestPamAuthenticator
    extends PamAuthenticator {
        private static final Map<String, String> users = new HashMap<String, String>();

        protected UserIdentity login(String username, String password) {
            if (users.containsKey(username) && users.get(username).equals(password)) {
                return new PamUserIdentity(username);
            }
            return null;
        }

        static {
            users.put("user1", "1");
            users.put("user2", "2");
            users.put("user3", "3");
            users.put("user4", "4");
        }
    }
}

