/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.auth;

import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.ApplyLdifFiles;
import org.apache.directory.server.core.annotations.ContextEntry;
import org.apache.directory.server.core.annotations.CreateDS;
import org.apache.directory.server.core.annotations.CreateIndex;
import org.apache.directory.server.core.annotations.CreatePartition;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.apache.hive.service.auth.ldap.LdapAuthenticationTestCase;
import org.apache.hive.service.auth.ldap.User;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=FrameworkRunner.class)
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP"), @CreateTransport(protocol="LDAPS")})
@CreateDS(partitions={@CreatePartition(name="example", suffix="dc=example,dc=com", contextEntry=@ContextEntry(entryLdif="dn: dc=example,dc=com\ndc: example\nobjectClass: top\nobjectClass: domain\n\n"), indexes={@CreateIndex(attribute="objectClass"), @CreateIndex(attribute="cn"), @CreateIndex(attribute="uid")})})
@ApplyLdifFiles(value={"ldap/example.com.ldif", "ldap/microsoft.schema.ldif", "ldap/ad.example.com.ldif"})
public class TestLdapAtnProviderWithMiniDS
extends AbstractLdapTestUnit {
    private static final String GROUP1_NAME = "group1";
    private static final String GROUP2_NAME = "group2";
    private static final String GROUP3_NAME = "group3";
    private static final String GROUP4_NAME = "group4";
    private static final String GROUP_ADMINS_NAME = "admins";
    private static final String GROUP_TEAM1_NAME = "team1";
    private static final String GROUP_TEAM2_NAME = "team2";
    private static final String GROUP_RESOURCE1_NAME = "resource1";
    private static final String GROUP_RESOURCE2_NAME = "resource2";
    private static final User USER1 = User.builder().id("user1").useIdForPassword().dn("uid=user1,ou=People,dc=example,dc=com").build();
    private static final User USER2 = User.builder().id("user2").useIdForPassword().dn("uid=user2,ou=People,dc=example,dc=com").build();
    private static final User USER3 = User.builder().id("user3").useIdForPassword().dn("cn=user3,ou=People,dc=example,dc=com").build();
    private static final User USER4 = User.builder().id("user4").useIdForPassword().dn("cn=user4,ou=People,dc=example,dc=com").build();
    private static final User ENGINEER_1 = User.builder().id("engineer1").dn("sAMAccountName=engineer1,ou=Engineering,dc=ad,dc=example,dc=com").password("engineer1-password").build();
    private static final User ENGINEER_2 = User.builder().id("engineer2").dn("sAMAccountName=engineer2,ou=Engineering,dc=ad,dc=example,dc=com").password("engineer2-password").build();
    private static final User MANAGER_1 = User.builder().id("manager1").dn("sAMAccountName=manager1,ou=Management,dc=ad,dc=example,dc=com").password("manager1-password").build();
    private static final User MANAGER_2 = User.builder().id("manager2").dn("sAMAccountName=manager2,ou=Management,dc=ad,dc=example,dc=com").password("manager2-password").build();
    private static final User ADMIN_1 = User.builder().id("admin1").dn("sAMAccountName=admin1,ou=Administration,dc=ad,dc=example,dc=com").password("admin1-password").build();
    private LdapAuthenticationTestCase testCase;

    private LdapAuthenticationTestCase.Builder defaultBuilder() {
        return LdapAuthenticationTestCase.builder().ldapServer(ldapServer);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        if (ldapServer.isStarted()) {
            ldapServer.stop();
        }
    }

    @Test
    public void testLDAPServer() throws Exception {
        Assert.assertTrue((boolean)ldapServer.isStarted());
        Assert.assertTrue((ldapServer.getPort() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testUserBindPositiveWithShortname() {
        this.testCase = this.defaultBuilder().userDNPatterns("uid=%s,ou=People,dc=example,dc=com").groupDNPatterns("uid=%s,ou=Groups,dc=example,dc=com").build();
        this.testCase.assertAuthenticatePasses(USER1.credentialsWithId());
        this.testCase.assertAuthenticatePasses(USER2.credentialsWithId());
    }

    @Test
    public void testUserBindPositiveWithShortnameOldConfig() {
        this.testCase = this.defaultBuilder().baseDN("ou=People,dc=example,dc=com").build();
        this.testCase.assertAuthenticatePasses(USER1.credentialsWithId());
        this.testCase.assertAuthenticatePasses(USER2.credentialsWithId());
    }

    @Test
    public void testUserBindNegativeWithShortname() {
        this.testCase = this.defaultBuilder().userDNPatterns("uid=%s,ou=People,dc=example,dc=com").groupDNPatterns("uid=%s,ou=Groups,dc=example,dc=com").build();
        this.testCase.assertAuthenticateFailsUsingWrongPassword(USER1.credentialsWithId());
        this.testCase.assertAuthenticateFailsUsingWrongPassword(USER2.credentialsWithId());
    }

    @Test
    public void testUserBindNegativeWithShortnameOldConfig() {
        this.testCase = this.defaultBuilder().baseDN("ou=People,dc=example,dc=com").build();
        this.testCase.assertAuthenticateFailsUsingWrongPassword(USER1.credentialsWithId());
        this.testCase.assertAuthenticateFails(USER1.getDn(), USER2.getPassword());
        this.testCase.assertAuthenticateFailsUsingWrongPassword(USER2.credentialsWithId());
    }

    @Test
    public void testUserBindPositiveWithDN() {
        this.testCase = this.defaultBuilder().userDNPatterns("uid=%s,ou=People,dc=example,dc=com").groupDNPatterns("uid=%s,ou=Groups,dc=example,dc=com").build();
        this.testCase.assertAuthenticatePasses(USER1.credentialsWithDn());
        this.testCase.assertAuthenticatePasses(USER2.credentialsWithDn());
    }

    @Test
    public void testUserBindPositiveWithDNOldConfig() {
        this.testCase = this.defaultBuilder().baseDN("ou=People,dc=example,dc=com").build();
        this.testCase.assertAuthenticatePasses(USER1.credentialsWithDn());
        this.testCase.assertAuthenticatePasses(USER2.credentialsWithDn());
    }

    @Test
    public void testUserBindPositiveWithDNWrongOldConfig() {
        this.testCase = this.defaultBuilder().baseDN("ou=DummyPeople,dc=example,dc=com").build();
        this.testCase.assertAuthenticatePasses(USER1.credentialsWithDn());
        this.testCase.assertAuthenticatePasses(USER2.credentialsWithDn());
    }

    @Test
    public void testUserBindPositiveWithDNWrongConfig() {
        this.testCase = this.defaultBuilder().userDNPatterns("uid=%s,ou=DummyPeople,dc=example,dc=com").groupDNPatterns("uid=%s,ou=DummyGroups,dc=example,dc=com").build();
        this.testCase.assertAuthenticatePasses(USER1.credentialsWithDn());
        this.testCase.assertAuthenticatePasses(USER2.credentialsWithDn());
    }

    @Test
    public void testUserBindPositiveWithDNBlankConfig() {
        this.testCase = this.defaultBuilder().userDNPatterns(" ").groupDNPatterns(" ").build();
        this.testCase.assertAuthenticatePasses(USER1.credentialsWithDn());
        this.testCase.assertAuthenticatePasses(USER2.credentialsWithDn());
    }

    @Test
    public void testUserBindPositiveWithDNBlankOldConfig() throws Exception {
        this.testCase = this.defaultBuilder().baseDN("").build();
        this.testCase.assertAuthenticatePasses(USER1.credentialsWithDn());
        this.testCase.assertAuthenticatePasses(USER2.credentialsWithDn());
    }

    @Test
    public void testUserBindNegativeWithDN() {
        this.testCase = this.defaultBuilder().userDNPatterns("uid=%s,ou=People,dc=example,dc=com").groupDNPatterns("uid=%s,ou=Groups,dc=example,dc=com").build();
        this.testCase.assertAuthenticateFailsUsingWrongPassword(USER1.credentialsWithDn());
        this.testCase.assertAuthenticateFails(USER1.getDn(), USER2.getPassword());
        this.testCase.assertAuthenticateFailsUsingWrongPassword(USER2.credentialsWithDn());
    }

    @Test
    public void testUserBindNegativeWithDNOldConfig() {
        this.testCase = this.defaultBuilder().baseDN("ou=People,dc=example,dc=com").build();
        this.testCase.assertAuthenticateFailsUsingWrongPassword(USER1.credentialsWithDn());
        this.testCase.assertAuthenticateFails(USER1.getDn(), USER2.getPassword());
        this.testCase.assertAuthenticateFailsUsingWrongPassword(USER2.credentialsWithDn());
    }

    @Test
    public void testUserFilterPositive() {
        this.testCase = this.defaultBuilder().userDNPatterns("uid=%s,ou=People,dc=example,dc=com").userFilters(USER1.getId()).build();
        this.testCase.assertAuthenticatePasses(USER1.credentialsWithId());
        this.testCase.assertAuthenticatePasses(USER1.credentialsWithDn());
        this.testCase = this.defaultBuilder().userDNPatterns("uid=%s,ou=People,dc=example,dc=com").userFilters(USER2.getId()).build();
        this.testCase.assertAuthenticatePasses(USER2.credentialsWithId());
        this.testCase.assertAuthenticatePasses(USER2.credentialsWithDn());
        this.testCase = this.defaultBuilder().userDNPatterns("uid=%s,ou=People,dc=example,dc=com").userFilters(USER1.getId(), USER2.getId()).build();
        this.testCase.assertAuthenticatePasses(USER1.credentialsWithId());
        this.testCase.assertAuthenticatePasses(USER1.credentialsWithDn());
        this.testCase.assertAuthenticatePasses(USER2.credentialsWithId());
        this.testCase.assertAuthenticatePasses(USER2.credentialsWithDn());
    }

    @Test
    public void testUserFilterNegative() {
        this.testCase = this.defaultBuilder().userDNPatterns("uid=%s,ou=People,dc=example,dc=com").userFilters(USER2.getId()).build();
        this.testCase.assertAuthenticateFails(USER1.credentialsWithId());
        this.testCase.assertAuthenticateFails(USER1.credentialsWithDn());
        this.testCase = this.defaultBuilder().userDNPatterns("uid=%s,ou=People,dc=example,dc=com").userFilters(USER1.getId()).build();
        this.testCase.assertAuthenticateFails(USER2.credentialsWithId());
        this.testCase.assertAuthenticateFails(USER2.credentialsWithDn());
        this.testCase = this.defaultBuilder().userDNPatterns("uid=%s,ou=People,dc=example,dc=com").userFilters(USER3.getId()).build();
        this.testCase.assertAuthenticateFails(USER1.credentialsWithId());
        this.testCase.assertAuthenticateFails(USER2.credentialsWithId());
    }

    @Test
    public void testGroupFilterPositive() {
        this.testCase = this.defaultBuilder().userDNPatterns("uid=%s,ou=People,dc=example,dc=com").groupDNPatterns("uid=%s,ou=Groups,dc=example,dc=com").groupFilters(GROUP1_NAME, GROUP2_NAME).build();
        this.testCase.assertAuthenticatePasses(USER1.credentialsWithId());
        this.testCase.assertAuthenticatePasses(USER1.credentialsWithDn());
        this.testCase.assertAuthenticatePasses(USER2.credentialsWithId());
        this.testCase.assertAuthenticatePasses(USER2.credentialsWithDn());
        this.testCase = this.defaultBuilder().userDNPatterns("uid=%s,ou=People,dc=example,dc=com").groupDNPatterns("uid=%s,ou=Groups,dc=example,dc=com").groupFilters(GROUP2_NAME).build();
        this.testCase.assertAuthenticatePasses(USER2.credentialsWithId());
        this.testCase.assertAuthenticatePasses(USER2.credentialsWithDn());
    }

    @Test
    public void testGroupFilterNegative() {
        this.testCase = this.defaultBuilder().userDNPatterns("uid=%s,ou=People,dc=example,dc=com").groupDNPatterns("uid=%s,ou=Groups,dc=example,dc=com").groupFilters(GROUP2_NAME).build();
        this.testCase.assertAuthenticateFails(USER1.credentialsWithId());
        this.testCase.assertAuthenticateFails(USER1.credentialsWithDn());
        this.testCase = this.defaultBuilder().userDNPatterns("uid=%s,ou=People,dc=example,dc=com").groupDNPatterns("uid=%s,ou=Groups,dc=example,dc=com").groupFilters(GROUP1_NAME).build();
        this.testCase.assertAuthenticateFails(USER2.credentialsWithId());
        this.testCase.assertAuthenticateFails(USER2.credentialsWithDn());
    }

    @Test
    public void testUserAndGroupFilterPositive() {
        this.testCase = this.defaultBuilder().userDNPatterns("uid=%s,ou=People,dc=example,dc=com").groupDNPatterns("uid=%s,ou=Groups,dc=example,dc=com").userFilters(USER1.getId(), USER2.getId()).groupFilters(GROUP1_NAME, GROUP2_NAME).build();
        this.testCase.assertAuthenticatePasses(USER1.credentialsWithId());
        this.testCase.assertAuthenticatePasses(USER1.credentialsWithDn());
        this.testCase.assertAuthenticatePasses(USER2.credentialsWithId());
        this.testCase.assertAuthenticatePasses(USER2.credentialsWithDn());
    }

    @Test
    public void testUserAndGroupFilterNegative() {
        this.testCase = this.defaultBuilder().userDNPatterns("uid=%s,ou=People,dc=example,dc=com").groupDNPatterns("uid=%s,ou=Groups,dc=example,dc=com").userFilters(USER1.getId(), USER2.getId()).groupFilters(GROUP3_NAME, GROUP3_NAME).build();
        this.testCase.assertAuthenticateFails(USER2.credentialsWithDn());
        this.testCase.assertAuthenticateFails(USER2.credentialsWithId());
        this.testCase.assertAuthenticateFails(USER3.credentialsWithDn());
        this.testCase.assertAuthenticateFails(USER3.credentialsWithId());
    }

    @Test
    public void testCustomQueryPositive() {
        this.testCase = this.defaultBuilder().baseDN("ou=People,dc=example,dc=com").userDNPatterns("cn=%s,ou=People,dc=example,dc=com", "uid=%s,ou=People,dc=example,dc=com").groupDNPatterns("cn=%s,ou=People,dc=example,dc=com").customQuery(String.format("(&(objectClass=person)(|(uid=%s)(uid=%s)))", USER1.getId(), USER4.getId())).build();
        this.testCase.assertAuthenticatePasses(USER1.credentialsWithId());
        this.testCase.assertAuthenticatePasses(USER1.credentialsWithDn());
        this.testCase.assertAuthenticatePasses(USER4.credentialsWithId());
        this.testCase.assertAuthenticatePasses(USER4.credentialsWithDn());
    }

    @Test
    public void testCustomQueryNegative() {
        this.testCase = this.defaultBuilder().baseDN("ou=People,dc=example,dc=com").customQuery(String.format("(&(objectClass=person)(uid=%s))", USER1.getId())).build();
        this.testCase.assertAuthenticateFails(USER2.credentialsWithDn());
        this.testCase.assertAuthenticateFails(USER2.credentialsWithId());
    }

    @Test
    public void testCustomQueryWithGroupsPositive() {
        this.testCase = this.defaultBuilder().baseDN("dc=example,dc=com").userDNPatterns("cn=%s,ou=People,dc=example,dc=com", "uid=%s,ou=People,dc=example,dc=com").customQuery(String.format("(&(objectClass=groupOfNames)(|(cn=%s)(cn=%s)))", GROUP1_NAME, GROUP2_NAME)).build();
        this.testCase.assertAuthenticatePasses(USER1.credentialsWithId());
        this.testCase.assertAuthenticatePasses(USER1.credentialsWithDn());
        this.testCase.assertAuthenticatePasses(USER2.credentialsWithId());
        this.testCase.assertAuthenticatePasses(USER2.credentialsWithDn());
        this.testCase = this.defaultBuilder().baseDN("dc=example,dc=com").userDNPatterns("cn=%s,ou=People,dc=example,dc=com", "uid=%s,ou=People,dc=example,dc=com").customQuery(String.format("(|(&(objectClass=groupOfNames)(cn=%s))(&(objectClass=person)(sn=%s)))", GROUP1_NAME, USER4.getId())).build();
        this.testCase.assertAuthenticatePasses(USER1.credentialsWithId());
        this.testCase.assertAuthenticatePasses(USER1.credentialsWithDn());
        this.testCase.assertAuthenticatePasses(USER4.credentialsWithId());
        this.testCase.assertAuthenticatePasses(USER4.credentialsWithDn());
        this.testCase = this.defaultBuilder().baseDN("dc=example,dc=com").userDNPatterns("cn=%s,ou=People,dc=example,dc=com", "uid=%s,ou=People,dc=example,dc=com").groupMembershipKey("uniqueMember").customQuery(String.format("(&(objectClass=groupOfUniqueNames)(cn=%s))", GROUP4_NAME)).build();
        this.testCase.assertAuthenticatePasses(USER4.credentialsWithId());
        this.testCase.assertAuthenticatePasses(USER4.credentialsWithDn());
    }

    @Test
    public void testCustomQueryWithGroupsNegative() {
        this.testCase = this.defaultBuilder().baseDN("dc=example,dc=com").userDNPatterns("cn=%s,ou=People,dc=example,dc=com", "uid=%s,ou=People,dc=example,dc=com").customQuery(String.format("(&(objectClass=groupOfNames)(|(cn=%s)(cn=%s)))", GROUP1_NAME, GROUP2_NAME)).build();
        this.testCase.assertAuthenticateFails(USER3.credentialsWithDn());
        this.testCase.assertAuthenticateFails(USER3.credentialsWithId());
    }

    @Test
    public void testGroupFilterPositiveWithCustomGUID() {
        this.testCase = this.defaultBuilder().userDNPatterns("cn=%s,ou=People,dc=example,dc=com").groupDNPatterns("cn=%s,ou=Groups,dc=example,dc=com").groupFilters(GROUP3_NAME).guidKey("cn").build();
        this.testCase.assertAuthenticatePasses(USER3.credentialsWithId());
        this.testCase.assertAuthenticatePasses(USER3.credentialsWithDn());
    }

    @Test
    public void testGroupFilterPositiveWithCustomAttributes() {
        this.testCase = this.defaultBuilder().userDNPatterns("cn=%s,ou=People,dc=example,dc=com").groupDNPatterns("cn=%s,ou=Groups,dc=example,dc=com").groupFilters(GROUP4_NAME).guidKey("cn").groupMembershipKey("uniqueMember").groupClassKey("groupOfUniqueNames").build();
        this.testCase.assertAuthenticatePasses(USER4.credentialsWithId());
        this.testCase.assertAuthenticatePasses(USER4.credentialsWithDn());
    }

    @Test
    public void testDirectUserMembershipGroupFilterPositive() {
        this.testCase = this.defaultBuilder().userDNPatterns("sAMAccountName=%s,ou=Engineering,dc=ad,dc=example,dc=com", "sAMAccountName=%s,ou=Management,dc=ad,dc=example,dc=com").groupDNPatterns("sAMAccountName=%s,ou=Teams,dc=ad,dc=example,dc=com", "sAMAccountName=%s,ou=Resources,dc=ad,dc=example,dc=com").groupFilters(GROUP_TEAM1_NAME, GROUP_TEAM2_NAME, GROUP_RESOURCE1_NAME, GROUP_RESOURCE2_NAME).guidKey("sAMAccountName").userMembershipKey("memberOf").build();
        this.testCase.assertAuthenticatePasses(ENGINEER_1.credentialsWithId());
        this.testCase.assertAuthenticatePasses(ENGINEER_2.credentialsWithId());
        this.testCase.assertAuthenticatePasses(MANAGER_1.credentialsWithId());
        this.testCase.assertAuthenticatePasses(MANAGER_2.credentialsWithId());
    }

    @Test
    public void testDirectUserMembershipGroupFilterNegative() {
        this.testCase = this.defaultBuilder().userDNPatterns("sAMAccountName=%s,ou=Engineering,dc=ad,dc=example,dc=com", "sAMAccountName=%s,ou=Management,dc=ad,dc=example,dc=com").groupDNPatterns("cn=%s,ou=Teams,dc=ad,dc=example,dc=com").groupFilters(GROUP_TEAM1_NAME).guidKey("sAMAccountName").userMembershipKey("memberOf").build();
        this.testCase.assertAuthenticateFails(ENGINEER_2.credentialsWithId());
        this.testCase.assertAuthenticateFails(MANAGER_2.credentialsWithId());
    }

    @Test
    public void testDirectUserMembershipGroupFilterNegativeWithoutUserBases() throws Exception {
        this.testCase = this.defaultBuilder().groupDNPatterns("cn=%s,ou=Teams,dc=ad,dc=example,dc=com").groupFilters(GROUP_TEAM1_NAME).guidKey("sAMAccountName").userMembershipKey("memberOf").build();
        this.testCase.assertAuthenticateFails(ENGINEER_1.credentialsWithId());
        this.testCase.assertAuthenticateFails(ENGINEER_2.credentialsWithId());
        this.testCase.assertAuthenticateFails(MANAGER_1.credentialsWithId());
        this.testCase.assertAuthenticateFails(MANAGER_2.credentialsWithId());
    }

    @Test
    public void testDirectUserMembershipGroupFilterWithDNCredentials() throws Exception {
        this.testCase = this.defaultBuilder().userDNPatterns("sAMAccountName=%s,ou=Engineering,dc=ad,dc=example,dc=com").groupDNPatterns("cn=%s,ou=Teams,dc=ad,dc=example,dc=com").groupFilters(GROUP_TEAM1_NAME).guidKey("sAMAccountName").userMembershipKey("memberOf").build();
        this.testCase.assertAuthenticatePasses(ENGINEER_1.credentialsWithDn());
        this.testCase.assertAuthenticateFails(MANAGER_1.credentialsWithDn());
    }

    @Test
    public void testDirectUserMembershipGroupFilterWithDifferentGroupClassKey() throws Exception {
        this.testCase = this.defaultBuilder().userDNPatterns("sAMAccountName=%s,ou=Administration,dc=ad,dc=example,dc=com").groupDNPatterns("cn=%s,ou=Administration,dc=ad,dc=example,dc=com").groupFilters(GROUP_ADMINS_NAME).guidKey("sAMAccountName").userMembershipKey("memberOf").groupClassKey("groupOfUniqueNames").build();
        this.testCase.assertAuthenticatePasses(ADMIN_1.credentialsWithId());
        this.testCase.assertAuthenticateFails(ENGINEER_1.credentialsWithId());
        this.testCase.assertAuthenticateFails(MANAGER_1.credentialsWithDn());
    }

    @Test
    public void testDirectUserMembershipGroupFilterNegativeWithWrongGroupClassKey() throws Exception {
        this.testCase = this.defaultBuilder().userDNPatterns("sAMAccountName=%s,ou=Administration,dc=ad,dc=example,dc=com").groupDNPatterns("cn=%s,ou=Administration,dc=ad,dc=example,dc=com").groupFilters(GROUP_ADMINS_NAME).guidKey("sAMAccountName").userMembershipKey("memberOf").groupClassKey("wrongClass").build();
        this.testCase.assertAuthenticateFails(ADMIN_1.credentialsWithId());
        this.testCase.assertAuthenticateFails(ENGINEER_1.credentialsWithId());
        this.testCase.assertAuthenticateFails(MANAGER_1.credentialsWithDn());
    }
}

